/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase;

import com.mapr.fs.hbase.HBaseAdminImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.AsyncProcess;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorImpl;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HRegionLocator;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.MasterKeepAliveConnection;
import org.apache.hadoop.hbase.client.NeedUnmanagedConnectionException;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.ServerStatisticTracker;
import org.apache.hadoop.hbase.client.TableConfiguration;
import org.apache.hadoop.hbase.client.backoff.ClientBackoffPolicy;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.client.mapr.AbstractHBaseAdmin;
import org.apache.hadoop.hbase.client.mapr.AbstractMapRClusterConnection;
import org.apache.hadoop.hbase.client.mapr.BaseTableMappingRules;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.security.User;

@InterfaceAudience.Private
public class MapRClusterConnectionImpl
extends AbstractMapRClusterConnection {
    public static final int DEFAULT_CALLBACK_THREADS = 2;
    private ThreadPoolExecutor bmPool_ = null;
    private static final Log LOG = LogFactory.getLog(MapRClusterConnectionImpl.class);
    private final Configuration conf;
    private final TableConfiguration tableConfig;
    private boolean managed_;
    private BaseTableMappingRules tableMappingRule_ = null;
    private volatile AbstractHBaseAdmin maprHBaseAdmin_ = null;

    public MapRClusterConnectionImpl(Configuration conf, boolean managed, User user, BaseTableMappingRules rule) throws IOException {
        this.conf = conf;
        this.managed_ = managed;
        this.tableConfig = new TableConfiguration(conf);
        this.tableMappingRule_ = rule;
        try {
            this.maprHBaseAdmin_ = new HBaseAdminImpl(conf, this.tableMappingRule_);
        }
        catch (Exception e) {
            throw e instanceof IOException ? (IOException)e : new IOException(e);
        }
        this.maprHBaseAdmin_.setUser(user);
    }

    public void abort(String why, Throwable e) {
        LOG.info((Object)("Client wants to abort connection with reason " + why + "and exception " + e.toString() + ".\nNo need to abort a mapr cluster connection"));
        throw new UnsupportedOperationException("abort is not supported through MapRConnection.");
    }

    public boolean isAborted() {
        return false;
    }

    private void initBMPool() {
        if (this.bmPool_ != null) {
            LOG.info((Object)"BufferedMutator Pool has been initialized.");
        }
        LOG.info((Object)"Creating BufferedMutator ThreadPoolExecutor for mapr connection  with 2 callbackThreads");
        this.bmPool_ = new ThreadPoolExecutor(2, 2, 1L, TimeUnit.HOURS, new LinkedBlockingQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public synchronized ThreadPoolExecutor getBMPool() {
        if (this.bmPool_ == null) {
            this.initBMPool();
        }
        return this.bmPool_;
    }

    private void shutdownBMPool() {
        this.bmPool_.shutdown();
        try {
            boolean terminated = false;
            while (!(terminated = this.bmPool_.awaitTermination(60L, TimeUnit.SECONDS))) {
            }
        }
        catch (InterruptedException e) {
            this.bmPool_.shutdownNow();
            LOG.warn((Object)"MapRClusterConnection BufferedMutator ThreadPool waitForTermination interrupted");
        }
    }

    public synchronized void close() throws IOException {
        if (this.maprHBaseAdmin_ != null) {
            this.maprHBaseAdmin_.close();
            this.maprHBaseAdmin_ = null;
        }
        if (this.bmPool_ != null) {
            this.shutdownBMPool();
            this.bmPool_ = null;
        }
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public BaseTableMappingRules getTableMappingRule() {
        return this.tableMappingRule_;
    }

    public HTableInterface getTable(String tableName) throws IOException {
        return this.getTable(TableName.valueOf((String)tableName));
    }

    public HTableInterface getTable(byte[] tableName) throws IOException {
        return this.getTable(TableName.valueOf((byte[])tableName));
    }

    public HTableInterface getTable(TableName tableName) throws IOException {
        return new HTable(tableName, (Connection)this);
    }

    public HTableInterface getTable(String tableName, ExecutorService pool) throws IOException {
        return this.getTable(TableName.valueOf((String)tableName), pool);
    }

    public HTableInterface getTable(byte[] tableName, ExecutorService pool) throws IOException {
        return this.getTable(TableName.valueOf((byte[])tableName), pool);
    }

    public HTableInterface getTable(TableName tableName, ExecutorService pool) throws IOException {
        if (this.managed_) {
            throw new NeedUnmanagedConnectionException();
        }
        return new HTable(tableName, (Connection)this, pool);
    }

    public BufferedMutator getBufferedMutator(BufferedMutatorParams params) {
        if (params.getTableName() == null) {
            throw new IllegalArgumentException("TableName cannot be null.");
        }
        boolean shutdownpool = true;
        if (params.getListener() != null && params.getPool() == null) {
            LOG.info((Object)"Use ThreadPool from MapRClusterConnection");
            params.pool((ExecutorService)this.getBMPool());
            shutdownpool = false;
        }
        if (params.getWriteBufferSize() == -1L) {
            params.writeBufferSize(this.tableConfig.getWriteBufferSize());
        }
        if (params.getMaxKeyValueSize() == -1) {
            params.maxKeyValueSize(this.tableConfig.getMaxKeyValueSize());
        }
        return new BufferedMutatorImpl((ClusterConnection)this, null, null, params, shutdownpool);
    }

    public BufferedMutator getBufferedMutator(TableName tableName) throws IOException {
        return this.getBufferedMutator(new BufferedMutatorParams(tableName));
    }

    public RegionLocator getRegionLocator(TableName tableName) throws IOException {
        return new HRegionLocator(tableName, (ClusterConnection)this);
    }

    public AbstractHBaseAdmin createAbstractHBaseAdmin() throws IOException {
        HBaseAdminImpl mAdmin = null;
        try {
            mAdmin = new HBaseAdminImpl(this.conf, this.tableMappingRule_);
        }
        catch (Exception e) {
            throw e instanceof IOException ? (IOException)e : new IOException(e);
        }
        return mAdmin;
    }

    public Admin getAdmin() throws IOException {
        if (this.managed_) {
            throw new NeedUnmanagedConnectionException();
        }
        if (this.maprHBaseAdmin_ == null) {
            throw new IOException("No connection to MapR cluster.");
        }
        return new HBaseAdmin((ClusterConnection)this);
    }

    public boolean isMasterRunning() throws MasterNotRunningException, ZooKeeperConnectionException {
        return true;
    }

    public boolean isTableEnabled(TableName tableName) throws IOException {
        return this.maprHBaseAdmin_.isTableEnabled(tableName.getAliasAsString());
    }

    public boolean isTableEnabled(byte[] tableName) throws IOException {
        return this.isTableEnabled(TableName.valueOf((byte[])tableName));
    }

    public boolean isTableDisabled(TableName tableName) throws IOException {
        return this.maprHBaseAdmin_.isTableDisabled(tableName.getAliasAsString());
    }

    public boolean isTableDisabled(byte[] tableName) throws IOException {
        return this.isTableDisabled(TableName.valueOf((byte[])tableName));
    }

    public boolean isTableAvailable(TableName tableName) throws IOException {
        return this.maprHBaseAdmin_.isTableAvailable(tableName.getAliasAsString());
    }

    public boolean isTableAvailable(byte[] tableName) throws IOException {
        return this.isTableAvailable(TableName.valueOf((byte[])tableName));
    }

    public boolean isTableAvailable(TableName tableName, byte[][] splitKeys) throws IOException {
        return this.maprHBaseAdmin_.isTableAvailable(tableName.getAliasAsString(), splitKeys);
    }

    public boolean isTableAvailable(byte[] tableName, byte[][] splitKeys) throws IOException {
        return this.isTableAvailable(tableName, splitKeys);
    }

    public HTableDescriptor[] listTables() throws IOException {
        return this.maprHBaseAdmin_.listTables();
    }

    public String[] getTableNames() throws IOException {
        return this.maprHBaseAdmin_.getTableNames();
    }

    public TableName[] listTableNames() throws IOException {
        return this.maprHBaseAdmin_.listTableNames();
    }

    public HTableDescriptor getHTableDescriptor(TableName tableName) throws IOException {
        return this.maprHBaseAdmin_.getTableDescriptor(tableName.getAliasAsString());
    }

    public HTableDescriptor getHTableDescriptor(byte[] tableName) throws IOException {
        return this.getHTableDescriptor(TableName.valueOf((byte[])tableName));
    }

    public HRegionLocation locateRegion(TableName tableName, byte[] row) throws IOException {
        throw new UnsupportedOperationException("locateRegion is not supported through MapRConnection.");
    }

    public HRegionLocation locateRegion(byte[] tableName, byte[] row) throws IOException {
        throw new UnsupportedOperationException("locateRegion is not supported through MapRConnection.");
    }

    public RegionLocations locateRegion(TableName tableName, byte[] row, boolean useCache, boolean retry) throws IOException {
        throw new UnsupportedOperationException("locateRegion is not supported through MapRConnection.");
    }

    public void clearRegionCache() {
        throw new UnsupportedOperationException("clearRegionCache is not supported through MapRConnection.");
    }

    public void clearRegionCache(TableName tableName) {
        throw new UnsupportedOperationException("clearRegionCache is not supported through MapRConnection.");
    }

    public void clearRegionCache(byte[] tableName) {
        throw new UnsupportedOperationException("clearRegionCache is not supported through MapRConnection.");
    }

    public void deleteCachedRegionLocation(HRegionLocation location) {
        throw new UnsupportedOperationException("deleteCachedRegionLocation is not supported through MapRConnection.");
    }

    public HRegionLocation relocateRegion(TableName tableName, byte[] row) throws IOException {
        throw new UnsupportedOperationException("relocateRegion is not supported through MapRConnection.");
    }

    public HRegionLocation relocateRegion(byte[] tableName, byte[] row) throws IOException {
        throw new UnsupportedOperationException("relocateRegion is not supported through MapRConnection.");
    }

    public void updateCachedLocations(TableName tableName, byte[] rowkey, Object exception, HRegionLocation source) {
        throw new UnsupportedOperationException("updateCachedLocations is not supported through MapRConnection.");
    }

    public void updateCachedLocations(TableName tableName, byte[] regionName, byte[] rowkey, Object exception, ServerName source) {
        throw new UnsupportedOperationException("updateCachedLocations is not supported through MapRConnection.");
    }

    public void updateCachedLocations(byte[] tableName, byte[] rowkey, Object exception, HRegionLocation source) {
        throw new UnsupportedOperationException("updateCachedLocations is not supported through MapRConnection.");
    }

    public HRegionLocation locateRegion(byte[] regionName) throws IOException {
        throw new UnsupportedOperationException("locateRegion is not supported through MapRConnection.");
    }

    public List<HRegionLocation> locateRegions(TableName tableName) throws IOException {
        throw new UnsupportedOperationException("locateRegions is not supported through MapRConnection.");
    }

    public List<HRegionLocation> locateRegions(byte[] tableName) throws IOException {
        throw new UnsupportedOperationException("locateRegions is not supported through MapRConnection.");
    }

    public List<HRegionLocation> locateRegions(TableName tableName, boolean useCache, boolean offlined) throws IOException {
        throw new UnsupportedOperationException("locateRegions is not supported through MapRConnection.");
    }

    public List<HRegionLocation> locateRegions(byte[] tableName, boolean useCache, boolean offlined) throws IOException {
        throw new UnsupportedOperationException("locateRegions is not supported through MapRConnection.");
    }

    public RegionLocations locateRegion(TableName tableName, byte[] row, boolean useCache, boolean retry, int replicaId) throws IOException {
        throw new UnsupportedOperationException("locateRegion is not supported through MapRConnection.");
    }

    public RegionLocations relocateRegion(TableName tableName, byte[] row, int replicaId) throws IOException {
        throw new UnsupportedOperationException("relocateRegion is not supported through MapRConnection.");
    }

    public MasterProtos.MasterService.BlockingInterface getMaster() throws IOException {
        throw new UnsupportedOperationException("relocateRegion is not supported through MapRConnection.");
    }

    public AdminProtos.AdminService.BlockingInterface getAdmin(ServerName serverName) throws IOException {
        throw new UnsupportedOperationException("AdminService.BlockingInterface getAdmin is not supported through MapRConnection.");
    }

    public ClientProtos.ClientService.BlockingInterface getClient(ServerName serverName) throws IOException {
        throw new UnsupportedOperationException("ClientService.BlockingInterface getClient is not supported through MapRConnection.");
    }

    public AdminProtos.AdminService.BlockingInterface getAdmin(ServerName serverName, boolean getMaster) throws IOException {
        throw new UnsupportedOperationException("AdminService.BlockingInterface getAdmin is not supported through MapRConnection.");
    }

    public HRegionLocation getRegionLocation(TableName tableName, byte[] row, boolean reload) throws IOException {
        throw new UnsupportedOperationException("getRegionLocation is not supported through MapRConnection.");
    }

    public HRegionLocation getRegionLocation(byte[] tableName, byte[] row, boolean reload) throws IOException {
        throw new UnsupportedOperationException("getRegionLocation is not supported through MapRConnection.");
    }

    public void processBatch(List<? extends Row> actions, TableName tableName, ExecutorService pool, Object[] results) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("processBatch is not supported through MapRConnection.");
    }

    public void processBatch(List<? extends Row> actions, byte[] tableName, ExecutorService pool, Object[] results) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("processBatch is not supported through MapRConnection.");
    }

    public <R> void processBatchCallback(List<? extends Row> list, TableName tableName, ExecutorService pool, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("processBatchCallback is not supported through MapRConnection.");
    }

    public <R> void processBatchCallback(List<? extends Row> list, byte[] tableName, ExecutorService pool, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("processBatchCallback is not supported through MapRConnection.");
    }

    public void setRegionCachePrefetch(TableName tableName, boolean enable) {
        throw new UnsupportedOperationException("setRegionCachePrefetch is not supported through MapRConnection.");
    }

    public void setRegionCachePrefetch(byte[] tableName, boolean enable) {
        throw new UnsupportedOperationException("setRegionCachePrefetch is not supported through MapRConnection.");
    }

    public boolean getRegionCachePrefetch(TableName tableName) {
        throw new UnsupportedOperationException("getRegionCachePrefetch is not supported through MapRConnection.");
    }

    public boolean getRegionCachePrefetch(byte[] tableName) {
        throw new UnsupportedOperationException("getRegionCachePrefetch is not supported through MapRConnection.");
    }

    public int getCurrentNrHRS() throws IOException {
        throw new UnsupportedOperationException("getCurrentNrHRS is not supported through MapRConnection.");
    }

    public HTableDescriptor[] getHTableDescriptorsByTableName(List<TableName> tableNames) throws IOException {
        ArrayList<String> strNames = new ArrayList<String>(tableNames.size());
        for (String name : strNames) {
            tableNames.add(TableName.valueOf((String)name));
        }
        return this.getHTableDescriptors(strNames);
    }

    public HTableDescriptor[] getHTableDescriptors(List<String> tableNames) throws IOException {
        ArrayList<HTableDescriptor> list = new ArrayList<HTableDescriptor>();
        for (String tableName : tableNames) {
            list.add(this.maprHBaseAdmin_.getTableDescriptor(tableName));
        }
        return list.toArray(new HTableDescriptor[list.size()]);
    }

    public boolean isClosed() {
        return this.maprHBaseAdmin_ == null;
    }

    public void clearCaches(ServerName sn) {
        throw new UnsupportedOperationException("clearCaches is not supported through MapRConnection.");
    }

    public MasterKeepAliveConnection getKeepAliveMasterService() throws MasterNotRunningException {
        throw new UnsupportedOperationException("getKeepAliveMasterService is not supported through MapRConnection.");
    }

    public boolean isDeadServer(ServerName serverName) {
        throw new UnsupportedOperationException("isDeadServer is not supported through MapRConnection.");
    }

    public NonceGenerator getNonceGenerator() {
        throw new UnsupportedOperationException("getNonceGenerator is not supported through MapRConnection.");
    }

    public AsyncProcess getAsyncProcess() {
        throw new UnsupportedOperationException("getAsyncProcess is not supported through MapRConnection.");
    }

    public RpcRetryingCallerFactory getNewRpcRetryingCallerFactory(Configuration conf) {
        throw new UnsupportedOperationException("getNewRpcRetryingCallerFactory is not supported through MapRConnection.");
    }

    public boolean isManaged() {
        return this.managed_;
    }

    public ServerStatisticTracker getStatisticsTracker() {
        throw new UnsupportedOperationException("getStatisticsTracker is not supported through MapRConnection.");
    }

    public ClientBackoffPolicy getBackoffPolicy() {
        throw new UnsupportedOperationException("getStatisticsTracker is not supported through MapRConnection.");
    }
}

