/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase;

import com.mapr.fs.MapRHTable;
import com.mapr.fs.jni.MapRIncrement;
import com.mapr.fs.jni.MapRRowConstraint;
import java.io.IOException;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.TreeMap;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.util.Bytes;

public class RowConstraintConverter {
    public static MapRRowConstraint toRowConstraint(MapRHTable htable, Map<byte[], NavigableSet<byte[]>> familyMap, int maxVersions, long minStamp, long maxStamp) throws NoSuchColumnFamilyException {
        int id = 0;
        TreeMap<Integer, NavigableSet<byte[]>> familyIdMap = new TreeMap<Integer, NavigableSet<byte[]>>();
        MapRRowConstraint rc = new MapRRowConstraint();
        rc.maxVersions = maxVersions;
        rc.minStamp = minStamp;
        rc.maxStamp = maxStamp;
        rc.numFamilies = 0;
        rc.numColumns = 0;
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : familyMap.entrySet()) {
            try {
                id = htable.getFamilyId(Bytes.toString((byte[])entry.getKey()));
            }
            catch (IOException ioe) {
                throw new NoSuchColumnFamilyException(ioe.toString());
            }
            NavigableSet<byte[]> columnSet = entry.getValue();
            familyIdMap.put(id, columnSet);
            if (columnSet != null) {
                rc.numColumns += columnSet.size();
            }
            ++rc.numFamilies;
        }
        rc.columns = new byte[rc.numColumns][];
        rc.families = new int[rc.numFamilies];
        rc.columnsPerFamily = new int[rc.numFamilies];
        int ccount = 0;
        int fcount = 0;
        for (Map.Entry entry : familyIdMap.entrySet()) {
            rc.families[fcount] = (Integer)entry.getKey();
            rc.columnsPerFamily[fcount] = 0;
            NavigableSet columnSet = (NavigableSet)entry.getValue();
            if (columnSet != null) {
                for (byte[] qualifier : columnSet) {
                    rc.columns[ccount] = qualifier;
                    int n = fcount;
                    rc.columnsPerFamily[n] = rc.columnsPerFamily[n] + 1;
                    ++ccount;
                }
            }
            ++fcount;
        }
        return rc;
    }

    public static MapRRowConstraint toRowConstraint(MapRHTable htable, Map<byte[], NavigableMap<byte[], Long>> familyMap, long minStamp, long maxStamp, MapRIncrement incr) throws NoSuchColumnFamilyException, IOException {
        int id = 0;
        TreeMap<Integer, NavigableMap<byte[], Long>> familyIdMap = new TreeMap<Integer, NavigableMap<byte[], Long>>();
        MapRRowConstraint rc = new MapRRowConstraint();
        rc.minStamp = minStamp;
        rc.maxStamp = maxStamp;
        rc.numFamilies = 0;
        rc.numColumns = 0;
        for (Map.Entry<byte[], NavigableMap<byte[], Long>> entry : familyMap.entrySet()) {
            try {
                id = htable.getFamilyId(Bytes.toString((byte[])entry.getKey()));
            }
            catch (IOException ioe) {
                throw new NoSuchColumnFamilyException(ioe.toString());
            }
            NavigableMap<byte[], Long> columnSet = entry.getValue();
            familyIdMap.put(id, columnSet);
            if (columnSet != null) {
                rc.numColumns += columnSet.size();
            } else {
                throw new IOException("At least one column required per family");
            }
            ++rc.numFamilies;
        }
        rc.columns = new byte[rc.numColumns][];
        rc.families = new int[rc.numFamilies];
        rc.columnsPerFamily = new int[rc.numFamilies];
        incr.deltas = new long[rc.numColumns];
        int ccount = 0;
        int fcount = 0;
        for (Map.Entry entry : familyIdMap.entrySet()) {
            rc.families[fcount] = (Integer)entry.getKey();
            rc.columnsPerFamily[fcount] = 0;
            NavigableMap columnSet = (NavigableMap)entry.getValue();
            if (columnSet != null) {
                for (Map.Entry qualifier : columnSet.entrySet()) {
                    rc.columns[ccount] = (byte[])qualifier.getKey();
                    incr.deltas[ccount] = (Long)qualifier.getValue();
                    int n = fcount;
                    rc.columnsPerFamily[n] = rc.columnsPerFamily[n] + 1;
                    ++ccount;
                }
            }
            ++fcount;
        }
        return rc;
    }

    public static MapRRowConstraint toRowConstraint(MapRHTable htable, byte[] family, byte[] qualifier) throws NoSuchColumnFamilyException, IOException {
        int id = 0;
        try {
            id = htable.getFamilyId(Bytes.toString((byte[])family));
        }
        catch (IOException ioe) {
            throw new NoSuchColumnFamilyException(ioe.toString());
        }
        MapRRowConstraint rc = new MapRRowConstraint();
        rc.numFamilies = 1;
        rc.families = new int[rc.numFamilies];
        rc.columnsPerFamily = new int[rc.numFamilies];
        rc.families[0] = id;
        if (qualifier != null) {
            rc.numColumns = 1;
            rc.columns = new byte[rc.numColumns][];
            rc.columns[0] = qualifier;
            rc.columnsPerFamily[0] = 1;
        } else {
            rc.numColumns = 0;
            rc.columnsPerFamily[0] = 0;
        }
        rc.minStamp = -9223372036854775807L;
        rc.maxStamp = Long.MAX_VALUE;
        return rc;
    }
}

