/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase.tools.mapreduce;

import com.mapr.fs.hbase.CFPermissions;
import com.mapr.fs.hbase.HBaseAdminImpl;
import com.mapr.fs.hbase.tools.mapreduce.DiffTables;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.mapr.BaseTableMappingRules;
import org.apache.hadoop.hbase.client.mapr.TableMappingRulesFactory;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class DiffTablesMeta
extends Configured
implements Tool {
    public static final int METATYPE_NONE = 0;
    public static final int METATYPE_CFS = 1;
    public static final int METATYPE_ACES = 2;
    public static final int METATYPE_MAXVERSION = 4;
    public static final int METATYPE_ATTRS = 8;
    public static final int METATYPE_ALL = 15;
    public static final int SAME_METADATA_RET = 0;
    public static final int DIFFERENT_METADATA_RET = 1;
    public static final int COMMAND_LINE_ERROR_RET = 2;
    public static final int SKIP_META_TEST = 3;
    static String srcPath = null;
    static String dstPath = null;
    static int metaTypeMask = 0;
    static boolean cmpmeta = true;
    private boolean callFromDiffTables = true;
    static Configuration config = null;

    public DiffTablesMeta(boolean callFromDiffTables) {
        this.callFromDiffTables = callFromDiffTables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compareTableMeta(String src, String dst, int metaTypeMask) throws Exception {
        try (HBaseAdminImpl hadminImpl = null;){
            int i;
            int size2;
            int size1;
            Object[] hcdsDst;
            Object[] hcdsSrc;
            Configuration conf = HBaseConfiguration.create();
            conf.set("hbase.table.namespace.mappings", "");
            BaseTableMappingRules tableMappingRule = TableMappingRulesFactory.create((Configuration)conf);
            hadminImpl = new HBaseAdminImpl(conf, tableMappingRule);
            if (!hadminImpl.tableExists(src)) {
                throw new IOException("Table " + src + " doesn't exist.");
            }
            if (!hadminImpl.tableExists(dst)) {
                throw new IOException("Table " + dst + " doesn't exist.");
            }
            HTableDescriptor htdSrc = hadminImpl.getTableDescriptor(src);
            HTableDescriptor htdDst = hadminImpl.getTableDescriptor(dst);
            if ((metaTypeMask & 1) > 0) {
                hcdsSrc = htdSrc.getColumnFamilies();
                hcdsDst = htdDst.getColumnFamilies();
                size1 = hcdsSrc.length;
                size2 = hcdsDst.length;
                Arrays.sort(hcdsSrc);
                Arrays.sort(hcdsDst);
                if (size1 != size2) {
                    System.out.println("The column families sizes are different. src has " + size1 + " cfs, but dst has " + size2 + " cfs.");
                    boolean bl = false;
                    return bl;
                }
                for (i = 0; i < size1; ++i) {
                    if (hcdsSrc[i].getNameAsString().compareTo(hcdsDst[i].getNameAsString()) == 0) continue;
                    System.out.println("METATYPE_CFS is different.");
                    boolean bl = false;
                    return bl;
                }
            }
            if ((metaTypeMask & 2) > 0) {
                Map<String, String> tablePermsSrc = hadminImpl.getTablePermissions(src);
                Map<String, String> tablePermsDst = hadminImpl.getTablePermissions(dst);
                size1 = tablePermsSrc.size();
                if (size1 != (size2 = tablePermsDst.size())) {
                    System.out.println("The Aces sizes of tablePerms are different.");
                    i = 0;
                    return i != 0;
                }
                for (String key : tablePermsSrc.keySet()) {
                    if (tablePermsDst.containsKey(key) && tablePermsSrc.get(key).compareTo(tablePermsDst.get(key)) == 0) continue;
                    System.out.println("METATYPE_ACES of table is different.");
                    boolean bl = false;
                    return bl;
                }
                if ((metaTypeMask & 1) > 0) {
                    List<CFPermissions> cfPermsSrc = hadminImpl.getFamilyPermissions(src);
                    List<CFPermissions> cfPermsDst = hadminImpl.getFamilyPermissions(dst);
                    size1 = cfPermsSrc.size();
                    if (size1 != (size2 = cfPermsDst.size())) {
                        System.out.println("The Aces sizes of column families are different.");
                        boolean bl = false;
                        return bl;
                    }
                    Collections.sort(cfPermsSrc, new Comparator<CFPermissions>(){

                        @Override
                        public int compare(CFPermissions c1, CFPermissions c2) {
                            return c1.getFamily().compareTo(c2.getFamily());
                        }
                    });
                    Collections.sort(cfPermsDst, new Comparator<CFPermissions>(){

                        @Override
                        public int compare(CFPermissions c1, CFPermissions c2) {
                            return c1.getFamily().compareTo(c2.getFamily());
                        }
                    });
                    for (int i2 = 0; i2 < size1; ++i2) {
                        Map<String, String> cfPermSrc = cfPermsSrc.get(i2).getCfPermissions();
                        Map<String, String> cfPermDst = cfPermsDst.get(i2).getCfPermissions();
                        if (size1 != size2) {
                            System.out.println("The Aces sizes of cfPerm are different.");
                            boolean bl = false;
                            return bl;
                        }
                        for (String key : cfPermSrc.keySet()) {
                            if (cfPermDst.containsKey(key) && cfPermSrc.get(key).compareTo(cfPermDst.get(key)) == 0) continue;
                            System.out.println("METATYPE_ACES of column families is different.");
                            boolean bl = false;
                            return bl;
                        }
                    }
                }
            }
            if ((metaTypeMask & 4) > 0) {
                hcdsSrc = htdSrc.getColumnFamilies();
                size1 = hcdsSrc.length;
                if (size1 != (size2 = (hcdsDst = htdDst.getColumnFamilies()).length)) {
                    System.out.println("The column families sizes are different.");
                    boolean cfPermsSrc = false;
                    return cfPermsSrc;
                }
                Arrays.sort(hcdsSrc);
                Arrays.sort(hcdsDst);
                for (int i3 = 0; i3 < size1; ++i3) {
                    int maxVersionsDst;
                    int maxVersionsSrc = hcdsSrc[i3].getMaxVersions();
                    if (maxVersionsSrc == (maxVersionsDst = hcdsDst[i3].getMaxVersions())) continue;
                    System.out.println("METATYPE_MAXVERSION is different.");
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
    }

    private boolean ParseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-h") || args[i].startsWith("--h")) {
                this.printUsage();
                return false;
            }
            if (args[i].equalsIgnoreCase("-src")) {
                srcPath = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-dst")) {
                dstPath = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-columns")) {
                metaTypeMask |= 1;
                continue;
            }
            if (args[i].equalsIgnoreCase("-Aces")) {
                metaTypeMask |= 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-maxversions")) {
                metaTypeMask |= 4;
                continue;
            }
            if (args[i].equalsIgnoreCase("-cmpmeta")) {
                String cmpmetaString;
                if ((cmpmetaString = args[++i]).equalsIgnoreCase("false")) {
                    cmpmeta = false;
                    continue;
                }
                if (!cmpmetaString.equalsIgnoreCase("true")) continue;
                cmpmeta = true;
                continue;
            }
            if (this.callFromDiffTables) continue;
            this.printUsage();
        }
        if (srcPath == null || dstPath == null) {
            this.printUsage();
        }
        return true;
    }

    private void printUsage() {
        if (this.callFromDiffTables) {
            DiffTables.printUsage(null);
        }
        System.err.println("Usage: hbase DiffTablesMeta -src tableA -dst tableB [options]. ");
        System.err.println("Options:");
        System.err.println("  [-cmpmeta] <true|false> by default it's true");
        System.err.println("  [-columns] compare column families");
        System.err.println("  [-Aces] compare Aces");
        System.err.println("  [-maxversions] compare max versions");
        System.err.println("By default checks all of them. ");
        System.exit(1);
    }

    public int run(String[] args) throws Exception {
        this.ParseArgs(args);
        if (!cmpmeta) {
            return 3;
        }
        return DiffTablesMeta.compareTableMeta(srcPath, dstPath, metaTypeMask == 0 ? 15 : metaTypeMask) ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new DiffTablesMeta(false), (String[])args);
            if (ret == 2) {
                System.out.println("Please check command line again and use correct format.");
            } else if (ret == 0) {
                System.out.println("DiffTablesMeta completed. Metadata of the two tables is same.");
            } else if (ret == 1) {
                System.err.println("ERROR: Metadata is different!");
            }
        }
        catch (Exception e) {
            ret = 1;
            e.printStackTrace();
        }
        System.exit(ret);
    }
}

