/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase.tools.mapreduce;

import com.mapr.fs.hbase.tools.mapreduce.DiffTablesMeta;
import com.mapr.fs.hbase.tools.mapreduce.RangeChecksumInputFormat;
import com.mapr.fs.hbase.tools.mapreduce.SegKeyRangeUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.HConnectable;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.ResultSerialization;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.mapreduce.TableSplit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.LazyOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class DiffTables
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(DiffTables.class);
    public static final String NAME = "difftables";
    public static final String tablesAreDifferent = "tablesAreDifferent";
    public static String outputDir = null;
    static String srcPath = null;
    static String dstPath = null;
    static String masterPath = null;
    static boolean switchSrcWithDst = false;
    static boolean misMatchOrError = false;
    static long startTime = 0L;
    static long endTime = Long.MAX_VALUE;
    static String columnSpec;
    static int maxVersions;
    static boolean runMR;
    static boolean exitOnFirstDiff;
    static MultipleOutputs<ImmutableBytesWritable, Result> mos;
    static int numThreads;
    static String splitKeyRangeFileName;
    static String includeKeyRangeFileName;
    static boolean deleteRW1;
    static boolean deleteRW2;
    public static boolean shouldExit;
    HTable srcTable;
    HTable dstTable;
    private static final Object lock;
    private static AtomicLong numRowsMismatchedInSrc;
    private static AtomicLong numRowsMismatchedInDst;

    private static ArrayList<Diff> scanAndGetDiff(ImmutableBytesWritable row, Result srcResult, ScanState dstScanState) throws IOException {
        int rowkeyCmpResult;
        ArrayList<Diff> diffs;
        block6: {
            diffs = new ArrayList<Diff>();
            if (dstScanState.result == null) {
                Diff diff = new Diff(row, srcResult, null);
                diffs.add(diff);
                return diffs;
            }
            rowkeyCmpResult = DiffTables.compareRowKey(srcResult.getRow(), dstScanState.result.getRow());
            while (dstScanState.result != null && rowkeyCmpResult > 0) {
                Diff diff = new Diff(new ImmutableBytesWritable(dstScanState.result.getRow()), null, dstScanState.result);
                diffs.add(diff);
                if (shouldExit) {
                    return diffs;
                }
                dstScanState.result = dstScanState.resultScanner.next();
                if (dstScanState.result == null) break;
                rowkeyCmpResult = DiffTables.compareRowKey(srcResult.getRow(), dstScanState.result.getRow());
            }
            try {
                Result.compareResults((Result)srcResult, (Result)dstScanState.result);
            }
            catch (Exception e1) {
                Diff diff = DiffTables.compareAndGetDiff(row, srcResult, dstScanState.result);
                diffs.add(diff);
                if (!shouldExit) break block6;
                return diffs;
            }
        }
        if (dstScanState.result != null && rowkeyCmpResult == 0) {
            dstScanState.result = dstScanState.resultScanner.next();
        }
        return diffs;
    }

    private static Diff compareAndGetDiff(ImmutableBytesWritable row, Result srcResult, Result dstResult) {
        if (dstResult == null || DiffTables.compareRowKey(srcResult.getRow(), dstResult.getRow()) < 0) {
            LOG.debug((Object)"rowKeyResult < 0");
            return new Diff(row, srcResult, null);
        }
        ArrayList<Cell> srcToDstDiff = new ArrayList<Cell>();
        ArrayList<Cell> dstToSrcDiff = new ArrayList<Cell>();
        try {
            Cell dstKeyValue;
            Cell srcKeyValue;
            int srcCount = 0;
            int dstCount = 0;
            Cell[] srcKeyValues = srcResult.rawCells();
            Cell[] dstKeyValues = dstResult.rawCells();
            while (srcCount < srcKeyValues.length && dstCount < dstKeyValues.length) {
                srcKeyValue = srcKeyValues[srcCount];
                dstKeyValue = dstKeyValues[dstCount];
                int kvResult = DiffTables.compareKeyValue(srcKeyValue, dstKeyValue);
                if (kvResult < 0) {
                    srcToDstDiff.add(srcKeyValue);
                    ++srcCount;
                    continue;
                }
                if (kvResult > 0) {
                    dstToSrcDiff.add(dstKeyValue);
                    ++dstCount;
                    continue;
                }
                int valueResult = DiffTables.compareKeyValue(srcKeyValue, dstKeyValue, FieldType.VALUE);
                if (valueResult != 0) {
                    srcToDstDiff.add(srcKeyValue);
                    if (!DiffTables.isAuthEnable()) {
                        dstToSrcDiff.add(dstKeyValue);
                    }
                }
                ++srcCount;
                ++dstCount;
            }
            while (srcCount < srcKeyValues.length) {
                srcKeyValue = srcKeyValues[srcCount];
                srcToDstDiff.add(srcKeyValue);
                ++srcCount;
            }
            while (dstCount < dstKeyValues.length) {
                dstKeyValue = dstKeyValues[dstCount];
                dstToSrcDiff.add(dstKeyValue);
                ++dstCount;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        return new Diff(row, Result.create(srcToDstDiff), Result.create(dstToSrcDiff));
    }

    private static Result convertPutToDelete(Result diff) {
        ArrayList<KeyValue> deletes = new ArrayList<KeyValue>();
        try {
            for (Cell c : diff.rawCells()) {
                if (KeyValue.Type.Delete.getCode() <= c.getTypeByte() && c.getTypeByte() <= KeyValue.Type.DeleteFamily.getCode()) {
                    throw new Exception("keyvalue type only can be PUT!");
                }
                KeyValue delete = new KeyValue(c.getRowArray(), c.getRowOffset(), (int)c.getRowLength(), c.getFamilyArray(), c.getFamilyOffset(), (int)c.getFamilyLength(), c.getQualifierArray(), c.getQualifierOffset(), c.getQualifierLength(), c.getTimestamp(), KeyValue.Type.Delete, c.getValueArray(), c.getValueOffset(), c.getValueLength(), c.getTagsArray(), c.getTagsOffset(), c.getTagsLengthUnsigned());
                deletes.add(delete);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new Result(deletes);
    }

    private static ArrayList<Diff> dumpRemainingScanner(ScanState scanState) throws IOException {
        ArrayList<Diff> diffs = new ArrayList<Diff>();
        while (scanState.result != null) {
            Diff diff = new Diff(new ImmutableBytesWritable(scanState.result.getRow()), null, scanState.result);
            diffs.add(diff);
            if (exitOnFirstDiff) {
                return diffs;
            }
            scanState.result = scanState.resultScanner.next();
        }
        return diffs;
    }

    private static boolean isAuthEnable() {
        return masterPath != null;
    }

    private static int compareRowKey(byte[] srcRowKey, byte[] destRowKey) {
        return ByteBuffer.wrap(srcRowKey).compareTo(ByteBuffer.wrap(destRowKey));
    }

    private static int compareKeyValue(Cell srcKeyValue, Cell dstKeyValue) throws Exception {
        int cfResult = DiffTables.compareKeyValue(srcKeyValue, dstKeyValue, FieldType.COLUMN_FAMILY);
        if (cfResult != 0) {
            return cfResult;
        }
        int quantifierResult = DiffTables.compareKeyValue(srcKeyValue, dstKeyValue, FieldType.QUANTIFIER);
        if (quantifierResult != 0) {
            return quantifierResult;
        }
        return DiffTables.compareKeyValue(srcKeyValue, dstKeyValue, FieldType.TIMESTAMP);
    }

    private static int compareKeyValue(Cell srcKeyValue, Cell dstKeyValue, FieldType dataModel) throws Exception {
        switch (dataModel) {
            case COLUMN_FAMILY: {
                return Bytes.compareTo((byte[])srcKeyValue.getFamilyArray(), (int)srcKeyValue.getFamilyOffset(), (int)srcKeyValue.getFamilyLength(), (byte[])dstKeyValue.getFamilyArray(), (int)dstKeyValue.getFamilyOffset(), (int)dstKeyValue.getFamilyLength());
            }
            case QUANTIFIER: {
                return Bytes.compareTo((byte[])srcKeyValue.getQualifierArray(), (int)srcKeyValue.getQualifierOffset(), (int)srcKeyValue.getQualifierLength(), (byte[])dstKeyValue.getQualifierArray(), (int)dstKeyValue.getQualifierOffset(), (int)dstKeyValue.getQualifierLength());
            }
            case TIMESTAMP: {
                Long srcTimestamp = srcKeyValue.getTimestamp();
                Long dstTimestamp = dstKeyValue.getTimestamp();
                return srcTimestamp.compareTo(dstTimestamp);
            }
            case VALUE: {
                return Bytes.compareTo((byte[])srcKeyValue.getValueArray(), (int)srcKeyValue.getValueOffset(), (int)srcKeyValue.getValueLength(), (byte[])dstKeyValue.getValueArray(), (int)dstKeyValue.getValueOffset(), (int)dstKeyValue.getValueLength());
            }
        }
        throw new Exception("Unsupport data model.");
    }

    private static Scan buildScan(Configuration conf) {
        Scan scan = new Scan();
        long startTime = conf.getLong("difftables.startTime", 0L);
        long endTime = conf.getLong("difftables.endTime", Long.MAX_VALUE);
        String columnSpec = conf.get("difftables.columnSpec", null);
        if (columnSpec != null) {
            String[] cols;
            for (String col : cols = columnSpec.split(",")) {
                if (col.contains(":")) {
                    String[] names = col.split(":");
                    scan.addColumn(Bytes.toBytes((String)names[0]), Bytes.toBytes((String)names[1]));
                    continue;
                }
                scan.addFamily(Bytes.toBytes((String)col));
            }
        }
        try {
            scan.setTimeRange(startTime, endTime);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        scan.setMaxVersions(conf.getInt("difftables.maxVersions", Integer.MAX_VALUE));
        return scan;
    }

    static String[] convertFromDiffTablesArg(String diffTableOutdir, String splitKRFile, String includeKRFile, String[] diffArgs) {
        if (diffArgs.length == 0 && splitKRFile == null && includeKRFile == null) {
            return new String[0];
        }
        if (includeKRFile != null && splitKRFile == null) {
            throw new IllegalArgumentException("Input key range file is missing.");
        }
        ArrayList<String> rangeArgs = new ArrayList<String>();
        for (int i = 0; i < diffArgs.length; ++i) {
            if (diffArgs[i].equalsIgnoreCase("-outdir")) {
                diffArgs[i + 1] = diffTableOutdir;
                LOG.info((Object)("diffTables -outdir =(" + diffArgs[i + 1] + ")"));
            }
            rangeArgs.add(diffArgs[i]);
        }
        if (splitKRFile != null) {
            rangeArgs.add("-split_keyrange");
            rangeArgs.add(splitKRFile);
        }
        if (includeKRFile != null) {
            rangeArgs.add("-keyrange_included");
            rangeArgs.add(includeKRFile);
        }
        String[] retArr = new String[rangeArgs.size()];
        retArr = rangeArgs.toArray(retArr);
        LOG.info((Object)rangeArgs.toString());
        return retArr;
    }

    public static Job createSubmittableMapReduceJob(Configuration conf, String[] args) throws IOException {
        Job job = new Job(conf, NAME);
        job.setJarByClass(DiffTables.class);
        TableMapReduceUtil.initTableMapperJob((String)srcPath, (Scan)DiffTables.buildScan(conf), DiffTableMapper.class, ImmutableBytesWritable.class, Result.class, (Job)job, (boolean)true, RangeChecksumInputFormat.class);
        job.setNumReduceTasks(0);
        job.setOutputKeyClass(ImmutableBytesWritable.class);
        job.setOutputValueClass(Result.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputDir));
        LazyOutputFormat.setOutputFormatClass((Job)job, SequenceFileOutputFormat.class);
        return job;
    }

    private int runNonMapReduceJob(Configuration conf) throws Exception {
        System.out.println("Non MapReduce job starts");
        conf.set("fs.default.name", "maprfs:///");
        conf.set("fs.maprfs.impl", "com.mapr.fs.MapRFileSystem");
        conf.set("mapr.htable.impl", "com.mapr.fs.MapRHTable");
        this.srcTable = new HTable(conf, srcPath.getBytes());
        byte[][] startKeys = this.srcTable.getStartKeys();
        byte[][] endKeys = this.srcTable.getEndKeys();
        int numSplits = startKeys.length;
        this.dstTable = new HTable(conf, dstPath.getBytes());
        numRowsMismatchedInSrc = new AtomicLong();
        numRowsMismatchedInDst = new AtomicLong();
        long ts = System.currentTimeMillis();
        ExecutorService executor = Executors.newFixedThreadPool(numThreads);
        for (int i = 0; i < numSplits; ++i) {
            executor.execute(new LoaderThread(i, startKeys[i], endKeys[i], conf));
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
            Thread.sleep(1000L);
        }
        Path srcDir = new Path(outputDir);
        FileSystem fs = srcDir.getFileSystem(conf);
        boolean mv1 = SegKeyRangeUtil.copyFileWithPrefix(fs, srcDir, new Path(outputDir + "/opsForDst"), conf, "opsForDst");
        boolean mv2 = SegKeyRangeUtil.copyFileWithPrefix(fs, srcDir, new Path(outputDir + "/opsForSrc"), conf, "opsForSrc");
        if (!mv1 || !mv2) {
            LOG.info((Object)("Failed to move output diff results " + outputDir + " into its sub folder opsForSrc or opsForDst"));
        }
        Path rw1Path = new Path(outputDir + "/" + (switchSrcWithDst ? "opsForSrc" : "opsForDst"));
        Path rw2Path = new Path(outputDir + "/" + (switchSrcWithDst ? "opsForDst" : "opsForSrc"));
        LOG.debug((Object)("rw1Path=" + rw1Path + ", rw2Path=" + rw2Path + ", deleteRW1=" + deleteRW1 + ", deleteRW2=" + deleteRW2));
        if (fs.exists(rw1Path) && deleteRW1) {
            fs.delete(rw1Path, true);
        }
        if (fs.exists(rw2Path) && deleteRW2) {
            fs.delete(rw2Path, true);
        }
        if (misMatchOrError) {
            System.out.println("The tables mismatch. numRowsMismatchedInSrc:" + numRowsMismatchedInSrc + "; numRowsMismatchedInDst:" + numRowsMismatchedInDst + ". Please check diff in " + outputDir);
            return 1;
        }
        long te = System.currentTimeMillis();
        System.out.println("Job completed in " + (te - ts) + " ms");
        SegKeyRangeUtil.writeStringToFile(conf, "", outputDir + "/" + "_SUCCESS");
        System.out.println("The tables match.");
        return 0;
    }

    public int run(String[] args) throws Exception {
        Configuration conf = this.getConf();
        this.setupConfig(conf);
        int ret = 0;
        if (runMR) {
            Path firstExitFilePath;
            Job job = DiffTables.createSubmittableMapReduceJob(conf, args);
            if (job != null) {
                ret = job.waitForCompletion(true) ? 0 : 1;
            }
            Path srcDir = new Path(outputDir);
            FileSystem fs = srcDir.getFileSystem(conf);
            conf.setBoolean("difftablestablesAreDifferent", false);
            boolean mv1 = SegKeyRangeUtil.copyFileWithPrefix(fs, srcDir, new Path(outputDir + "/opsForDst"), conf, "opsForDst");
            boolean mv2 = SegKeyRangeUtil.copyFileWithPrefix(fs, srcDir, new Path(outputDir + "/opsForSrc"), conf, "opsForSrc");
            if (!mv1 || !mv2) {
                LOG.info((Object)("Failed to move output diff results " + outputDir + " into its sub folder opsForSrc or opsForDst"));
            }
            Counters counters = job.getCounters();
            Counter srcMismatch = counters.findCounter((Enum)COUNTERS.NUM_ROWS_MISMATCH_IN_SRC);
            Counter dstMismatch = counters.findCounter((Enum)COUNTERS.NUM_ROWS_MISMATCH_IN_DST);
            System.out.print("Mapreduce job " + (ret == 0 ? "completed. " : "failed. "));
            boolean printcounter = false;
            if (ret == 0) {
                if (srcMismatch.getValue() == 0L && dstMismatch.getValue() == 0L) {
                    System.out.println("The tables match.");
                } else {
                    System.out.println("The tables mismatch.");
                    printcounter = true;
                }
            } else {
                printcounter = true;
            }
            if (printcounter) {
                System.out.println(srcMismatch.getDisplayName() + ":" + srcMismatch.getValue() + "; " + dstMismatch.getDisplayName() + ":" + dstMismatch.getValue() + ". Please check diff in " + outputDir);
            }
            if (fs.exists(firstExitFilePath = new Path(SegKeyRangeUtil.getTmpDirName(conf) + "/firstExit"))) {
                fs.delete(firstExitFilePath, false);
            }
        } else {
            ret = this.runNonMapReduceJob(conf);
        }
        return ret;
    }

    private void setupConfig(Configuration conf) {
        conf.setBoolean("difftables.exitOnFirstDiff", exitOnFirstDiff);
        if (columnSpec != null) {
            conf.set("difftables.columnSpec", columnSpec);
        }
        conf.setLong("difftables.startTime", startTime);
        conf.setLong("difftables.endTime", endTime);
        conf.setInt("difftables.maxVersions", maxVersions);
        if (masterPath != null) {
            conf.set("difftables.masterPath", masterPath);
            if (!masterPath.equals(srcPath)) {
                String tmp = srcPath;
                srcPath = dstPath;
                dstPath = tmp;
                switchSrcWithDst = true;
            }
        }
        conf.setBoolean("difftables.switchSrcWithDst", switchSrcWithDst);
        conf.set("difftables.dstPath", dstPath);
        if (splitKeyRangeFileName != null) {
            conf.set("splitfilename", splitKeyRangeFileName);
        }
        if (includeKeyRangeFileName != null) {
            conf.set("includedregionfilename", includeKeyRangeFileName);
        }
    }

    public static boolean doCommandLine(String[] args) {
        if (args.length <= 0) {
            DiffTables.printUsage(null);
            return false;
        }
        try {
            boolean hasNumThreads = false;
            String master = null;
            for (int i = 0; i < args.length; ++i) {
                String cmd = args[i];
                if (cmd.equalsIgnoreCase("-h") || cmd.startsWith("--h")) {
                    DiffTables.printUsage(null);
                    return false;
                }
                if (cmd.equalsIgnoreCase("-src")) {
                    if (!DiffTables.checkNextArg(args, i)) {
                        return false;
                    }
                    srcPath = args[++i];
                    continue;
                }
                if (cmd.equalsIgnoreCase("-dst")) {
                    if (!DiffTables.checkNextArg(args, i)) {
                        return false;
                    }
                    dstPath = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-columns")) {
                    if (!DiffTables.checkNextArg(args, i)) {
                        return false;
                    }
                    columnSpec = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-starttime")) {
                    String startTimeStr;
                    if (!DiffTables.checkNextArg(args, i)) {
                        return false;
                    }
                    startTime = (startTimeStr = args[++i]).equalsIgnoreCase("-INF") ? 0L : Long.parseLong(startTimeStr);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-endtime")) {
                    String endTimeStr;
                    if (!DiffTables.checkNextArg(args, i)) {
                        return false;
                    }
                    endTime = (endTimeStr = args[++i]).equalsIgnoreCase("INF") ? Long.MAX_VALUE : Long.parseLong(endTimeStr);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-split_keyrange")) {
                    if (!DiffTables.checkNextArg(args, i)) {
                        return false;
                    }
                    splitKeyRangeFileName = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-keyrange_included")) {
                    if (!DiffTables.checkNextArg(args, i)) {
                        return false;
                    }
                    includeKeyRangeFileName = args[++i];
                    continue;
                }
                if (cmd.equalsIgnoreCase("-maxversions")) {
                    if (!DiffTables.checkNextArg(args, i)) {
                        return false;
                    }
                    maxVersions = Integer.parseInt(args[++i]);
                    continue;
                }
                if (cmd.equalsIgnoreCase("-outdir")) {
                    if (!DiffTables.checkNextArg(args, i)) {
                        return false;
                    }
                    outputDir = args[++i];
                    continue;
                }
                if (cmd.equalsIgnoreCase("-first_exit")) {
                    exitOnFirstDiff = true;
                    continue;
                }
                if (cmd.equalsIgnoreCase("-master")) {
                    if (!DiffTables.checkNextArg(args, i)) {
                        return false;
                    }
                    master = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-mapreduce")) {
                    String isMapreduce;
                    if (!DiffTables.checkNextArg(args, i)) {
                        return false;
                    }
                    if ((isMapreduce = args[++i]).equalsIgnoreCase("false")) {
                        runMR = false;
                        continue;
                    }
                    if (!isMapreduce.equalsIgnoreCase("true")) continue;
                    runMR = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-cmpmeta")) {
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-numthreads")) {
                    numThreads = Integer.parseInt(args[++i]);
                    hasNumThreads = true;
                    continue;
                }
                DiffTables.printUsage("unrecognized argument " + args[i]);
                return false;
            }
            Configuration conf = HBaseConfiguration.create();
            if (includeKeyRangeFileName != null && splitKeyRangeFileName == null) {
                DiffTables.printUsage("when specifying -keyrange_included, please also specify -split_keyrange.");
            }
            if (srcPath == null) {
                DiffTables.printUsage("Missing -src.");
                return false;
            }
            if (dstPath == null) {
                DiffTables.printUsage("Missing -dst.");
                return false;
            }
            if (!SegKeyRangeUtil.isTable(conf, srcPath)) {
                DiffTables.printUsage("Table " + srcPath + " does not exist.");
                return false;
            }
            if (!SegKeyRangeUtil.isTable(conf, dstPath)) {
                DiffTables.printUsage("Table " + dstPath + " does not exist.");
                return false;
            }
            if (SegKeyRangeUtil.tablesAreSame(conf, srcPath, dstPath)) {
                System.out.println("The tables match. " + srcPath + " and " + dstPath + " are the same table.");
                System.exit(0);
            }
            if (hasNumThreads && runMR) {
                DiffTables.printUsage("-numthreads should be used only when -mapreduce is false.");
            }
            if (startTime < 0L) {
                DiffTables.printUsage("starttime (" + startTime + ") cannot be negative.");
                return false;
            }
            if (endTime < 0L) {
                DiffTables.printUsage("endtime (" + endTime + ") cannot be negative.");
                return false;
            }
            if (startTime > endTime) {
                DiffTables.printUsage("endtime is smaller than starttime.");
                return false;
            }
            if (master != null) {
                if (master.equalsIgnoreCase("src")) {
                    masterPath = srcPath;
                } else if (master.equalsIgnoreCase("dst")) {
                    masterPath = dstPath;
                } else {
                    DiffTables.printUsage("-master should be given as either src or dst");
                }
            }
            if (maxVersions < 0) {
                DiffTables.printUsage("maxVersions (" + maxVersions + ") cannot be negative.");
                return false;
            }
            if (outputDir == null) {
                DiffTables.printUsage("Missing -outdir");
                return false;
            }
            if (SegKeyRangeUtil.checkPathExists(conf, outputDir)) {
                DiffTables.printUsage("Output directory " + outputDir + " already exists");
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            DiffTables.printUsage("Can't start because " + e.getMessage());
            return false;
        }
        return true;
    }

    private static boolean checkNextArg(String[] args, int i) {
        if (i + 1 >= args.length || args[i + 1].matches("-[cdefkmnosu][a-zA-Z_]*")) {
            DiffTables.printUsage("Missing argument after " + args[i]);
            return false;
        }
        return true;
    }

    public static void printUsage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("Usage: hbase com.mapr.fs.hbase.tools.mapreduce.DiffTables \n-src <source table path>\n-dst <destination table path>\n-outdir <output directory>\n[-master <src|dst> ] The master table to use for the diff.\n[-first_exit] Exit when first difference is found.\n[-columns <comma separated list of family[:column]> ]\n[-starttime <start diff at timestamp>]\n[-endtime <end diff at timestamp>]\n[-maxversions] <max number of versions to copy>\n[-mapreduce] <true|false> (default: true)]\n[-numthreads <numThreads> (default:16, valid only when -mapreduce is false)]\n[-cmpmeta <true|false> (default: true)]\n");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyMerge(FileSystem srcFS, Path srcDir, FileSystem dstFS, Path dstFile, Configuration conf, String prefix) throws IOException {
        if (!srcFS.exists(srcDir)) {
            throw new IOException("Source " + srcDir + " doesn't exist");
        }
        if (dstFS.exists(dstFile)) {
            throw new IOException("Target " + dstFile + " already exists");
        }
        if (!srcFS.getFileStatus(srcDir).isDirectory()) {
            return false;
        }
        conf.set("fs.default.name", "maprfs:///");
        conf.set("fs.maprfs.impl", "com.mapr.fs.MapRFileSystem");
        conf.set("mapr.htable.impl", "com.mapr.fs.MapRHTable");
        conf.setStrings("io.serializations", new String[]{conf.get("io.serializations"), ResultSerialization.class.getName()});
        SequenceFile.Reader reader = null;
        SequenceFile.Writer writer = null;
        try {
            Object[] contents = srcFS.listStatus(srcDir);
            Arrays.sort(contents);
            for (int i = 0; i < contents.length; ++i) {
                if (!contents[i].isFile() || !contents[i].getPath().getName().startsWith(prefix)) continue;
                if (writer == null) {
                    writer = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)dstFile), SequenceFile.Writer.keyClass(ImmutableBytesWritable.class), SequenceFile.Writer.valueClass(Result.class)});
                }
                reader = new SequenceFile.Reader(srcFS, contents[i].getPath(), conf);
                ImmutableBytesWritable key = (ImmutableBytesWritable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
                Result value = (Result)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)conf);
                try {
                    while (reader.next((Writable)key)) {
                        value = (Result)reader.getCurrentValue((Object)null);
                        writer.append((Object)key, (Object)value);
                    }
                }
                catch (Throwable throwable) {
                    block14: {
                        boolean bl;
                        block15: {
                            reader.close();
                            if (srcFS.delete(contents[i].getPath(), true)) break block14;
                            bl = false;
                            if (writer == null) break block15;
                            conf.setBoolean("difftablestablesAreDifferent", true);
                            writer.close();
                        }
                        return bl;
                    }
                    throw throwable;
                }
                reader.close();
                if (srcFS.delete(contents[i].getPath(), true)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (writer != null) {
                conf.setBoolean("difftablestablesAreDifferent", true);
                writer.close();
            }
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        int ret = 0;
        if (!DiffTables.doCommandLine(args)) {
            System.exit(1);
        }
        try {
            ret = ToolRunner.run((Configuration)conf, (Tool)new DiffTablesMeta(true), (String[])args);
            if (ret == 1) {
                System.out.println("ERROR: Metadata is different.");
                System.out.println("To skip metadata comparison, use the option -cmpmeta false.");
                System.exit(ret);
            } else if (ret == 3) {
                System.out.println("Skip Metadata test.");
            } else if (ret == 0) {
                System.out.println("DiffTablesMeta completed. Metadata of the two tables is same.");
            }
            ret = ToolRunner.run((Configuration)conf, (Tool)new DiffTables(), (String[])args);
        }
        catch (Exception e) {
            ret = 1;
            e.printStackTrace();
        }
        System.exit(ret);
    }

    static {
        maxVersions = Integer.MAX_VALUE;
        runMR = true;
        exitOnFirstDiff = false;
        mos = null;
        numThreads = 16;
        splitKeyRangeFileName = null;
        includeKeyRangeFileName = null;
        deleteRW1 = true;
        deleteRW2 = true;
        shouldExit = false;
        lock = new Object();
    }

    class LoaderThread
    implements Runnable {
        byte[] startKey;
        byte[] endKey;
        int myid;
        Configuration conf;
        RecordWriter<ImmutableBytesWritable, Result> rw1 = null;
        RecordWriter<ImmutableBytesWritable, Result> rw2 = null;

        LoaderThread(int id, byte[] s, byte[] e, Configuration conf) throws IOException {
            this.myid = id;
            this.startKey = s;
            this.endKey = e;
            this.conf = conf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ResultScanner srcScanner = null;
            ResultScanner dstScanner = null;
            try {
                ArrayList diffs;
                Scan scan = DiffTables.buildScan(this.conf);
                scan.setStartRow(this.startKey);
                scan.setStopRow(this.endKey);
                srcScanner = DiffTables.this.srcTable.getScanner(scan);
                dstScanner = DiffTables.this.dstTable.getScanner(scan);
                String rw1Path = outputDir + "/" + (switchSrcWithDst ? "opsForSrc" : "opsForDst") + "_" + this.myid;
                this.rw1 = this.createRecordWriter(this.conf, rw1Path);
                if (!DiffTables.isAuthEnable()) {
                    String rw2Path = outputDir + "/" + (switchSrcWithDst ? "opsForDst" : "opsForSrc") + "_" + this.myid;
                    this.rw2 = this.createRecordWriter(this.conf, rw2Path);
                }
                Result srcRes = srcScanner.next();
                ScanState dstScanState = new ScanState();
                dstScanState.result = dstScanner.next();
                dstScanState.resultScanner = dstScanner;
                while (srcRes != null) {
                    if (shouldExit) {
                        return;
                    }
                    diffs = DiffTables.scanAndGetDiff(new ImmutableBytesWritable(srcRes.getRow()), srcRes, dstScanState);
                    this.writeDiffs(diffs);
                    srcRes = srcScanner.next();
                }
                if (dstScanState.resultScanner != null) {
                    diffs = DiffTables.dumpRemainingScanner(dstScanState);
                    this.writeDiffs(diffs);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (srcScanner != null) {
                    srcScanner.close();
                }
                if (dstScanner != null) {
                    dstScanner.close();
                }
                try {
                    if (this.rw1 != null) {
                        this.rw1.close(null);
                    }
                    if (this.rw2 != null) {
                        this.rw2.close(null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private void writeDiffs(ArrayList<Diff> diffs) throws IOException, InterruptedException {
            for (Diff diff : diffs) {
                if (diff.srcToDstDiff != null) {
                    this.writeDiff(diff.row, diff.srcToDstDiff, DiffType.SRC_TO_DST);
                }
                if (diff.dstToSrcDiff == null) continue;
                this.writeDiff(diff.row, diff.dstToSrcDiff, DiffType.DST_TO_SRC);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeDiff(ImmutableBytesWritable row, Result diff, DiffType type) {
            if (diff == null || diff.size() == 0) {
                return;
            }
            if (exitOnFirstDiff) {
                Object object = lock;
                synchronized (object) {
                    if (shouldExit) {
                        System.out.println("First diff exists, Thread " + this.myid + " exit.");
                        return;
                    }
                    shouldExit = true;
                    System.out.println("Thread " + this.myid + " see the first diff, set shouldExit to true.");
                }
            }
            misMatchOrError = true;
            if (DiffTables.isAuthEnable() && type == DiffType.DST_TO_SRC) {
                diff = DiffTables.convertPutToDelete(diff);
            }
            try {
                if (DiffTables.isAuthEnable() || type == DiffType.SRC_TO_DST) {
                    deleteRW1 = false;
                    this.rw1.write((Object)row, (Object)diff);
                } else {
                    deleteRW2 = false;
                    this.rw2.write((Object)row, (Object)diff);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (type == DiffType.SRC_TO_DST) {
                numRowsMismatchedInDst.getAndIncrement();
            } else {
                numRowsMismatchedInSrc.getAndIncrement();
            }
        }

        public RecordWriter<ImmutableBytesWritable, Result> createRecordWriter(Configuration conf, String filePath) throws IOException {
            conf.setStrings("io.serializations", new String[]{conf.get("io.serializations"), ResultSerialization.class.getName()});
            Path path = new Path(filePath);
            FileSystem fs = path.getFileSystem(conf);
            final SequenceFile.Writer out = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)path, ImmutableBytesWritable.class, Result.class);
            return new RecordWriter<ImmutableBytesWritable, Result>(){

                public void write(ImmutableBytesWritable key, Result value) throws IOException {
                    out.append((Object)key, (Object)value);
                }

                public void close(TaskAttemptContext context) throws IOException, InterruptedException {
                    out.close();
                }
            };
        }
    }

    static enum FieldType {
        COLUMN_FAMILY,
        QUANTIFIER,
        TIMESTAMP,
        VALUE;

    }

    public static class DiffTableMapper
    extends TableMapper<ImmutableBytesWritable, Result> {
        private Path firstExitFilePath = null;
        private ScanState dstScanState = new ScanState();
        private String dstPath = null;
        private boolean switchSrcWithDst = false;
        public static String outputSrcToDstName = null;
        public static String outputDstToSrcName = null;

        public void startFirstExitChecker(Mapper.Context context) throws IOException {
            FileSystem fs = FileSystem.get((Configuration)context.getConfiguration());
            this.firstExitFilePath = new Path(SegKeyRangeUtil.getTmpDirName(context.getConfiguration()) + "/firstExit");
            FirstExitChecker timerTask = new FirstExitChecker(fs, context.getTaskAttemptID(), this.firstExitFilePath);
            Timer timer = new Timer(true);
            timer.scheduleAtFixedRate((TimerTask)timerTask, 0L, 10000L);
            LOG.info((Object)("Task " + context.getTaskAttemptID() + " start FirstExitChecker."));
        }

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            super.setup(context);
            if (mos == null) {
                mos = new MultipleOutputs((TaskInputOutputContext)context);
            }
            TableSplit tableSplit = (TableSplit)context.getInputSplit();
            final byte[] startRow = tableSplit.getStartRow();
            final byte[] stopRow = tableSplit.getEndRow();
            Configuration conf = context.getConfiguration();
            exitOnFirstDiff = conf.getBoolean("difftables.exitOnFirstDiff", false);
            if (exitOnFirstDiff) {
                this.startFirstExitChecker(context);
            }
            this.dstPath = conf.get("difftables.dstPath");
            masterPath = conf.get("difftables.masterPath");
            this.switchSrcWithDst = conf.getBoolean("difftables.switchSrcWithDst", false);
            final Scan dstScan = DiffTables.buildScan(conf);
            HConnectionManager.execute((HConnectable)new HConnectable<Void>(conf){

                public Void connect(HConnection conn) throws IOException {
                    HTable dstTable = new HTable(this.conf, DiffTableMapper.this.dstPath);
                    dstScan.setStartRow(startRow);
                    dstScan.setStopRow(stopRow);
                    ((DiffTableMapper)DiffTableMapper.this).dstScanState.resultScanner = dstTable.getScanner(dstScan);
                    dstTable.close();
                    return null;
                }
            });
            this.dstScanState.result = this.dstScanState.resultScanner.next();
            if (DiffTables.isAuthEnable()) {
                outputSrcToDstName = this.switchSrcWithDst ? "opsForSrc" : "opsForDst";
                outputDstToSrcName = this.switchSrcWithDst ? "opsForSrc" : "opsForDst";
            } else {
                outputSrcToDstName = this.switchSrcWithDst ? "opsForSrc" : "opsForDst";
                outputDstToSrcName = this.switchSrcWithDst ? "opsForDst" : "opsForSrc";
            }
        }

        public void run(Mapper.Context context) throws IOException, InterruptedException {
            this.setup(context);
            while (context.nextKeyValue() && !shouldExit) {
                this.map((ImmutableBytesWritable)context.getCurrentKey(), (Result)context.getCurrentValue(), context);
            }
            this.cleanup(context);
        }

        public void map(ImmutableBytesWritable row, Result srcResult, Mapper.Context context) throws IOException, InterruptedException {
            ArrayList diffs = DiffTables.scanAndGetDiff(row, srcResult, this.dstScanState);
            this.writeDiffs(diffs, context);
        }

        protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            if (this.dstScanState.resultScanner != null) {
                ArrayList diffs = DiffTables.dumpRemainingScanner(this.dstScanState);
                this.writeDiffs(diffs, context);
                this.dstScanState.resultScanner.close();
            }
            mos.close();
            mos = null;
        }

        private void writeDiffs(ArrayList<Diff> diffs, Mapper.Context context) throws IOException, InterruptedException {
            for (Diff diff : diffs) {
                if (diff.srcToDstDiff != null) {
                    this.writeDiff(diff.row, diff.srcToDstDiff, DiffType.SRC_TO_DST, context);
                }
                if (diff.dstToSrcDiff == null) continue;
                this.writeDiff(diff.row, diff.dstToSrcDiff, DiffType.DST_TO_SRC, context);
            }
        }

        private void writeDiff(ImmutableBytesWritable row, Result diff, DiffType type, Mapper.Context context) throws IOException, InterruptedException {
            if (diff == null || diff.size() == 0) {
                return;
            }
            if (exitOnFirstDiff) {
                shouldExit = true;
                try {
                    FileSystem fs = FileSystem.get((Configuration)context.getConfiguration());
                    fs.create(this.firstExitFilePath, false);
                    LOG.info((Object)("A first difference was encountered. Task " + context.getTaskAttemptID() + " creates first_diff file and should exit."));
                }
                catch (IOException e) {
                    LOG.info((Object)("Create first exit file fails. first diff exists, Task " + context.getTaskAttemptID() + " should exit."));
                    return;
                }
            }
            if (DiffTables.isAuthEnable() && type == DiffType.DST_TO_SRC) {
                diff = DiffTables.convertPutToDelete(diff);
            }
            mos.write((Object)row, (Object)diff, type == DiffType.SRC_TO_DST ? outputSrcToDstName : outputDstToSrcName);
            if (type == DiffType.SRC_TO_DST) {
                context.getCounter((Enum)COUNTERS.NUM_ROWS_MISMATCH_IN_DST).increment(1L);
            } else {
                context.getCounter((Enum)COUNTERS.NUM_ROWS_MISMATCH_IN_SRC).increment(1L);
            }
        }

        public class FirstExitChecker
        extends TimerTask {
            private FileSystem fs;
            private TaskAttemptID id;
            private Path firstExitFilePath;

            public FirstExitChecker(FileSystem fs, TaskAttemptID id, Path tmpFile) throws IOException {
                this.fs = fs;
                this.id = id;
                this.firstExitFilePath = tmpFile;
            }

            @Override
            public void run() {
                try {
                    if (this.fs.exists(this.firstExitFilePath)) {
                        LOG.info((Object)("In Timer, first diff exists, Task " + this.id + " should exit."));
                        shouldExit = true;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class Diff {
        ImmutableBytesWritable row = null;
        Result srcToDstDiff = null;
        Result dstToSrcDiff = null;

        public Diff(ImmutableBytesWritable row, Result srcToDstDiff, Result dstToSrcDiff) {
            this.row = row;
            this.srcToDstDiff = srcToDstDiff;
            this.dstToSrcDiff = dstToSrcDiff;
        }
    }

    public static class ScanState {
        public Result result = null;
        public ResultScanner resultScanner = null;
    }

    public static enum COUNTERS {
        NUM_ROWS_MISMATCH_IN_SRC,
        NUM_ROWS_MISMATCH_IN_DST;

    }

    static enum DiffType {
        SRC_TO_DST,
        DST_TO_SRC;

    }
}

