/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.google.protobuf.ByteString;
import com.mapr.fs.proto.Dbfilters;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.BinaryPrefixComparator;
import org.apache.hadoop.hbase.filter.BitComparator;
import org.apache.hadoop.hbase.filter.ColumnCountGetFilter;
import org.apache.hadoop.hbase.filter.ColumnPaginationFilter;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.ColumnRangeFilter;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.DependentColumnFilter;
import org.apache.hadoop.hbase.filter.FamilyFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.FuzzyRowFilter;
import org.apache.hadoop.hbase.filter.InclusiveStopFilter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.MultipleColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.NullComparator;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RandomRowFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueExcludeFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.SkipFilter;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.filter.TimestampsFilter;
import org.apache.hadoop.hbase.filter.ValueFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.util.Bytes;

public class FilterSerializer {
    public static final int kColumnCountGetFilter = 409745603;
    public static final int kColumnPaginationFilter = -2105150122;
    public static final int kColumnPrefixFilter = -1669216178;
    public static final int kColumnRangeFilter = 447559409;
    public static final int kDependentColumnFilter = 321328927;
    public static final int kFamilyFilter = -2132594774;
    public static final int kFilterList = -1540440220;
    public static final int kFirstKeyOnlyFilter = -246927775;
    public static final int kFuzzyRowFilter = -707981514;
    public static final int kInclusiveStopFilter = -415384136;
    public static final int kKeyOnlyFilter = -1104448491;
    public static final int kMultipleColumnPrefixFilter = 1191557246;
    public static final int kPageFilter = 917503509;
    public static final int kPrefixFilter = -446632872;
    public static final int kQualifierFilter = -445873580;
    public static final int kRandomRowFilter = 1771146753;
    public static final int kRowFilter = 1184742660;
    public static final int kSingleColumnValueFilter = 1032050493;
    public static final int kSingleColumnValueExcludeFilter = -1891801459;
    public static final int kSkipFilter = -203453179;
    public static final int kTimestampsFilter = -109471581;
    public static final int kValueFilter = -1408316709;
    public static final int kWhileMatchFilter = -1452360102;
    public static final int kBinaryComparator = 99850341;
    public static final int kBinaryPrefixComparator = -553094825;
    public static final int kBitComparator = 1829255125;
    public static final int kNullComparator = -2059143701;
    public static final int kRegexStringComparator = -489178560;
    public static final int kSubstringComparator = 261492377;

    public static String getFilterId(int hashCode) {
        return String.format("%08x", hashCode);
    }

    public static Dbfilters.FilterMsg serialize(Filter filterToSerialize) throws IOException {
        if (filterToSerialize == null) {
            throw new NullPointerException();
        }
        String classname = filterToSerialize.getClass().getName();
        String id = FilterSerializer.getFilterId(classname.hashCode());
        ByteString state = ByteString.EMPTY;
        switch (classname.hashCode()) {
            case 409745603: {
                ColumnCountGetFilter filter = (ColumnCountGetFilter)filterToSerialize;
                state = Dbfilters.ColumnCountGetFilterProto.newBuilder().setLimit(filter.getLimit()).build().toByteString();
                break;
            }
            case -2105150122: {
                ColumnPaginationFilter filter = (ColumnPaginationFilter)filterToSerialize;
                state = Dbfilters.ColumnPaginationFilterProto.newBuilder().setLimit(filter.getLimit()).setOffset(filter.getOffset()).build().toByteString();
                break;
            }
            case -1669216178: {
                ColumnPrefixFilter filter = (ColumnPrefixFilter)filterToSerialize;
                state = Dbfilters.ColumnPrefixFilterProto.newBuilder().setPrefix(ByteString.copyFrom((byte[])filter.getPrefix())).build().toByteString();
                break;
            }
            case 447559409: {
                ColumnRangeFilter filter = (ColumnRangeFilter)filterToSerialize;
                Dbfilters.ColumnRangeFilterProto.Builder crfp = Dbfilters.ColumnRangeFilterProto.newBuilder();
                if (filter.getMinColumn() != null) {
                    crfp.setMinColumn(ByteString.copyFrom((byte[])filter.getMinColumn()));
                    crfp.setMinColumnInclusive(filter.getMinColumnInclusive());
                }
                if (filter.getMaxColumn() != null) {
                    crfp.setMaxColumn(ByteString.copyFrom((byte[])filter.getMaxColumn()));
                    crfp.setMaxColumnInclusive(filter.getMaxColumnInclusive());
                }
                state = crfp.build().toByteString();
                break;
            }
            case 321328927: {
                DependentColumnFilter filter = (DependentColumnFilter)filterToSerialize;
                state = Dbfilters.DependentColumnFilterProto.newBuilder().setColumnFamily(ByteString.copyFrom((byte[])filter.getFamily())).setColumnQualifier(ByteString.copyFrom((byte[])filter.getQualifier())).setDropDependentColumn(filter.getDropDependentColumn()).setFilterComparator(FilterSerializer.toFilterComparatorProto((CompareFilter)filter)).build().toByteString();
                break;
            }
            case -2132594774: {
                FamilyFilter filter = (FamilyFilter)filterToSerialize;
                state = Dbfilters.FamilyFilterProto.newBuilder().setFilterComparator(FilterSerializer.toFilterComparatorProto((CompareFilter)filter)).build().toByteString();
                break;
            }
            case -1540440220: {
                FilterList filterList = (FilterList)filterToSerialize;
                Dbfilters.FilterListProto.Builder builder = Dbfilters.FilterListProto.newBuilder();
                builder.setOperator(Dbfilters.FilterListProto.OperatorProto.valueOf((String)filterList.getOperator().name()));
                for (Filter filter : filterList.getFilters()) {
                    builder.addFilters(FilterSerializer.serialize(filter));
                }
                state = builder.build().toByteString();
                break;
            }
            case -246927775: {
                state = Dbfilters.FirstKeyOnlyFilterProto.newBuilder().build().toByteString();
                break;
            }
            case -707981514: {
                FuzzyRowFilter filter = (FuzzyRowFilter)filterToSerialize;
                Dbfilters.FuzzyRowFilterProto.Builder builder = Dbfilters.FuzzyRowFilterProto.newBuilder();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                filter.write((DataOutput)dos);
                DataInputStream dis = new DataInputStream(new ByteArrayInputStream(baos.toByteArray()));
                int fuzzyKeysCount = dis.readInt();
                for (int i = 0; i < fuzzyKeysCount; ++i) {
                    Dbfilters.BytesBytesPairProto.Builder pairBuilder = Dbfilters.BytesBytesPairProto.newBuilder();
                    pairBuilder.setFirst(ByteString.copyFrom((byte[])Bytes.readByteArray((DataInput)dis)));
                    pairBuilder.setSecond(ByteString.copyFrom((byte[])Bytes.readByteArray((DataInput)dis)));
                    builder.addFuzzyKeysData(pairBuilder.build());
                }
                state = builder.build().toByteString();
                break;
            }
            case -415384136: {
                InclusiveStopFilter filter = (InclusiveStopFilter)filterToSerialize;
                state = Dbfilters.InclusiveStopFilterProto.newBuilder().setStopRowKey(ByteString.copyFrom((byte[])filter.getStopRowKey())).build().toByteString();
                break;
            }
            case -1104448491: {
                KeyOnlyFilter filter = (KeyOnlyFilter)filterToSerialize;
                state = Dbfilters.KeyOnlyFilterProto.newBuilder().setLenAsVal(filter.isLenAsVal()).build().toByteString();
                break;
            }
            case 1191557246: {
                MultipleColumnPrefixFilter filter = (MultipleColumnPrefixFilter)filterToSerialize;
                Dbfilters.MultipleColumnPrefixFilterProto.Builder builder = Dbfilters.MultipleColumnPrefixFilterProto.newBuilder();
                for (byte[] prefix : filter.getSortedPrefixes()) {
                    builder.addSortedPrefixes(ByteString.copyFrom((byte[])prefix));
                }
                state = builder.build().toByteString();
                break;
            }
            case 917503509: {
                PageFilter filter = (PageFilter)filterToSerialize;
                state = Dbfilters.PageFilterProto.newBuilder().setPageSize(filter.getPageSize()).setRowsAccepted(0L).build().toByteString();
                break;
            }
            case -446632872: {
                PrefixFilter filter = (PrefixFilter)filterToSerialize;
                state = Dbfilters.PrefixFilterProto.newBuilder().setPrefix(ByteString.copyFrom((byte[])filter.getPrefix())).build().toByteString();
                break;
            }
            case -445873580: {
                QualifierFilter filter = (QualifierFilter)filterToSerialize;
                state = Dbfilters.QualifierFilterProto.newBuilder().setFilterComparator(FilterSerializer.toFilterComparatorProto((CompareFilter)filter)).build().toByteString();
                break;
            }
            case 1771146753: {
                RandomRowFilter filter = (RandomRowFilter)filterToSerialize;
                state = Dbfilters.RandomRowFilterProto.newBuilder().setChance(filter.getChance()).build().toByteString();
                break;
            }
            case 1184742660: {
                RowFilter filter = (RowFilter)filterToSerialize;
                state = Dbfilters.RowFilterProto.newBuilder().setFilterComparator(FilterSerializer.toFilterComparatorProto((CompareFilter)filter)).build().toByteString();
                break;
            }
            case 1032050493: {
                SingleColumnValueFilter filter = (SingleColumnValueFilter)filterToSerialize;
                state = Dbfilters.SingleColumnValueFilterProto.newBuilder().setColumnFamily(ByteString.copyFrom((byte[])filter.getFamily())).setColumnQualifier(ByteString.copyFrom((byte[])filter.getQualifier())).setFilterComparator(FilterSerializer.toFilterComparatorProto(filter.getOperator(), filter.getComparator())).setFilterIfMissing(filter.getFilterIfMissing()).setLatestVersionOnly(filter.getLatestVersionOnly()).build().toByteString();
                break;
            }
            case -1891801459: {
                SingleColumnValueExcludeFilter filter = (SingleColumnValueExcludeFilter)filterToSerialize;
                state = Dbfilters.SingleColumnValueExcludeFilterProto.newBuilder().setSingleColumnValueFilter(Dbfilters.SingleColumnValueFilterProto.newBuilder().setColumnFamily(ByteString.copyFrom((byte[])filter.getFamily())).setColumnQualifier(ByteString.copyFrom((byte[])filter.getQualifier())).setFilterComparator(FilterSerializer.toFilterComparatorProto(filter.getOperator(), filter.getComparator())).setFilterIfMissing(filter.getFilterIfMissing()).setLatestVersionOnly(filter.getLatestVersionOnly()).build()).build().toByteString();
                break;
            }
            case -203453179: {
                SkipFilter filter = (SkipFilter)filterToSerialize;
                state = Dbfilters.SkipFilterProto.newBuilder().setFilter(FilterSerializer.serialize(filter.getFilter())).build().toByteString();
                break;
            }
            case -109471581: {
                TimestampsFilter filter = (TimestampsFilter)filterToSerialize;
                Dbfilters.TimestampsFilterProto.Builder builder = Dbfilters.TimestampsFilterProto.newBuilder();
                Iterator i$ = filter.getTimestamps().iterator();
                while (i$.hasNext()) {
                    long timestamp = (Long)i$.next();
                    builder.addTimestamps(timestamp);
                }
                state = builder.build().toByteString();
                break;
            }
            case -1408316709: {
                ValueFilter filter = (ValueFilter)filterToSerialize;
                state = Dbfilters.ValueFilterProto.newBuilder().setFilterComparator(FilterSerializer.toFilterComparatorProto((CompareFilter)filter)).build().toByteString();
                break;
            }
            case -1452360102: {
                WhileMatchFilter filter = (WhileMatchFilter)filterToSerialize;
                state = Dbfilters.WhileMatchFilterProto.newBuilder().setFilter(FilterSerializer.serialize(filter.getFilter())).build().toByteString();
                break;
            }
            default: {
                id = classname;
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                filterToSerialize.write((DataOutput)new DataOutputStream(buffer));
                state = ByteString.copyFrom((byte[])buffer.toByteArray());
            }
        }
        return Dbfilters.FilterMsg.newBuilder().setId(id).setSerializedState(state).build();
    }

    protected static Dbfilters.FilterComparatorProto toFilterComparatorProto(CompareFilter filter) throws IOException {
        return FilterSerializer.toFilterComparatorProto(filter.getOperator(), filter.getComparator());
    }

    protected static Dbfilters.FilterComparatorProto toFilterComparatorProto(CompareFilter.CompareOp op, WritableByteArrayComparable comparator) throws IOException {
        Dbfilters.FilterComparatorProto.Builder builder = Dbfilters.FilterComparatorProto.newBuilder();
        builder.setCompareOp(Dbfilters.CompareOpProto.valueOf((String)op.name()));
        if (comparator != null) {
            builder.setComparator(FilterSerializer.toComparatorProto(comparator));
        }
        return builder.build();
    }

    protected static Dbfilters.ComparatorProto toComparatorProto(WritableByteArrayComparable hbaseComparator) throws IOException {
        String classname = hbaseComparator.getClass().getName();
        String name = FilterSerializer.getFilterId(classname.hashCode());
        ByteString state = ByteString.EMPTY;
        switch (classname.hashCode()) {
            case 99850341: {
                BinaryComparator cmp = (BinaryComparator)hbaseComparator;
                state = Dbfilters.BinaryComparatorProto.newBuilder().setComparable(ByteString.copyFrom((byte[])cmp.getValue())).build().toByteString();
                break;
            }
            case -553094825: {
                BinaryPrefixComparator cmp = (BinaryPrefixComparator)hbaseComparator;
                state = Dbfilters.BinaryPrefixComparatorProto.newBuilder().setComparable(ByteString.copyFrom((byte[])cmp.getValue())).build().toByteString();
                break;
            }
            case 1829255125: {
                BitComparator cmp = (BitComparator)hbaseComparator;
                state = Dbfilters.BitComparatorProto.newBuilder().setComparable(ByteString.copyFrom((byte[])cmp.getValue())).setBitwiseOp(Dbfilters.BitComparatorProto.BitwiseOpProto.valueOf((String)cmp.getOperator().name())).build().toByteString();
                break;
            }
            case -2059143701: {
                state = Dbfilters.NullComparatorProto.newBuilder().build().toByteString();
                break;
            }
            case -489178560: {
                RegexStringComparator cmp = (RegexStringComparator)hbaseComparator;
                state = Dbfilters.RegexStringComparatorProto.newBuilder().setPattern(ByteString.copyFrom((byte[])cmp.getPattern().getBytes("UTF-8"))).build().toByteString();
                break;
            }
            case 261492377: {
                SubstringComparator cmp = (SubstringComparator)hbaseComparator;
                state = Dbfilters.SubstringComparatorProto.newBuilder().setSubstr(cmp.getSubstr()).build().toByteString();
                break;
            }
            default: {
                name = classname;
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                hbaseComparator.write((DataOutput)new DataOutputStream(buffer));
                state = ByteString.copyFrom((byte[])buffer.toByteArray());
            }
        }
        return Dbfilters.ComparatorProto.newBuilder().setName(name).setSerializedComparator(state).build();
    }

    public static void main(String[] args) {
        Class[] allFilters = new Class[]{ColumnCountGetFilter.class, ColumnPaginationFilter.class, ColumnPrefixFilter.class, ColumnRangeFilter.class, DependentColumnFilter.class, FamilyFilter.class, FilterList.class, FirstKeyOnlyFilter.class, FuzzyRowFilter.class, InclusiveStopFilter.class, KeyOnlyFilter.class, MultipleColumnPrefixFilter.class, PageFilter.class, PrefixFilter.class, QualifierFilter.class, RandomRowFilter.class, RowFilter.class, SingleColumnValueFilter.class, SingleColumnValueExcludeFilter.class, SkipFilter.class, TimestampsFilter.class, ValueFilter.class, WhileMatchFilter.class};
        Class[] allComparators = new Class[]{BinaryComparator.class, BinaryPrefixComparator.class, BitComparator.class, NullComparator.class, RegexStringComparator.class, SubstringComparator.class};
        FilterSerializer.createConstants(allFilters);
        System.out.println();
        FilterSerializer.createSwitchCase(allFilters);
        System.out.println();
        FilterSerializer.createConstants(allComparators);
        System.out.println();
        FilterSerializer.createSwitchCase(allComparators);
    }

    public static void createSwitchCase(Class[] allFilters) {
        System.out.println("switch (classname.hashCode()) {");
        for (Class clazz : allFilters) {
            FilterSerializer.createCase(clazz);
        }
        System.out.println("default:");
        System.out.println("  break;");
        System.out.println("}");
    }

    public static void createCase(Class clazz) {
        System.out.println("case k" + clazz.getSimpleName() + ":");
        System.out.println("  break;");
    }

    public static void createConstants(Class[] allFilters) {
        for (Class clazz : allFilters) {
            FilterSerializer.createConstant(clazz);
        }
    }

    public static void createConstant(Class clazz) {
        System.out.println(String.format("public static final int k%-32s= 0x%08x;", clazz.getSimpleName(), clazz.getName().hashCode()));
    }
}

