/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.FilterSerializer;
import com.mapr.fs.MapRHTable;
import com.mapr.fs.RowConstraintConverter;
import com.mapr.fs.jni.MapRScan;
import com.mapr.fs.proto.Dbfilters;
import java.io.IOException;
import org.apache.hadoop.hbase.client.Scan;

public class ScanConverter {
    public static MapRScan toMapRScan(Scan scan, MapRHTable htable) throws IOException {
        MapRScan maprscan = new MapRScan();
        maprscan.batch = scan.getBatch();
        maprscan.caching = scan.getCaching();
        maprscan.startRow = scan.getStartRow();
        maprscan.stopRow = scan.getStopRow();
        maprscan.filter = null;
        maprscan.rowConstraint = RowConstraintConverter.toRowConstraint(htable, scan.getFamilyMap(), scan.getMaxVersions(), scan.getTimeRange().getMin(), scan.getTimeRange().getMax());
        if (scan.getFilter() != null) {
            Dbfilters.FilterMsg filterMsg = FilterSerializer.serialize(scan.getFilter());
            maprscan.setFilter(filterMsg.toByteArray());
        }
        return maprscan;
    }
}

