/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase.mapreduce;

import com.mapr.fs.BulkLoadHelper;
import com.mapr.fs.hbase.mapreduce.HFileInputFormat;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat;
import org.apache.hadoop.hbase.mapreduce.KeyValueSortReducer;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.mapreduce.hadoopbackport.InputSampler;
import org.apache.hadoop.hbase.mapreduce.hadoopbackport.TotalOrderPartitioner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class ImportFiles
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(ImportFiles.class);
    String inputDir = null;
    String tableName = null;
    boolean sampleInputFiles = true;
    boolean isResult = true;
    boolean mappersOnly = false;
    static final String NAME = "ImportFiles";

    private void usage() {
        System.err.println("Usage: ImportFiles -inputDir inputDir -table table <-format Result|HFile> <-sample true|false> <-mapOnly true|false>");
        System.exit(1);
    }

    private void parseArgs(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            String bval;
            if (args[i].equalsIgnoreCase("-inputDir")) {
                this.inputDir = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-table")) {
                this.tableName = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-format")) {
                String format;
                if ((format = args[++i]).equalsIgnoreCase("Result")) {
                    this.isResult = true;
                    continue;
                }
                if (format.equalsIgnoreCase("HFile")) {
                    this.isResult = false;
                    continue;
                }
                System.err.println("unknown format : " + format);
                this.usage();
                continue;
            }
            if (args[i].equalsIgnoreCase("-sample")) {
                if ((bval = args[++i]).equalsIgnoreCase("true")) {
                    this.sampleInputFiles = true;
                    continue;
                }
                if (bval.equalsIgnoreCase("false")) {
                    this.sampleInputFiles = false;
                    continue;
                }
                System.err.println("Invalid option for -sample");
                this.usage();
                continue;
            }
            if (args[i].equalsIgnoreCase("-mapOnly")) {
                if ((bval = args[++i]).equalsIgnoreCase("true")) {
                    this.mappersOnly = true;
                    continue;
                }
                if (bval.equalsIgnoreCase("false")) {
                    this.mappersOnly = false;
                    continue;
                }
                System.err.println("Invalid option for -mapOnly");
                this.usage();
                continue;
            }
            this.usage();
        }
        if (this.inputDir == null || this.tableName == null) {
            this.usage();
        }
    }

    private static List<ImmutableBytesWritable> getRegionStartKeys(HTable table) throws IOException {
        byte[][] byteKeys = table.getStartKeys();
        ArrayList<ImmutableBytesWritable> ret = new ArrayList<ImmutableBytesWritable>(byteKeys.length);
        for (byte[] byteKey : byteKeys) {
            ret.add(new ImmutableBytesWritable(byteKey));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePartitions(Configuration conf, Path partitionsPath, List<ImmutableBytesWritable> startKeys) throws IOException {
        if (startKeys.isEmpty()) {
            throw new IllegalArgumentException("No regions passed");
        }
        TreeSet<ImmutableBytesWritable> sorted = new TreeSet<ImmutableBytesWritable>(startKeys);
        ImmutableBytesWritable first = sorted.first();
        if (!first.equals((Object)HConstants.EMPTY_BYTE_ARRAY)) {
            throw new IllegalArgumentException("First region of table should have empty start key. Instead has: " + Bytes.toStringBinary((byte[])first.get()));
        }
        sorted.remove(first);
        FileSystem fs = partitionsPath.getFileSystem(conf);
        try (SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)partitionsPath, ImmutableBytesWritable.class, NullWritable.class);){
            for (ImmutableBytesWritable startKey : sorted) {
                writer.append((Writable)startKey, (Writable)NullWritable.get());
            }
        }
    }

    private static void dumpPartitions(Configuration conf, Path partitionsPath) throws IOException {
        FileSystem fs = partitionsPath.getFileSystem(conf);
        SequenceFile.Reader reader = new SequenceFile.Reader(fs, partitionsPath, conf);
        ImmutableBytesWritable key = new ImmutableBytesWritable();
        NullWritable value = NullWritable.get();
        int i = 0;
        while (reader.next((Writable)key, (Writable)value)) {
            LOG.info((Object)("Partition " + i + " : " + Bytes.toString((byte[])key.get())));
            ++i;
        }
        reader.close();
    }

    public int run(String[] args) throws Exception {
        this.parseArgs(args);
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        if (!fs.exists(new Path(this.inputDir))) {
            throw new Exception("Input directory " + this.inputDir + " does not exist.");
        }
        try {
            HTable table = new HTable(this.getConf(), this.tableName);
            table.close();
        }
        catch (Exception e) {
            throw new Exception("Cannot open table " + this.tableName + ": " + e.getMessage());
        }
        Job job = new Job(this.getConf(), "ImportFiles_" + this.tableName);
        Configuration conf = job.getConfiguration();
        job.setJarByClass(ImportFiles.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(this.inputDir)});
        if (this.isResult) {
            job.setInputFormatClass(SequenceFileInputFormat.class);
            job.setMapperClass(ResultImporter.class);
        } else {
            job.setInputFormatClass(HFileInputFormat.class);
        }
        job.setMapOutputKeyClass(ImmutableBytesWritable.class);
        job.setMapOutputValueClass(KeyValue.class);
        String uuid = UUID.randomUUID().toString();
        job.setPartitionerClass(TotalOrderPartitioner.class);
        Path partitionFile = new Path(job.getWorkingDirectory(), "partitions_" + uuid);
        TotalOrderPartitioner.setPartitionFile((Configuration)conf, (Path)partitionFile);
        if (this.sampleInputFiles) {
            InputSampler.SplitSampler sampler = new InputSampler.SplitSampler(1000);
            InputSampler.writePartitionFile((Job)job, (InputSampler.Sampler)sampler);
        } else {
            LOG.info((Object)("Looking up current regions for table " + this.tableName));
            HTable table = new HTable(conf, this.tableName);
            List<ImmutableBytesWritable> startKeys = ImportFiles.getRegionStartKeys(table);
            ImportFiles.writePartitions(conf, partitionFile, startKeys);
            if (this.mappersOnly) {
                job.setNumReduceTasks(0);
            } else {
                LOG.info((Object)("Configuring " + startKeys.size() + " reduce partitions " + "to match current region count"));
                job.setNumReduceTasks(startKeys.size());
            }
        }
        ImportFiles.dumpPartitions(conf, partitionFile);
        URI partitionUri = new URI(partitionFile.toString());
        DistributedCache.addCacheFile((URI)partitionUri, (Configuration)conf);
        if (!this.mappersOnly) {
            job.setReducerClass(KeyValueSortReducer.class);
        }
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(job.getWorkingDirectory(), "output_" + uuid));
        job.setOutputKeyClass(ImmutableBytesWritable.class);
        job.setOutputValueClass(KeyValue.class);
        job.setOutputFormatClass(HFileOutputFormat.class);
        HFileOutputFormat.configureMapRTablePath((Job)job, (String)this.tableName);
        job.submit();
        int ret = job.waitForCompletion(true) ? 0 : 1;
        BulkLoadHelper.clearBulkLoad(conf, this.tableName);
        return ret;
    }

    public static void main(String[] args) throws Exception {
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)new Configuration(), (Tool)new ImportFiles(), (String[])args);
        }
        catch (Exception e) {
            ret = 1;
            e.printStackTrace();
        }
        System.exit(ret);
    }

    static class ResultImporter
    extends TableMapper<ImmutableBytesWritable, KeyValue> {
        ResultImporter() {
        }

        public void map(ImmutableBytesWritable row, Result value, Mapper.Context context) throws IOException {
            try {
                for (KeyValue kv : value.raw()) {
                    context.write((Object)row, (Object)kv);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

