/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class CmpTables
extends Configured
implements Tool {
    String srcPath;
    String dstPath;
    int numThreads = 16;
    HTable srcTable;
    HTable dstTable;
    AtomicLong numRowsMatched;
    boolean misMatchOrError = false;
    String cfStr;

    private void Usage() {
        System.err.println("usage: CmpTables -src srcPath -dst dstPath [-numthreads num (default:" + this.numThreads + ")" + " -cfs columnFamilies]");
        System.exit(1);
    }

    private void ParseArgs(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-src")) {
                this.srcPath = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-dst")) {
                this.dstPath = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-numthreads")) {
                this.numThreads = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-cfs")) {
                this.cfStr = args[++i];
                continue;
            }
            this.Usage();
        }
        if (this.srcPath == null || this.dstPath == null) {
            this.Usage();
        }
    }

    public int run(String[] args) throws Exception {
        Configuration conf = this.getConf();
        conf.set("fs.default.name", "maprfs:///");
        conf.set("fs.maprfs.impl", "com.mapr.fs.MapRFileSystem");
        conf.set("mapr.htable.impl", "com.mapr.fs.MapRHTable");
        this.ParseArgs(args);
        this.srcTable = new HTable(conf, this.srcPath.getBytes());
        byte[][] startKeys = this.srcTable.getStartKeys();
        byte[][] endKeys = this.srcTable.getEndKeys();
        int numSplits = startKeys.length;
        this.dstTable = new HTable(conf, this.dstPath.getBytes());
        this.numRowsMatched = new AtomicLong();
        long ts = System.currentTimeMillis();
        ExecutorService executor = Executors.newFixedThreadPool(this.numThreads);
        for (int i = 0; i < numSplits; ++i) {
            executor.execute(new LoaderThread(i, startKeys[i], endKeys[i]));
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        if (this.misMatchOrError) {
            return 1;
        }
        long te = System.currentTimeMillis();
        System.out.println("Test completed in " + (te - ts) + " ms");
        System.out.println("The tables match, compared " + this.numRowsMatched.get() + " rows");
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)new Configuration(), (Tool)new CmpTables(), (String[])args);
        }
        catch (Exception e) {
            ret = 1;
            e.printStackTrace();
        }
        System.exit(ret);
    }

    class LoaderThread
    implements Runnable {
        byte[] startKey;
        byte[] endKey;
        int myid;

        LoaderThread(int id, byte[] s, byte[] e) {
            this.myid = id;
            this.startKey = s;
            this.endKey = e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ResultScanner srcScanner = null;
            ResultScanner dstScanner = null;
            try {
                Scan scan = new Scan(this.startKey, this.endKey);
                if (CmpTables.this.cfStr != null) {
                    StringTokenizer st = new StringTokenizer(CmpTables.this.cfStr, ",");
                    while (st.hasMoreTokens()) {
                        scan.addFamily(st.nextToken().getBytes());
                    }
                }
                scan.setMaxVersions();
                srcScanner = CmpTables.this.srcTable.getScanner(scan);
                dstScanner = CmpTables.this.dstTable.getScanner(scan);
                Result srcRes = srcScanner.next();
                Result dstRes = dstScanner.next();
                Result srcResPrev = null;
                Result dstResPrev = null;
                while (srcRes != null || dstRes != null) {
                    if (srcRes == null) {
                        System.err.println("scanner on " + CmpTables.this.srcPath + " ended prematurely");
                        if (srcResPrev != null) {
                            System.err.println("last row on " + CmpTables.this.srcPath + ": " + srcResPrev);
                        }
                        throw new Exception("table mismatch");
                    }
                    if (dstRes == null) {
                        System.err.println("scanner on " + CmpTables.this.dstPath + " ended prematurely");
                        if (dstResPrev != null) {
                            System.err.println("last row on " + CmpTables.this.dstPath + ": " + dstResPrev);
                        }
                        throw new Exception("table mismatch");
                    }
                    Result.compareResults((Result)srcRes, (Result)dstRes);
                    srcResPrev = srcRes;
                    dstResPrev = dstRes;
                    srcRes = srcScanner.next();
                    dstRes = dstScanner.next();
                    CmpTables.this.numRowsMatched.getAndIncrement();
                }
            }
            catch (Exception e) {
                CmpTables.this.misMatchOrError = true;
                e.printStackTrace();
            }
            finally {
                if (srcScanner != null) {
                    srcScanner.close();
                }
                if (dstScanner != null) {
                    dstScanner.close();
                }
            }
        }
    }
}

