/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase.tools.mapreduce;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.HConnectable;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.LazyOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class DiffTables
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(DiffTables.class);
    public static final String NAME = "difftables";
    static long startTime = 0L;
    static long endTime = Long.MAX_VALUE;
    static String srcTableName = null;
    static String destTableName = null;
    static boolean onlyCertainColumnFamilies = false;
    static String families = null;
    static int maxVersions = Integer.MAX_VALUE;
    static OutputFormat outputFormat = OutputFormat.SEQUENCE;
    static String outputDir = "/difftablesOut";
    static boolean exitOnFirstDiff = false;
    static boolean exit = false;
    public static boolean donePrintUsage = false;

    public static Job createSubmittableJob(Configuration conf, String[] args) throws IOException {
        if (!DiffTables.doCommandLine(args)) {
            return null;
        }
        conf.setBoolean("difftables.exitOnFirstDiff", exitOnFirstDiff);
        conf.set("difftables.destTableName", destTableName);
        if (families != null) {
            conf.set("difftables.families", families);
        }
        conf.setLong("difftables.startTime", startTime);
        conf.setLong("difftables.endTime", endTime);
        conf.setInt("difftables.maxVersions", maxVersions);
        Job job = new Job(conf, NAME);
        job.setJarByClass(DiffTables.class);
        Scan srcScan = new Scan();
        srcScan.setTimeRange(startTime, endTime);
        if (families != null) {
            String[] fams;
            for (String fam : fams = families.split(",")) {
                srcScan.addFamily(Bytes.toBytes((String)fam));
            }
        }
        srcScan.setMaxVersions(maxVersions);
        TableMapReduceUtil.initTableMapperJob((String)srcTableName, (Scan)srcScan, DiffTableMapper.class, ImmutableBytesWritable.class, Result.class, (Job)job);
        job.setNumReduceTasks(0);
        job.setOutputKeyClass(ImmutableBytesWritable.class);
        job.setOutputValueClass(Result.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputDir + "/" + srcTableName.replace("/", "") + "To" + destTableName.replace("/", "") + ".diff"));
        if (outputFormat == OutputFormat.SEQUENCE) {
            LazyOutputFormat.setOutputFormatClass((Job)job, SequenceFileOutputFormat.class);
        } else {
            LazyOutputFormat.setOutputFormatClass((Job)job, TextOutputFormat.class);
            job.getConfiguration().setBoolean("difftables.isBinaryOutput", false);
        }
        return job;
    }

    private static boolean doCommandLine(String[] args) {
        if (args.length < 4) {
            DiffTables.printUsage(null);
            return false;
        }
        try {
            for (int i = 0; i < args.length; ++i) {
                String cmd = args[i];
                if (cmd.equals("-h") || cmd.startsWith("--h")) {
                    DiffTables.printUsage(null);
                    return false;
                }
                if (cmd.equals("-src")) {
                    if (!DiffTables.checkNextArg(args, i)) {
                        return false;
                    }
                    srcTableName = args[i + 1];
                    continue;
                }
                if (cmd.equals("-dst")) {
                    if (!DiffTables.checkNextArg(args, i)) {
                        return false;
                    }
                    destTableName = args[i + 1];
                    continue;
                }
                if (cmd.equals("-cf")) {
                    if (!DiffTables.checkNextArg(args, i)) {
                        return false;
                    }
                    onlyCertainColumnFamilies = true;
                    families = args[i + 1];
                    continue;
                }
                if (cmd.equals("-time_range")) {
                    if (!DiffTables.checkNextArg(args, i)) {
                        return false;
                    }
                    if (args[i + 1].split(",").length < 2) {
                        DiffTables.printUsage(null);
                        return false;
                    }
                    String startTimeString = args[i + 1].split(",")[0];
                    String endTimeString = args[i + 1].split(",")[1];
                    startTime = startTimeString.equals("-INF") ? 0L : Long.parseLong(startTimeString);
                    if (endTimeString.equals("INF")) {
                        endTime = Long.MAX_VALUE;
                        continue;
                    }
                    endTime = Long.parseLong(endTimeString);
                    continue;
                }
                if (cmd.equals("-output_format")) {
                    if (!DiffTables.checkNextArg(args, i)) {
                        return false;
                    }
                    if (args[i + 1].equals("text")) {
                        outputFormat = OutputFormat.TEXT;
                        continue;
                    }
                    if (args[i + 1].equals("sequence")) {
                        outputFormat = OutputFormat.SEQUENCE;
                        continue;
                    }
                    DiffTables.printUsage(null);
                    return false;
                }
                if (cmd.equals("-outdir")) {
                    if (!DiffTables.checkNextArg(args, i)) {
                        return false;
                    }
                    outputDir = args[i + 1];
                    continue;
                }
                if (cmd.equals("-first_exit")) {
                    exitOnFirstDiff = true;
                    continue;
                }
                if (!cmd.equals("-maxVersions")) continue;
                if (!DiffTables.checkNextArg(args, i)) {
                    return false;
                }
                maxVersions = Integer.parseInt(args[i + 1]);
            }
            if (srcTableName == null || destTableName == null) {
                DiffTables.printUsage(null);
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            DiffTables.printUsage("Can't start because " + e.getMessage());
            return false;
        }
        return true;
    }

    private static boolean checkNextArg(String[] args, int i) {
        if (i + 1 >= args.length) {
            DiffTables.printUsage(null);
            return false;
        }
        return true;
    }

    private static void printUsage(String errorMsg) {
        if (donePrintUsage) {
            return;
        }
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("Usage: hbase diffTables -src tableA -dst tableB [options]. ");
        System.err.println("Notes: the output directory will contain tableATotableB.diff and tableBTotableA.diff. \n  Please use hbase org.apache.hadoop.hbase.mapreduce.Import /path/to/tableBTotableA.diff to merge tableB into tableA \n  and hbase org.apache.hadoop.hbase.mapreduce.Import /path/to/tableATotableB.diff to merge tableA into tableB.");
        System.err.println("Options:");
        System.err.println("  [-first_exit] Job exits on the first difference with a non-zero status and it will it reports first diff for both src-dest and dest-src");
        System.err.println("  [-outdir output_seq_file_dir] Chooses directory for \tSequenceFile output. Internally creates two subdirectories which contain the src-dst and dst-src if there is no -auth specified");
        System.err.println("  [-cf cf1,cf2,...] Only inspects the listed subset of column families.");
        System.err.println("  [-time_range start,end] start & end are timestamps or dates in quotes. Only inspects rows & cols created during the given time interval. If end is  INF , then its all time after start. If start is  -INF , then its all time before end.");
        System.err.println("  [-output_format] Specify outputformat - text or sequence.");
        System.err.println("  [-maxVersions] Specify maxVersions to compare, by default it will compare all versions.");
        donePrintUsage = true;
    }

    public int run(String[] args) throws Exception {
        Configuration conf = this.getConf();
        Job job = DiffTables.createSubmittableJob(conf, args);
        int ret = 0;
        if (job != null) {
            ret = job.waitForCompletion(true) ? 0 : 1;
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new DiffTables(), (String[])args);
            DiffTables.switchSrcAndDst(args);
            ret = ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new DiffTables(), (String[])args);
        }
        catch (Exception e) {
            ret = 1;
            e.printStackTrace();
        }
        System.exit(ret);
    }

    public static void switchSrcAndDst(String[] args) {
        if (args.length < 4) {
            return;
        }
        String srcTable = null;
        String dstTable = null;
        int srcIdx = -1;
        int dstIdx = -1;
        for (int i = 0; i < args.length; ++i) {
            String cmd = args[i];
            if (cmd.equals("-src")) {
                if (!DiffTables.checkNextArg(args, i)) {
                    return;
                }
                srcTable = args[i + 1];
                srcIdx = i + 1;
                continue;
            }
            if (cmd.equals("-dst")) {
                if (!DiffTables.checkNextArg(args, i)) {
                    return;
                }
                dstTable = args[i + 1];
                dstIdx = i + 1;
                continue;
            }
            if (srcIdx != -1 && dstIdx != -1) break;
        }
        if (srcIdx == -1 || dstIdx == -1) {
            DiffTables.printUsage(null);
            return;
        }
        args[srcIdx] = dstTable;
        args[dstIdx] = srcTable;
    }

    public static class DiffTableMapper
    extends TableMapper<ImmutableBytesWritable, Result> {
        private ResultScanner destResultScanner = null;
        private MultipleOutputs<ImmutableBytesWritable, Result> mos = null;
        private Result destResult = null;
        private boolean isBinary = true;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            super.setup(context);
            if (this.mos == null) {
                this.mos = new MultipleOutputs((TaskInputOutputContext)context);
            }
        }

        public void map(ImmutableBytesWritable row, final Result srcResult, Mapper.Context context) throws IOException {
            if (exit) {
                return;
            }
            Configuration conf = context.getConfiguration();
            this.isBinary = conf.getBoolean("difftables.isBinaryOutput", false);
            final Scan destScan = new Scan();
            long startTime = conf.getLong("difftables.startTime", 0L);
            long endTime = conf.getLong("difftables.endTime", Long.MAX_VALUE);
            String families = conf.get("difftables.families", null);
            if (families != null) {
                String[] fams;
                for (String fam : fams = families.split(",")) {
                    destScan.addFamily(Bytes.toBytes((String)fam));
                }
            }
            destScan.setTimeRange(startTime, endTime);
            destScan.setMaxVersions(conf.getInt("difftables.maxVersions", Integer.MAX_VALUE));
            HConnectionManager.execute((HConnectable)new HConnectable<Void>(conf){

                public Void connect(HConnection conn) throws IOException {
                    HTable destTable = new HTable(this.conf, this.conf.get("difftables.destTableName"));
                    destScan.setStartRow(srcResult.getRow());
                    DiffTableMapper.this.destResultScanner = destTable.getScanner(destScan);
                    return null;
                }
            });
            this.destResult = this.destResultScanner.next();
            try {
                LOG.info((Object)("srcResult: " + srcResult + "; destResult: " + this.destResult));
                Result.compareResults((Result)srcResult, (Result)this.destResult);
            }
            catch (Exception e1) {
                exitOnFirstDiff = conf.getBoolean("difftables.exitOnFirstDiff", false);
                if (exit || exitOnFirstDiff) {
                    LOG.info((Object)"A first difference was encountered.");
                    exit = true;
                }
                this.outputPatch(row, srcResult, this.destResult);
            }
        }

        protected void outputPatch(ImmutableBytesWritable srcRow, Result srcResult, Result destResult) {
            if (destResult == null || this.compareRowKey(srcResult.getRow(), destResult.getRow()) < 0) {
                LOG.debug((Object)"rowKeyResult < 0");
                ArrayList<KeyValue> srcToDestDiff = this.getAllKeyValues(srcResult);
                this.writeDiff(srcRow, srcToDestDiff);
                return;
            }
            ArrayList<KeyValue> srcToDestDiff = new ArrayList<KeyValue>();
            try {
                KeyValue addToDestDiff;
                KeyValue srcKeyValue;
                int srcCount = 0;
                int destCount = 0;
                KeyValue[] srcKeyValues = srcResult.raw();
                KeyValue[] destKeyValues = destResult.raw();
                while (srcCount < srcKeyValues.length && destCount < destKeyValues.length) {
                    srcKeyValue = srcKeyValues[srcKeyValues.length - 1 - srcCount];
                    KeyValue destKeyValue = destKeyValues[destKeyValues.length - 1 - destCount];
                    LOG.debug((Object)("srcKeyValue: " + srcKeyValue + "; destKeyValue: " + destKeyValue));
                    addToDestDiff = new KeyValue(srcResult.getRow(), srcKeyValue.getFamily(), srcKeyValue.getQualifier(), srcKeyValue.getTimestamp(), srcKeyValue.getValue());
                    int cfResult = this.compareColumnFamily(srcKeyValue, destKeyValue);
                    if (cfResult < 0) {
                        LOG.debug((Object)"cfResult < 0");
                        srcToDestDiff.add(addToDestDiff);
                        ++srcCount;
                        continue;
                    }
                    if (cfResult > 0) {
                        LOG.debug((Object)"cfResult > 0");
                        ++destCount;
                        continue;
                    }
                    LOG.debug((Object)"cfResult == 0");
                    int quantifierResult = this.compareQuantifier(srcKeyValue, destKeyValue);
                    if (quantifierResult < 0) {
                        LOG.debug((Object)"quantifierResult < 0");
                        srcToDestDiff.add(addToDestDiff);
                        ++srcCount;
                        continue;
                    }
                    if (quantifierResult > 0) {
                        LOG.debug((Object)"quantifierResult > 0");
                        ++destCount;
                        continue;
                    }
                    LOG.debug((Object)"quantifierResult == 0");
                    int timestampResult = this.compareTimestamp(srcKeyValue, destKeyValue);
                    if (timestampResult < 0) {
                        LOG.debug((Object)("timestampResult < 0, addToDestDiff: " + addToDestDiff));
                        srcToDestDiff.add(addToDestDiff);
                        ++srcCount;
                        continue;
                    }
                    if (timestampResult > 0) {
                        LOG.debug((Object)("timestampResult > 0, addToDestDiff: " + addToDestDiff));
                        ++destCount;
                        continue;
                    }
                    LOG.debug((Object)("timestampResult == 0, addToDestDiff: " + addToDestDiff));
                    int valueResult = this.compareValue(srcKeyValue, destKeyValue);
                    if (valueResult < 0) {
                        LOG.debug((Object)"valueResult < 0");
                        srcToDestDiff.add(addToDestDiff);
                        ++srcCount;
                        continue;
                    }
                    if (valueResult > 0) {
                        LOG.debug((Object)"valueResult > 0");
                        ++destCount;
                        continue;
                    }
                    LOG.debug((Object)"valueResult == 0");
                    ++srcCount;
                    ++destCount;
                }
                while (srcCount < srcKeyValues.length) {
                    srcKeyValue = srcKeyValues[srcKeyValues.length - 1 - srcCount];
                    addToDestDiff = new KeyValue(srcResult.getRow(), srcKeyValue.getFamily(), srcKeyValue.getQualifier(), srcKeyValue.getTimestamp(), srcKeyValue.getValue());
                    srcToDestDiff.add(addToDestDiff);
                    ++srcCount;
                }
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
            this.writeDiff(srcRow, srcToDestDiff);
        }

        private ArrayList<KeyValue> getAllKeyValues(Result result) {
            ArrayList<KeyValue> keyValueList = new ArrayList<KeyValue>();
            KeyValue[] keyValues = result.raw();
            for (int i = 0; i < keyValues.length; ++i) {
                keyValueList.add(keyValues[keyValues.length - 1 - i]);
            }
            return keyValueList;
        }

        protected void writeDiff(ImmutableBytesWritable srcRow, ArrayList<KeyValue> srcToDestDiff) {
            String prefix = exitOnFirstDiff ? "firstdiff-" : "";
            try {
                if (srcToDestDiff != null && srcToDestDiff.size() > 0) {
                    this.mos.write((Object)srcRow, (Object)new Result(srcToDestDiff), prefix + (this.isBinary ? "sequence" : "text"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        protected int compareRowKey(byte[] srcRowKey, byte[] destRowKey) {
            return ByteBuffer.wrap(srcRowKey).compareTo(ByteBuffer.wrap(destRowKey));
        }

        protected int compareColumnFamily(KeyValue srcKeyValue, KeyValue destKeyValue) {
            byte[] srcColumnFamily = srcKeyValue.getFamily();
            byte[] destColumnFamily = destKeyValue.getFamily();
            return ByteBuffer.wrap(srcColumnFamily).compareTo(ByteBuffer.wrap(destColumnFamily));
        }

        protected int compareQuantifier(KeyValue srcKeyValue, KeyValue destKeyValue) {
            byte[] srcQuantifier = srcKeyValue.getQualifier();
            byte[] destQuantifier = destKeyValue.getQualifier();
            return ByteBuffer.wrap(srcQuantifier).compareTo(ByteBuffer.wrap(destQuantifier));
        }

        protected int compareTimestamp(KeyValue srcKeyValue, KeyValue destKeyValue) {
            Long srcTimestamp = srcKeyValue.getTimestamp();
            Long destTimestamp = destKeyValue.getTimestamp();
            return srcTimestamp.compareTo(destTimestamp);
        }

        protected int compareValue(KeyValue srcKeyValue, KeyValue destKeyValue) {
            byte[] srcValue = srcKeyValue.getValue();
            byte[] destValue = destKeyValue.getValue();
            return ByteBuffer.wrap(srcValue).compareTo(ByteBuffer.wrap(destValue));
        }

        protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            if (this.destResultScanner != null) {
                this.destResultScanner.close();
            }
            this.mos.close();
        }
    }

    static enum OutputFormat {
        TEXT,
        SEQUENCE;

    }
}

