/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.BulkLoadHelper;
import com.mapr.fs.BulkLoadRecordWriter;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class CopyTableTest
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(CopyTableTest.class);
    String srcPath;
    String dstPath;
    Configuration conf;
    HTable srcTable;
    boolean failed = false;
    int numThreads = 16;
    static boolean isSuccess = false;

    private void Usage() {
        System.err.println("usage: CopyTableTest -src srcPath -dst dstPath [-numthreads numThreads (default:" + this.numThreads + ")]");
        System.exit(1);
    }

    private void ParseArgs(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-src")) {
                this.srcPath = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-dst")) {
                this.dstPath = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-numthreads")) {
                this.numThreads = Integer.parseInt(args[++i]);
                continue;
            }
            this.Usage();
        }
        if (this.srcPath == null || this.dstPath == null) {
            this.Usage();
        }
    }

    public int run(String[] args) throws Exception {
        this.conf = this.getConf();
        this.conf.set("fs.default.name", "maprfs:///");
        this.conf.set("fs.maprfs.impl", "com.mapr.fs.MapRFileSystem");
        this.conf.set("mapr.htable.impl", "com.mapr.fs.MapRHTable");
        this.ParseArgs(args);
        this.srcTable = new HTable(this.conf, this.srcPath.getBytes());
        byte[][] startKeys = this.srcTable.getStartKeys();
        byte[][] endKeys = this.srcTable.getEndKeys();
        int numSplits = startKeys.length;
        HBaseAdmin hbaseAdmin = new HBaseAdmin(this.conf);
        if (!hbaseAdmin.tableExists(this.dstPath)) {
            BulkLoadHelper.createTableForCopy(this.conf, this.srcPath, this.dstPath);
        }
        hbaseAdmin.close();
        long ts = System.currentTimeMillis();
        ExecutorService executor = Executors.newFixedThreadPool(this.numThreads);
        for (int i = 0; i < numSplits; ++i) {
            executor.execute(new LoaderThread(i, startKeys[i], endKeys[i]));
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        if (this.failed) {
            return 1;
        }
        long te = System.currentTimeMillis();
        System.out.println("Test completed in " + (te - ts) + " ms");
        BulkLoadHelper.clearBulkLoad(this.conf, this.dstPath);
        return 0;
    }

    public static boolean copy(final String[] args, String user) throws Exception {
        UserGroupInformation ugi = CopyTableTest.createUser(user);
        LOG.info((Object)("Running non-mapreduce copytable job as user: " + user));
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try {
                    System.out.println("No map-reduce");
                    int status = ToolRunner.run((Configuration)new Configuration(), (Tool)new CopyTableTest(), (String[])args);
                    if (status == 0) {
                        CopyTableTest.setJobSuccessful();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)("Exception while running non-mapreduce copytable job: " + e));
                    throw new Exception(e.getMessage());
                }
                return null;
            }
        });
        return isSuccess;
    }

    public static void setJobSuccessful() {
        isSuccess = true;
    }

    public static void main(String[] args) throws Exception {
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)new Configuration(), (Tool)new CopyTableTest(), (String[])args);
        }
        catch (Exception e) {
            ret = 1;
            e.printStackTrace();
        }
        System.exit(ret);
    }

    private static UserGroupInformation createUser(String user) throws IOException {
        return UserGroupInformation.createRemoteUser((String)user);
    }

    class LoaderThread
    implements Runnable {
        byte[] startKey;
        byte[] endKey;
        int myid;

        LoaderThread(int id, byte[] s, byte[] e) {
            this.myid = id;
            this.startKey = s;
            this.endKey = e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BulkLoadRecordWriter writer = null;
            try (ResultScanner scanner = null;){
                writer = new BulkLoadRecordWriter(CopyTableTest.this.conf, new Path(CopyTableTest.this.dstPath));
                Scan scan = new Scan(this.startKey, this.endKey);
                scan.setMaxVersions();
                scanner = CopyTableTest.this.srcTable.getScanner(scan);
                Result r = scanner.next();
                while (r != null) {
                    KeyValue[] kvList;
                    for (KeyValue kv : kvList = r.raw()) {
                        writer.write(null, kv);
                    }
                    r = scanner.next();
                }
                if (writer != null) {
                    writer.close(null);
                }
            }
        }
    }
}

