/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.MapRHTable;
import com.mapr.fs.proto.Dbserver;
import java.io.IOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;

public class HRegionConverter {
    public static HRegionInfo toHRegionInfo(Dbserver.TabletDesc tablet, byte[] tableName) {
        return new HRegionInfo(tableName, tablet.getStartKey().toByteArray(), tablet.getEndKey().toByteArray(), false, 0L);
    }

    public static HRegionLocation toHRegionLocation(Dbserver.TabletDesc tablet, MapRHTable htable) throws IOException {
        ServerName sn = HRegionConverter.toServerName(tablet, htable);
        return new HRegionLocation(HRegionConverter.toHRegionInfo(tablet, htable.getName()), sn.getHostname(), sn.getPort());
    }

    public static ServerName toServerName(Dbserver.TabletDesc tablet, MapRHTable htable) throws IOException {
        int port;
        int cid = tablet.getFid().getCid();
        String host = htable.getServerForCid(cid);
        String[] tokens = host.split(":");
        if (tokens == null || tokens.length != 2) {
            throw new IOException("Bad host information for cid=" + cid + ", host=" + host);
        }
        try {
            port = Integer.parseInt(tokens[1]);
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Bad host information for cid=" + cid + ", host=" + host);
        }
        return new ServerName(tokens[0], port, -1L);
    }
}

