/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.proto.Dbserver;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;

public class BulkLoadHelper {
    public static void createTableForCopy(Configuration conf, String src, String dst) throws IOException {
        HTable srcTable = new HTable(conf, src);
        HTableDescriptor htd = new HTableDescriptor(srcTable.getTableDescriptor());
        htd.setValue("BULKLOAD", "true");
        HBaseAdmin hbaseAdmin = new HBaseAdmin(conf);
        htd.setName(dst.getBytes());
        hbaseAdmin.createTable(htd);
    }

    public static void clearBulkLoad(Configuration conf, String tableName) throws IOException {
        BulkLoadHelper.setBulkLoadAttr(conf, tableName, false);
    }

    private static void setBulkLoadAttr(Configuration conf, String tableName, boolean flag) throws IOException {
        Path tablePath = new Path(tableName);
        MapRFileSystem mfs = new MapRFileSystem();
        mfs.initialize(tablePath.toUri(), conf);
        Dbserver.TableAces aces = Dbserver.TableAces.newBuilder().build();
        Dbserver.TableAttr attr = Dbserver.TableAttr.newBuilder().setBulkLoad(flag).build();
        mfs.modifyTableAttr(tablePath, attr, aces);
        mfs.close();
    }
}

