/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.Inode;
import com.mapr.fs.MapRHTable;
import com.mapr.fs.MapRResultScanner;
import com.mapr.fs.ResultConverter;
import com.mapr.fs.jni.MapRResult;
import com.mapr.fs.jni.MapRScan;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;

public class ResultScannerImpl
extends MapRResultScanner
implements ResultScanner {
    public ResultScannerImpl(MapRScan scan, Inode inode, MapRHTable htable, long id) {
        super(scan, inode, htable, id);
    }

    public Result next() throws IOException {
        MapRResult[] res = new MapRResult[]{new MapRResult()};
        this.inode_.scanNext(this.scannerId_, 1, res);
        Result result = null;
        if (!res[0].isEmpty()) {
            result = ResultConverter.toHBaseResult(res[0], this.htable_);
        }
        this.inode_.scannerReleaseTempMemory(this.scannerId_);
        return result;
    }

    public Result[] next(int nbRows) throws IOException {
        MapRResult[] res = new MapRResult[nbRows];
        for (int i = 0; i < nbRows; ++i) {
            res[i] = new MapRResult();
        }
        this.inode_.scanNext(this.scannerId_, nbRows, res);
        Result[] results = this.createHBaseResult(res);
        this.inode_.scannerReleaseTempMemory(this.scannerId_);
        return results;
    }

    Result[] createHBaseResult(MapRResult[] results) throws IOException {
        int rows = 0;
        for (int i = 0; i < results.length && !results[i].isEmpty(); ++i) {
            ++rows;
        }
        if (rows > 0) {
            Result[] res = new Result[rows];
            for (int i = 0; i < rows; ++i) {
                res[i] = ResultConverter.toHBaseResult(results[i], this.htable_);
            }
            return res;
        }
        return null;
    }

    public Iterator<Result> iterator() {
        return new Iterator<Result>(){
            Result next = null;

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    try {
                        this.next = ResultScannerImpl.this.next();
                        return this.next != null;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return true;
            }

            @Override
            public Result next() {
                if (!this.hasNext()) {
                    return null;
                }
                Result temp = this.next;
                this.next = null;
                return temp;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

