/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.mapr.TableMappingRulesInterface;
import org.apache.hadoop.hbase.util.Bytes;

public class TableMappingRules
implements TableMappingRulesInterface {
    public static final String MAPR_ENGINE = "mapr";
    public static final String HBASE_ENGINE = "hbase";
    public static final String HBASE_TABLE_NAMESPACE_MAPPINGS = "hbase.table.namespace.mappings";
    private static final String RULE_SPLITTER = ":";
    private static final String RULE_SEPARATOR = ",";
    private static final String EMPTY_RULE = "";
    private static final Pattern BSLASH_PATTERN = Pattern.compile("\\\\+");
    private static final Log LOG = LogFactory.getLog(TableMappingRules.class);
    private static final Map<String, RuleList> ruleListMap_ = new HashMap<String, RuleList>();
    private final TableMappingRulesInterface.ClusterType clusterType_;
    private final Configuration conf_;
    private RuleList ruleList_ = null;
    private volatile FileSystem fs_ = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableMappingRules(Configuration conf) {
        String mappingRules = conf.get(HBASE_TABLE_NAMESPACE_MAPPINGS, EMPTY_RULE).trim();
        Map<String, RuleList> map = ruleListMap_;
        synchronized (map) {
            this.ruleList_ = ruleListMap_.get(mappingRules);
            if (this.ruleList_ == null) {
                this.ruleList_ = new RuleList(mappingRules);
                ruleListMap_.put(mappingRules, this.ruleList_);
            }
        }
        this.conf_ = conf;
        this.clusterType_ = conf.getBoolean("hbase.available", true) ? TableMappingRulesInterface.ClusterType.HBASE_MAPR : TableMappingRulesInterface.ClusterType.MAPR_ONLY;
    }

    public boolean isMapRDefault() {
        return this.ruleList_.isAllTableGoose() || MAPR_ENGINE.equals(this.conf_.get("db.engine.default", HBASE_ENGINE));
    }

    public TableMappingRulesInterface.ClusterType getClusterType() {
        return this.clusterType_;
    }

    public byte[] isLegalTableName(byte[] tableName) {
        try {
            return this.isMapRTable(tableName) ? tableName : HTableDescriptor.isLegalTableName((byte[])tableName);
        }
        catch (IOException iOException) {
            return tableName;
        }
    }

    public String isLegalTableName(String tableName) {
        try {
            return this.isMapRTable(tableName) ? tableName : Bytes.toString((byte[])this.isLegalTableName(Bytes.toBytes((String)tableName)));
        }
        catch (IOException iOException) {
            return tableName;
        }
    }

    public boolean isMapRTable(byte[] tableName) throws IOException {
        if (tableName == null) {
            throw new IllegalArgumentException("Table name can not be null.");
        }
        return this.isMapRTable(Bytes.toString((byte[])tableName));
    }

    public boolean isMapRTable(String tableName) throws IOException {
        return this.getMaprTablePath(tableName) != null;
    }

    public String toString() {
        return "TableMappingRule [rules_='" + this.ruleList_.rules_ + "']";
    }

    public Path getMaprTablePath(byte[] tableName) throws IOException {
        if (tableName == null) {
            throw new IllegalArgumentException("Table name can not be null.");
        }
        return this.getMaprTablePath(Bytes.toString((byte[])tableName));
    }

    public Path getMaprTablePath(String tableName) throws IOException {
        if (tableName == null) {
            throw new IllegalArgumentException("Table name can not be null.");
        }
        if ((tableName = BSLASH_PATTERN.matcher(tableName).replaceAll("/")).startsWith("/") || tableName.toLowerCase().startsWith("maprfs://")) {
            return new Path(tableName);
        }
        if (tableName.toLowerCase().startsWith("hbase://") || HTableDescriptor.isMetaTable((byte[])Bytes.toBytes((String)tableName))) {
            return null;
        }
        if (tableName.contains("/")) {
            return new Path(this.getFS().getHomeDirectory(), tableName);
        }
        for (Rule rule : this.ruleList_) {
            String path = rule.uri.toString();
            if (rule.glob.equals(tableName)) {
                return this.makePath(path, tableName);
            }
            if (!rule.pattern.matcher(tableName).matches()) continue;
            return this.makePath(path.endsWith("/") ? path : path + "/", tableName);
        }
        return null;
    }

    protected Path makePath(String parent, String table) throws IOException {
        Path path;
        Path path2 = path = parent.endsWith("/") ? new Path(parent, table) : new Path(parent);
        if (!parent.startsWith("/")) {
            path = new Path(this.getFS().getHomeDirectory(), path);
        }
        return path;
    }

    protected synchronized FileSystem getFS() throws IOException {
        if (this.fs_ == null) {
            this.fs_ = FileSystem.get((Configuration)this.conf_);
        }
        return this.fs_;
    }

    public static boolean isMapRTable(Configuration conf, String tableName) throws IOException {
        return new TableMappingRules(conf).isMapRTable(tableName);
    }

    public static Path getMaprTablePath(Configuration conf, String tableName) throws IOException {
        return new TableMappingRules(conf).getMaprTablePath(tableName);
    }

    public Path getDefaultTablePath() throws IOException {
        return this.ruleList_.isAllTableGoose() ? this.ruleList_.getDefaultTablePath() : this.getFS().getWorkingDirectory();
    }

    static {
        ruleListMap_.put(EMPTY_RULE, new RuleList());
    }

    static class Rule {
        static final String REGEX_SPECIAL_CHARS = "[\\^$.|?+()";
        final URI uri;
        final String glob;
        final Pattern pattern;

        Rule(String glob, URI uri) {
            this.glob = glob;
            this.uri = uri;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < glob.length(); ++i) {
                char ch = glob.charAt(i);
                if (REGEX_SPECIAL_CHARS.indexOf(ch) != -1) {
                    sb.append('\\');
                } else if (ch == '*') {
                    sb.append('.');
                }
                sb.append(ch);
            }
            this.pattern = Pattern.compile(sb.toString());
        }

        public String toString() {
            return "Rule [pattern=" + this.glob + ", uri=" + this.uri + "]";
        }

        boolean matches(String text) {
            return this.pattern.matcher(text).matches();
        }
    }

    static class RuleList
    extends ArrayList<Rule> {
        private static final long serialVersionUID = 1381209101513814010L;
        private final String rules_;
        private boolean isAllTableGoose_ = false;
        private Path defaultTablePath_ = null;

        public RuleList() {
            this.rules_ = TableMappingRules.EMPTY_RULE;
        }

        RuleList(String rules) {
            this.rules_ = rules;
            String[] mappings = this.rules_.split(TableMappingRules.RULE_SEPARATOR);
            for (int i = 0; i < mappings.length; ++i) {
                String mapping = mappings[i].trim().replaceAll("/+", "/");
                if (this.checkAndAdd(mapping)) continue;
                LOG.warn((Object)("Invalid mapping '" + mapping + "' found, ignoring."));
            }
        }

        public Path getDefaultTablePath() {
            return this.isAllTableGoose_ ? this.defaultTablePath_ : null;
        }

        public boolean isAllTableGoose() {
            return this.isAllTableGoose_;
        }

        public void setAllTableGoose(boolean isAllTableGoose_) {
            this.isAllTableGoose_ = isAllTableGoose_;
        }

        protected boolean checkAndAdd(String mapping) {
            int firstSplit = mapping.indexOf(TableMappingRules.RULE_SPLITTER);
            int lastSplit = mapping.lastIndexOf(TableMappingRules.RULE_SPLITTER);
            int length = mapping.length();
            if (firstSplit <= 0 || lastSplit == length - 1) {
                return false;
            }
            try {
                String[] parts = mapping.split(TableMappingRules.RULE_SPLITTER, 2);
                String glob = parts[0].trim();
                URI uri = new URI(parts[1].trim());
                if (glob.equals("*")) {
                    this.isAllTableGoose_ = true;
                    this.defaultTablePath_ = new Path(uri);
                }
                for (Rule rule : this) {
                    if (!rule.pattern.matcher(glob).matches()) continue;
                    LOG.warn((Object)("Duplicate mapping '" + mapping + "' found, ignoring. Original rule '" + rule.glob + TableMappingRules.RULE_SPLITTER + rule.uri + "'"));
                    return true;
                }
                this.add(new Rule(glob, uri));
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

