/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.MapRHTable;
import com.mapr.fs.jni.MapRGet;
import com.mapr.fs.jni.MapRIncrement;
import com.mapr.fs.jni.MapRKeyValue;
import com.mapr.fs.jni.MapRPut;
import com.mapr.fs.jni.MapRResult;
import com.mapr.fs.jni.MapRRowConstraint;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;

public class ResultConverter {
    public static Result createHBaseResult(MapRGet mget, MapRHTable htable) throws IOException {
        Result result = ResultConverter.toHBaseResult(mget.getResult(), mget.getKey(), htable);
        return result;
    }

    public static Result[] createHBaseResult(MapRGet[] mgets, MapRHTable htable) throws IOException {
        Result[] res = new Result[mgets.length];
        for (int i = 0; i < mgets.length; ++i) {
            res[i] = ResultConverter.toHBaseResult(mgets[i].getResult(), mgets[i].getKey(), htable);
        }
        return res;
    }

    public static Result createHBaseResult(MapRIncrement incr, MapRHTable htable) throws IOException {
        if (incr.newValues.length != incr.rowConstraint.numColumns) {
            throw new IOException("Mistmatch in increment request(" + incr.rowConstraint.numColumns + ") and reply (" + incr.newValues.length + ").");
        }
        int cellPos = 0;
        MapRRowConstraint rc = incr.rowConstraint;
        KeyValue[] cells = new KeyValue[rc.numColumns];
        for (int f = 0; f < rc.numFamilies; ++f) {
            String cfname;
            try {
                cfname = htable.getFamilyName(rc.families[f]);
            }
            catch (IOException ioe) {
                System.out.println("Stale column family id=" + rc.families[f] + ". Ignoring get request with key=[" + Bytes.toString((byte[])incr.key) + "]");
                continue;
            }
            byte[] fname = Bytes.toBytes((String)cfname);
            for (int c = 0; c < rc.columnsPerFamily[f]; ++c) {
                cells[cellPos] = new KeyValue(incr.key, fname, rc.columns[cellPos], incr.timestamp, Bytes.toBytes((long)incr.newValues[cellPos]));
                ++cellPos;
            }
        }
        Arrays.sort(cells, KeyValue.COMPARATOR);
        return new Result(cells);
    }

    public static Result toHBaseResult(MapRResult mresult, byte[] key, MapRHTable htable) throws IOException {
        if (mresult == null || mresult.isEmpty()) {
            return new Result((KeyValue[])null);
        }
        int cellPos = 0;
        int columnId = 0;
        KeyValue[] cells = new KeyValue[mresult.columnOffsets.length];
        for (int f = 0; f < mresult.cfIds.length; ++f) {
            String cfname;
            try {
                cfname = htable.getFamilyName(mresult.cfIds[f]);
            }
            catch (IOException ioe) {
                System.out.println("Stale column family id=" + mresult.cfIds[f] + ". Ignoring get request with key=[" + Bytes.toString((byte[])key) + "]");
                continue;
            }
            byte[] fname = Bytes.toBytes((String)cfname);
            for (int c = 0; c < mresult.cellsPerFamily[f]; ++c) {
                for (int v = 0; v < mresult.versions[columnId]; ++v) {
                    cells[cellPos] = new KeyValue(mresult.bbuf, key, 0, 0, fname, mresult.columnOffsets[columnId], mresult.columnLengths[columnId], mresult.valueOffsets[cellPos], mresult.valueLengths[cellPos], mresult.timestamps[cellPos]);
                    ++cellPos;
                }
                ++columnId;
            }
        }
        Arrays.sort(cells, KeyValue.COMPARATOR);
        return new Result(cells);
    }

    public static Result toHBaseResult(MapRResult mresult, MapRHTable htable) throws IOException {
        if (mresult == null || mresult.isEmpty()) {
            return new Result((KeyValue[])null);
        }
        int cellPos = 0;
        int columnId = 0;
        KeyValue[] cells = new KeyValue[mresult.columnOffsets.length];
        for (int f = 0; f < mresult.cfIds.length; ++f) {
            String cfname;
            try {
                cfname = htable.getFamilyName(mresult.cfIds[f]);
            }
            catch (IOException ioe) {
                byte[] key = new byte[mresult.keyLength];
                mresult.bbuf.position(0);
                mresult.bbuf.get(key, 0, mresult.keyLength);
                System.out.println("Stale column family id=" + mresult.cfIds[f] + ". Ignoring the result for row with key=[" + Bytes.toString((byte[])key) + "]");
                continue;
            }
            byte[] fname = Bytes.toBytes((String)cfname);
            for (int c = 0; c < mresult.cellsPerFamily[f]; ++c) {
                for (int v = 0; v < mresult.versions[columnId]; ++v) {
                    cells[cellPos] = new KeyValue(mresult.bbuf, null, 0, mresult.keyLength, fname, mresult.columnOffsets[columnId], mresult.columnLengths[columnId], mresult.valueOffsets[cellPos], mresult.valueLengths[cellPos], mresult.timestamps[cellPos]);
                    ++cellPos;
                }
                ++columnId;
            }
        }
        Arrays.sort(cells, KeyValue.COMPARATOR);
        return new Result(cells);
    }

    public static Result toHBaseResult(MapRPut mput, MapRHTable htable) throws IOException {
        if (mput == null || mput.getKeyValues() == null || mput.numCells == 0) {
            return new Result((KeyValue[])null);
        }
        int cellPos = 0;
        MapRKeyValue[] mcells = mput.getKeyValues();
        KeyValue[] cells = new KeyValue[mput.numCells];
        for (int f = 0; f < mput.numFamilies; ++f) {
            String cfname;
            try {
                cfname = htable.getFamilyName(mput.families[f]);
            }
            catch (IOException ioe) {
                throw new IOException("Stale column family id=" + mput.families[f]);
            }
            byte[] fname = Bytes.toBytes((String)cfname);
            for (int c = 0; c < mput.cellsPerFamily[f]; ++c) {
                MapRKeyValue mcell = mcells[cellPos];
                cells[cellPos] = new KeyValue(mput.key, fname, mcell.getBuffer(), mcell.getColumnOffset(), mcell.getColumnLength(), mput.rowTimeStamp, KeyValue.Type.Put, mcell.getValue(), 0, mcell.getValue().length);
                ++cellPos;
            }
        }
        Arrays.sort(cells, KeyValue.COMPARATOR);
        return new Result(cells);
    }
}

