/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.GetConverter;
import com.mapr.fs.HRegionConverter;
import com.mapr.fs.IncrementConverter;
import com.mapr.fs.MapRHTable;
import com.mapr.fs.MapRTabletScanner;
import com.mapr.fs.PutConverter;
import com.mapr.fs.ResultConverter;
import com.mapr.fs.ResultScannerImpl;
import com.mapr.fs.ScanConverter;
import com.mapr.fs.SchemaHelper;
import com.mapr.fs.jni.MapRGet;
import com.mapr.fs.jni.MapRIncrement;
import com.mapr.fs.jni.MapRPut;
import com.mapr.fs.jni.MapRScan;
import com.mapr.fs.proto.Dbserver;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.AbstractHTableInterface;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowLock;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.UnmodifyableHTableDescriptor;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.client.mapr.TableMappingRulesFactory;
import org.apache.hadoop.hbase.ipc.CoprocessorProtocol;
import org.apache.hadoop.hbase.util.Addressing;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

public class HTableImpl
extends MapRHTable
implements AbstractHTableInterface {
    public static final String CONFIG_PARAM_FLUSH_ON_READ = "fs.mapr.hbase.flushonread";
    private boolean autoFlush;
    private boolean flushOnRead;
    protected byte[] tableName;

    public HTableImpl(Configuration conf, String tableName) throws IOException {
        this(conf, Bytes.toBytes((String)tableName));
    }

    public HTableImpl(Configuration conf, byte[] tableName, ExecutorService pool) throws IOException {
        this(conf, tableName);
    }

    public HTableImpl(byte[] tableName, HConnection connection, ExecutorService pool) throws IOException {
        this(connection.getConfiguration(), tableName, pool);
    }

    public HTableImpl(Configuration conf, byte[] tableName) throws IOException {
        try {
            this.init(conf, TableMappingRulesFactory.create((Configuration)conf).getMaprTablePath(tableName));
            this.tableName = Bytes.toBytes((String)this.tablePath_.toUri().getPath());
            this.setFlushOnRead(conf.getBoolean(CONFIG_PARAM_FLUSH_ON_READ, false));
            this.autoFlush = true;
        }
        catch (FileNotFoundException e) {
            TableNotFoundException ex = new TableNotFoundException();
            ex.initCause((Throwable)e);
            throw ex;
        }
    }

    public byte[] getTableName() {
        return this.tableName;
    }

    public Configuration getConfiguration() {
        return this.conf_;
    }

    public void flushCommits() throws IOException {
        super.flushCommits();
    }

    public void close() throws IOException {
        super.close();
    }

    public HTableDescriptor getTableDescriptor() throws IOException {
        return new UnmodifyableHTableDescriptor(SchemaHelper.toHTableDescriptor(this.maprfs_, this.tablePath_));
    }

    public boolean exists(Get get) throws IOException {
        Result r = this.get(get);
        return r != null && !r.isEmpty();
    }

    public void batch(List<? extends Row> actions, Object[] results) throws IOException, InterruptedException {
        int i = 0;
        for (Row row : actions) {
            if (row instanceof Delete) {
                this.delete((Delete)row);
                results[i] = new Result();
            } else if (row instanceof Put) {
                this.put((Put)row);
                results[i] = new Result();
            } else if (row instanceof Get) {
                results[i] = this.get((Get)row);
            } else if (row instanceof Append) {
                results[i] = this.append((Append)row);
            } else if (row instanceof Increment) {
                results[i] = this.increment((Increment)row);
            } else if (row instanceof RowMutations) {
                this.mutateRow((RowMutations)row);
                results[i] = new Result();
            }
            ++i;
        }
    }

    public Object[] batch(List<? extends Row> actions) throws IOException, InterruptedException {
        Object[] results = new Object[actions.size()];
        this.batch(actions, results);
        return results;
    }

    public Result get(Get get) throws IOException {
        MapRGet mget = GetConverter.toMapRGet(get, this);
        this.get(mget, this.flushOnRead);
        Result result = ResultConverter.createHBaseResult(mget, (MapRHTable)this);
        if (mget.getArena() != 0L) {
            this.freeArena(mget.getArena());
        }
        return result;
    }

    public Result[] get(List<Get> gets) throws IOException {
        if (gets.size() > 0) {
            MapRGet[] mgets = GetConverter.toMapRGets(gets, this);
            this.get(mgets, this.flushOnRead);
            Result[] results = ResultConverter.createHBaseResult(mgets, (MapRHTable)this);
            if (mgets[0].getArena() != 0L) {
                this.freeArena(mgets[0].getArena());
            }
            return results;
        }
        return null;
    }

    public Result getRowOrBefore(byte[] row, byte[] family) throws IOException {
        throw new UnsupportedOperationException("This is not yet supported");
    }

    public ResultScanner getScanner(Scan scan) throws IOException {
        MapRScan maprscan = ScanConverter.toMapRScan(scan, this);
        maprscan.setFlushOnRead(this.flushOnRead);
        long id = this.table_.getScanner(maprscan);
        ResultScannerImpl scanner = new ResultScannerImpl(maprscan, this.table_, this, id);
        this.addScanner(scanner);
        return scanner;
    }

    public ResultScanner getScanner(byte[] family) throws IOException {
        Scan scan = new Scan();
        scan.addFamily(family);
        return this.getScanner(scan);
    }

    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        Scan scan = new Scan();
        scan.addColumn(family, qualifier);
        return this.getScanner(scan);
    }

    public void put(Put put) throws IOException {
        MapRPut mput = PutConverter.toMapRPut(put, (MapRHTable)this);
        if (!this.autoFlush) {
            this.put(mput);
        } else {
            this.syncPut(mput, true);
        }
    }

    public void put(List<Put> puts) throws IOException {
        MapRPut[] mputs = new MapRPut[puts.size()];
        int i = 0;
        for (Put put : puts) {
            mputs[i++] = PutConverter.toMapRPut(put, (MapRHTable)this);
        }
        if (!this.autoFlush) {
            this.put(mputs);
        } else {
            this.syncPut(mputs, true);
        }
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put) throws IOException {
        int id = 0;
        boolean useCf = true;
        if (!Bytes.equals((byte[])row, (byte[])put.getRow())) {
            throw new DoNotRetryIOException("Action's getRow must match the passed row");
        }
        if (family != null) {
            try {
                id = this.getFamilyId(Bytes.toString((byte[])family));
            }
            catch (IOException ioe) {
                throw new IOException("Invalid column family " + Bytes.toString((byte[])family), ioe);
            }
        } else {
            useCf = false;
        }
        MapRPut mput = PutConverter.toMapRPut(put, (MapRHTable)this);
        return this.checkAndPut(row, useCf, id, qualifier, value, mput, this.flushOnRead);
    }

    public void delete(Delete delete) throws IOException {
        MapRPut mput = PutConverter.toMapRPut(delete, (MapRHTable)this);
        this.delete(mput);
    }

    public void delete(List<Delete> deletes) throws IOException {
        MapRPut[] mputs = new MapRPut[deletes.size()];
        int i = 0;
        for (Delete delete : deletes) {
            mputs[i++] = PutConverter.toMapRPut(delete, (MapRHTable)this);
        }
        this.delete(mputs);
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
        int id = 0;
        boolean useCf = true;
        if (!Bytes.equals((byte[])row, (byte[])delete.getRow())) {
            throw new DoNotRetryIOException("Action's getRow must match the passed row");
        }
        if (family != null) {
            try {
                id = this.getFamilyId(Bytes.toString((byte[])family));
            }
            catch (IOException ioe) {
                throw new IOException("Invalid column family " + Bytes.toString((byte[])family), ioe);
            }
        } else {
            useCf = false;
        }
        MapRPut mput = PutConverter.toMapRPut(delete, (MapRHTable)this);
        return this.checkAndDelete(row, useCf, id, qualifier, value, mput, this.flushOnRead);
    }

    public void mutateRow(RowMutations rm) throws IOException {
        byte[] row = rm.getRow();
        if (rm.getMutations().size() > 0) {
            int i = 0;
            MapRPut[] mputs = new MapRPut[rm.getMutations().size()];
            for (Mutation m : rm.getMutations()) {
                MapRPut mput;
                if (m instanceof Put) {
                    mput = PutConverter.toMapRPut((Put)m, (MapRHTable)this);
                    mputs[i++] = mput;
                    continue;
                }
                if (m instanceof Delete) {
                    mput = PutConverter.toMapRPut((Delete)m, (MapRHTable)this);
                    mputs[i++] = mput;
                    continue;
                }
                throw new IOException("Mutations can only be put or delete");
            }
            this.syncPut(mputs);
        }
    }

    public Result append(Append append) throws IOException {
        if (append.numFamilies() == 0) {
            throw new IOException("Invalid arguments to append, no columns specified");
        }
        MapRPut mput = PutConverter.toMapRPut(append, (MapRHTable)this);
        if (append.isReturnResults()) {
            this.append(mput, true, this.flushOnRead);
            return ResultConverter.toHBaseResult(mput, (MapRHTable)this);
        }
        this.append(mput, false, this.flushOnRead);
        return null;
    }

    public Result increment(Increment increment) throws IOException {
        if (!increment.hasFamilies()) {
            throw new IOException("Invalid arguments to increment, no columns specified");
        }
        MapRIncrement mincr = IncrementConverter.toMapRIncrement(increment, this);
        this.increment(mincr, this.flushOnRead);
        return ResultConverter.createHBaseResult(mincr, (MapRHTable)this);
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        NullPointerException npe = null;
        if (row == null) {
            npe = new NullPointerException("row is null");
        } else if (family == null) {
            npe = new NullPointerException("column is null");
        }
        if (npe != null) {
            throw new IOException("Invalid arguments to incrementColumnValue", npe);
        }
        MapRIncrement mincr = IncrementConverter.toMapRIncrement(row, family, qualifier, amount, this);
        this.increment(mincr, this.flushOnRead);
        return mincr.newValues[0];
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
        return this.incrementColumnValue(row, family, qualifier, amount);
    }

    public void setFlushOnRead(boolean val) {
        this.flushOnRead = val;
    }

    public boolean shouldFlushOnRead() {
        return this.flushOnRead;
    }

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    public RowLock lockRow(byte[] row) throws IOException {
        return null;
    }

    public void unlockRow(RowLock rl) throws IOException {
    }

    public <T extends CoprocessorProtocol> T coprocessorProxy(Class<T> protocol, byte[] row) {
        return null;
    }

    public <T extends CoprocessorProtocol, R> Map<byte[], R> coprocessorExec(Class<T> protocol, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws IOException, Throwable {
        return null;
    }

    public <T extends CoprocessorProtocol, R> void coprocessorExec(Class<T> protocol, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws IOException, Throwable {
    }

    public HRegionLocation getRegionLocation(byte[] row) throws IOException {
        MapRTabletScanner scanner = this.getTabletScanner(row);
        Dbserver.TabletDesc tablet = scanner.next();
        if (tablet != null) {
            return HRegionConverter.toHRegionLocation(tablet, this);
        }
        return null;
    }

    public HRegionLocation getRegionLocation(String row) throws IOException {
        return this.getRegionLocation(Bytes.toBytes((String)row));
    }

    public HRegionLocation getRegionLocation(byte[] row, boolean reload) throws IOException {
        return this.getRegionLocation(row);
    }

    public HConnection getConnection() {
        return null;
    }

    public int getScannerCaching() {
        return 0;
    }

    public void setScannerCaching(int scannerCaching) {
    }

    public byte[][] getStartKeys() throws IOException {
        return (byte[][])this.getStartEndKeys().getFirst();
    }

    public byte[][] getEndKeys() throws IOException {
        return (byte[][])this.getStartEndKeys().getSecond();
    }

    public Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
        List nextSet;
        LinkedList<byte[]> startKeyList = new LinkedList<byte[]>();
        LinkedList<byte[]> endKeyList = new LinkedList<byte[]>();
        MapRTabletScanner scanner = this.getTabletScanner();
        while ((nextSet = scanner.nextSet()) != null) {
            for (Dbserver.TabletDesc tablet : nextSet) {
                startKeyList.add(tablet.getStartKey().toByteArray());
                endKeyList.add(tablet.getEndKey().toByteArray());
            }
        }
        return new Pair(startKeyList.toArray((T[])new byte[startKeyList.size()][]), endKeyList.toArray((T[])new byte[endKeyList.size()][]));
    }

    public Map<HRegionInfo, HServerAddress> getRegionsInfo() throws IOException {
        TreeMap<HRegionInfo, HServerAddress> regionMap = new TreeMap<HRegionInfo, HServerAddress>();
        NavigableMap<HRegionInfo, ServerName> regionLocations = this.getRegionLocations();
        for (Map.Entry entry : regionLocations.entrySet()) {
            HServerAddress server = new HServerAddress();
            ServerName serverName = (ServerName)entry.getValue();
            if (serverName != null && serverName.getHostAndPort() != null) {
                server = new HServerAddress(Addressing.createInetSocketAddressFromHostAndPortStr((String)serverName.getHostAndPort()));
            }
            regionMap.put((HRegionInfo)entry.getKey(), server);
        }
        return regionMap;
    }

    public NavigableMap<HRegionInfo, ServerName> getRegionLocations() throws IOException {
        List nextSet;
        TreeMap<HRegionInfo, ServerName> regions = new TreeMap<HRegionInfo, ServerName>();
        MapRTabletScanner scanner = this.getTabletScanner();
        while ((nextSet = scanner.nextSet()) != null) {
            for (Dbserver.TabletDesc tablet : nextSet) {
                HRegionInfo info = HRegionConverter.toHRegionInfo(tablet, this.tableNameInBytes_);
                ServerName sn = HRegionConverter.toServerName(tablet, this);
                regions.put(info, sn);
            }
        }
        return regions;
    }

    public void prewarmRegionCache(Map<HRegionInfo, HServerAddress> regionMap) {
    }

    public void serializeRegionInfo(DataOutput out) throws IOException {
        Map<HRegionInfo, HServerAddress> allRegions = this.getRegionsInfo();
        out.writeInt(allRegions.size());
        for (Map.Entry<HRegionInfo, HServerAddress> es : allRegions.entrySet()) {
            es.getKey().write(out);
            es.getValue().write(out);
        }
    }

    public Map<HRegionInfo, HServerAddress> deserializeRegionInfo(DataInput in) throws IOException {
        TreeMap<HRegionInfo, HServerAddress> allRegions = new TreeMap<HRegionInfo, HServerAddress>();
        int regionsCount = in.readInt();
        for (int i = 0; i < regionsCount; ++i) {
            HRegionInfo hri = new HRegionInfo();
            hri.readFields(in);
            HServerAddress hsa = new HServerAddress();
            hsa.readFields(in);
            allRegions.put(hri, hsa);
        }
        return allRegions;
    }

    public void setAutoFlush(boolean autoFlush) {
        this.autoFlush = autoFlush;
    }

    public void setAutoFlush(boolean autoFlush, boolean clearBufferOnFail) {
        this.setAutoFlush(autoFlush);
    }

    public long getWriteBufferSize() {
        return 0L;
    }

    public void setWriteBufferSize(long writeBufferSize) throws IOException {
    }

    public ArrayList<Put> getWriteBuffer() {
        return null;
    }

    public void clearRegionCache() {
    }

    public void setOperationTimeout(int operationTimeout) {
    }

    public int getOperationTimeout() {
        return 0;
    }

    public ExecutorService getPool() {
        return null;
    }

    public List<HRegionLocation> getRegionsInRange(byte[] startKey, byte[] endKey) throws IOException {
        HRegionLocation regionLocation;
        boolean endKeyIsEndOfTable = Bytes.equals((byte[])endKey, (byte[])HConstants.EMPTY_END_ROW);
        if (Bytes.compareTo((byte[])startKey, (byte[])endKey) > 0 && !endKeyIsEndOfTable) {
            throw new IllegalArgumentException("Invalid range: " + Bytes.toStringBinary((byte[])startKey) + " > " + Bytes.toStringBinary((byte[])endKey));
        }
        ArrayList<HRegionLocation> regionList = new ArrayList<HRegionLocation>();
        byte[] currentKey = startKey;
        do {
            regionLocation = this.getRegionLocation(currentKey, false);
            regionList.add(regionLocation);
        } while (!Bytes.equals((byte[])(currentKey = regionLocation.getRegionInfo().getEndKey()), (byte[])HConstants.EMPTY_END_ROW) && (endKeyIsEndOfTable || Bytes.compareTo((byte[])currentKey, (byte[])endKey) < 0));
        return regionList;
    }
}

