/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.HRegionConverter;
import com.mapr.fs.MapRDBConstants;
import com.mapr.fs.MapRFileStatus;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.MapRTabletScanner;
import com.mapr.fs.SchemaHelper;
import com.mapr.fs.TableProperties;
import com.mapr.fs.proto.Dbserver;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HBaseAdminInterface;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.mapr.TableMappingRulesFactory;
import org.apache.hadoop.hbase.client.mapr.TableMappingRulesInterface;
import org.apache.hadoop.hbase.ipc.CoprocessorProtocol;
import org.apache.hadoop.hbase.ipc.HMasterInterface;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

public class HBaseAdminImpl
implements HBaseAdminInterface,
MapRDBConstants {
    private static final Log LOG = LogFactory.getLog(HBaseAdmin.class);
    private volatile MapRFileSystem maprfs_;
    private final Configuration conf_;
    private final TableMappingRulesInterface tableMappingRule_;

    public HBaseAdminImpl(Configuration c) throws MasterNotRunningException, ZooKeeperConnectionException {
        try {
            this.conf_ = c;
            this.tableMappingRule_ = TableMappingRulesFactory.create((Configuration)this.conf_);
            this.maprfs_ = new MapRFileSystem();
            this.maprfs_.initialize(new URI("maprfs:///"), this.conf_);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while instantiating HBaseAdminImpl", e);
        }
    }

    public HBaseAdminImpl(HConnection connection) throws MasterNotRunningException, ZooKeeperConnectionException {
        this(connection.getConfiguration());
    }

    public Configuration getConfiguration() {
        return this.conf_;
    }

    public String[] getMasterCoprocessors() {
        return null;
    }

    public void abort(String why, Throwable e) {
    }

    public boolean isAborted() {
        return false;
    }

    public void close() throws IOException {
        this.maprfs_.close();
    }

    public HConnection getConnection() {
        this.unSupportedOperation("getConnection()");
        return null;
    }

    @Deprecated
    public HMasterInterface getMaster() throws MasterNotRunningException, ZooKeeperConnectionException {
        this.unSupportedOperation("getMaster()");
        return null;
    }

    public boolean isMasterRunning() throws MasterNotRunningException, ZooKeeperConnectionException {
        return true;
    }

    public boolean tableExists(byte[] tablePath) throws IOException {
        return this.tableExists(Bytes.toString((byte[])tablePath));
    }

    public boolean tableExists(String tablePath) throws IOException {
        return this.maprfs_.isTable(this.getTablePath(tablePath));
    }

    public HTableDescriptor[] listTables() throws IOException {
        return this.listTables((String)null);
    }

    public HTableDescriptor[] listTables(Pattern pattern) throws IOException {
        return this.listTables(pattern == null ? null : pattern.pattern());
    }

    public HTableDescriptor[] listTables(String lookupPattern) throws IOException {
        ArrayList<HTableDescriptor> descriptors = new ArrayList<HTableDescriptor>();
        FileStatus[] status = this.doListTables(lookupPattern);
        if (status != null && status.length > 0) {
            for (int i = 0; i < status.length; ++i) {
                descriptors.add(SchemaHelper.toHTableDescriptor(this.maprfs_, status[i].getPath(), lookupPattern == null || !lookupPattern.contains("/")));
            }
        }
        return descriptors.toArray(new HTableDescriptor[descriptors.size()]);
    }

    protected FileStatus[] doListTables(String lookupPath) throws IOException {
        Path path = null;
        if (lookupPath == null || lookupPath.length() == 0 || lookupPath.equals(".*")) {
            path = this.tableMappingRule_.getDefaultTablePath();
            if (!this.maprfs_.exists(path)) {
                throw new IOException("doListTables() called for default path(" + path.toUri().getPath() + "), but it does not exists.");
            }
        } else {
            path = this.getTablePath(lookupPath);
        }
        if (this.maprfs_.isTable(path)) {
            return new FileStatus[]{this.maprfs_.getFileStatus(path)};
        }
        String name = ".*";
        if (!this.maprfs_.exists(path)) {
            Path parent = path.getParent();
            if (!this.maprfs_.exists(parent)) {
                throw new IOException("Path '" + path.toString() + "' or its parent does not exist.");
            }
            name = path.getName();
            path = parent;
        }
        final Pattern filter = Pattern.compile(name);
        return this.maprfs_.listStatus(path, new PathFilter(){

            public boolean accept(Path path) {
                return filter.matcher(path.getName()).matches() && HBaseAdminImpl.this.maprfs_.isTable(path);
            }
        });
    }

    public HTableDescriptor getTableDescriptor(byte[] tableName) throws TableNotFoundException, IOException {
        if (tableName == null || tableName.length == 0) {
            return null;
        }
        return this.getTableDescriptor(this.getTablePath(tableName));
    }

    public HTableDescriptor getTableDescriptor(String tableName) throws TableNotFoundException, IOException {
        if (tableName == null || tableName.length() == 0) {
            return null;
        }
        return this.getTableDescriptor(this.getTablePath(tableName));
    }

    protected HTableDescriptor getTableDescriptor(Path tablePath) throws TableNotFoundException, IOException {
        this.checkTable(tablePath);
        return SchemaHelper.toHTableDescriptor(this.maprfs_, tablePath);
    }

    public HTableDescriptor[] getTableDescriptors(List<String> tableNames) throws IOException {
        ArrayList<HTableDescriptor> descriptors = new ArrayList<HTableDescriptor>();
        if (tableNames != null && tableNames.size() > 0) {
            for (String tableName : tableNames) {
                descriptors.add(this.getTableDescriptor(tableName));
            }
        }
        return descriptors.toArray(new HTableDescriptor[descriptors.size()]);
    }

    public void createTable(HTableDescriptor desc, byte[][] splitKeys) throws IOException {
        if (desc == null || desc.getName() == null) {
            throw new IllegalArgumentException("Table descriptor or name can not be null: " + desc);
        }
        try {
            Path path = this.getTablePath(desc.getName());
            if (this.maprfs_.exists(path)) {
                throw new TableExistsException(path.toString());
            }
            this.maprfs_.createTable(path, splitKeys);
            for (HColumnDescriptor cf : desc.getFamilies()) {
                String name = cf.getNameAsString();
                this.maprfs_.createColumnFamily(path, name, SchemaHelper.toSchemaFamily(cf, false));
            }
            TableProperties.setTableProperties(path, desc.getValues());
            LOG.debug((Object)("Created table " + path));
        }
        catch (IOException e) {
            LOG.debug((Object)("Error creating table '" + desc.getNameAsString() + "': " + e.getMessage()));
            throw e;
        }
    }

    public void createTable(HTableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        if (numRegions < 3) {
            throw new IllegalArgumentException("Must create at least three regions");
        }
        if (Bytes.compareTo((byte[])startKey, (byte[])endKey) >= 0) {
            throw new IllegalArgumentException("Start key must be smaller than end key");
        }
        byte[][] splitKeys = Bytes.split((byte[])startKey, (byte[])endKey, (int)(numRegions - 3));
        if (splitKeys == null || splitKeys.length != numRegions - 1) {
            throw new IllegalArgumentException("Unable to split key range into enough regions");
        }
        this.createTable(desc, splitKeys);
    }

    public void createTable(HTableDescriptor desc) throws IOException {
        this.createTable(desc, null);
    }

    public void createTableAsync(HTableDescriptor desc, byte[][] splitKeys) throws IOException {
        this.createTable(desc, splitKeys);
    }

    public void deleteTable(byte[] tableName) throws IOException {
        this.deleteTable(Bytes.toString((byte[])tableName));
    }

    public void deleteTable(String tablePath) throws IOException {
        this.deleteTable(this.getTablePath(tablePath));
    }

    public void deleteTable(Path tablePath) throws IOException {
        this.checkTable(tablePath);
        MapRFileStatus status = this.maprfs_.getMapRFileStatus(tablePath);
        if (!status.isTable()) {
            throw new IOException("Path '" + tablePath.toString() + "' is not a table");
        }
        this.maprfs_.delete(tablePath, false);
        TableProperties.removeProperties(tablePath);
        LOG.debug((Object)("Deleted table " + tablePath));
    }

    public HTableDescriptor[] deleteTables(Pattern pattern) throws IOException {
        return this.deleteTables(pattern.pattern());
    }

    public HTableDescriptor[] deleteTables(String lookupPath) throws IOException {
        LinkedList<HTableDescriptor> failed = new LinkedList<HTableDescriptor>();
        FileStatus[] tables = this.doListTables(lookupPath);
        if (tables != null && tables.length > 0) {
            for (FileStatus table : tables) {
                Path path = table.getPath();
                try {
                    this.deleteTable(path);
                }
                catch (IOException ex) {
                    LOG.info((Object)("Failed to delete table " + path.getName()), (Throwable)ex);
                    failed.add(SchemaHelper.toHTableDescriptor(this.maprfs_, path));
                }
            }
        }
        return failed.toArray(new HTableDescriptor[failed.size()]);
    }

    public void addColumn(byte[] tableName, HColumnDescriptor cf) throws IOException {
        this.addColumn(this.getTablePath(tableName), cf);
    }

    public void addColumn(String tableName, HColumnDescriptor cf) throws IOException {
        this.addColumn(this.getTablePath(tableName), cf);
    }

    public void addColumn(Path tablePath, HColumnDescriptor cf) throws IOException {
        this.checkTable(tablePath);
        String name = cf.getNameAsString();
        try {
            this.maprfs_.createColumnFamily(this.maprfs_.resolveTablePath(tablePath), name, SchemaHelper.toSchemaFamily(cf, false));
        }
        catch (IOException e) {
            LOG.error((Object)("Exception while adding column familiy '" + name + "' for table '" + tablePath + "'"));
            throw e;
        }
    }

    public void modifyColumn(byte[] tableName, HColumnDescriptor cf) throws IOException {
        this.modifyColumn(this.getTablePath(tableName), cf);
    }

    public void modifyColumn(String tableName, HColumnDescriptor cf) throws IOException {
        this.modifyColumn(this.getTablePath(tableName), cf);
    }

    public void modifyColumn(Path tablePath, HColumnDescriptor cf) throws IOException {
        HTableDescriptor desc = this.getTableDescriptor(tablePath);
        if (!desc.hasFamily(cf.getName())) {
            throw new InvalidFamilyOperationException("Column family '" + cf.getNameAsString() + "' does not exist");
        }
        try {
            this.maprfs_.modifyColumnFamily(this.maprfs_.resolveTablePath(tablePath), cf.getNameAsString(), SchemaHelper.toSchemaFamily(cf, false));
        }
        catch (IOException e) {
            LOG.error((Object)("Exception while modifying column familiy '" + cf.getNameAsString() + "' for table '" + tablePath + "'"));
            throw e;
        }
    }

    public void deleteColumn(byte[] tableName, byte[] columnName) throws IOException {
        this.deleteColumn(Bytes.toString((byte[])tableName), Bytes.toString((byte[])columnName));
    }

    public void deleteColumn(String tableName, String columnName) throws IOException {
        Path path = this.getTablePath(tableName);
        this.checkTable(path);
        try {
            this.maprfs_.deleteColumnFamily(this.maprfs_.resolveTablePath(path), columnName);
        }
        catch (IOException e) {
            LOG.error((Object)("Exception while deleting column familiy '" + columnName + "' for table '" + tableName + "'"));
            throw e;
        }
    }

    public Pair<Integer, Integer> getAlterStatus(byte[] tableName) throws IOException {
        return new Pair((Object)0, (Object)0);
    }

    public CompactionRequest.CompactionState getCompactionState(String tableNameOrRegionName) throws IOException, InterruptedException {
        return CompactionRequest.CompactionState.NONE;
    }

    public CompactionRequest.CompactionState getCompactionState(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        return CompactionRequest.CompactionState.NONE;
    }

    @Deprecated
    public boolean balanceSwitch(boolean b) throws MasterNotRunningException, ZooKeeperConnectionException {
        this.unSupportedOperation("balanceSwitch()");
        return false;
    }

    public boolean setBalancerRunning(boolean on, boolean synchronous) throws MasterNotRunningException, ZooKeeperConnectionException {
        this.unSupportedOperation("setBalancerRunning()");
        return false;
    }

    public boolean balancer() throws MasterNotRunningException, ZooKeeperConnectionException {
        this.unSupportedOperation("balancer()");
        return false;
    }

    public void modifyTable(byte[] tableName, HTableDescriptor htd) throws IOException {
        Path path = this.getTablePath(tableName);
        this.checkTable(path);
        TableProperties.setTableProperties(path, htd.getValues());
    }

    public void shutdown() throws IOException {
    }

    public void stopMaster() throws IOException {
    }

    public void stopRegionServer(String hostnamePort) throws IOException {
    }

    public void enableTableAsync(String tableName) throws IOException {
        this.enableTable(tableName);
    }

    public void enableTableAsync(byte[] tableName) throws IOException {
        this.enableTable(tableName);
    }

    public void enableTable(byte[] tableName) throws IOException {
        this.enableTable(Bytes.toString((byte[])tableName));
    }

    public void enableTable(String tableName) throws IOException {
        Path path = this.getTablePath(tableName);
        this.checkTable(path);
        TableProperties.setTableProperty(path, "DISABLED", TableProperties.FALSE);
    }

    public HTableDescriptor[] enableTables(Pattern pattern) throws IOException {
        return this.enableTables(pattern == null ? null : pattern.pattern());
    }

    public HTableDescriptor[] enableTables(String regex) throws IOException {
        return this.setTableDisabledStatus(regex, false);
    }

    public void disableTableAsync(String tableName) throws IOException {
        this.disableTable(tableName);
    }

    public void disableTableAsync(byte[] tableName) throws IOException {
        this.disableTable(Bytes.toString((byte[])tableName));
    }

    public void disableTable(byte[] tableName) throws IOException {
        this.disableTable(Bytes.toString((byte[])tableName));
    }

    public void disableTable(String tableName) throws IOException {
        Path path = this.getTablePath(tableName);
        this.checkTable(path);
        TableProperties.setTableProperty(path, "DISABLED", TableProperties.TRUE);
    }

    public HTableDescriptor[] disableTables(Pattern pattern) throws IOException {
        return this.disableTables(pattern == null ? null : pattern.pattern());
    }

    public HTableDescriptor[] disableTables(String regex) throws IOException {
        return this.setTableDisabledStatus(regex, true);
    }

    public boolean isTableEnabled(String tableName) throws IOException {
        return !this.isTableDisabled(tableName);
    }

    public boolean isTableEnabled(byte[] tableName) throws IOException {
        return !this.isTableDisabled(tableName);
    }

    public boolean isTableDisabled(byte[] tableName) throws IOException {
        return this.isTableDisabled(Bytes.toString((byte[])tableName));
    }

    public boolean isTableDisabled(String tableName) throws IOException {
        Path path = this.getTablePath(tableName);
        this.checkTable(path);
        return Boolean.parseBoolean(TableProperties.getTableProperty(path, "DISABLED"));
    }

    public boolean isTableAvailable(byte[] tableName) throws IOException {
        return this.tableExists(tableName) && this.isTableEnabled(tableName);
    }

    public boolean isTableAvailable(String tableName) throws IOException {
        return this.tableExists(tableName) && this.isTableEnabled(tableName);
    }

    public void closeRegion(String regionname, String serverName) throws IOException {
    }

    public void closeRegion(byte[] regionname, String serverName) throws IOException {
    }

    public boolean closeRegionWithEncodedRegionName(String encodedRegionName, String serverName) throws IOException {
        return false;
    }

    public void closeRegion(ServerName sn, HRegionInfo hri) throws IOException {
    }

    public void flush(String tableNameOrRegionName) throws IOException, InterruptedException {
    }

    public void flush(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
    }

    public byte[][] rollHLogWriter(String serverName) throws IOException, FailedLogCloseException {
        return null;
    }

    public void compact(String tableNameOrRegionName) throws IOException, InterruptedException {
    }

    public void compact(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
    }

    public void compact(byte[] tableNameOrRegionName, boolean major) throws IOException, InterruptedException {
    }

    public void majorCompact(String tableNameOrRegionName) throws IOException, InterruptedException {
    }

    public void majorCompact(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
    }

    public void move(byte[] encodedRegionName, byte[] destServerName) throws UnknownRegionException, MasterNotRunningException, ZooKeeperConnectionException {
    }

    public void assign(byte[] regionName) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
    }

    public void unassign(byte[] regionName, boolean force) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
    }

    public void split(String tableNameOrRegionName) throws IOException, InterruptedException {
    }

    public void split(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
    }

    public void split(String tableNameOrRegionName, String splitPoint) throws IOException, InterruptedException {
    }

    public void split(byte[] tableNameOrRegionName, byte[] splitPoint) throws IOException, InterruptedException {
    }

    public ClusterStatus getClusterStatus() throws IOException {
        return null;
    }

    public List<HRegionInfo> getTableRegions(byte[] tableName) throws IOException {
        List nextSet;
        ArrayList<HRegionInfo> tableRegions = new ArrayList<HRegionInfo>();
        String tablePath = Bytes.toString((byte[])tableName);
        MapRTabletScanner scanner = this.maprfs_.getTabletScanner(new Path(tablePath));
        while ((nextSet = scanner.nextSet()) != null) {
            for (Dbserver.TabletDesc tablet : nextSet) {
                tableRegions.add(HRegionConverter.toHRegionInfo(tablet, tableName));
            }
        }
        return tableRegions;
    }

    protected HTableDescriptor[] setTableDisabledStatus(String regex, Boolean disabled) throws IOException {
        if (regex == null) {
            return null;
        }
        FileStatus[] tables = this.doListTables(regex);
        if (tables != null && tables.length > 0) {
            for (FileStatus table : tables) {
                TableProperties.setTableProperty(table.getPath(), "DISABLED", disabled.toString());
            }
        }
        return new HTableDescriptor[0];
    }

    protected Path getTablePath(String tableName) throws IOException {
        return this.tableMappingRule_.getMaprTablePath(tableName);
    }

    protected Path getTablePath(byte[] tableName) throws IOException {
        return this.tableMappingRule_.getMaprTablePath(tableName);
    }

    protected void unSupportedOperation(String operation) {
        throw new UnsupportedOperationException(operation + " called on MapR HBaseAdminImpl");
    }

    protected void checkTable(Path path) throws IOException, TableNotFoundException {
        if (!this.maprfs_.exists(path)) {
            throw new TableNotFoundException("Table '" + path + "' does not exist.");
        }
        if (!this.maprfs_.isTable(path)) {
            throw new TableNotFoundException("Path '" + path + "' is a not a table.");
        }
    }

    public void compact(String tableOrRegionName, String columnFamily) throws IOException, InterruptedException {
    }

    public void compact(byte[] tableNameOrRegionName, byte[] columnFamily) throws IOException, InterruptedException {
    }

    public void majorCompact(String tableNameOrRegionName, String columnFamily) throws IOException, InterruptedException {
    }

    public void majorCompact(byte[] tableNameOrRegionName, byte[] columnFamily) throws IOException, InterruptedException {
    }

    public Pair<HRegionInfo, ServerName> getRegion(byte[] tableNameOrRegionName, CatalogTracker ct) throws IOException {
        return null;
    }

    public <T extends CoprocessorProtocol> T coprocessorProxy(Class<T> protocol) {
        return null;
    }
}

