/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.kvstore;

import com.mapr.baseutils.utils.Util;
import com.mapr.fs.proto.Common;
import com.mapr.kvstore.KvClientInterface;
import com.mapr.kvstore.KvStoreAdmin;
import com.mapr.kvstore.KvStoreException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VersionUpgradeHelper {
    public static final Log LOG = LogFactory.getLog(VersionUpgradeHelper.class);
    private String compName = "None";
    private KvStoreAdmin kvAdmin;
    private KvClientInterface kvClnt;
    TreeMap<String, VersionInfo> versionInfoMap;
    String onDiskMetaDataVersion = null;
    boolean isMetadataUpgradeDone = false;

    public VersionUpgradeHelper(KvClientInterface kvClnt, String compName) {
        this.kvClnt = kvClnt;
        this.kvAdmin = new KvStoreAdmin(kvClnt);
        this.versionInfoMap = new TreeMap(Collections.reverseOrder());
        if (compName != null) {
            this.compName = compName;
        }
        this.resetMetadataInfo();
    }

    private void resetMetadataInfo() {
        this.onDiskMetaDataVersion = null;
        this.isMetadataUpgradeDone = false;
        this.versionInfoMap.clear();
    }

    private void setMetadataInfo(String currentVersionPath, boolean isUpgradeDone, TreeMap<String, VersionInfo> vInfo) {
        this.onDiskMetaDataVersion = currentVersionPath;
        this.isMetadataUpgradeDone = isUpgradeDone;
        this.versionInfoMap.putAll(vInfo);
    }

    private String getCompName() {
        return this.compName;
    }

    private String dumpVersionMap(String context) {
        StringBuilder sb = new StringBuilder(context);
        for (Map.Entry<String, VersionInfo> entry : this.versionInfoMap.entrySet()) {
            VersionInfo vInfo = entry.getValue();
            sb.append(" ver: ");
            sb.append(entry.getKey());
            sb.append(" exist: ");
            sb.append(vInfo.getFid() != null);
            sb.append(" type: ");
            sb.append(vInfo.getFileType());
            sb.append("  ");
        }
        return sb.toString();
    }

    public String getCurrentVersion() throws Exception {
        if (this.onDiskMetaDataVersion == null) {
            throw new Exception(this.getCompName() + ": current version is fetched before it is initialized");
        }
        return this.onDiskMetaDataVersion;
    }

    public boolean isUpgradeDone() {
        return this.isMetadataUpgradeDone;
    }

    public void reInitMetadataInfo(List<String> potentialVersionList) throws Exception {
        this.resetMetadataInfo();
        this.initMetadataInfo(potentialVersionList);
    }

    public void initMetadataInfo(List<String> inVersionList) throws Exception {
        LOG.info((Object)(this.getCompName() + ": initMetadataInfo with versions: " + Arrays.toString(inVersionList.toArray())));
        if (inVersionList == null || inVersionList.isEmpty()) {
            throw new KvStoreException("Version list is either null or empty");
        }
        this.checkIfListSorted(inVersionList);
        TreeMap<String, VersionInfo> localVersionMap = new TreeMap<String, VersionInfo>(Collections.reverseOrder());
        String onDiskMDVersion = this.initVersionInfoFromDisk(inVersionList, localVersionMap);
        if (onDiskMDVersion == null) {
            String versionToBe = localVersionMap.firstKey();
            LOG.info((Object)("This is a fresh cluster with metadata verison " + versionToBe));
            localVersionMap.put(versionToBe, new VersionInfo(null, Common.FileType.FTInval));
            this.setMetadataInfo(versionToBe, false, localVersionMap);
            return;
        }
        LOG.info((Object)(": OnDiskVersion " + onDiskMDVersion + " checking if upgrade fully done"));
        boolean isUpgradeFullyDone = this.isUpgradeDone(localVersionMap, onDiskMDVersion);
        this.setMetadataInfo(onDiskMDVersion, isUpgradeFullyDone, localVersionMap);
        LOG.info((Object)("Upgrade Result : OnDiskVersion " + onDiskMDVersion + " upgraded: " + isUpgradeFullyDone));
        this.dumpVersionMap("initMetadataInfo");
    }

    public void createAndOpenMetadataPath(boolean create) throws Exception {
        String curVersion = this.getCurrentVersion();
        VersionInfo vInfo = this.versionInfoMap.get(curVersion);
        if (!create || vInfo.isFileCreated()) {
            LOG.info((Object)("createAndOpenMetaPath: create: " + create + ", version: " + curVersion + " exists: " + vInfo.isFileCreated() + " ftype: " + vInfo.getFileType()));
            return;
        }
        LOG.info((Object)("Metapath: " + curVersion + " is not present, creating it"));
        Common.FidMsg fid = this.createdir(curVersion, true);
        TreeMap<String, VersionInfo> localVersionMap = new TreeMap<String, VersionInfo>(Collections.reverseOrder());
        localVersionMap.put(curVersion, new VersionInfo(fid, Common.FileType.FTDirectory));
        this.setMetadataInfo(curVersion, false, localVersionMap);
        LOG.info((Object)("For fresh cluster, versionDir: " + curVersion + " is created, fid: " + Util.printFidMsg((Common.FidMsg)fid)));
    }

    private String initVersionInfoFromDisk(List<String> inVersionList, TreeMap<String, VersionInfo> outMap) throws Exception {
        boolean metaDirFound = false;
        String onDiskMDVersion = null;
        ListIterator<String> listItr = inVersionList.listIterator(inVersionList.size());
        while (listItr.hasPrevious()) {
            String versionDir = listItr.previous();
            Common.FidMsg fid = this.lookupDir(versionDir);
            if (fid == null) {
                outMap.put(versionDir, new VersionInfo(fid, Common.FileType.FTInval));
                continue;
            }
            Common.FileType ftype = this.getFileType(fid);
            outMap.put(versionDir, new VersionInfo(fid, ftype));
            if (!metaDirFound && ftype != Common.FileType.FTDirectory) {
                throw new KvStoreException("Version directory exist: " + versionDir + "with invalid type: " + ftype);
            }
            if (metaDirFound && ftype == Common.FileType.FTDirectory) {
                throw new KvStoreException("Two Version directory exists: " + versionDir + " and " + onDiskMDVersion);
            }
            if (metaDirFound || ftype != Common.FileType.FTDirectory) continue;
            onDiskMDVersion = versionDir;
            metaDirFound = true;
        }
        return onDiskMDVersion;
    }

    private boolean isUpgradeDone(TreeMap<String, VersionInfo> vMap, String onDiskMDVersion) throws Exception {
        Map.Entry<String, VersionInfo> firstEntry = vMap.firstEntry();
        String firstKey = firstEntry.getKey();
        if (!firstKey.equals(onDiskMDVersion)) {
            LOG.info((Object)("Cluster not upgraded, expected: " + firstKey + " current: " + onDiskMDVersion));
            return false;
        }
        NavigableMap<String, VersionInfo> tombStoneMap = vMap.tailMap(firstKey, false);
        for (Map.Entry entry : tombStoneMap.entrySet()) {
            String curKey = (String)entry.getKey();
            VersionInfo vInfo = (VersionInfo)entry.getValue();
            if (!vInfo.isTombStonePresent()) {
                LOG.info((Object)("tombStone not present, version: " + curKey + " exists: " + vInfo.isFileCreated() + " ftype: " + vInfo.getFileType()));
                return false;
            }
            LOG.info((Object)("version: " + curKey + " isExistent: " + vInfo.isFileCreated() + " ftype: " + vInfo.getFileType()));
        }
        LOG.info((Object)("Cluster is fully Upgraded with version: " + onDiskMDVersion + " and tombstones "));
        return true;
    }

    public void upgradeMetadataVersion() throws Exception {
        if (this.onDiskMetaDataVersion == null || this.versionInfoMap.isEmpty()) {
            throw new Exception(this.getCompName() + ": Upgrade is called before initialization");
        }
        if (this.isMetadataUpgradeDone) {
            LOG.info((Object)(this.getCompName() + ": Upgrade is already successfully with On Disk version: " + this.onDiskMetaDataVersion));
            return;
        }
        String srcVersion = this.onDiskMetaDataVersion;
        String destVersion = this.versionInfoMap.firstKey();
        TreeMap<String, VersionInfo> upgradedEntriesMap = new TreeMap<String, VersionInfo>();
        if (!destVersion.equals(srcVersion)) {
            LOG.info((Object)(this.getCompName() + ": rename needed onDisk: " + srcVersion + " expected: " + destVersion));
            this.rename(srcVersion, destVersion, upgradedEntriesMap);
        }
        LOG.info((Object)"Creating tombstones");
        NavigableMap<String, VersionInfo> tombStoneMap = this.versionInfoMap.tailMap(destVersion, false);
        this.createTombStone(tombStoneMap, upgradedEntriesMap);
        this.setMetadataInfo(destVersion, true, upgradedEntriesMap);
        if (!this.isUpgradeDone(this.versionInfoMap, this.onDiskMetaDataVersion)) {
            this.dumpVersionMap("postFailedUpgrade");
            throw new Exception("upgradeMetadataVersion failed");
        }
        this.dumpVersionMap("postUpgrade");
    }

    private void createTombStone(NavigableMap<String, VersionInfo> tombStoneMap, TreeMap<String, VersionInfo> upgradedEntriesMap) throws Exception {
        for (Map.Entry entry : tombStoneMap.entrySet()) {
            String curKey = (String)entry.getKey();
            VersionInfo vInfo = (VersionInfo)entry.getValue();
            if (vInfo.isTombStonePresent()) {
                LOG.info((Object)("tombStone present, version: " + curKey + " exists: " + vInfo.isFileCreated() + " ftype: " + vInfo.getFileType()));
                continue;
            }
            LOG.info((Object)("version: " + curKey + " isExistent: " + vInfo.isFileCreated() + " ftype: " + vInfo.getFileType()));
            Common.FidMsg fid = this.createTombStoneKv(curKey, true);
            upgradedEntriesMap.put(curKey, new VersionInfo(fid, Common.FileType.FTKvstore));
        }
    }

    private void checkIfListSorted(List<String> list) throws Exception {
        for (int i = 0; i < list.size() - 1; ++i) {
            if (list.get(i).compareTo(list.get(i + 1)) < 0) continue;
            throw new KvStoreException(this.getCompName() + ": Incorrect version order at: " + i + " " + list.get(i) + " and " + list.get(i + 1));
        }
    }

    private Common.FidMsg lookupDir(String dirPath) {
        return this.kvClnt.lookup(dirPath);
    }

    private Common.FileType getFileType(Common.FidMsg fid) {
        return this.kvClnt.getfiletype(fid);
    }

    private int rename(String src, String dest) {
        return this.kvAdmin.rename(src, dest);
    }

    private void rename(String src, String dest, TreeMap<String, VersionInfo> upgradedEntriesMap) {
        int status = this.rename(src, dest);
        if (status != 0) {
            throw new KvStoreException(this.getCompName() + ": Rename of " + src + " to: " + dest + " failed with status: " + status);
        }
        Common.FidMsg fid = this.lookupDir(src);
        if (fid != null) {
            throw new KvStoreException("Post Rename, old dir " + src + "still exists fid: " + Util.printFidMsg((Common.FidMsg)fid));
        }
        upgradedEntriesMap.put(src, new VersionInfo(fid, Common.FileType.FTInval));
        fid = this.lookupDir(dest);
        if (fid == null) {
            throw new KvStoreException("Post Rename, new dir " + dest + " doesn't exist ");
        }
        Common.FileType ftype = this.getFileType(fid);
        if (ftype != Common.FileType.FTDirectory) {
            throw new KvStoreException("Post Rename Version new version " + dest + " is not of type dir type: " + ftype);
        }
        upgradedEntriesMap.put(dest, new VersionInfo(fid, Common.FileType.FTDirectory));
        LOG.info((Object)("Rename successful src " + src + " --> dest " + dest + " destFid: " + Util.printFidMsg((Common.FidMsg)fid)));
    }

    private Common.FidMsg createdir(String dirName, boolean verify) throws Exception {
        Common.FidMsg retFid = null;
        int status = 1;
        while (status != 0) {
            status = this.kvAdmin.createdirs(dirName, null, null, 432);
            if (status != 0 && status != 17) {
                if (status == 19 || status == 30) {
                    throw new KvStoreException(this.getCompName() + ": KvStore returned error " + status + " while creating a dir " + dirName);
                }
                LOG.warn((Object)(this.getCompName() + ": Creation of dir " + dirName + " failed with status: " + status + " Sleeping and retrying"));
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            if (verify && status == 17) {
                throw new KvStoreException(this.getCompName() + ": Dir creation with verify failed, dir: " + dirName + " already existing");
            }
            LOG.info((Object)(this.getCompName() + ": KvStore createAndOpenTable: Verifying dir: " + dirName));
            retFid = this.lookupDir(dirName);
            if (retFid == null) {
                throw new KvStoreException(this.getCompName() + ": KvStore returned error while verification of  dir " + dirName);
            }
            LOG.info((Object)(this.getCompName() + ": Creation of dir: " + dirName + " is successful, fid: " + Util.printFidMsg((Common.FidMsg)retFid)));
        }
        return retFid;
    }

    private Common.FidMsg createTombStoneKv(String kvName, boolean verifyKey) throws Exception {
        Common.FidMsg retFid = null;
        int status = -1;
        while (status != 0) {
            status = this.kvAdmin.create(kvName, null, null, 432, Common.FSKeyType.LongKey.getNumber());
            if (status != 0 && status != 17) {
                if (status == 19 || status == 30) {
                    throw new KvStoreException(this.getCompName() + ": KvStore returned error " + status + " while creating a dir " + kvName);
                }
                LOG.warn((Object)(this.getCompName() + ": Creation of kv " + kvName + " failed with status: " + status + " Sleeping and retrying"));
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            if (status == 17 && verifyKey) {
                throw new KvStoreException(this.getCompName() + " tombStone existent Kv: " + kvName + " verify key failed");
            }
            LOG.info((Object)("KvStore createAndOpenTable: Verifying dir: " + kvName));
            retFid = this.lookupDir(kvName);
            if (retFid == null) {
                throw new KvStoreException(this.getCompName() + ": KvStore returned error while verification of  dir " + kvName);
            }
            LOG.info((Object)("Creation of tombStone: " + kvName + " is successful, fid: " + Util.printFidMsg((Common.FidMsg)retFid)));
        }
        return retFid;
    }

    private class VersionInfo {
        Common.FidMsg fid;
        Common.FileType ftype;

        public VersionInfo(Common.FidMsg fid, Common.FileType ftype) {
            this.fid = fid;
            this.ftype = ftype;
        }

        Common.FidMsg getFid() {
            return this.fid;
        }

        boolean isFileCreated() {
            return this.fid != null;
        }

        Common.FileType getFileType() {
            return this.ftype;
        }

        boolean isTombStonePresent() {
            return this.fid != null && this.ftype == Common.FileType.FTKvstore;
        }
    }
}

