/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.kvstore;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Fileserver;
import com.mapr.kvstore.HashedStringKvFactory;
import com.mapr.kvstore.HashedStringKvStore;
import com.mapr.kvstore.InMemoryKvDatabase;
import com.mapr.kvstore.KvDatabaseFactory;
import com.mapr.kvstore.KvDatabaseOp;
import com.mapr.kvstore.KvTable;
import com.mapr.kvstore.KvTableScanner;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class InMemoryHashedStringKvStoreTest {
    Logger logger = LoggerFactory.getLogger(InMemoryHashedStringKvStoreTest.class);
    private static final int MaxOpInOneTxn = 15;
    private static HashMap<String, Integer> originalKv = null;
    private static KvDatabaseFactory inMemoryKvFactory = null;
    private static HashedStringKvFactory hashedKvFactory = null;
    private static KvTable<String> hashedKv = null;

    @BeforeClass
    public static void init() throws Exception {
        originalKv = new HashMap();
        inMemoryKvFactory = new InMemoryKvDatabase(true);
        hashedKvFactory = new HashedStringKvFactory(inMemoryKvFactory);
        hashedKv = hashedKvFactory.create();
        hashedKvFactory.createAndOpenTable("hashedStringKv", hashedKv, Common.FSKeyType.VarKey.getNumber(), false);
    }

    @AfterClass
    public static void finalCleanup() {
        originalKv.clear();
    }

    @Before
    public void prepareKv() {
    }

    @After
    public void cleanup() {
        originalKv.clear();
    }

    @Test
    public void verifyKvOpsTestA() throws Exception {
        String methodName = new Object(){}.getClass().getEnclosingMethod().getName();
        int maxNrEntries = 65536;
        int maxTargetStrLen = 2048;
        this.executeCURD(methodName, maxNrEntries, maxTargetStrLen);
    }

    @Test
    public void verifyKvOpsTestB() throws Exception {
        String methodName = new Object(){}.getClass().getEnclosingMethod().getName();
        int maxNrEntries = 0x100000;
        int maxTargetStrLen = 128;
        this.executeCURD(methodName, maxNrEntries, maxTargetStrLen);
    }

    @Test
    public void verifyKvOpsTestC() throws Exception {
        String methodName = new Object(){}.getClass().getEnclosingMethod().getName();
        int maxNrEntries = 524288;
        int maxTargetStrLen = 128;
        ((HashedStringKvStore)hashedKv).injectFixHash(true);
        this.executeCURD(methodName, maxNrEntries, maxTargetStrLen);
        ((HashedStringKvStore)hashedKv).injectFixHash(false);
    }

    @Test
    public void verifyKvOpsTestD() throws Exception {
        String methodName = new Object(){}.getClass().getEnclosingMethod().getName();
        int maxNrEntries = 65536;
        int maxTargetStrLen = 2048;
        ((HashedStringKvStore)hashedKv).injectFixHash(true);
        this.executeCURD(methodName, maxNrEntries, maxTargetStrLen);
        ((HashedStringKvStore)hashedKv).injectFixHash(false);
    }

    @Test
    public void verifyKvOpsTestE() throws Exception {
        String methodName = new Object(){}.getClass().getEnclosingMethod().getName();
        int maxNrEntries = 65536;
        int maxTargetStrLen = 2048;
        this.executeCURD(methodName, maxNrEntries, maxTargetStrLen);
    }

    @Test
    public void verifyKvOpsTestF() throws Exception {
        String methodName = new Object(){}.getClass().getEnclosingMethod().getName();
        int maxNrEntries = 0x100000;
        int maxTargetStrLen = 128;
        this.executeCURD(methodName, maxNrEntries, maxTargetStrLen);
    }

    private void executeCURD(String testName, int maxNrEntries, int maxTargetStrLen) {
        System.out.println("\n -- Starting Test " + testName + " for nrEntries: " + maxNrEntries + " maxStrLen: " + maxTargetStrLen + "---");
        InMemoryHashedStringKvStoreTest.generateKeyValues(maxNrEntries, maxTargetStrLen);
        InMemoryHashedStringKvStoreTest.insertGeneratedKeyValues();
        long origCount = this.logAndGetCollisionCount(testName);
        this.scanAndVerify();
        this.verifyLookup();
        this.updateValues();
        this.scanVerifyFail();
        InMemoryHashedStringKvStoreTest.insertGeneratedKeyValues();
        this.scanAndVerify();
        long currentCount = this.logAndGetCollisionCount(null);
        if (origCount != currentCount) {
            Assert.assertTrue((String)(testName + ": Collision count changed after update: current: " + currentCount + " expected: " + origCount), (boolean)false);
        }
        this.deleteAllAndVerify();
        currentCount = this.logAndGetCollisionCount(testName + " Successful Finish");
        if (origCount != currentCount) {
            Assert.assertTrue((String)(testName + ": Collision count changed after delete: current: " + currentCount + " expected: " + origCount), (boolean)false);
        }
        System.out.println(" --------- Finished Test " + testName + " ----------\n");
    }

    private static void generateKeyValues(int maxNrEntries, int maxTargetStrLen) {
        int leftLimit = 33;
        int rightLimit = 126;
        Random random = new Random();
        int eachLenNr = maxNrEntries >= maxTargetStrLen ? maxNrEntries / maxTargetStrLen : 1;
        for (int len = 1; len <= maxTargetStrLen; ++len) {
            for (int nr = 1; nr <= eachLenNr; ++nr) {
                String generatedString = random.ints(leftLimit, rightLimit + 1).limit(len).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
                int value = random.nextInt();
                originalKv.put(generatedString, value);
            }
        }
    }

    private static void insertGeneratedKeyValues() {
        int numOps = 0;
        int numKeyInserted = 0;
        KvDatabaseOp op = null;
        int status = 0;
        for (Map.Entry<String, Integer> entry : originalKv.entrySet()) {
            if (numOps == 0) {
                op = hashedKvFactory.getOperator();
            }
            if ((status = op.hashedKeyInsert(hashedKv, entry.getKey(), entry.getValue().intValue())) != 0) {
                Assert.assertTrue((String)("insertGeneratedKeyValues: insertion failed for key: " + entry.getKey() + " value: " + entry.getValue()), (status == 0 ? 1 : 0) != 0);
            }
            ++numKeyInserted;
            if (++numOps < 15) continue;
            status = op.apply();
            Assert.assertTrue((String)"insertGeneratedKeyValues: apply failed", (status == 0 ? 1 : 0) != 0);
            numOps = 0;
        }
        if (numOps != 0) {
            status = op.apply();
            Assert.assertTrue((String)"insertGeneratedKeyValues: final apply failed", (status == 0 ? 1 : 0) != 0);
            numOps = 0;
        }
        System.out.println("insertGeneratedKeyValues: Successful numInserted: " + numKeyInserted + " originalKeyCount: " + originalKv.size() + " kvKeyCnt: " + hashedKv.getKeyCnt());
    }

    private long logAndGetCollisionCount(String ctx) {
        long collisionCount = hashedKv.lookupCollisionNr();
        if (collisionCount < 0L) {
            Assert.assertTrue((String)"Fail to lookup collision count", (collisionCount >= 0L ? 1 : 0) != 0);
        }
        if (ctx != null) {
            System.out.println(ctx + " collision Count: " + collisionCount);
        }
        return collisionCount;
    }

    private void scanAndVerify() {
        Fileserver.KvMsg msg;
        HashMap<String, Integer> localEntriesMap = new HashMap<String, Integer>(originalKv);
        KvTableScanner scanner = hashedKv.getHashedStringScanner();
        int nrEntriesFound = 0;
        while ((msg = scanner.next()) != null) {
            String key = msg.getKey().getVarKey().toStringUtf8();
            CLDBProto.HashedStringValue value = null;
            try {
                value = CLDBProto.HashedStringValue.parseFrom((ByteString)msg.getValue());
            }
            catch (InvalidProtocolBufferException e) {
                Assert.assertTrue((String)("InvalidProtocolBufferException:Error while parsing value for hashed key: " + msg.getKey()), (boolean)false);
            }
            int val = value.getInt32Id();
            Integer expectedVal = localEntriesMap.get(key);
            if (expectedVal == null) {
                Assert.assertTrue((String)("verifyInsertedKey: Key: {} " + key + " is not present in hash string table"), (expectedVal != null ? 1 : 0) != 0);
            }
            if (val != expectedVal) {
                Assert.assertTrue((String)("verifyInsertedKey: Value: {} " + val + " is not same as expectedVal: " + expectedVal + " for Key: {} " + key), (val == expectedVal ? 1 : 0) != 0);
            }
            localEntriesMap.remove(key);
            ++nrEntriesFound;
        }
        if (nrEntriesFound != originalKv.size() || !localEntriesMap.isEmpty()) {
            Assert.assertTrue((String)("verifyInsertedKey: Scan found entries: " + nrEntriesFound + " inserted: " + originalKv.size() + " isEmpty: " + localEntriesMap.isEmpty()), (nrEntriesFound == originalKv.size() && localEntriesMap.isEmpty() ? 1 : 0) != 0);
        }
        System.out.println("Insertion and Verification of Keys Successful");
        scanner.close();
    }

    private void verifyLookup() {
        int logEntryNr = 1000000;
        int numLookup = 0;
        long startTime = System.currentTimeMillis();
        for (Map.Entry<String, Integer> entry : originalKv.entrySet()) {
            CLDBProto.HashedStringValue value = null;
            byte[] valB = hashedKv.lookup((Object)entry.getKey());
            try {
                value = CLDBProto.HashedStringValue.parseFrom((byte[])valB);
            }
            catch (InvalidProtocolBufferException e) {
                Assert.assertTrue((String)("InvalidProtocolBufferException:Error while parsing value for hashed key: " + entry.getKey()), (boolean)false);
            }
            if (value.getInt32Id() != entry.getValue().intValue()) {
                Assert.assertTrue((String)("Lookup of key: " + entry.getKey() + "  mismatch, value: " + value.getInt32Id() + " expected: " + entry.getValue()), (boolean)false);
            }
            if (++numLookup % logEntryNr != 0) continue;
            long secs = (System.currentTimeMillis() - startTime) / 1000L;
            System.out.println("Lookup of " + logEntryNr + " keys took " + secs + " seconds");
            startTime = System.currentTimeMillis();
        }
    }

    private void updateValues() {
        Random random = new Random();
        for (Map.Entry<String, Integer> entry : originalKv.entrySet()) {
            int value = random.nextInt();
            value = value != entry.getValue() ? value : value + 1;
            originalKv.put(entry.getKey(), value);
        }
    }

    private void scanVerifyFail() {
        Fileserver.KvMsg msg;
        HashMap<String, Integer> localEntriesMap = new HashMap<String, Integer>(originalKv);
        KvTableScanner scanner = hashedKv.getHashedStringScanner();
        int nrEntriesFound = 0;
        while ((msg = scanner.next()) != null) {
            String key = msg.getKey().getVarKey().toStringUtf8();
            CLDBProto.HashedStringValue value = null;
            try {
                value = CLDBProto.HashedStringValue.parseFrom((ByteString)msg.getValue());
            }
            catch (InvalidProtocolBufferException e) {
                Assert.assertTrue((String)("InvalidProtocolBufferException:Error while parsing value for hashed key: " + msg.getKey()), (boolean)false);
            }
            int val = value.getInt32Id();
            Integer expectedVal = localEntriesMap.get(key);
            if (expectedVal == null) {
                Assert.assertTrue((String)("scanVerifyFail: Key: {} " + key + " is not present in hash string table"), (expectedVal != null ? 1 : 0) != 0);
            }
            if (val == expectedVal) {
                Assert.assertTrue((String)("scanVerifyFail: Value: {} " + val + " is same as expectedVal: " + expectedVal + " for Key: {} " + key), (boolean)false);
            }
            localEntriesMap.remove(key);
            ++nrEntriesFound;
        }
        if (nrEntriesFound != originalKv.size() || !localEntriesMap.isEmpty()) {
            Assert.assertTrue((String)("scanVerifyFail: Scan found entries: " + nrEntriesFound + " inserted: " + originalKv.size() + " isEmpty: " + localEntriesMap.isEmpty()), (nrEntriesFound == originalKv.size() && localEntriesMap.isEmpty() ? 1 : 0) != 0);
        }
        System.out.println("scanVerifyFail Successful");
        scanner.close();
    }

    private void deleteAllAndVerify() {
        int expectedKeyCnt;
        int numOps = 0;
        int numKeyDeleted = 0;
        KvDatabaseOp op = null;
        int status = 0;
        for (Map.Entry<String, Integer> entry : originalKv.entrySet()) {
            if (numOps == 0) {
                op = hashedKvFactory.getOperator();
            }
            if ((status = op.hashedKeyDelete(hashedKv, entry.getKey())) != 0) {
                Assert.assertTrue((String)("deleteAllAndVerify: delete failed for key: " + entry.getKey()), (boolean)false);
            }
            ++numKeyDeleted;
            if (++numOps < 15) continue;
            status = op.apply();
            Assert.assertTrue((String)"deleteAllAndVerify: apply failed", (status == 0 ? 1 : 0) != 0);
            numOps = 0;
        }
        if (numOps != 0) {
            status = op.apply();
            Assert.assertTrue((String)"deleteAllAndVerify: final apply failed", (status == 0 ? 1 : 0) != 0);
            numOps = 0;
        }
        int n = expectedKeyCnt = hashedKv.isExistCollisionKey() ? 1 : 0;
        if (hashedKv.getKeyCnt() != expectedKeyCnt) {
            Assert.assertTrue((String)("deleteAllAndVerify: Key count mismatch current: " + hashedKv.getKeyCnt() + " expected: " + expectedKeyCnt), (boolean)false);
        }
        System.out.println("deleteAllAndVerify: Successful numDeleted: " + numKeyDeleted + " originalKeyCount: " + originalKv.size() + " kvKeyCnt: " + hashedKv.getKeyCnt() + " expected: " + expectedKeyCnt);
    }
}

