/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.kvstore;

import com.google.protobuf.ByteString;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Fileserver;
import com.mapr.kvstore.KvStoreException;
import com.mapr.kvstore.KvTable;
import com.mapr.kvstore.KvTableScanner;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class InMemoryKvTable<T>
implements KvTable<T> {
    private int type = -1;
    private String varKeyType = String.class.getName();
    private final String tableName = "InMemoryKvTable";
    private TreeMap<T, ByteString> table = new TreeMap();

    @Override
    public int open(String name) {
        return 0;
    }

    @Override
    public void close() {
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void setVarKeyType(String type) {
        this.varKeyType = type;
    }

    @Override
    public byte[] lookup(T keyValue) {
        return this.lookup(keyValue, false);
    }

    @Override
    public byte[] lookup(T keyValue, boolean allowStaleRead) {
        ByteString value = this.table.get(keyValue);
        return value == null ? null : value.toByteArray();
    }

    @Override
    public boolean exists(T keyValue) {
        return this.table.get(keyValue) != null;
    }

    @Override
    public Fileserver.KvMsg getLeftNearValue(T key) {
        Map.Entry<T, ByteString> entry = this.table.floorEntry(key);
        if (entry == null) {
            return null;
        }
        Fileserver.KvStoreKey kvStoreKey = this.getKvStoreKey(entry.getKey());
        if (kvStoreKey == null) {
            return null;
        }
        return Fileserver.KvMsg.newBuilder().setKey(kvStoreKey).setValue(entry.getValue()).build();
    }

    private Fileserver.KvStoreKey getKvStoreKey(T key) {
        if (this.type == Common.FSKeyType.UintKey.getNumber()) {
            return Fileserver.KvStoreKey.newBuilder().setIntKey(((Integer)key).intValue()).setType(Common.FSKeyType.UintKey).build();
        }
        if (this.type == Common.FSKeyType.LongKey.getNumber()) {
            return Fileserver.KvStoreKey.newBuilder().setLongKey(((Long)key).longValue()).setType(Common.FSKeyType.LongKey).build();
        }
        if (this.type == Common.FSKeyType.VarKey.getNumber()) {
            return Fileserver.KvStoreKey.newBuilder().setVarKey(ByteString.copyFromUtf8((String)((String)key))).setType(Common.FSKeyType.VarKey).build();
        }
        return null;
    }

    @Override
    public Fileserver.KvMsg getRightNearValue(T key) {
        Map.Entry<T, ByteString> entry = this.table.higherEntry(key);
        if (entry == null) {
            return null;
        }
        Fileserver.KvStoreKey kvStoreKey = this.getKvStoreKey(entry.getKey());
        if (kvStoreKey == null) {
            return null;
        }
        return Fileserver.KvMsg.newBuilder().setKey(kvStoreKey).setValue(entry.getValue()).build();
    }

    @Override
    public Fileserver.KvstoreLookupNearResponse lookupNear(T key) throws KvStoreException {
        Fileserver.KvMsg leftMsg = this.getLeftNearValue(key);
        Fileserver.KvMsg rightMsg = this.getRightNearValue(key);
        Fileserver.KvstoreLookupNearResponse.Builder resp = Fileserver.KvstoreLookupNearResponse.newBuilder();
        if (leftMsg != null) {
            resp.setLeftKV(leftMsg);
        } else {
            resp.setLeftEod(true);
        }
        if (rightMsg != null) {
            resp.setRightKV(rightMsg);
        } else {
            resp.setRightEod(true);
        }
        return resp.setStatus(0).build();
    }

    @Override
    public Fileserver.KvStoreKey getMinKey() {
        T minKey = this.table.firstKey();
        if (minKey == null) {
            return null;
        }
        return this.getKvStoreKey(minKey);
    }

    @Override
    public Fileserver.KvStoreKey getMaxKey() {
        T maxKey = this.table.lastKey();
        if (maxKey == null) {
            return null;
        }
        return this.getKvStoreKey(maxKey);
    }

    @Override
    public int getKeyCnt() {
        return this.table.size();
    }

    @Override
    public T getKeyFromKvStoreKey(Fileserver.KvStoreKey key) {
        try {
            if (this.type == Common.FSKeyType.UintKey.getNumber()) {
                return Integer.class.cast(key.getIntKey());
            }
            if (this.type == Common.FSKeyType.LongKey.getNumber()) {
                return Long.class.cast(key.getLongKey());
            }
            if (this.type == Common.FSKeyType.VarKey.getNumber()) {
                String keyInStringFormat = key.getVarKey().toStringUtf8();
                return String.class.cast(keyInStringFormat);
            }
            return null;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public synchronized KvTableScanner getScanner(T startKey, T endKey, boolean keysOnly) {
        return new InMemoryKvTableScanner(startKey, endKey, keysOnly);
    }

    @Override
    public synchronized KvTableScanner getScanner(T startKey, boolean keysOnly) {
        return new InMemoryKvTableScanner(startKey, keysOnly);
    }

    @Override
    public synchronized KvTableScanner getScanner(boolean keysOnly) {
        return new InMemoryKvTableScanner(keysOnly);
    }

    @Override
    public void setType(int type) {
        this.type = type;
    }

    public ByteString insert(T key, ByteString value) {
        return this.table.put(key, value);
    }

    public ByteString delete(T key) {
        return this.table.remove(key);
    }

    public class InMemoryKvTableScanner
    implements KvTableScanner {
        private final boolean keysOnly;
        private final Iterator<T> keyIter;
        private final Iterator<Map.Entry<T, ByteString>> entryIter;

        public InMemoryKvTableScanner(T startKey, T endKey, boolean keysOnly) {
            this.keysOnly = keysOnly;
            if (keysOnly) {
                this.keyIter = InMemoryKvTable.this.table.subMap(startKey, true, endKey, true).keySet().iterator();
                this.entryIter = null;
            } else {
                this.entryIter = InMemoryKvTable.this.table.subMap(startKey, true, endKey, true).entrySet().iterator();
                this.keyIter = null;
            }
        }

        public InMemoryKvTableScanner(T startKey, boolean keysOnly) {
            this.keysOnly = keysOnly;
            if (keysOnly) {
                this.keyIter = InMemoryKvTable.this.table.tailMap(startKey, true).keySet().iterator();
                this.entryIter = null;
            } else {
                this.entryIter = InMemoryKvTable.this.table.tailMap(startKey, true).entrySet().iterator();
                this.keyIter = null;
            }
        }

        public InMemoryKvTableScanner(boolean keysOnly) {
            this.keysOnly = keysOnly;
            if (keysOnly) {
                this.keyIter = InMemoryKvTable.this.table.keySet().iterator();
                this.entryIter = null;
            } else {
                this.entryIter = InMemoryKvTable.this.table.entrySet().iterator();
                this.keyIter = null;
            }
        }

        @Override
        public Fileserver.KvMsg next() {
            return this.keysOnly ? this.getNextKey() : this.getNextEntry();
        }

        private Fileserver.KvMsg getNextKey() {
            if (!this.keyIter.hasNext()) {
                return null;
            }
            Fileserver.KvStoreKey kvStoreKey = this.getKvStoreKey(this.keyIter.next());
            if (kvStoreKey == null) {
                return null;
            }
            return Fileserver.KvMsg.newBuilder().setKey(kvStoreKey).build();
        }

        private Fileserver.KvMsg getNextEntry() {
            if (!this.entryIter.hasNext()) {
                return null;
            }
            Map.Entry entry = this.entryIter.next();
            Fileserver.KvStoreKey kvStoreKey = this.getKvStoreKey(entry.getKey());
            if (kvStoreKey == null) {
                return null;
            }
            return Fileserver.KvMsg.newBuilder().setKey(kvStoreKey).setValue(entry.getValue()).build();
        }

        private Fileserver.KvStoreKey getKvStoreKey(T key) {
            if (InMemoryKvTable.this.type == Common.FSKeyType.UintKey.getNumber()) {
                return Fileserver.KvStoreKey.newBuilder().setIntKey(((Integer)key).intValue()).setType(Common.FSKeyType.UintKey).build();
            }
            if (InMemoryKvTable.this.type == Common.FSKeyType.LongKey.getNumber()) {
                return Fileserver.KvStoreKey.newBuilder().setLongKey(((Long)key).longValue()).setType(Common.FSKeyType.LongKey).build();
            }
            if (InMemoryKvTable.this.type == Common.FSKeyType.VarKey.getNumber()) {
                return Fileserver.KvStoreKey.newBuilder().setVarKey(ByteString.copyFromUtf8((String)((String)key))).setType(Common.FSKeyType.VarKey).build();
            }
            return null;
        }

        @Override
        public void close() {
        }
    }
}

