/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.kvstore;

import com.google.protobuf.ByteString;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Fileserver;
import com.mapr.kvstore.ByteStringComparator;
import com.mapr.kvstore.KvStoreException;
import com.mapr.kvstore.KvTable;
import com.mapr.kvstore.KvTableScanner;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class InMemoryByteStringKvTable<T>
implements KvTable<T> {
    private int type = -1;
    private String varKeyType = String.class.getName();
    private final String tableName = "InMemoryByteStringKvTable";
    private TreeMap<ByteString, ByteString> table = new TreeMap(new ByteStringComparator());

    @Override
    public int open(String name) {
        return 0;
    }

    @Override
    public void close() {
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void setVarKeyType(String type) {
        this.varKeyType = type;
    }

    @Override
    public byte[] lookup(T keyValue) {
        return this.lookup(keyValue, false);
    }

    @Override
    public byte[] lookup(T keyValue, boolean allowStaleRead) {
        ByteString value = this.table.get(keyValue);
        return value == null ? null : value.toByteArray();
    }

    @Override
    public boolean exists(T keyValue) {
        return this.table.get(keyValue) != null;
    }

    @Override
    public Fileserver.KvMsg getLeftNearValue(T key) {
        Map.Entry<ByteString, ByteString> entry = this.table.floorEntry((ByteString)key);
        if (entry == null) {
            return null;
        }
        Fileserver.KvStoreKey kvStoreKey = this.getKvStoreKey(entry.getKey());
        if (kvStoreKey == null) {
            return null;
        }
        return Fileserver.KvMsg.newBuilder().setKey(kvStoreKey).setValue(entry.getValue()).build();
    }

    private Fileserver.KvStoreKey getKvStoreKey(ByteString key) {
        if (this.type == Common.FSKeyType.VarKey.getNumber()) {
            return Fileserver.KvStoreKey.newBuilder().setVarKey(key).setType(Common.FSKeyType.VarKey).build();
        }
        return null;
    }

    @Override
    public Fileserver.KvMsg getRightNearValue(T key) {
        Map.Entry<ByteString, ByteString> entry = this.table.higherEntry((ByteString)key);
        if (entry == null) {
            return null;
        }
        Fileserver.KvStoreKey kvStoreKey = this.getKvStoreKey(entry.getKey());
        if (kvStoreKey == null) {
            return null;
        }
        return Fileserver.KvMsg.newBuilder().setKey(kvStoreKey).setValue(entry.getValue()).build();
    }

    @Override
    public Fileserver.KvstoreLookupNearResponse lookupNear(T key) throws KvStoreException {
        Fileserver.KvMsg leftMsg = this.getLeftNearValue(key);
        Fileserver.KvMsg rightMsg = this.getRightNearValue(key);
        Fileserver.KvstoreLookupNearResponse.Builder resp = Fileserver.KvstoreLookupNearResponse.newBuilder();
        if (leftMsg != null) {
            resp.setLeftKV(leftMsg);
        } else {
            resp.setLeftEod(true);
        }
        if (rightMsg != null) {
            resp.setRightKV(rightMsg);
        } else {
            resp.setRightEod(true);
        }
        return resp.setStatus(0).build();
    }

    @Override
    public Fileserver.KvStoreKey getMinKey() {
        ByteString minKey = this.table.firstKey();
        if (minKey == null) {
            return null;
        }
        return this.getKvStoreKey(minKey);
    }

    @Override
    public Fileserver.KvStoreKey getMaxKey() {
        ByteString maxKey = this.table.lastKey();
        if (maxKey == null) {
            return null;
        }
        return this.getKvStoreKey(maxKey);
    }

    @Override
    public int getKeyCnt() {
        return this.table.size();
    }

    @Override
    public T getKeyFromKvStoreKey(Fileserver.KvStoreKey key) {
        try {
            if (this.type == Common.FSKeyType.UintKey.getNumber()) {
                return Integer.class.cast(key.getIntKey());
            }
            if (this.type == Common.FSKeyType.LongKey.getNumber()) {
                return Long.class.cast(key.getLongKey());
            }
            if (this.type == Common.FSKeyType.VarKey.getNumber()) {
                String keyInStringFormat = key.getVarKey().toStringUtf8();
                return String.class.cast(keyInStringFormat);
            }
            return null;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public synchronized KvTableScanner getScanner(T startKey, T endKey, boolean keysOnly) {
        return new InMemoryKvByteTableScanner((ByteString)startKey, (ByteString)endKey, keysOnly);
    }

    @Override
    public synchronized KvTableScanner getScanner(T startKey, boolean keysOnly) {
        return new InMemoryKvByteTableScanner((ByteString)startKey, keysOnly);
    }

    @Override
    public synchronized KvTableScanner getScanner(boolean keysOnly) {
        return new InMemoryKvByteTableScanner(keysOnly);
    }

    @Override
    public void setType(int type) {
        this.type = type;
    }

    public ByteString insert(ByteString key, ByteString value) {
        return this.table.put(key, value);
    }

    public ByteString delete(ByteString key) {
        return this.table.remove(key);
    }

    public class InMemoryKvByteTableScanner
    implements KvTableScanner {
        private final boolean keysOnly;
        private final Iterator<ByteString> keyIter;
        private final Iterator<Map.Entry<ByteString, ByteString>> entryIter;

        public InMemoryKvByteTableScanner(ByteString startKey, ByteString endKey, boolean keysOnly) {
            this.keysOnly = keysOnly;
            if (keysOnly) {
                this.keyIter = InMemoryByteStringKvTable.this.table.subMap(startKey, true, endKey, true).keySet().iterator();
                this.entryIter = null;
            } else {
                this.entryIter = InMemoryByteStringKvTable.this.table.subMap(startKey, true, endKey, true).entrySet().iterator();
                this.keyIter = null;
            }
        }

        public InMemoryKvByteTableScanner(ByteString startKey, boolean keysOnly) {
            this.keysOnly = keysOnly;
            if (keysOnly) {
                this.keyIter = InMemoryByteStringKvTable.this.table.tailMap(startKey, true).keySet().iterator();
                this.entryIter = null;
            } else {
                this.entryIter = InMemoryByteStringKvTable.this.table.tailMap(startKey, true).entrySet().iterator();
                this.keyIter = null;
            }
        }

        public InMemoryKvByteTableScanner(boolean keysOnly) {
            this.keysOnly = keysOnly;
            if (keysOnly) {
                this.keyIter = InMemoryByteStringKvTable.this.table.keySet().iterator();
                this.entryIter = null;
            } else {
                this.entryIter = InMemoryByteStringKvTable.this.table.entrySet().iterator();
                this.keyIter = null;
            }
        }

        @Override
        public Fileserver.KvMsg next() {
            return this.keysOnly ? this.getNextKey() : this.getNextEntry();
        }

        private Fileserver.KvMsg getNextKey() {
            if (!this.keyIter.hasNext()) {
                return null;
            }
            Fileserver.KvStoreKey kvStoreKey = this.getKvStoreKey(this.keyIter.next());
            if (kvStoreKey == null) {
                return null;
            }
            return Fileserver.KvMsg.newBuilder().setKey(kvStoreKey).build();
        }

        private Fileserver.KvMsg getNextEntry() {
            if (!this.entryIter.hasNext()) {
                return null;
            }
            Map.Entry<ByteString, ByteString> entry = this.entryIter.next();
            Fileserver.KvStoreKey kvStoreKey = this.getKvStoreKey(entry.getKey());
            if (kvStoreKey == null) {
                return null;
            }
            return Fileserver.KvMsg.newBuilder().setKey(kvStoreKey).setValue(entry.getValue()).build();
        }

        private Fileserver.KvStoreKey getKvStoreKey(ByteString key) {
            if (InMemoryByteStringKvTable.this.type == Common.FSKeyType.VarKey.getNumber()) {
                return Fileserver.KvStoreKey.newBuilder().setVarKey(key).setType(Common.FSKeyType.VarKey).build();
            }
            return null;
        }

        @Override
        public void close() {
        }
    }
}

