/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.kvstore;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.BinaryString;
import com.mapr.baseutils.utils.Util;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Fileserver;
import com.mapr.kvstore.HashedStringScanner;
import com.mapr.kvstore.KvDatabaseOp;
import com.mapr.kvstore.KvStoreException;
import com.mapr.kvstore.KvTable;
import com.mapr.kvstore.KvTableScanner;
import com.mapr.kvstore.Scanner;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashedStringKvStore
implements KvTable<String> {
    private static final Logger LOG = LoggerFactory.getLogger(HashedStringKvStore.class);
    static final byte[] MaxCollisionNrKey = new byte[]{0};
    private static final int nonConfictingHashLen = 8;
    private AtomicLong maxHashedCollisionNr;
    private ReentrantLock updateLock;
    private KvTable<ByteString> kvTable;
    private boolean returnFixHash = false;

    public HashedStringKvStore(KvTable<ByteString> kvTable) {
        this.kvTable = kvTable;
        this.maxHashedCollisionNr = new AtomicLong(0L);
        this.updateLock = new ReentrantLock();
        this.returnFixHash = false;
    }

    KvTable<ByteString> getInnerTable() {
        return this.kvTable;
    }

    @Override
    public int open(String name) {
        int status = this.kvTable.open(name);
        if (status != 0) {
            LOG.error("HashedStringKvStore Open failed for table: " + name);
            return status;
        }
        return this.popuplateMaxHashedCollisionNr();
    }

    @Override
    public String getTableName() {
        return this.kvTable.getTableName();
    }

    @Override
    public void close() {
        this.kvTable.close();
    }

    void injectFixHash(boolean val) {
        this.returnFixHash = val;
    }

    @Override
    public void setVarKeyType(String type) {
        this.kvTable.setVarKeyType(type);
    }

    @Override
    public byte[] lookup(String keyValue) {
        HashedKeyLookupResult result = this.hashedKeyLookup(keyValue);
        if (result == null || result.getVal() == null) {
            return null;
        }
        return result.getVal().toByteArray();
    }

    @Override
    public byte[] lookup(String keyValue, boolean allowStaleRead) {
        LOG.error("lookup with allowStaleRead not supported for HashedKv table" + this.getTableName());
        throw new KvStoreException("getLeftNearValue not supported for HashedKv table" + this.getTableName());
    }

    @Override
    public Fileserver.KvMsg getLeftNearValue(String key) {
        LOG.error("getLeftNearValue not supported for HashedKv table" + this.getTableName());
        throw new KvStoreException("getLeftNearValue not supported for HashedKv table" + this.getTableName());
    }

    @Override
    public Fileserver.KvMsg getRightNearValue(String key) {
        LOG.error("getRightNearValue not supported for HashedKv table" + this.getTableName());
        throw new KvStoreException("getRightNearValue not supported for HashedKv table" + this.getTableName());
    }

    @Override
    public Fileserver.KvstoreLookupNearResponse lookupNear(String key) throws KvStoreException {
        LOG.error("lookupNear not supported for HashedKv table" + this.getTableName());
        throw new KvStoreException("lookupNear not supported for HashedKv table" + this.getTableName());
    }

    @Override
    public Fileserver.KvStoreKey getMinKey() {
        LOG.error("getMinKey not supported for HashedKv table" + this.getTableName());
        throw new KvStoreException("getMinKey not supported for HashedKv table" + this.getTableName());
    }

    @Override
    public Fileserver.KvStoreKey getMaxKey() {
        LOG.error("getMaxKey not supported for HashedKv table" + this.getTableName());
        throw new KvStoreException("getMaxKey not supported for HashedKv table" + this.getTableName());
    }

    @Override
    public int getKeyCnt() {
        return this.kvTable.getKeyCnt();
    }

    @Override
    public boolean exists(String keyValue) {
        byte[] val = null;
        try {
            val = this.lookup(keyValue);
        }
        catch (Exception e) {
            LOG.error("Exception during kvstore exists key: ", (Throwable)e);
            throw e;
        }
        return val != null;
    }

    @Override
    public String getKeyFromKvStoreKey(Fileserver.KvStoreKey key) {
        try {
            return (String)String.class.cast(key.getVarKey());
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    private HashedKeyLookupResult hashedKeyLookup(String key) {
        Fileserver.KvMsg msg;
        HashedKeyLookupResult result = new HashedKeyLookupResult();
        byte[] hash = this.getHash(key);
        result.setHash(hash);
        ByteString lowestHashedKey = this.getLowestHashedKey(hash);
        ByteString highestHashedKey = this.getHighestHashedKey(hash);
        if (LOG.isDebugEnabled()) {
            LOG.debug("For key: {} lowestHashedKey:{} -- {} highestHashedKey:{} -- {}", new Object[]{key, BinaryString.toStringHex((byte[])lowestHashedKey.toByteArray()), Util.printableKey((byte[])lowestHashedKey.toByteArray()), BinaryString.toStringHex((byte[])highestHashedKey.toByteArray()), Util.printableKey((byte[])highestHashedKey.toByteArray())});
        }
        KvTableScanner rangeScanner = this.kvTable.getScanner(lowestHashedKey, highestHashedKey, false);
        boolean conflictingHashPresent = false;
        while ((msg = rangeScanner.next()) != null) {
            conflictingHashPresent = true;
            ByteString hashedKey = msg.getKey().getVarKey();
            try {
                ByteString val = msg.getValue();
                if (val == null) {
                    LOG.error("Table : {} got Null Value for key:{} hashedKey:{}", new Object[]{this.getTableName(), key, Util.printableKey((byte[])hashedKey.toByteArray())});
                    continue;
                }
                CLDBProto.HashedStringValue hashedVal = CLDBProto.HashedStringValue.parseFrom((ByteString)val);
                if (!key.equals(hashedVal.getOriginalKey())) continue;
                result.setHashedKey(hashedKey);
                result.setVal(hashedVal);
                return result;
            }
            catch (InvalidProtocolBufferException e) {
                LOG.error("InvalidProtocolBufferException : for table: {} key:{} hashedKey:{} e: {}", new Object[]{this.getTableName(), key, Util.printableKey((byte[])hashedKey.toByteArray()), e});
            }
        }
        result.setConfilictingHashPresent(conflictingHashPresent);
        if (LOG.isDebugEnabled()) {
            LOG.debug("lookupKey: KEY NOT FOUND Table : {} got Null Value for key:{} hashedKey:{} conflictingHashPresent: {}", new Object[]{this.getTableName(), key, Util.printableKey((byte[])hash), conflictingHashPresent});
        }
        return result;
    }

    public Scanner getScanner(String startKey, String endKey, boolean keysOnly) {
        LOG.error("getScanner with key range not supported for HashedKv table" + this.getTableName() + " instead use HashedKeyScanner");
        throw new KvStoreException("getScanner with key range not supported for HashedKvTable, use HashedKeyScanner");
    }

    public Scanner getScanner(String startKey, boolean keysOnly) {
        LOG.error("getScanner with startKey not supported for HashedKv table" + this.getTableName() + " instead use HashedKeyScanner");
        throw new KvStoreException("getScanner with startKey not supported for HashedKvTable, use HashedKeyScanner");
    }

    @Override
    public Scanner getScanner(boolean keysOnly) {
        LOG.error("getScanner on full range not supported for HashedKv table" + this.getTableName() + " instead use HashedKeyScanner");
        throw new KvStoreException("getScanner on full range not supported for HashedKvTable, use HashedKeyScanner");
    }

    @Override
    public KvTableScanner getHashedStringScanner() {
        ByteString minKey = HashedStringKvStore.getMostMinimumKey();
        KvTableScanner scanner = this.kvTable.getScanner(minKey, false);
        return new HashedStringScanner(this.kvTable, scanner);
    }

    @Override
    public void setType(int type) {
        this.kvTable.setType(type);
    }

    @Override
    public long lookupCollisionNr() {
        CLDBProto.HashedStringValue val;
        byte[] data = null;
        try {
            data = this.kvTable.lookup(this.getMaxCollisionNrKey());
            if (data == null) {
                LOG.info("Table " + this.getTableName() + " doesn't have lookup key with collision");
                return 0L;
            }
            val = CLDBProto.HashedStringValue.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error("InvalidProtocolBufferException : Error while parsing protocol buffer in table openfor table " + this.getTableName());
            return -1L;
        }
        return val.getInt64Id();
    }

    @Override
    public boolean isExistCollisionKey() {
        byte[] data = this.kvTable.lookup(this.getMaxCollisionNrKey());
        if (data == null) {
            LOG.info("Table " + this.getTableName() + " doesn't have lookup key with collision");
            return false;
        }
        return true;
    }

    private int popuplateMaxHashedCollisionNr() {
        long val = this.lookupCollisionNr();
        if (val < 0L) {
            LOG.error("Unable to fetch MaxHashedCollisionNr");
            return -1;
        }
        this.maxHashedCollisionNr.set(val);
        return 0;
    }

    private ByteString getMaxCollisionNrKey() {
        return ByteString.copyFrom((byte[])MaxCollisionNrKey);
    }

    private long getCollisionNr() {
        return this.maxHashedCollisionNr.get();
    }

    private long incrAndGetCollisionNr() {
        return this.maxHashedCollisionNr.incrementAndGet();
    }

    byte[] getHash(String key) {
        byte[] retArr = Arrays.copyOfRange(Util.getSHA256((String)key), 0, 8);
        if (this.returnFixHash && retArr[0] == 0) {
            return new byte[]{13, 14, 10, 13, 11, 14, 14, 15};
        }
        return retArr;
    }

    private ByteString getKeyWithCollision(byte[] hash, long collisionNr) {
        int i;
        byte[] result = new byte[16];
        for (i = 0; i < 8; ++i) {
            result[i] = hash[i];
        }
        for (i = 7; i >= 0; --i) {
            result[8 + i] = (byte)(collisionNr & 0xFFL);
            collisionNr >>= 8;
        }
        return ByteString.copyFrom((byte[])result);
    }

    private ByteString getLowestHashedKey(byte[] hash) {
        return ByteString.copyFrom((byte[])hash);
    }

    private ByteString getHighestHashedKey(byte[] hash) {
        return this.getKeyWithCollision(hash, Long.MAX_VALUE);
    }

    private static ByteString getMostMinimumKey() {
        byte[] result = new byte[8];
        for (int i = 0; i < 8; ++i) {
            result[i] = 0;
        }
        return ByteString.copyFrom((byte[])result);
    }

    public int addInsertOp(KvDatabaseOp op, String key, int val, boolean skipCollisionCountUpdate, boolean verifyKey, HashSet<HashedStringKvStore> pendingUnlockTables) {
        LOG.debug("addInsertOp: For table: {} key: {} val: {}", new Object[]{this.getTableName(), key, val});
        if (!this.updateLock.isHeldByCurrentThread()) {
            this.updateLock.lock();
            pendingUnlockTables.add(this);
        }
        CLDBProto.HashedStringValue hashedVal = CLDBProto.HashedStringValue.newBuilder().setOriginalKey(key).setInt32Id(val).build();
        HashedKeyLookupResult result = this.hashedKeyLookup(key);
        if (result == null) {
            LOG.error("Insert of Key: {} val: {} failed in table: {}", new Object[]{key, val, this.getTableName()});
            return -1;
        }
        if (result.getVal() != null) {
            if (verifyKey) {
                LOG.error("addInsertOp failed: Key Already Present: For table: {} key: {} val: {} ", new Object[]{this.getTableName(), key, val});
                return -1;
            }
            LOG.debug("For table: {} key: {} val: {} key is present, hence updating key", new Object[]{this.getTableName(), key, val});
            return op.insert(this.kvTable, result.getHashedKey(), (MessageLite)hashedVal);
        }
        if (!result.isConfilictingHashPresent()) {
            LOG.debug("For table: {} key: {} val: {} key is not present, hence updating key", new Object[]{this.getTableName(), key, val});
            return op.insert(this.kvTable, ByteString.copyFrom((byte[])result.getHash()), (MessageLite)hashedVal);
        }
        long collisionNr = this.incrAndGetCollisionNr();
        ByteString keyWithCollision = this.getKeyWithCollision(result.getHash(), collisionNr);
        LOG.debug("conflicting insert table: {} key: {} val: {} collisionNr: {}  ", new Object[]{this.getTableName(), key, val, collisionNr});
        if (!skipCollisionCountUpdate) {
            CLDBProto.HashedStringValue collisionCountVal = CLDBProto.HashedStringValue.newBuilder().setInt64Id(collisionNr).build();
            int status = op.insert(this.kvTable, this.getMaxCollisionNrKey(), (MessageLite)collisionCountVal);
            if (status != 0) {
                LOG.error("addInsertOp failed for conflicting key table: {} key: {} val: {} ", new Object[]{this.getTableName(), key, val});
                return status;
            }
        }
        return op.insert(this.kvTable, keyWithCollision, (MessageLite)hashedVal);
    }

    public int insertCollisionCount(KvDatabaseOp op, HashSet<HashedStringKvStore> pendingUnlockTables) {
        if (!this.updateLock.isHeldByCurrentThread()) {
            this.updateLock.lock();
            pendingUnlockTables.add(this);
        }
        CLDBProto.HashedStringValue collisionCountVal = CLDBProto.HashedStringValue.newBuilder().setInt64Id(this.getCollisionNr()).build();
        return op.insert(this.kvTable, this.getMaxCollisionNrKey(), (MessageLite)collisionCountVal);
    }

    public int addDeleteOp(KvDatabaseOp op, String key, HashSet<HashedStringKvStore> pendingUnlockTables) {
        HashedKeyLookupResult result;
        LOG.debug("addDeleteOp: For table: {} key: {} ", (Object)this.getTableName(), (Object)key);
        if (!this.updateLock.isHeldByCurrentThread()) {
            this.updateLock.lock();
            pendingUnlockTables.add(this);
        }
        if ((result = this.hashedKeyLookup(key)) == null) {
            LOG.error("addDeleteOp of Key: {} failed in table: {}", (Object)key, (Object)this.getTableName());
            return -1;
        }
        if (result.getVal() == null) {
            LOG.debug("addDeleteOp: For table: {} key: {} not present", (Object)this.getTableName(), (Object)key);
            return 0;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("addDeleteOp: For table: {} key: {} key is present with hashedKey: {}", new Object[]{this.getTableName(), key, Util.printableKey((byte[])result.getHashedKey().toByteArray())});
        }
        return op.delete(this.kvTable, result.getHashedKey());
    }

    public void releaseUpdateLock() {
        if (!this.updateLock.isHeldByCurrentThread()) {
            LOG.error("Table Lock: {} is not held by current thread", (Object)this.getTableName());
            return;
        }
        this.updateLock.unlock();
    }

    private class HashedKeyLookupResult {
        byte[] hash;
        ByteString hashedKey;
        CLDBProto.HashedStringValue val;
        boolean confilictingHashPresent;

        private HashedKeyLookupResult() {
        }

        public byte[] getHash() {
            return this.hash;
        }

        public void setHash(byte[] hash) {
            this.hash = hash;
        }

        public ByteString getHashedKey() {
            return this.hashedKey;
        }

        public void setHashedKey(ByteString hashedKey) {
            this.hashedKey = hashedKey;
        }

        public CLDBProto.HashedStringValue getVal() {
            return this.val;
        }

        public void setVal(CLDBProto.HashedStringValue val) {
            this.val = val;
        }

        public boolean isConfilictingHashPresent() {
            return this.confilictingHashPresent;
        }

        public void setConfilictingHashPresent(boolean confilictingHashPresent) {
            this.confilictingHashPresent = confilictingHashPresent;
        }
    }
}

