/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.kvstore;

import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import com.mapr.fs.Rpc;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Fileserver;
import com.mapr.fs.proto.Security;
import com.mapr.kvstore.KvStore;
import com.mapr.kvstore.KvStoreClient;
import com.mapr.kvstore.KvStoreException;
import com.mapr.kvstore.KvStoreStaleException;
import com.mapr.kvstore.KvTableScanner;
import com.mapr.kvstore.Operation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Scanner
implements KvTableScanner {
    private long binding;
    private Common.FidMsg fid;
    private Common.FSKeyType type;
    private int stKey;
    private int enKey;
    private long stLongKey;
    private long enLongKey;
    private ByteString stVarKey;
    private ByteString enVarKey;
    private boolean keysOnly;
    private boolean endScan;
    private Fileserver.KvstoreScanResponse resp;
    private int idx;
    private Security.CredentialsMsg creds_;
    private Fileserver.BTreeRAParam racookie_;
    public static final Log LOG = LogFactory.getLog(Operation.class);

    public Scanner(KvStoreClient clnt, Common.FidMsg fidValue, int startKey, int endKey, boolean keysOnlyV, Security.CredentialsMsg creds) {
        this.binding = clnt.getBinding(KvStoreClient.BindingType.ScannerBinding);
        this.type = Common.FSKeyType.UintKey;
        this.stKey = startKey;
        this.enKey = endKey;
        this.fid = fidValue;
        this.keysOnly = keysOnlyV;
        this.resp = Fileserver.KvstoreScanResponse.newBuilder().setStatus(0).build();
        this.idx = 0;
        this.endScan = false;
        this.initRacookie();
        this.creds_ = creds;
    }

    public Scanner(KvStoreClient clnt, Common.FidMsg fidValue, long startKey, long endKey, boolean keysOnlyV, Security.CredentialsMsg creds) {
        this.binding = clnt.getBinding(KvStoreClient.BindingType.ScannerBinding);
        this.type = Common.FSKeyType.LongKey;
        this.stLongKey = startKey;
        this.enLongKey = endKey;
        this.fid = fidValue;
        this.keysOnly = keysOnlyV;
        this.resp = Fileserver.KvstoreScanResponse.newBuilder().setStatus(0).build();
        this.idx = 0;
        this.endScan = false;
        this.initRacookie();
        this.creds_ = creds;
    }

    public Scanner(KvStoreClient clnt, Common.FidMsg fidValue, ByteString startKey, ByteString endKey, boolean keysOnlyV, Security.CredentialsMsg creds) {
        this.binding = clnt.getBinding(KvStoreClient.BindingType.ScannerBinding);
        this.type = Common.FSKeyType.VarKey;
        this.stVarKey = startKey;
        this.enVarKey = endKey;
        this.fid = fidValue;
        this.keysOnly = keysOnlyV;
        this.resp = Fileserver.KvstoreScanResponse.newBuilder().setStatus(0).build();
        this.idx = 0;
        this.endScan = false;
        this.initRacookie();
        this.creds_ = creds;
    }

    private void initRacookie() {
        this.racookie_ = Fileserver.BTreeRAParam.newBuilder().build();
    }

    private void setCookie(Fileserver.KvstoreScanResponse resp) {
        this.setStartKey(resp);
        this.setRacookie(resp);
    }

    private void setRacookie(Fileserver.KvstoreScanResponse resp) {
        if (resp.hasRacookie()) {
            this.racookie_ = Fileserver.BTreeRAParam.newBuilder((Fileserver.BTreeRAParam)resp.getRacookie()).build();
        }
    }

    private void setStartKey(Fileserver.KvstoreScanResponse resp) {
        if (this.type == Common.FSKeyType.UintKey) {
            this.stKey = resp.getCookie().getIntKey();
        } else if (this.type == Common.FSKeyType.LongKey) {
            this.stLongKey = resp.getCookie().getLongKey();
        } else {
            this.stVarKey = resp.getCookie().getVarKey();
        }
    }

    private Fileserver.KvStoreKey getStartKey() {
        Fileserver.KvStoreKey key = this.type == Common.FSKeyType.UintKey ? Fileserver.KvStoreKey.newBuilder().setType(Common.FSKeyType.UintKey).setIntKey(this.stKey).build() : (this.type == Common.FSKeyType.LongKey ? Fileserver.KvStoreKey.newBuilder().setType(Common.FSKeyType.LongKey).setLongKey(this.stLongKey).build() : Fileserver.KvStoreKey.newBuilder().setType(Common.FSKeyType.VarKey).setVarKey(this.stVarKey).build());
        return key;
    }

    private Fileserver.KvStoreKey getLastKey() {
        Fileserver.KvStoreKey key = this.type == Common.FSKeyType.UintKey ? Fileserver.KvStoreKey.newBuilder().setType(Common.FSKeyType.UintKey).setIntKey(this.enKey).build() : (this.type == Common.FSKeyType.LongKey ? Fileserver.KvStoreKey.newBuilder().setType(Common.FSKeyType.LongKey).setLongKey(this.enLongKey).build() : Fileserver.KvStoreKey.newBuilder().setType(Common.FSKeyType.VarKey).setVarKey(this.enVarKey).build());
        return key;
    }

    @Override
    public Fileserver.KvMsg next() {
        if (this.idx >= this.resp.getKvMsgCount()) {
            if (this.endScan) {
                return null;
            }
            Fileserver.KvStoreKey key = this.getStartKey();
            Fileserver.KvStoreKey lastKey = this.getLastKey();
            Fileserver.KvstoreScanRequest req = Fileserver.KvstoreScanRequest.newBuilder().setFid(this.fid).setStartKey(key).setEndKey(lastKey).setKeysonly(this.keysOnly).setCreds(this.creds_).setRacookie(this.racookie_).build();
            byte[] reply = null;
            String origName = KvStore.setThreadName(Fileserver.FSProg.KvstoreScanProc, this.fid);
            try {
                reply = Rpc.sendRequest((long)this.binding, (int)Common.MapRProgramId.FileServerProgramId.getNumber(), (int)Fileserver.FSProg.KvstoreScanProc.getNumber(), (MessageLite)req);
                if (reply == null) {
                    LOG.error((Object)("KvStore: Rpc to server failed for scan on Fid: " + this.fid.getCinum() + ":" + this.fid.getUniq()));
                    throw new KvStoreException("Reply from server for kvstorescan is null.");
                }
                this.resp = Fileserver.KvstoreScanResponse.parseFrom((byte[])reply);
                if (this.resp.getStatus() == 116 || this.resp.getStatus() == 19) {
                    throw new KvStoreStaleException("Reply from server kvstorescan with status " + this.resp.getStatus());
                }
                if (this.resp.getStatus() == 122) {
                    throw new KvStoreException("Reply from server kvstorescan with status " + this.resp.getStatus());
                }
                if (this.resp.getKvMsgCount() == 0) {
                    Fileserver.KvMsg kvMsg = null;
                    return kvMsg;
                }
                if (this.resp.getStatus() == 28) {
                    this.setCookie(this.resp);
                } else {
                    this.endScan = true;
                }
            }
            catch (KvStoreStaleException e) {
                throw e;
            }
            catch (KvStoreException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Object)("Exception during Scan: " + e));
                if (reply != null) {
                    LOG.error((Object)("KvStoreScan resp size : " + reply.length));
                }
                e.printStackTrace();
                throw new KvStoreException("Exception during kvstore scan: ", e);
            }
            finally {
                Thread.currentThread().setName(origName);
            }
            this.idx = 0;
        }
        ++this.idx;
        return this.resp.getKvMsg(this.idx - 1);
    }

    @Override
    public void close() {
    }
}

