/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.kvstore;

import com.google.protobuf.MessageLite;
import com.mapr.fs.Rpc;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Fileserver;
import com.mapr.fs.proto.Security;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KvStoreClient {
    private long clntPtr;
    private int rootCid;
    private int numRpcThreads;
    private Security.CredentialsMsg creds;
    private int DEFAULT_ROOT_DIR_CINUM = 16;
    private int DEFAULT_ROOT_DIR_UNIQ = 2;
    BindingIdxTracker bindingIdxTracker = null;
    private List<Long> bindings = null;
    public long binding;
    public static final Log LOG = LogFactory.getLog(KvStoreClient.class);

    private final native long OpenClient(String var1);

    private final native long OpenClientWithCid(String var1, int var2, String var3, int var4);

    private final native void CloseClient(long var1);

    private final native int create(long var1, String var3, int var4, int var5);

    private final native void setNoDelete(long var1, int var3, boolean var4);

    private final native byte[] lookup(long var1, String var3);

    private final native int gettype(long var1, byte[] var3);

    private final native int remove(long var1, String var3);

    private final native int rename(long var1, String var3, String var4);

    public long getBinding() {
        return this.bindings.get(0);
    }

    public long getBinding(BindingType bType) {
        return this.bindingIdxTracker.getBinding(bType);
    }

    @Deprecated
    public KvStoreClient(String scheme, String clusterName, String host, int port) {
        this.numRpcThreads = 1;
        this.bindingIdxTracker = new BindingIdxTracker();
        this.bindings = new ArrayList<Long>();
        int rpcServerIdx = 0;
        this.clntPtr = this.OpenClient(clusterName);
        LOG.info((Object)("MapClient created host = " + host + " port = " + port));
        try {
            int port1 = Rpc.initializeRpcServer((String)new String("KvCli"), (int)0, (int)0, (String)clusterName, null, null, (int)rpcServerIdx);
            if (port1 < 0) {
                throw new IOException("Exception in RPC initialize");
            }
            long tmpBinding = Rpc.createBindingOnServerFor((int)2130706433, (int)5660, (String)clusterName, (int)Security.ServerKeyType.ServerKey.getNumber(), (int)rpcServerIdx);
            Rpc.setAllowImpersonation((long)this.binding);
            this.bindings.add(tmpBinding);
            LOG.info((Object)("Successfully created KvStoreClient binding on RPC Server Idx: " + rpcServerIdx + " listen port: " + port1 + " binding: " + String.format("0x%08X", tmpBinding)));
        }
        catch (Exception e) {
            this.binding = 0L;
            LOG.error((Object)("Exception RpcInit: " + e));
            e.printStackTrace();
        }
    }

    public KvStoreClient(String clusterName, int rootCid, String fsHost, int fsPort, boolean doNotTimeout, Security.CredentialsMsg creds) throws IOException {
        this(clusterName, rootCid, fsHost, fsPort, doNotTimeout, creds, 1);
    }

    public KvStoreClient(String clusterName, int rootCid, String fsHost, int fsPort, boolean doNotTimeout, Security.CredentialsMsg creds, int numRpcThreads) throws IOException {
        ArrayList<Integer> kvPorts = new ArrayList<Integer>();
        kvPorts.add(fsPort);
        this.initializeKvClient(clusterName, rootCid, fsHost, kvPorts, doNotTimeout, creds, numRpcThreads);
    }

    public KvStoreClient(String clusterName, int rootCid, String fsHost, List<Integer> kvPorts, boolean doNotTimeout, Security.CredentialsMsg creds, int numRpcThreads) throws IOException {
        this.initializeKvClient(clusterName, rootCid, fsHost, kvPorts, doNotTimeout, creds, numRpcThreads);
    }

    private void initializeKvClient(String clusterName, int rootCid, String fsHost, List<Integer> kvPorts, boolean doNotTimeout, Security.CredentialsMsg creds, int numRpcThreads) throws IOException {
        LOG.info((Object)("Creating KvStoreClient communicating on RPC Server Idx: " + numRpcThreads + " with KvPorts: " + Arrays.toString(kvPorts.toArray())));
        this.numRpcThreads = numRpcThreads;
        this.bindingIdxTracker = new BindingIdxTracker();
        this.bindings = new ArrayList<Long>();
        this.clntPtr = this.OpenClientWithCid(clusterName, rootCid, fsHost, kvPorts.get(0));
        if (this.clntPtr == 0L) {
            throw new IOException("Could not initialize KvStoreClient");
        }
        this.rootCid = rootCid;
        this.creds = creds;
        try {
            for (int i = 0; i < numRpcThreads; ++i) {
                int port1 = Rpc.initializeRpcServer((String)new String("KvCli"), (int)0, (int)0, (String)clusterName, null, null, (int)i);
                if (port1 >= 0) continue;
                throw new IOException("Exception in RPC initialize");
            }
            InetAddress in = InetAddress.getByName(fsHost);
            byte[] ipBytes = in.getAddress();
            long ip = 0L;
            ip |= (long)(ipBytes[0] & 0xFF);
            ip <<= 8;
            ip |= (long)(ipBytes[1] & 0xFF);
            ip <<= 8;
            ip |= (long)(ipBytes[2] & 0xFF);
            ip <<= 8;
            ip |= (long)(ipBytes[3] & 0xFF);
            int rpcServerIdx = 0;
            for (int i = 0; i < kvPorts.size(); ++i) {
                int fsPort = kvPorts.get(i);
                rpcServerIdx = (rpcServerIdx + 1) % numRpcThreads;
                long tmpBinding = Rpc.createBindingOnServerFor((int)((int)ip), (int)fsPort, (String)clusterName, (int)Security.ServerKeyType.ServerKey.getNumber(), (int)rpcServerIdx);
                if (doNotTimeout) {
                    Rpc.doNotTimeout((long)tmpBinding);
                }
                Rpc.setAllowImpersonation((long)tmpBinding);
                this.bindings.add(tmpBinding);
                LOG.info((Object)("Successfully created KvStoreClient binding on rpcServerIdx: " + rpcServerIdx + " toPort: " + fsPort + " binding: " + String.format("0x%08X", tmpBinding)));
            }
            this.binding = this.bindings.get(0);
        }
        catch (Exception e) {
            LOG.error((Object)("Exception RpcInit: " + e));
            e.printStackTrace();
        }
    }

    public void setNoDelete(int cid, boolean setNoDelete) {
        this.setNoDelete(this.clntPtr, cid, setNoDelete);
    }

    public int probe() {
        Common.FidMsg fid = Common.FidMsg.newBuilder().setCid(this.rootCid).setCinum(this.DEFAULT_ROOT_DIR_CINUM).setUniq(this.DEFAULT_ROOT_DIR_UNIQ).build();
        Fileserver.GetattrRequest req = Fileserver.GetattrRequest.newBuilder().setNode(fid).setCreds(this.creds).build();
        byte[] reply = null;
        try {
            reply = Rpc.sendRequest((long)this.binding, (int)Common.MapRProgramId.FileServerProgramId.getNumber(), (int)Fileserver.FSProg.GetattrProc.getNumber(), (MessageLite)req);
            if (reply == null) {
                LOG.error((Object)"KvStore probe : RPC response null");
                return 10009;
            }
            Fileserver.GetattrResponse resp = Fileserver.GetattrResponse.parseFrom((byte[])reply);
            return resp.getStatus();
        }
        catch (Exception e) {
            LOG.error((Object)("KvStore probe : Exception " + e));
            return 10003;
        }
    }

    public void close() {
        this.CloseClient(this.clntPtr);
        this.clntPtr = 0L;
    }

    public int create(String name, int mode, int keytype) {
        int ret = this.create(this.clntPtr, name, mode, keytype);
        return ret;
    }

    public Common.FidMsg lookup(String name) {
        byte[] bytes = this.lookup(this.clntPtr, name);
        if (bytes == null) {
            return null;
        }
        try {
            Common.FidMsg fid = Common.FidMsg.parseFrom((byte[])bytes);
            return fid;
        }
        catch (Exception e) {
            LOG.error((Object)("Exception: During file " + name + " lookup" + e));
            e.printStackTrace();
            return null;
        }
    }

    public Common.FSKeyType gettype(Common.FidMsg fid) {
        int ret = this.gettype(this.clntPtr, fid.toByteArray());
        return Common.FSKeyType.valueOf((int)ret);
    }

    public int remove(String name) {
        int ret = this.remove(this.clntPtr, name);
        return ret;
    }

    public int rename(String oldname, String newname) {
        int ret = this.rename(this.clntPtr, oldname, newname);
        return ret;
    }

    private class BindingIdxTracker {
        int curDefaultBindingIdx = 0;
        int curScannerBindingIdx = 0;
        int curKvMultiOpBindingIdx = 0;

        synchronized long getBinding(BindingType btype) {
            int idx = 0;
            int maxCount = KvStoreClient.this.bindings.size();
            switch (btype) {
                case DefaultBinding: {
                    idx = this.curDefaultBindingIdx;
                    this.curDefaultBindingIdx = (this.curDefaultBindingIdx + 1) % maxCount;
                    break;
                }
                case ScannerBinding: {
                    idx = this.curScannerBindingIdx;
                    this.curScannerBindingIdx = (this.curScannerBindingIdx + 1) % maxCount;
                    break;
                }
                case KvMultiOpBinding: {
                    idx = this.curKvMultiOpBindingIdx;
                    this.curKvMultiOpBindingIdx = (this.curKvMultiOpBindingIdx + 1) % maxCount;
                    break;
                }
                case Max: {
                    idx = 0;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("For Binding type: " + (Object)((Object)btype) + " using binding at idx: " + idx + " binding: " + KvStoreClient.this.bindings.get(idx)));
            }
            return (Long)KvStoreClient.this.bindings.get(idx);
        }
    }

    public static enum BindingType {
        DefaultBinding,
        ScannerBinding,
        KvMultiOpBinding,
        Max;

    }
}

