/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.kvstore;

import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import com.mapr.fs.Rpc;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Fileserver;
import com.mapr.fs.proto.Security;
import com.mapr.kvstore.KvDatabaseOp;
import com.mapr.kvstore.KvStore;
import com.mapr.kvstore.KvStoreClient;
import com.mapr.kvstore.KvStoreException;
import com.mapr.kvstore.KvTable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Operation
implements KvDatabaseOp {
    private Fileserver.KvStoreMultiopRequest.Builder req;
    private Fileserver.SnapVolumeRequest.Builder snapVol;
    private int rwVolId_;
    private int snapId_;
    static int testUid = 97;
    static int testGid = 47;
    private Security.CredentialsMsg creds_;
    private long binding;
    private Fileserver.ContainerOpType opType;
    private boolean skipLogFlush = false;
    public static final Log LOG = LogFactory.getLog(Operation.class);

    @Deprecated
    public Operation(KvStoreClient clnt) {
        this.binding = clnt.binding;
        this.req = Fileserver.KvStoreMultiopRequest.newBuilder();
        this.creds_ = Security.CredentialsMsg.newBuilder().setUid(testUid).addGids(testGid).build();
        this.opType = Fileserver.ContainerOpType.InvalidOp;
    }

    public Operation(KvStoreClient clnt, Security.CredentialsMsg creds) {
        this.binding = clnt.binding;
        this.req = Fileserver.KvStoreMultiopRequest.newBuilder();
        this.creds_ = creds;
        this.opType = Fileserver.ContainerOpType.InvalidOp;
    }

    @Override
    public void setSkipLogFlush(boolean skipLogFlush) {
        this.skipLogFlush = skipLogFlush;
    }

    @Override
    public int insert(KvTable<Integer> kvTable, Integer key, MessageLite value, boolean verifyKey) {
        KvStore kvStore = (KvStore)kvTable;
        Fileserver.KvStoreKey kvStoreKey = Fileserver.KvStoreKey.newBuilder().setType(Common.FSKeyType.UintKey).setIntKey(key.intValue()).build();
        return this.addInsertOp(kvStore.getFid(), kvStoreKey, value.toByteString(), verifyKey);
    }

    public int insert(KvStore<Integer> kv, Integer keyValue, MessageLite value) {
        return this.insert(kv, keyValue, value, false);
    }

    @Override
    public int insert(KvTable<Long> kv, Long key, MessageLite value, boolean verifyKey) {
        KvStore kvStore = (KvStore)kv;
        Fileserver.KvStoreKey kvStoreKey = Fileserver.KvStoreKey.newBuilder().setType(Common.FSKeyType.LongKey).setLongKey(key.longValue()).build();
        return this.addInsertOp(kvStore.getFid(), kvStoreKey, value.toByteString(), verifyKey);
    }

    @Override
    public int insert(KvTable<String> kv, String key, MessageLite value) {
        KvStore kvStore = (KvStore)kv;
        Fileserver.KvStoreKey kvStoreKey = Fileserver.KvStoreKey.newBuilder().setType(Common.FSKeyType.VarKey).setVarKey(ByteString.copyFromUtf8((String)key)).build();
        return this.addInsertOp(kvStore.getFid(), kvStoreKey, value.toByteString());
    }

    @Override
    public int insert(KvTable<String> kv, String key, String value) {
        KvStore kvStore = (KvStore)kv;
        Fileserver.KvStoreKey kvStoreKey = Fileserver.KvStoreKey.newBuilder().setType(Common.FSKeyType.VarKey).setVarKey(ByteString.copyFromUtf8((String)key)).build();
        return this.addInsertOp(kvStore.getFid(), kvStoreKey, ByteString.copyFromUtf8((String)value));
    }

    @Override
    public int insert(KvTable<?> kv, Fileserver.KvStoreKey key, ByteString value) {
        KvStore kvStore = (KvStore)kv;
        return this.addInsertOp(kvStore.getFid(), key, value);
    }

    private int addInsertOp(Common.FidMsg fid, Fileserver.KvStoreKey key, ByteString value) {
        return this.addInsertOp(fid, key, value, false);
    }

    private int addInsertOp(Common.FidMsg fid, Fileserver.KvStoreKey key, ByteString value, boolean verifyKey) {
        Fileserver.KvSetMsg setMsg = Fileserver.KvSetMsg.newBuilder().setFid(fid).setKey(key).setValue(value).build();
        Fileserver.KvMutationMsg mutMsg = Fileserver.KvMutationMsg.newBuilder().setSetOp(true).setKvSetMsg(setMsg).setVerifyKey(verifyKey).build();
        this.req.addKvMutationMsg(mutMsg);
        return 0;
    }

    @Override
    public int delete(KvTable<Integer> kvTable, Integer keyValue) {
        KvStore kvStore = (KvStore)kvTable;
        Fileserver.KvStoreKey key = Fileserver.KvStoreKey.newBuilder().setType(Common.FSKeyType.UintKey).setIntKey(keyValue.intValue()).build();
        return this.addDeleteOp(kvStore.getFid(), key);
    }

    @Override
    public int delete(KvTable<Long> kvTable, Long keyValue) {
        KvStore kvStore = (KvStore)kvTable;
        Fileserver.KvStoreKey key = Fileserver.KvStoreKey.newBuilder().setType(Common.FSKeyType.LongKey).setLongKey(keyValue.longValue()).build();
        return this.addDeleteOp(kvStore.getFid(), key);
    }

    @Override
    public int delete(KvTable<String> kvTable, String keyValue) {
        KvStore kvStore = (KvStore)kvTable;
        Fileserver.KvStoreKey key = Fileserver.KvStoreKey.newBuilder().setType(Common.FSKeyType.VarKey).setVarKey(ByteString.copyFromUtf8((String)keyValue)).build();
        return this.delete(kvStore, key);
    }

    @Override
    public int delete(KvTable<?> kvTable, Fileserver.KvStoreKey key) {
        KvStore kvStore = (KvStore)kvTable;
        return this.addDeleteOp(kvStore.getFid(), key);
    }

    private int addDeleteOp(Common.FidMsg fid, Fileserver.KvStoreKey key) {
        Fileserver.KvDeleteMsg delMsg = Fileserver.KvDeleteMsg.newBuilder().setFid(fid).setKey(key).build();
        Fileserver.KvMutationMsg mutMsg = Fileserver.KvMutationMsg.newBuilder().setSetOp(false).setKvDeleteMsg(delMsg).build();
        this.req.addKvMutationMsg(mutMsg);
        return 0;
    }

    public static Fileserver.KvStoreKey getKey(byte[] keyBytes, int keyLength) {
        ByteString keyB = ByteString.copyFrom((byte[])keyBytes, (int)0, (int)keyLength);
        return Fileserver.KvStoreKey.newBuilder().setType(Common.FSKeyType.VarKey).setVarKey(keyB).build();
    }

    public int createContainer(int cid, int volId, List<Common.Server> servers, boolean isNameContainer, boolean isMirrorContainer, boolean isShuffleVolume, Common.ContainerReplType replType, Common.SetattrMsg rootDirAttr, Common.FSVolumeProperties fsVolProps, long cycleId) {
        if (this.opType != Fileserver.ContainerOpType.InvalidOp) {
            LOG.error((Object)("Create container not supported, already added op." + this.opType));
            return 22;
        }
        Fileserver.CreateContainerMsg.Builder createBuilder = Fileserver.CreateContainerMsg.newBuilder().setCid(cid).setVolId(volId).addAllServers(servers).setRootOfVolume(isNameContainer).setIsMirrorContainer(isMirrorContainer).setVolumeProperties(fsVolProps).setReplType(replType).setCycleId(cycleId).setIsShuffleVolume(isShuffleVolume);
        if (rootDirAttr != null) {
            createBuilder.setRootDirAttr(rootDirAttr);
        }
        Fileserver.CreateContainerMsg create = createBuilder.build();
        Fileserver.ContainerMutationMsg msg = Fileserver.ContainerMutationMsg.newBuilder().setOp(Fileserver.ContainerOpType.CreateOp).setCreateContainer(create).build();
        this.req.addContainerMsg(msg);
        this.opType = Fileserver.ContainerOpType.CreateOp;
        return 0;
    }

    public int bulkCreateContainer(int[] cidList, int volId, List<List<Common.Server>> servers, boolean isMirrorVolume, boolean isShuffleVolume, Common.ContainerReplType replType, Common.FSVolumeProperties fsVolProps, long[] cycleIdList) {
        if (this.opType != Fileserver.ContainerOpType.InvalidOp) {
            LOG.error((Object)("Bulk create container not supported, already added op." + this.opType));
            return 22;
        }
        if (cidList.length != servers.size()) {
            LOG.error((Object)"Bulk create container: number of cids and selected servers size does not match");
            return 22;
        }
        for (int i = 0; i < cidList.length; ++i) {
            Fileserver.CreateContainerMsg.Builder createBuilder = Fileserver.CreateContainerMsg.newBuilder().setCid(cidList[i]).setVolId(volId).addAllServers((Iterable)servers.get(i)).setRootOfVolume(false).setIsMirrorContainer(isMirrorVolume).setVolumeProperties(fsVolProps).setReplType(replType).setCycleId(cycleIdList[i]).setIsShuffleVolume(isShuffleVolume);
            Fileserver.ContainerMutationMsg msg = Fileserver.ContainerMutationMsg.newBuilder().setOp(Fileserver.ContainerOpType.CreateOp).setCreateContainer(createBuilder).build();
            this.req.addContainerMsg(msg);
        }
        this.req.setBulkContainerCreate(true);
        this.opType = Fileserver.ContainerOpType.CreateOp;
        return 0;
    }

    public int createStaleContainer(int cid, int volId, List<Common.Server> servers, boolean rootOfVolume, boolean isMirrorContainer, Common.ContainerReplType replType, Common.FSVolumeProperties fsVolprops, long cycleId) {
        if (this.opType != Fileserver.ContainerOpType.InvalidOp) {
            LOG.error((Object)("Create container not supported, already added op." + this.opType));
            return 22;
        }
        Fileserver.CreateContainerMsg create = Fileserver.CreateContainerMsg.newBuilder().setCid(cid).setVolId(volId).addAllServers(servers).setRootOfVolume(rootOfVolume).setIsStale(true).setIsMirrorContainer(isMirrorContainer).setReplType(replType).setVolumeProperties(fsVolprops).setCycleId(cycleId).build();
        Fileserver.ContainerMutationMsg msg = Fileserver.ContainerMutationMsg.newBuilder().setOp(Fileserver.ContainerOpType.CreateOp).setCreateContainer(create).build();
        this.req.addContainerMsg(msg);
        this.opType = Fileserver.ContainerOpType.CreateOp;
        return 0;
    }

    public int removeContainer(int cid, int serverIp) {
        if (this.opType != Fileserver.ContainerOpType.InvalidOp && this.opType != Fileserver.ContainerOpType.DeleteOp) {
            LOG.error((Object)("Delete container not supported, already added op." + this.opType));
            return 22;
        }
        Fileserver.DeleteContainerMsg del = Fileserver.DeleteContainerMsg.newBuilder().setCid(cid).setServerId(serverIp).build();
        Fileserver.ContainerMutationMsg msg = Fileserver.ContainerMutationMsg.newBuilder().setOp(Fileserver.ContainerOpType.DeleteOp).setDelContainer(del).build();
        this.req.addContainerMsg(msg);
        this.opType = Fileserver.ContainerOpType.DeleteOp;
        return 0;
    }

    public int createSnapshotRootContainer(int rwContainerId, int rwVolId, int snapContainerId, int snapId, Common.Server master, String snapName) {
        if (this.opType != Fileserver.ContainerOpType.InvalidOp) {
            LOG.error((Object)("Snapshot RootContainer not supported, already added op." + this.opType));
            return 22;
        }
        Fileserver.SnapContainerMsg msg = Fileserver.SnapContainerMsg.newBuilder().setRwcid(rwContainerId).setSnapcid(snapContainerId).setServer(master).build();
        this.snapVol = Fileserver.SnapVolumeRequest.newBuilder().setSnapName(snapName).setVolId(rwVolId).setSnapId(snapId).setVolRoot(msg);
        this.opType = Fileserver.ContainerOpType.SnapshotOp;
        this.rwVolId_ = rwVolId;
        this.snapId_ = snapId;
        return 0;
    }

    public int createSnapshotContainer(int rwContainerId, int rwVolId, int snapContainerId, int snapId, Common.Server master) {
        if (this.opType != Fileserver.ContainerOpType.SnapshotOp) {
            LOG.error((Object)("Snapshot container not supported, as Snapshot of root is not added. Optype added is " + this.opType));
            return 22;
        }
        if (this.rwVolId_ != rwVolId || this.snapId_ != snapId) {
            LOG.error((Object)"volid or snapid mismatched.");
            LOG.error((Object)("Stored volid " + this.rwVolId_ + " snapid " + this.snapId_));
            LOG.error((Object)("Passed volid " + rwVolId + " snapid " + snapId));
            return 22;
        }
        if (master == null) {
            LOG.error((Object)("Missing field: Master for container " + rwContainerId));
            return 22;
        }
        Fileserver.SnapContainerMsg msg = Fileserver.SnapContainerMsg.newBuilder().setRwcid(rwContainerId).setSnapcid(snapContainerId).setServer(master).build();
        this.snapVol.addVolOthers(msg);
        return 0;
    }

    public int deleteSnapshotVolume(int rwRootContainerId, int rwVolId, int snapRootContainerId, int snapId, Common.Server master, String snapName) {
        if (this.opType != Fileserver.ContainerOpType.InvalidOp) {
            LOG.error((Object)("Delete snapshot volume not supported, already added op." + this.opType));
            return 22;
        }
        Fileserver.SnapVolumeDeleteRequest snapReq = Fileserver.SnapVolumeDeleteRequest.newBuilder().setRwRootCid(rwRootContainerId).setVolId(rwVolId).setSnapRootCid(snapRootContainerId).setSnapId(snapId).setSnapName(snapName).build();
        Fileserver.SnapVolumeDeleteMsg snapMsg = Fileserver.SnapVolumeDeleteMsg.newBuilder().setMaster(master).setReq(snapReq).build();
        Fileserver.ContainerMutationMsg msg = Fileserver.ContainerMutationMsg.newBuilder().setOp(Fileserver.ContainerOpType.SnapshotDeleteOp).setSnapVolumeDelete(snapMsg).build();
        this.req.addContainerMsg(msg);
        this.opType = Fileserver.ContainerOpType.SnapshotDeleteOp;
        return 0;
    }

    @Override
    public int apply() {
        return this.apply(null);
    }

    public int apply(List<Fileserver.KvStoreMultiopResponse> multiResp) {
        byte[] reply = null;
        try {
            this.req.setCreds(this.creds_);
            if (this.opType == Fileserver.ContainerOpType.SnapshotOp) {
                Fileserver.ContainerMutationMsg msg = Fileserver.ContainerMutationMsg.newBuilder().setOp(Fileserver.ContainerOpType.SnapshotOp).setSnapVolume(this.snapVol).build();
                this.req.addContainerMsg(msg);
            }
            this.req.setSkipLogFlush(this.skipLogFlush);
            Fileserver.KvStoreMultiopRequest reqp = this.req.build();
            reply = Rpc.sendRequest((long)this.binding, (int)Common.MapRProgramId.FileServerProgramId.getNumber(), (int)Fileserver.FSProg.KvMultiopProc.getNumber(), (MessageLite)reqp);
            if (reply == null) {
                LOG.error((Object)("KvStore: Reply from server kvstoremultiop was null: Request: " + reqp));
                throw new KvStoreException("Reply from server kvstoremultiop null");
            }
            Fileserver.KvStoreMultiopResponse resp = Fileserver.KvStoreMultiopResponse.parseFrom((byte[])reply);
            if (resp.getStatus() == 116 || resp.getStatus() == 19 || resp.getStatus() == 28 || resp.getStatus() == 22 || resp.getStatus() == 13 || resp.getStatus() == 122) {
                throw new KvStoreException("Reply from server kvstoremultiop with status " + resp.getStatus());
            }
            if (resp.getStatus() != 0 && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Kvstoremultiop return status:" + resp.getStatus() + " for operation " + this.opType));
            }
            if (multiResp != null) {
                multiResp.add(resp);
            }
            return resp.getStatus();
        }
        catch (Exception e) {
            LOG.error((Object)("Exception during kvstore RPC op apply: " + e));
            if (reply != null) {
                LOG.error((Object)("Resp size: " + reply.length));
            }
            throw new KvStoreException("Exception during kvstore op apply: ", e);
        }
    }
}

