/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.kvstore;

import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import com.mapr.fs.Rpc;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Fileserver;
import com.mapr.fs.proto.Security;
import com.mapr.kvstore.KvStoreClient;
import com.mapr.kvstore.KvStoreException;
import com.mapr.kvstore.KvStoreStaleException;
import com.mapr.kvstore.KvTable;
import com.mapr.kvstore.Scanner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KvStore<T>
implements KvTable<T> {
    private long binding;
    private KvStoreClient kvClnt;
    private Common.FidMsg fid;
    private Security.CredentialsMsg creds_;
    private Common.FSKeyType type;
    private String tableName;
    private static final int testUid = 97;
    private static final int testGid = 47;
    private static final long MAX_LONG = Long.MAX_VALUE;
    private static final long MIN_LONG = 1L;
    private static final int MAX_INT = Integer.MAX_VALUE;
    private static final int MIN_INT = 1;
    private static final Log LOG = LogFactory.getLog(KvStore.class);

    public Common.FidMsg getFid() {
        return this.fid;
    }

    @Deprecated
    public KvStore(KvStoreClient clnt) {
        this.kvClnt = clnt;
        this.creds_ = Security.CredentialsMsg.newBuilder().setUid(97).addGids(47).build();
        this.binding = clnt.binding;
    }

    public KvStore(KvStoreClient clnt, Security.CredentialsMsg creds) {
        this.kvClnt = clnt;
        this.creds_ = creds;
        this.binding = clnt.binding;
    }

    @Override
    public int open(String name) {
        this.type = Common.FSKeyType.InvalidKey;
        if (!name.startsWith("/")) {
            this.fid = null;
            return 22;
        }
        this.fid = this.kvClnt.lookup(name);
        if (this.fid == null) {
            return 2;
        }
        this.type = this.kvClnt.gettype(this.fid);
        if (this.type == Common.FSKeyType.InvalidKey) {
            return 22;
        }
        this.tableName = KvStore.getTableName(name);
        return 0;
    }

    private static String getTableName(String absoluteName) {
        if (absoluteName == null) {
            return "unknown_tablename";
        }
        int lastIndex = absoluteName.lastIndexOf(47);
        if (lastIndex == -1 || lastIndex == absoluteName.length() - 1) {
            return "unknown_tablename";
        }
        return absoluteName.substring(lastIndex + 1);
    }

    @Override
    public void close() {
    }

    private Fileserver.KvStoreKey createKey(T keyValue) {
        Fileserver.KvStoreKey key = this.type == Common.FSKeyType.UintKey ? Fileserver.KvStoreKey.newBuilder().setType(this.type).setIntKey(((Integer)keyValue).intValue()).build() : (this.type == Common.FSKeyType.LongKey ? Fileserver.KvStoreKey.newBuilder().setType(this.type).setLongKey(((Long)keyValue).longValue()).build() : Fileserver.KvStoreKey.newBuilder().setType(Common.FSKeyType.VarKey).setVarKey(ByteString.copyFromUtf8((String)((String)keyValue))).build());
        return key;
    }

    public byte[] lookup(T keyValue) {
        Fileserver.KvStoreKey key = this.createKey(keyValue);
        return this.lookup(key, false);
    }

    @Override
    public byte[] lookup(T keyValue, boolean allowStaleRead) {
        Fileserver.KvStoreKey key = this.createKey(keyValue);
        return this.lookup(key, allowStaleRead);
    }

    @Override
    private byte[] lookup(Fileserver.KvStoreKey key, boolean allowStaleRead) {
        Fileserver.KvstoreLookupRequest req = Fileserver.KvstoreLookupRequest.newBuilder().setFid(this.fid).setKey(key).setCreds(this.creds_).setAllowStaleRead(allowStaleRead).build();
        byte[] reply = null;
        try {
            reply = Rpc.sendRequest((long)this.binding, (int)Common.MapRProgramId.FileServerProgramId.getNumber(), (int)Fileserver.FSProg.KvstoreLookupProc.getNumber(), (MessageLite)req);
            if (reply == null) {
                LOG.error((Object)("Reply for lookup on Fid: " + this.fid.getCinum() + ":" + this.fid.getUniq() + " Key: " + this.parseToString(key) + " is null."));
                throw new KvStoreException("Reply from server kvstorelookup null");
            }
            Fileserver.KvstoreLookupResponse resp = Fileserver.KvstoreLookupResponse.parseFrom((byte[])reply);
            if (resp.getStatus() == 116 || resp.getStatus() == 19) {
                throw new KvStoreStaleException("Reply from server kvstorelookup with status " + resp.getStatus());
            }
            if (resp.getStatus() == 122) {
                throw new KvStoreException("Reply from server kvstorelookup with status " + resp.getStatus());
            }
            if (resp.getStatus() == 0) {
                byte[] retValue = resp.getValue().toByteArray();
                return retValue;
            }
        }
        catch (KvStoreException e) {
            throw e;
        }
        catch (Exception e) {
            if (reply != null) {
                LOG.error((Object)("KvStoreLookup resp size : " + reply.length));
            }
            throw new KvStoreException("Exception during kvstore lookup: ", e);
        }
        return null;
    }

    @Override
    public Fileserver.KvMsg getLeftNearValue(T key) {
        Fileserver.KvstoreLookupNearResponse resp = this.lookupNear(key);
        if (resp == null) {
            return null;
        }
        if (resp.getLeftEod() || !resp.hasLeftEod() || !resp.hasLeftKV()) {
            return null;
        }
        return resp.getLeftKV();
    }

    @Override
    public Fileserver.KvMsg getRightNearValue(T key) {
        Fileserver.KvstoreLookupNearResponse resp = this.lookupNear(key);
        if (resp == null) {
            return null;
        }
        if (resp.getRightEod() || !resp.hasRightEod() || !resp.hasRightKV()) {
            return null;
        }
        return resp.getRightKV();
    }

    @Override
    public Fileserver.KvstoreLookupNearResponse lookupNear(T key) throws KvStoreException {
        Fileserver.KvStoreKey kvStoreKey = this.createKey(key);
        Fileserver.KvstoreLookupNearRequest req = Fileserver.KvstoreLookupNearRequest.newBuilder().setFid(this.fid).setKey(kvStoreKey).setCreds(this.creds_).build();
        byte[] reply = null;
        try {
            reply = Rpc.sendRequest((long)this.binding, (int)Common.MapRProgramId.FileServerProgramId.getNumber(), (int)Fileserver.FSProg.KvstoreLookupNearProc.getNumber(), (MessageLite)req);
            if (reply == null) {
                LOG.error((Object)("[Null Kvstore LookupNear Response]  Key: " + this.parseToString(kvStoreKey) + " Fid: " + this.fid.getCinum() + ":" + this.fid.getUniq()));
                throw new KvStoreException("Null Kvstore LookupNear Response");
            }
            Fileserver.KvstoreLookupNearResponse resp = Fileserver.KvstoreLookupNearResponse.parseFrom((byte[])reply);
            if (resp.getStatus() == 116 || resp.getStatus() == 19) {
                throw new KvStoreStaleException("KvstoreLookupNearResponse Status: " + resp.getStatus());
            }
            if (resp.getStatus() == 122) {
                throw new KvStoreException("KvstoreLookupNearResponse Status: " + resp.getStatus());
            }
            if (resp.getStatus() == 0) {
                return resp;
            }
            return null;
        }
        catch (KvStoreException e) {
            throw e;
        }
        catch (Exception e) {
            if (reply != null) {
                LOG.error((Object)("KvStoreLookupNearResponse size : " + reply.length));
            }
            throw new KvStoreException("Exception in KvStore LookupNear: ", e);
        }
    }

    @Override
    public Fileserver.KvStoreKey getMinKey() {
        Fileserver.KvstoreGetKeyRequest req = Fileserver.KvstoreGetKeyRequest.newBuilder().setFid(this.fid).setOp(Fileserver.KvstoreGetKeyRequest.GetKeyOp.GetSmallestKey).setCreds(this.creds_).build();
        try {
            byte[] reply = Rpc.sendRequest((long)this.binding, (int)Common.MapRProgramId.FileServerProgramId.getNumber(), (int)Fileserver.FSProg.KvstoreGetKeyProc.getNumber(), (MessageLite)req);
            if (reply == null) {
                LOG.error((Object)("Reply for getminkey for Fid: " + this.fid.getCinum() + ":" + this.fid.getUniq() + " is null."));
                throw new KvStoreException("Reply from server kvstoregetkey null");
            }
            Fileserver.KvstoreGetKeyResponse resp = Fileserver.KvstoreGetKeyResponse.parseFrom((byte[])reply);
            if (resp.getStatus() == 116 || resp.getStatus() == 19 || resp.getStatus() == 122) {
                throw new KvStoreException("Reply from server kvstoregetkey with status " + resp.getStatus());
            }
            if (resp.getStatus() == 0) {
                return resp.getKey();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception during kvstore getminkey: ", (Throwable)e);
            throw new KvStoreException("Exception during kvstore getminkey: ", e);
        }
        return null;
    }

    @Override
    public Fileserver.KvStoreKey getMaxKey() {
        Fileserver.KvstoreGetKeyRequest req = Fileserver.KvstoreGetKeyRequest.newBuilder().setFid(this.fid).setOp(Fileserver.KvstoreGetKeyRequest.GetKeyOp.GetLargestKey).setCreds(this.creds_).build();
        try {
            byte[] reply = Rpc.sendRequest((long)this.binding, (int)Common.MapRProgramId.FileServerProgramId.getNumber(), (int)Fileserver.FSProg.KvstoreGetKeyProc.getNumber(), (MessageLite)req);
            if (reply == null) {
                LOG.error((Object)("Reply for getmaxkey for Fid: " + this.fid.getCinum() + ":" + this.fid.getUniq() + " is null."));
                throw new KvStoreException("Reply from server kvstoregetkey null");
            }
            Fileserver.KvstoreGetKeyResponse resp = Fileserver.KvstoreGetKeyResponse.parseFrom((byte[])reply);
            if (resp.getStatus() == 116 || resp.getStatus() == 19 || resp.getStatus() == 122) {
                throw new KvStoreException("Reply from server kvstoregetkey with status " + resp.getStatus());
            }
            if (resp.getStatus() == 0) {
                return resp.getKey();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception during kvstore getmaxkey: ", (Throwable)e);
            throw new KvStoreException("Exception during kvstore getmaxkey: ", e);
        }
        return null;
    }

    @Override
    public int getKeyCnt() {
        Fileserver.KvstoreGetKeyRequest req = Fileserver.KvstoreGetKeyRequest.newBuilder().setFid(this.fid).setOp(Fileserver.KvstoreGetKeyRequest.GetKeyOp.GetKeyCnt).setCreds(this.creds_).build();
        try {
            byte[] reply = Rpc.sendRequest((long)this.binding, (int)Common.MapRProgramId.FileServerProgramId.getNumber(), (int)Fileserver.FSProg.KvstoreGetKeyProc.getNumber(), (MessageLite)req);
            if (reply == null) {
                LOG.error((Object)("Reply for getkeycnt for Fid: " + this.fid.getCinum() + ":" + this.fid.getUniq() + " is null."));
                throw new KvStoreException("Reply from server kvstoregetkey null");
            }
            Fileserver.KvstoreGetKeyResponse resp = Fileserver.KvstoreGetKeyResponse.parseFrom((byte[])reply);
            if (resp.getStatus() == 116 || resp.getStatus() == 19 || resp.getStatus() == 122) {
                throw new KvStoreException("Reply from server kvstoregetkey with status " + resp.getStatus());
            }
            if (resp.getStatus() == 0) {
                return resp.getKeycnt();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception during kvstore getkeycnt: ", (Throwable)e);
            throw new KvStoreException("Unable to obtain key count for table " + this.tableName, e);
        }
        return 0;
    }

    @Override
    public boolean exists(T keyValue) {
        boolean retValue = false;
        Fileserver.KvStoreKey key = this.createKey(keyValue);
        Fileserver.KvstoreLookupRequest req = Fileserver.KvstoreLookupRequest.newBuilder().setFid(this.fid).setKey(key).setCreds(this.creds_).build();
        try {
            byte[] reply = Rpc.sendRequest((long)this.binding, (int)Common.MapRProgramId.FileServerProgramId.getNumber(), (int)Fileserver.FSProg.KvstoreLookupProc.getNumber(), (MessageLite)req);
            if (reply == null) {
                LOG.error((Object)("Reply for exists for " + keyValue + " for Fid: " + this.fid.getCinum() + ":" + this.fid.getUniq() + " is null."));
                throw new KvStoreException("Reply from server kvstoreexists null");
            }
            Fileserver.KvstoreLookupResponse resp = Fileserver.KvstoreLookupResponse.parseFrom((byte[])reply);
            if (resp.getStatus() == 116 || resp.getStatus() == 19 || resp.getStatus() == 122) {
                throw new KvStoreException("Reply from server for exists with status " + resp.getStatus());
            }
            if (resp.getStatus() == 0) {
                retValue = true;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception during kvstore exists key: ", (Throwable)e);
            throw new KvStoreException("Exception during kvstore exists key: ", e);
        }
        return retValue;
    }

    @Override
    public T getKeyFromKvStoreKey(Fileserver.KvStoreKey key) {
        try {
            switch (this.type) {
                case UintKey: {
                    return Integer.class.cast(key.getIntKey());
                }
                case LongKey: {
                    return Long.class.cast(key.getLongKey());
                }
                case VarKey: {
                    return ByteString.class.cast(key.getVarKey());
                }
            }
            return null;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    private String parseToString(Fileserver.KvStoreKey key) {
        if (this.type == Common.FSKeyType.UintKey) {
            return Integer.toString(key.getIntKey());
        }
        if (this.type == Common.FSKeyType.LongKey) {
            return Long.toString(key.getLongKey());
        }
        if (this.type == Common.FSKeyType.VarKey) {
            return key.getVarKey().toStringUtf8();
        }
        return null;
    }

    public Fileserver.KvStoreKey parseKvStoreKey(String keyString) {
        Fileserver.KvStoreKey key;
        if (this.type == Common.FSKeyType.UintKey) {
            key = Fileserver.KvStoreKey.newBuilder().setType(Common.FSKeyType.UintKey).setIntKey(Integer.parseInt(keyString)).build();
        } else if (this.type == Common.FSKeyType.LongKey) {
            key = Fileserver.KvStoreKey.newBuilder().setType(Common.FSKeyType.LongKey).setLongKey(Long.parseLong(keyString)).build();
        } else if (this.type == Common.FSKeyType.VarKey) {
            key = Fileserver.KvStoreKey.newBuilder().setType(Common.FSKeyType.VarKey).setVarKey(ByteString.copyFromUtf8((String)keyString)).build();
        } else {
            return null;
        }
        return key;
    }

    public Scanner getScanner(Fileserver.KvStoreKey startKey, Fileserver.KvStoreKey endKey, boolean keysOnly) {
        Scanner scanner = this.type == Common.FSKeyType.UintKey ? new Scanner(this.kvClnt, this.fid, startKey.getIntKey(), endKey.getIntKey(), keysOnly, this.creds_) : (this.type == Common.FSKeyType.LongKey ? new Scanner(this.kvClnt, this.fid, startKey.getLongKey(), endKey.getLongKey(), keysOnly, this.creds_) : new Scanner(this.kvClnt, this.fid, startKey.getVarKey(), endKey.getVarKey(), keysOnly, this.creds_));
        return scanner;
    }

    @Override
    public Scanner getScanner(T startKey, T endKey, boolean keysOnly) {
        Scanner scanner;
        if (this.type == Common.FSKeyType.UintKey) {
            scanner = new Scanner(this.kvClnt, this.fid, (Integer)startKey, (Integer)endKey, keysOnly, this.creds_);
        } else if (this.type == Common.FSKeyType.LongKey) {
            scanner = new Scanner(this.kvClnt, this.fid, (Long)startKey, (Long)endKey, keysOnly, this.creds_);
        } else {
            ByteString stKey = ByteString.copyFromUtf8((String)((String)startKey));
            ByteString enKey = ByteString.copyFromUtf8((String)((String)endKey));
            scanner = new Scanner(this.kvClnt, this.fid, stKey, enKey, keysOnly, this.creds_);
        }
        return scanner;
    }

    @Override
    public Scanner getScanner(T startKey, boolean keysOnly) {
        Scanner scanner = null;
        if (this.type == Common.FSKeyType.UintKey) {
            scanner = new Scanner(this.kvClnt, this.fid, (Integer)startKey, Integer.MAX_VALUE, keysOnly, this.creds_);
        } else if (this.type == Common.FSKeyType.LongKey) {
            scanner = new Scanner(this.kvClnt, this.fid, (Long)startKey, Long.MAX_VALUE, keysOnly, this.creds_);
        } else {
            LOG.error((Object)("getScanner without endKey should not be called for varKey for fid:" + this.fid.getCinum() + ":" + this.fid.getUniq()));
            throw new KvStoreException("Scanner for varkey null");
        }
        return scanner;
    }

    @Override
    public Scanner getScanner(boolean keysOnly) {
        Scanner scanner = null;
        if (this.type == Common.FSKeyType.UintKey) {
            scanner = new Scanner(this.kvClnt, this.fid, 1, Integer.MAX_VALUE, keysOnly, this.creds_);
        } else if (this.type == Common.FSKeyType.LongKey) {
            scanner = new Scanner(this.kvClnt, this.fid, 1L, Long.MAX_VALUE, keysOnly, this.creds_);
        } else {
            ByteString stKey = ByteString.copyFromUtf8((String)"");
            ByteString enKey = ByteString.copyFromUtf8((String)"ZZZ");
            scanner = new Scanner(this.kvClnt, this.fid, stKey, enKey, keysOnly, this.creds_);
        }
        return scanner;
    }

    public void printKey(Fileserver.KvStoreKey key) {
        if (this.type == Common.FSKeyType.UintKey) {
            System.out.println(key.getIntKey());
        } else if (this.type == Common.FSKeyType.LongKey) {
            System.out.println(key.getLongKey());
        } else if (this.type == Common.FSKeyType.VarKey) {
            System.out.println(key.getVarKey().toStringUtf8());
        }
    }

    public static Common.FSKeyType gettype(KvStoreClient clnt, String name) {
        Common.FidMsg tempFid = clnt.lookup(name);
        if (tempFid == null) {
            return Common.FSKeyType.InvalidKey;
        }
        return clnt.gettype(tempFid);
    }

    @Override
    public void setType(int type) {
    }
}

