/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.kvstore;

import com.google.protobuf.MessageLite;
import com.mapr.fs.Rpc;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Fileserver;
import com.mapr.fs.proto.Security;
import com.mapr.kvstore.Operation;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KvStoreClient {
    private long clntPtr;
    public long binding;
    private int rootCid;
    private Security.CredentialsMsg creds;
    private int DEFAULT_ROOT_DIR_CINUM = 16;
    private int DEFAULT_ROOT_DIR_UNIQ = 2;
    public static final Log LOG = LogFactory.getLog(Operation.class);

    private final native long OpenClient(String var1);

    private final native long OpenClientWithCid(String var1, int var2, String var3, int var4);

    private final native void CloseClient(long var1);

    private final native int create(long var1, String var3, int var4, int var5);

    private final native void setNoDelete(long var1, int var3, boolean var4);

    private final native byte[] lookup(long var1, String var3);

    private final native int gettype(long var1, byte[] var3);

    private final native int remove(long var1, String var3);

    @Deprecated
    public KvStoreClient(String scheme, String clusterName, String host, int port) {
        this.clntPtr = this.OpenClient(clusterName);
        LOG.info((Object)("MapClient created host = " + host + " port = " + port));
        try {
            int port1 = Rpc.initialize((int)0, (int)0, (String)clusterName);
            if (port1 < 0) {
                throw new IOException("Exception in RPC initialize");
            }
            this.binding = Rpc.createBindingFor((int)2130706433, (int)5660, (String)clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
            Rpc.setAllowImpersonation((long)this.binding);
        }
        catch (Exception e) {
            this.binding = 0L;
            LOG.error((Object)("Exception RpcInit: " + e));
            e.printStackTrace();
        }
    }

    public KvStoreClient(String clusterName, int rootCid, String fsHost, int fsPort, boolean doNotTimeout, Security.CredentialsMsg creds) throws IOException {
        this.clntPtr = this.OpenClientWithCid(clusterName, rootCid, fsHost, fsPort);
        if (this.clntPtr == 0L) {
            throw new IOException("Could not initialize KvStoreClient");
        }
        this.rootCid = rootCid;
        this.creds = creds;
        try {
            int port1 = Rpc.initialize((int)0, (int)0, (String)clusterName);
            if (port1 < 0) {
                throw new IOException("Exception in RPC initialize");
            }
            InetAddress in = InetAddress.getByName(fsHost);
            byte[] ipBytes = in.getAddress();
            long ip = 0L;
            ip |= (long)(ipBytes[0] & 0xFF);
            ip <<= 8;
            ip |= (long)(ipBytes[1] & 0xFF);
            ip <<= 8;
            ip |= (long)(ipBytes[2] & 0xFF);
            ip <<= 8;
            this.binding = Rpc.createBindingFor((int)((int)(ip |= (long)(ipBytes[3] & 0xFF))), (int)fsPort, (String)clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
            if (doNotTimeout) {
                Rpc.doNotTimeout((long)this.binding);
            }
            Rpc.setAllowImpersonation((long)this.binding);
        }
        catch (Exception e) {
            this.binding = 0L;
            LOG.error((Object)("Exception RpcInit: " + e));
            e.printStackTrace();
        }
    }

    public void setNoDelete(int cid, boolean setNoDelete) {
        this.setNoDelete(this.clntPtr, cid, setNoDelete);
    }

    public int probe() {
        Common.FidMsg fid = Common.FidMsg.newBuilder().setCid(this.rootCid).setCinum(this.DEFAULT_ROOT_DIR_CINUM).setUniq(this.DEFAULT_ROOT_DIR_UNIQ).build();
        Fileserver.GetattrRequest req = Fileserver.GetattrRequest.newBuilder().setNode(fid).setCreds(this.creds).build();
        byte[] reply = null;
        try {
            reply = Rpc.sendRequest((long)this.binding, (int)Common.MapRProgramId.FileServerProgramId.getNumber(), (int)Fileserver.FSProg.GetattrProc.getNumber(), (MessageLite)req);
            if (reply == null) {
                LOG.error((Object)"KvStore probe : RPC response null");
                return 10009;
            }
            Fileserver.GetattrResponse resp = Fileserver.GetattrResponse.parseFrom((byte[])reply);
            return resp.getStatus();
        }
        catch (Exception e) {
            LOG.error((Object)("KvStore probe : Exception " + e));
            return 10003;
        }
    }

    public void close() {
        this.CloseClient(this.clntPtr);
        this.clntPtr = 0L;
    }

    public int create(String name, int mode, int keytype) {
        int ret = this.create(this.clntPtr, name, mode, keytype);
        return ret;
    }

    public Common.FidMsg lookup(String name) {
        byte[] bytes = this.lookup(this.clntPtr, name);
        if (bytes == null) {
            return null;
        }
        try {
            Common.FidMsg fid = Common.FidMsg.parseFrom((byte[])bytes);
            return fid;
        }
        catch (Exception e) {
            LOG.error((Object)("Exception: During file " + name + " lookup" + e));
            e.printStackTrace();
            return null;
        }
    }

    public Common.FSKeyType gettype(Common.FidMsg fid) {
        int ret = this.gettype(this.clntPtr, fid.toByteArray());
        return Common.FSKeyType.valueOf((int)ret);
    }

    public int remove(String name) {
        int ret = this.remove(this.clntPtr, name);
        return ret;
    }
}

