/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.gateway;

import com.mapr.fs.gateway.conf.GatewayConfiguration;
import com.mapr.fs.gateway.conf.GatewayConfigurationHolder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GatewayAlarm {
    public static final Log LOG = LogFactory.getLog(GatewayAlarm.class);
    static GatewayConfiguration conf = GatewayConfigurationHolder.getInstance();

    public static void setAlarm(String alarm, String desc) throws IOException {
        try {
            String descAndHostName = desc + " on node " + conf.getHostName();
            ProcessBuilder pb = new ProcessBuilder("maprcli", "alarm", "raise", "-alarm", alarm, "-description", descAndHostName);
            Process p = pb.start();
            p.waitFor();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public static void clearAlarm(String alarm, String desc) throws IOException {
        try {
            ProcessBuilder pb = new ProcessBuilder("maprcli", "alarm", "list", "-alarm", alarm);
            Process p = pb.start();
            p.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = "";
            while ((line = reader.readLine()) != null) {
                if (!line.contains(desc)) continue;
                GatewayAlarm.clearAlarm(alarm);
                break;
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static void clearAlarm(String alarm) throws IOException {
        try {
            ProcessBuilder pb = new ProcessBuilder("maprcli", "alarm", "clear", "-alarm", alarm);
            Process p = pb.start();
            p.waitFor();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }
}

