/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.gateway.external.tools;

import com.mapr.fs.gateway.external.GatewaySink;
import com.mapr.fs.gateway.external.tools.ExternalOutputFormat;
import com.mapr.fs.gateway.external.tools.ExternalTableMapper;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.yaml.snakeyaml.Yaml;

public class CopyTableExt
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(CopyTableExt.class);
    private static final String EXT_ELASTICSEARCH = ".es";
    static final String NAME = "CopyTableExt";
    String srcPath;
    String dstPath;
    Configuration conf;
    HTable srcTable;
    boolean failed = false;
    int numThreads = 16;
    boolean isMapReduce = true;
    String columnSpec;
    int maxVersions = Integer.MAX_VALUE;
    long startTime = 0L;
    long endTime = Long.MAX_VALUE;
    static boolean isSuccess = false;

    protected void setScanColumns(Scan scan) {
        if (this.columnSpec != null) {
            String[] cols;
            for (String col : cols = this.columnSpec.split(",")) {
                if (col.contains(":")) {
                    String[] names = col.split(":");
                    scan.addColumn(Bytes.toBytes((String)names[0]), Bytes.toBytes((String)names[1]));
                    continue;
                }
                scan.addFamily(Bytes.toBytes((String)col));
            }
        }
    }

    private static List<ImmutableBytesWritable> getRegionStartKeys(HTable table) throws IOException {
        byte[][] byteKeys = table.getStartKeys();
        ArrayList<ImmutableBytesWritable> ret = new ArrayList<ImmutableBytesWritable>(byteKeys.length);
        for (byte[] byteKey : byteKeys) {
            ret.add(new ImmutableBytesWritable(byteKey));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePartitions(Configuration conf, Path partitionsPath, List<ImmutableBytesWritable> startKeys) throws IOException {
        if (startKeys.isEmpty()) {
            throw new IllegalArgumentException("No regions passed");
        }
        TreeSet<ImmutableBytesWritable> sorted = new TreeSet<ImmutableBytesWritable>(startKeys);
        ImmutableBytesWritable first = sorted.first();
        if (!first.equals((Object)HConstants.EMPTY_BYTE_ARRAY)) {
            throw new IllegalArgumentException("First region of table should have empty start key. Instead has: " + Bytes.toStringBinary((byte[])first.get()));
        }
        sorted.remove(first);
        FileSystem fs = partitionsPath.getFileSystem(conf);
        try (SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)partitionsPath, ImmutableBytesWritable.class, NullWritable.class);){
            for (ImmutableBytesWritable startKey : sorted) {
                writer.append((Writable)startKey, (Writable)NullWritable.get());
            }
        }
    }

    private void Usage() {
        System.err.println("Usage: CopyTableExt -src srcPath -dst dstPath [-columns <cf1[:col1],...>][-maxversions <max number of versions to copy>] [-starttime <time>] [-endtime <time>] [-mapreduce <true|false> (default: true)] [-numthreads numThreads (default:" + this.numThreads + ")]");
        System.exit(1);
    }

    private void ParseArgs(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-src")) {
                this.srcPath = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-dst")) {
                this.dstPath = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-numthreads")) {
                this.numThreads = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-columns")) {
                this.columnSpec = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-maxversions")) {
                this.maxVersions = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-starttime")) {
                String startTimeStr;
                this.startTime = (startTimeStr = args[++i]).equals("-INF") ? 0L : Long.parseLong(startTimeStr);
                continue;
            }
            if (args[i].equalsIgnoreCase("-endtime")) {
                String endTimeStr;
                this.endTime = (endTimeStr = args[++i]).equals("INF") ? Long.MAX_VALUE : Long.parseLong(endTimeStr);
                continue;
            }
            if (args[i].equalsIgnoreCase("-mapreduce")) {
                this.isMapReduce = Boolean.valueOf(args[++i]);
                continue;
            }
            System.err.println("Unrecognized argument: " + args[i]);
            this.Usage();
        }
        if (this.srcPath == null || this.dstPath == null) {
            this.Usage();
        }
    }

    public int run(String[] args) throws Exception {
        this.ParseArgs(args);
        if (!this.dstPath.endsWith(EXT_ELASTICSEARCH)) {
            throw new IllegalArgumentException("Destination " + this.dstPath + " is not a supported external destination");
        }
        if (this.isMapReduce) {
            return this.run_MR();
        }
        return this.run_NoMR();
    }

    public int run_MR() throws Exception {
        int ret;
        Job job = new Job(this.getConf(), "CopyTableExt_" + this.dstPath);
        Configuration conf = job.getConfiguration();
        job.setJarByClass(CopyTableExt.class);
        Scan scan = new Scan();
        scan.setMaxVersions();
        this.setScanColumns(scan);
        scan.setMaxVersions(this.maxVersions);
        scan.setTimeRange(this.startTime, this.endTime);
        TableMapReduceUtil.initTableMapperJob((String)this.srcPath, (Scan)scan, ExternalTableMapper.class, ImmutableBytesWritable.class, Result.class, (Job)job);
        LOG.info((Object)("Looking up current regions for table " + this.srcPath));
        HTable srcTable = new HTable(conf, this.srcPath);
        List<ImmutableBytesWritable> startKeys = CopyTableExt.getRegionStartKeys(srcTable);
        String uuid = UUID.randomUUID().toString();
        job.setNumReduceTasks(0);
        TableMapReduceUtil.addDependencyJars((Configuration)conf, (Class[])new Class[]{Yaml.class, GatewaySink.class});
        Path outputPath = new Path(conf.get("hadoop.tmp.dir"), "output_" + uuid);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        job.setOutputKeyClass(ImmutableBytesWritable.class);
        job.setOutputValueClass(Result.class);
        job.setOutputFormatClass(ExternalOutputFormat.class);
        ExternalOutputFormat.setDestinationTable(job, this.dstPath);
        ExternalOutputFormat.setIsCompare(job, false);
        job.submit();
        System.out.println("job_id: " + job.getJobID().toString());
        int n = ret = job.waitForCompletion(true) ? 0 : 1;
        if (ret == 0) {
            FileSystem fs = outputPath.getFileSystem(conf);
            fs.delete(outputPath);
        }
        return ret;
    }

    public int run_NoMR() throws Exception {
        this.conf = this.getConf();
        this.conf.set("fs.default.name", "maprfs:///");
        this.conf.set("fs.maprfs.impl", "com.mapr.fs.MapRFileSystem");
        this.conf.set("mapr.htable.impl", "com.mapr.fs.MapRHTable");
        this.srcTable = new HTable(this.conf, this.srcPath.getBytes());
        byte[][] startKeys = this.srcTable.getStartKeys();
        byte[][] endKeys = this.srcTable.getEndKeys();
        int numSplits = startKeys.length;
        long ts = System.currentTimeMillis();
        ExecutorService executor = Executors.newFixedThreadPool(this.numThreads);
        for (int i = 0; i < numSplits; ++i) {
            executor.execute(new ExternalLoaderThread(i, startKeys[i], endKeys[i]));
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        if (this.failed) {
            return 1;
        }
        long te = System.currentTimeMillis();
        System.out.println("Test completed in " + (te - ts) + " ms");
        return 0;
    }

    public static boolean copy(final String[] args, String user, boolean isMapReduce) throws Exception {
        String usingMapReduce = isMapReduce ? "using map-reduce" : "not using map-reduce";
        UserGroupInformation ugi = CopyTableExt.createUser(user);
        LOG.info((Object)("Running copytable job " + usingMapReduce + " as user: " + user));
        if (!isMapReduce) {
            System.out.println("No map-reduce");
        }
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try {
                    int status = ToolRunner.run((Configuration)new Configuration(), (Tool)new CopyTableExt(), (String[])args);
                    if (status == 0) {
                        CopyTableExt.setJobSuccessful();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)("Exception while running copytable job: " + e));
                    throw new Exception(e.getMessage());
                }
                return null;
            }
        });
        return isSuccess;
    }

    public static void setJobSuccessful() {
        isSuccess = true;
    }

    public static void main(String[] args) throws Exception {
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)new Configuration(), (Tool)new CopyTableExt(), (String[])args);
        }
        catch (Exception e) {
            ret = 1;
            e.printStackTrace();
        }
        System.exit(ret);
    }

    private static UserGroupInformation createUser(String user) throws IOException {
        return UserGroupInformation.createRemoteUser((String)user);
    }

    class ExternalLoaderThread
    extends BaseLoaderThread {
        ExternalLoaderThread(int id, byte[] s, byte[] e) {
            super(id, s, e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            GatewaySink sink = null;
            try (ResultScanner scanner = null;){
                sink = new GatewaySink();
                if (sink.OpenStream(CopyTableExt.this.dstPath) != 0) {
                    throw new IOException("Failed to open GatewaySink");
                }
                Scan scan = new Scan(this.startKey, this.endKey);
                CopyTableExt.this.setScanColumns(scan);
                scan.setMaxVersions(CopyTableExt.this.maxVersions);
                scan.setTimeRange(CopyTableExt.this.startTime, CopyTableExt.this.endTime);
                scanner = CopyTableExt.this.srcTable.getScanner(scan);
                Result[] results = scanner.next(1);
                while (results != null && results.length > 0) {
                    if (sink.AppendStream(results[0]) != 0) {
                        throw new IOException("Failed to append to GatewaySink stream");
                    }
                    results = scanner.next(1);
                }
                if (sink.CloseStream() != 0) {
                    throw new IOException("Failed to close GatewaySink");
                }
            }
        }
    }

    abstract class BaseLoaderThread
    implements Runnable {
        protected byte[] startKey;
        protected byte[] endKey;
        protected int myid;

        protected BaseLoaderThread(int id, byte[] s, byte[] e) {
            this.myid = id;
            this.startKey = s;
            this.endKey = e;
        }
    }
}

