/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.gateway.external;

import com.mapr.fs.gateway.external.ConfigInfo;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class GatewayClassLoader {
    public static final Log LOG = LogFactory.getLog(GatewayClassLoader.class);
    public Map<String, ConfigInfo> configFileCache;
    public Configuration conf;
    public FileSystem fs;
    ClassLoader parentClassLoader;
    public String localJar = null;
    private String localJarDir = "/tmp/mapr-gateway";

    public GatewayClassLoader(ClassLoader pCL) {
        try {
            this.conf = new Configuration();
            this.fs = FileSystem.get((Configuration)this.conf);
            this.configFileCache = new HashMap<String, ConfigInfo>();
            this.parentClassLoader = pCL;
        }
        catch (Exception e) {
            LOG.error((Object)"Error loading the gatewayClassLoader Class", (Throwable)e);
        }
    }

    public void setLocalPath(String path) {
        this.localJar = path;
    }

    void createLocalJarDirectory() throws Exception {
        File dir = new File(this.localJarDir);
        if (dir.exists() && dir.isFile()) {
            dir.delete();
        }
        if (!dir.exists()) {
            dir.mkdirs();
            dir.setExecutable(true, false);
            dir.setReadable(true, false);
            dir.setWritable(true, false);
        }
    }

    void localizeJar(FileStatus mfsStatus, File localFile) throws Exception {
        if (!localFile.exists() || mfsStatus.getModificationTime() > localFile.lastModified()) {
            this.fs.copyToLocalFile(false, mfsStatus.getPath(), new Path(localFile.getPath()));
            LOG.info((Object)("Copying Jar " + mfsStatus.getPath() + " to " + localFile.getPath()));
        }
    }

    public Class loadClass(String sinkJarPath, String sinkClassName) throws Exception {
        try {
            File localJarPath;
            ConfigInfo info = this.configFileCache.get(sinkJarPath);
            if (info != null) {
                return info.getSinkClass();
            }
            LOG.info((Object)("Creating a new sink class loader for " + sinkJarPath + ":" + sinkClassName));
            if (sinkJarPath == null) {
                throw new Exception("External sink jar paths not provided");
            }
            this.createLocalJarDirectory();
            String[] sinkJars = sinkJarPath.split(":");
            ArrayList<URL> urls = new ArrayList<URL>();
            if (this.localJar != null && (localJarPath = new File(this.localJar)).exists()) {
                for (File f : localJarPath.listFiles()) {
                    if (!f.isFile() || !f.getName().endsWith(".jar")) continue;
                    LOG.info((Object)("Adding default jar " + f.getAbsolutePath() + " to new class path"));
                    urls.add(f.toURI().toURL());
                }
            }
            for (int i = 0; i < sinkJars.length; ++i) {
                FileStatus[] statuses;
                Path sPath = new Path(sinkJars[i]);
                FileStatus status = this.fs.getFileStatus(sPath);
                if (status.isFile() && status.getPath().getName().endsWith(".jar")) {
                    File dstFilePath = new File(this.localJarDir, status.getPath().getName());
                    this.localizeJar(status, dstFilePath);
                    urls.add(dstFilePath.toURI().toURL());
                    continue;
                }
                if (!status.isDir()) continue;
                for (FileStatus st : statuses = this.fs.listStatus(sPath)) {
                    if (!st.isFile() || !st.getPath().getName().endsWith(".jar")) continue;
                    File dstFilePath = new File(this.localJarDir, st.getPath().getName());
                    this.localizeJar(st, dstFilePath);
                    urls.add(dstFilePath.toURI().toURL());
                }
            }
            URL[] urlArray = urls.toArray(new URL[urls.size()]);
            URLClassLoader newClassLoader = new URLClassLoader(urlArray, this.parentClassLoader);
            Class<?> sinkClassObj = null;
            sinkClassObj = newClassLoader.loadClass(sinkClassName);
            ConfigInfo newInfo = new ConfigInfo(newClassLoader, sinkClassObj);
            this.configFileCache.put(sinkJarPath, newInfo);
            return newInfo.getSinkClass();
        }
        catch (Throwable t) {
            LOG.error((Object)"Got an error while creating a class loader", t);
            throw new IOException("Got an error while creating a class loader", t);
        }
    }
}

