/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.jdbc.jdbc42.future;

import com.mapr.drill.dsi.dataengine.utilities.OrderType;
import com.mapr.drill.exceptions.ExceptionConverter;
import com.mapr.drill.jdbc.common.SConnection;
import com.mapr.drill.jdbc.jdbc41.future.S41DatabaseMetaData;
import com.mapr.drill.support.ILogger;
import com.mapr.drill.support.LogUtilities;
import java.sql.SQLException;

public class S42DatabaseMetaData
extends S41DatabaseMetaData {
    public S42DatabaseMetaData(SConnection sConnection, ILogger iLogger) throws SQLException {
        super(sConnection, iLogger);
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 2;
    }

    @Override
    protected OrderType getJDBCOrderType() {
        return OrderType.JDBC_42;
    }

    @Override
    public long getMaxLogicalLobSize() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return 0L;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsRefCursors() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return false;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }
}

