/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.jdbc.jdbc41.utilities;

import com.mapr.drill.exceptions.ExceptionConverter;
import com.mapr.drill.exceptions.JDBCMessageKey;
import com.mapr.drill.jdbc.common.BaseForwardResultSet;
import com.mapr.drill.jdbc.common.SArray;
import com.mapr.drill.support.IWarningListener;
import com.mapr.drill.support.LogUtilities;
import com.mapr.drill.support.exceptions.ExceptionType;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;

public class ResultSetUtilities {
    public static <T> T getObjectByType(BaseForwardResultSet baseForwardResultSet, int n, Class<T> clazz) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(baseForwardResultSet.getLogger(), n, clazz);
            if (clazz.equals(BigDecimal.class)) {
                return (T)baseForwardResultSet.getBigDecimal(n);
            }
            if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
                boolean bl = baseForwardResultSet.getBoolean(n);
                return (T)(baseForwardResultSet.wasNull() ? null : Boolean.valueOf(bl));
            }
            if (clazz.equals(Byte.class) || clazz.equals(Byte.TYPE)) {
                byte by = baseForwardResultSet.getByte(n);
                return (T)(baseForwardResultSet.wasNull() ? null : Byte.valueOf(by));
            }
            if (clazz.equals(byte[].class)) {
                return (T)baseForwardResultSet.getBytes(n);
            }
            if (clazz.equals(Date.class)) {
                return (T)baseForwardResultSet.getDate(n);
            }
            if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
                double d = baseForwardResultSet.getDouble(n);
                return (T)(baseForwardResultSet.wasNull() ? null : Double.valueOf(d));
            }
            if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
                float f = baseForwardResultSet.getFloat(n);
                return (T)(baseForwardResultSet.wasNull() ? null : Float.valueOf(f));
            }
            if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
                int n2 = baseForwardResultSet.getInt(n);
                return (T)(baseForwardResultSet.wasNull() ? null : Integer.valueOf(n2));
            }
            if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
                long l = baseForwardResultSet.getLong(n);
                return (T)(baseForwardResultSet.wasNull() ? null : Long.valueOf(l));
            }
            if (clazz.equals(Object.class)) {
                return (T)baseForwardResultSet.getObject(n);
            }
            if (clazz.equals(Short.class) || clazz.equals(Short.TYPE)) {
                short s = baseForwardResultSet.getShort(n);
                return (T)(baseForwardResultSet.wasNull() ? null : Short.valueOf(s));
            }
            if (clazz.equals(String.class)) {
                return (T)baseForwardResultSet.getString(n);
            }
            if (clazz.equals(Time.class)) {
                return (T)baseForwardResultSet.getTime(n);
            }
            if (clazz.equals(Timestamp.class)) {
                return (T)baseForwardResultSet.getTimestamp(n);
            }
            if (Array.class.equals(clazz) || SArray.class.isAssignableFrom(clazz)) {
                return (T)baseForwardResultSet.getArray(n);
            }
            if (clazz.equals(Blob.class) || clazz.equals(Clob.class) || clazz.equals(Ref.class) || clazz.equals(URL.class) || clazz.equals(NClob.class) || clazz.equals(RowId.class) || clazz.equals(SQLXML.class)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)baseForwardResultSet.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)baseForwardResultSet.getWarningListener(), ExceptionType.NON_TRANSIENT, String.valueOf(n), clazz.getName());
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, baseForwardResultSet.getWarningListener(), baseForwardResultSet.getLogger());
        }
    }
}

