/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.exceptions;

import com.mapr.drill.exceptions.JDBCMessageKey;
import com.mapr.drill.support.ILogger;
import com.mapr.drill.support.IMessageSource;
import com.mapr.drill.support.IWarningListener;
import com.mapr.drill.support.LogUtilities;
import com.mapr.drill.support.exceptions.ExceptionType;
import com.mapr.drill.support.exceptions.FailedPropertiesReason;
import java.sql.SQLException;
import java.util.Map;

public abstract class ExceptionConverter {
    private static ExceptionConverter s_converter = null;

    protected ExceptionConverter() {
    }

    public static ExceptionConverter getInstance() {
        return s_converter;
    }

    public static void setInstance(ExceptionConverter exceptionConverter) {
        if (null != exceptionConverter) {
            s_converter = exceptionConverter;
        }
    }

    public abstract SQLException toSQLException(Exception var1, IWarningListener var2);

    public SQLException toSQLException(Exception exception, IWarningListener iWarningListener, ILogger iLogger) {
        SQLException sQLException = this.toSQLException(exception, iWarningListener);
        LogUtilities.logError(sQLException, iLogger);
        return sQLException;
    }

    public SQLException toSQLException(JDBCMessageKey jDBCMessageKey, IWarningListener iWarningListener, ExceptionType exceptionType, Object ... objectArray) {
        return this.toSQLException(jDBCMessageKey, iWarningListener, exceptionType, null, objectArray);
    }

    public SQLException toSQLException(JDBCMessageKey jDBCMessageKey, IWarningListener iWarningListener, ExceptionType exceptionType, Map<String, FailedPropertiesReason> map, Object ... objectArray) {
        Object object;
        int n;
        IMessageSource iMessageSource = iWarningListener.getMessageSource();
        String string = iMessageSource.loadMessage(iWarningListener.getLocale(), 1, jDBCMessageKey.name(), objectArray);
        int n2 = 0;
        int n3 = string.indexOf(40);
        if (n3 < (n = string.indexOf(41)) && -1 != n3) {
            object = string.substring(++n3, n);
            try {
                n2 = Integer.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        object = Thread.currentThread().getStackTrace();
        StackTraceElement[] stackTraceElementArray = new StackTraceElement[((StackTraceElement[])object).length - 2];
        System.arraycopy(object, 2, stackTraceElementArray, 0, stackTraceElementArray.length);
        return this.createSQLException(jDBCMessageKey.getSQLState(), string, n2, stackTraceElementArray, exceptionType, map);
    }

    public SQLException toSQLException(String string, String string2, int n, ExceptionType exceptionType) {
        return this.toSQLException(string, string2, n, exceptionType, null);
    }

    public SQLException toSQLException(String string, String string2, int n, ExceptionType exceptionType, Map<String, FailedPropertiesReason> map) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[stackTraceElementArray.length - 2];
        System.arraycopy(stackTraceElementArray, 2, stackTraceElementArray2, 0, stackTraceElementArray2.length);
        return this.createSQLException(string, string2, n, stackTraceElementArray2, exceptionType, map);
    }

    protected abstract SQLException createSQLException(String var1, String var2, int var3, StackTraceElement[] var4, ExceptionType var5, Map<String, FailedPropertiesReason> var6);
}

