/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.dsi.dataengine.impl.future;

import com.mapr.drill.dsi.core.impl.DSIDriver;
import com.mapr.drill.dsi.dataengine.interfaces.future.IResultSet;
import com.mapr.drill.dsi.dataengine.utilities.CursorType;
import com.mapr.drill.dsi.utilities.DSIMessageKey;
import com.mapr.drill.support.IWarningListener;
import com.mapr.drill.support.exceptions.ErrorException;
import java.util.BitSet;

public abstract class DSISimpleResultSet
implements IResultSet {
    private int m_fetchSize = 0;
    private boolean m_hasStartedFetch = false;
    private boolean m_isClosed = false;
    private long m_currentRow = 0L;
    private IWarningListener m_warningListener = null;
    private final BitSet m_needsData = new BitSet();

    @Override
    public void close() {
        if (!this.m_isClosed) {
            this.m_isClosed = true;
            try {
                this.closeCursor();
            }
            catch (ErrorException errorException) {
                throw new RuntimeException(errorException);
            }
        }
    }

    @Override
    public void closeCursor() throws ErrorException {
        this.m_hasStartedFetch = false;
        this.m_currentRow = 0L;
        this.doCloseCursor();
    }

    @Override
    public boolean getDataNeeded(int n) {
        return this.m_needsData.get(n);
    }

    @Override
    public int getFetchSize() throws ErrorException {
        return this.m_fetchSize;
    }

    public IWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    @Override
    public boolean moveToNextRow() throws ErrorException {
        if (!this.m_hasStartedFetch) {
            this.m_hasStartedFetch = true;
            this.m_currentRow = 0L;
        } else {
            ++this.m_currentRow;
        }
        return this.doMoveToNextRow();
    }

    @Override
    public void registerWarningListener(IWarningListener iWarningListener) {
        this.m_warningListener = iWarningListener;
    }

    @Override
    public boolean rowDeleted() {
        return false;
    }

    @Override
    public boolean rowInserted() {
        return false;
    }

    @Override
    public boolean rowUpdated() {
        return false;
    }

    @Override
    public void setCursorType(CursorType cursorType) throws ErrorException {
        if (CursorType.FORWARD_ONLY != cursorType) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.CURSOR_NOT_SUPPORTED.name(), String.valueOf((Object)cursorType));
        }
    }

    @Override
    public void setDataNeeded(int n, boolean bl) {
        this.m_needsData.set(n, bl);
    }

    @Override
    public void setFetchSize(int n) throws ErrorException {
        this.m_fetchSize = n;
    }

    @Override
    public boolean supportsHasMoreRows() {
        return true;
    }

    protected abstract void doCloseCursor() throws ErrorException;

    protected abstract boolean doMoveToNextRow() throws ErrorException;

    protected int getCurrentRow() {
        return (int)this.m_currentRow;
    }
}

