/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.dsi.core.utilities.impl.future;

import com.mapr.drill.dsi.core.utilities.impl.future.NumericJDBCDataSource;
import com.mapr.drill.dsi.exceptions.IncorrectTypeException;
import com.mapr.drill.support.IWarningListener;
import com.mapr.drill.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.sql.SQLException;

public abstract class UnsignedTinyIntJDBCDataSource
extends NumericJDBCDataSource {
    private static final short TWO_TO_8 = 256;

    public UnsignedTinyIntJDBCDataSource(IWarningListener iWarningListener) {
        super(iWarningListener);
    }

    @Override
    public Short get() throws ErrorException {
        try {
            short s = this.getAndCheck();
            if (s == 0 && this.wasNull()) {
                return null;
            }
            return s;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public String getString() throws ErrorException, IncorrectTypeException, SQLException {
        short s = this.getAndCheck();
        if (s == 0 && this.wasNull()) {
            return null;
        }
        return Short.toString(s);
    }

    @Override
    public boolean getBoolean() throws ErrorException, IncorrectTypeException, SQLException {
        return this.getAndCheck() != 0;
    }

    @Override
    public byte getByte() throws ErrorException, IncorrectTypeException, SQLException {
        short s = this.getAndCheck();
        if (s > 127) {
            this.onOverflow(s, "getByte");
        }
        return (byte)s;
    }

    @Override
    public abstract short getShort() throws ErrorException, SQLException;

    protected final short getAndCheck() throws ErrorException, SQLException {
        short s = this.getShort();
        assert (s >= 0 && s <= 256);
        return s;
    }

    @Override
    public int getInt() throws ErrorException, IncorrectTypeException, SQLException {
        return this.getAndCheck();
    }

    @Override
    public long getLong() throws ErrorException, IncorrectTypeException, SQLException {
        return this.getAndCheck();
    }

    @Override
    public float getFloat() throws ErrorException, IncorrectTypeException, SQLException {
        return this.getAndCheck();
    }

    @Override
    public BigDecimal getBigDecimal() throws ErrorException, IncorrectTypeException, SQLException {
        short s = this.getAndCheck();
        if (s == 0 && this.wasNull()) {
            return null;
        }
        return BigDecimal.valueOf(s);
    }
}

