/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.dsi.core.utilities.impl.future;

import com.mapr.drill.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.mapr.drill.dsi.core.utilities.impl.future.NumberJDBCDataSink;
import com.mapr.drill.dsi.exceptions.IncorrectTypeException;
import com.mapr.drill.support.IWarningListener;
import com.mapr.drill.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.sql.SQLException;

public abstract class UnsignedSmallIntJDBCDataSink
extends NumberJDBCDataSink<Integer> {
    public UnsignedSmallIntJDBCDataSink(IWarningListener iWarningListener) {
        super(iWarningListener);
    }

    @Override
    protected abstract void doSet(Integer var1) throws ErrorException;

    @Override
    public void set(Object object) throws IncorrectTypeException, ErrorException {
        if (object == null) {
            this.doSet((Integer)null);
        } else {
            BigDecimal bigDecimal = NonTrivialJDBCConversions.objectToBigDecimal(object, null, this.getAndClearListener());
            int n = NonTrivialJDBCConversions.DecimalConverter.toUInt16(bigDecimal, this.getAndClearListener());
            this.handleConversionResult(object, "set");
            this.doSet(n);
        }
    }

    @Override
    public void setByte(byte by) throws IncorrectTypeException, SQLException, ErrorException {
        int n = NonTrivialJDBCConversions.LongConverter.toUInt16(by, this.getAndClearListener());
        if (!this.conversionSuccessful()) {
            this.handleConversionResult(by, "setByte");
        }
        this.doSet(n);
    }

    @Override
    public void setShort(short s) throws IncorrectTypeException, SQLException, ErrorException {
        int n = NonTrivialJDBCConversions.LongConverter.toUInt16(s, this.getAndClearListener());
        if (!this.conversionSuccessful()) {
            this.handleConversionResult(s, "setShort");
        }
        this.doSet(n);
    }

    @Override
    public void setInt(int n) throws IncorrectTypeException, SQLException, ErrorException {
        int n2 = NonTrivialJDBCConversions.LongConverter.toUInt16(n, this.getAndClearListener());
        if (!this.conversionSuccessful()) {
            this.handleConversionResult(n, "setInt");
        }
        this.doSet(n2);
    }

    @Override
    public void setLong(long l) throws IncorrectTypeException, SQLException, ErrorException {
        int n = NonTrivialJDBCConversions.LongConverter.toUInt16(l, this.getAndClearListener());
        if (!this.conversionSuccessful()) {
            this.handleConversionResult(l, "setLong");
        }
        this.doSet(n);
    }

    @Override
    public void setFloat(float f) throws IncorrectTypeException, SQLException, ErrorException {
        int n = NonTrivialJDBCConversions.DoubleConverter.toUInt16(f, this.getAndClearListener());
        if (!this.conversionSuccessful()) {
            this.handleConversionResult(Float.valueOf(f), "setFloat");
        }
        this.doSet(n);
    }

    @Override
    public void setDouble(double d) throws IncorrectTypeException, SQLException, ErrorException {
        int n = NonTrivialJDBCConversions.DoubleConverter.toUInt16(d, this.getAndClearListener());
        if (!this.conversionSuccessful()) {
            this.handleConversionResult(d, "setDouble");
        }
        this.doSet(n);
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws IncorrectTypeException, SQLException, ErrorException {
        if (bigDecimal == null) {
            this.setNull(3);
        } else {
            int n = NonTrivialJDBCConversions.DecimalConverter.toUInt16(bigDecimal, this.getAndClearListener());
            if (!this.conversionSuccessful()) {
                this.handleConversionResult(bigDecimal, "setBigDecimal");
            }
            this.doSet(n);
        }
    }

    @Override
    public void setString(String string) throws IncorrectTypeException, SQLException, ErrorException {
        if (string == null) {
            this.setNull(1);
        } else {
            try {
                this.setInt(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                int n = NonTrivialJDBCConversions.DecimalConverter.toUInt16(new BigDecimal(string.trim()), this.getAndClearListener());
                if (!this.conversionSuccessful()) {
                    this.handleConversionResult(string, "setString");
                }
                this.doSet(n);
            }
        }
    }
}

