/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.dsi.core.utilities.impl.future;

import com.mapr.drill.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.mapr.drill.dsi.core.utilities.impl.future.ConvertingJDBCDataSink;
import com.mapr.drill.dsi.dataengine.interfaces.future.IJDBCArray;
import com.mapr.drill.dsi.exceptions.IncorrectTypeException;
import com.mapr.drill.support.IWarningListener;
import com.mapr.drill.support.exceptions.ErrorException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public abstract class StringJDBCDataSink
extends ConvertingJDBCDataSink {
    public StringJDBCDataSink(IWarningListener iWarningListener) {
        super(iWarningListener);
    }

    @Override
    public void set(Object object) throws IncorrectTypeException, ErrorException {
        if (object == null || object instanceof String) {
            this.doSetString((String)object);
        } else if (object instanceof Reader) {
            this.doSetReader((Reader)object);
        } else {
            throw new IncorrectTypeException();
        }
    }

    protected abstract void doSetString(String var1) throws ErrorException;

    protected abstract void doSetReader(Reader var1) throws ErrorException;

    @Override
    public void setReader(Reader reader) throws IncorrectTypeException, ErrorException {
        this.doSetReader(reader);
    }

    @Override
    public void setBinaryStream(InputStream inputStream, int n) throws IncorrectTypeException, SQLException, ErrorException {
        this.setBinaryStream(inputStream, (long)n);
    }

    @Override
    public void setArray(IJDBCArray iJDBCArray) throws IncorrectTypeException, SQLException, ErrorException {
        if (iJDBCArray == null) {
            this.setNull(2003);
        } else {
            this.doSetString(iJDBCArray.toString());
        }
    }

    @Override
    public void setBinaryStream(InputStream inputStream, long l) throws IncorrectTypeException, SQLException, ErrorException {
        this.setBinaryStream(inputStream);
    }

    @Override
    public void setBinaryStream(InputStream inputStream) throws IncorrectTypeException, SQLException, ErrorException {
        this.doSetReader(inputStream == null ? null : new NonTrivialJDBCConversions.HexStringReader(inputStream, false));
    }

    @Override
    public void setBoolean(boolean bl) throws IncorrectTypeException, SQLException, ErrorException {
        this.doSetString(bl ? "1" : "0");
    }

    @Override
    public void setBytes(byte[] byArray) throws IncorrectTypeException, SQLException, ErrorException {
        if (byArray == null) {
            this.setNull(-2);
        } else {
            this.doSetString(NonTrivialJDBCConversions.bytesToHex(byArray));
        }
    }

    @Override
    public void setShort(short s) throws IncorrectTypeException, SQLException, ErrorException {
        this.doSetString(Short.toString(s));
    }

    @Override
    public void setInt(int n) throws IncorrectTypeException, SQLException, ErrorException {
        this.doSetString(Integer.toString(n));
    }

    @Override
    public void setLong(long l) throws IncorrectTypeException, SQLException, ErrorException {
        this.doSetString(Long.toString(l));
    }

    @Override
    public void setFloat(float f) throws IncorrectTypeException, SQLException, ErrorException {
        this.doSetString(Float.toString(f));
    }

    @Override
    public void setDouble(double d) throws IncorrectTypeException, SQLException, ErrorException {
        this.doSetString(Double.toString(d));
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws IncorrectTypeException, SQLException, ErrorException {
        this.doSetString(bigDecimal == null ? null : bigDecimal.toPlainString());
    }

    @Override
    public void setString(String string) throws IncorrectTypeException, SQLException, ErrorException {
        this.doSetString(string);
    }

    @Override
    public void setDate(Date date, Calendar calendar) throws IncorrectTypeException, SQLException, ErrorException {
        if (date == null) {
            this.setNull(91);
        } else {
            if (calendar == null) {
                calendar = this.getLocalCalendarForConversions();
            }
            this.doSetString(NonTrivialJDBCConversions.dateToString(date, calendar));
        }
    }

    @Override
    public void setTime(Time time, Calendar calendar) throws IncorrectTypeException, SQLException, ErrorException {
        if (time == null) {
            this.setNull(92);
        } else {
            if (calendar == null) {
                calendar = this.getLocalCalendarForConversions();
            }
            this.doSetString(NonTrivialJDBCConversions.timeToString(time, calendar, 3));
        }
    }

    @Override
    public void setTimestamp(Timestamp timestamp, Calendar calendar) throws IncorrectTypeException, SQLException, ErrorException {
        if (timestamp == null) {
            this.setNull(93);
        } else {
            if (calendar == null) {
                calendar = this.getLocalCalendarForConversions();
            }
            this.doSetString(NonTrivialJDBCConversions.timestampToString(timestamp, calendar, 9));
        }
    }

    @Override
    public void setCharacterStream(Reader reader) throws IncorrectTypeException, SQLException, ErrorException {
        this.doSetReader(reader);
    }

    @Override
    public void setNull(int n) throws IncorrectTypeException, SQLException, ErrorException {
        if (n > 1999 && n < 2007 && n != 2003 && n != 2002 && n != 2000 || 70 == n) {
            throw new IncorrectTypeException();
        }
        this.doSetString(null);
    }
}

