/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.dsi.core.utilities.impl.future;

import com.mapr.drill.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.mapr.drill.dsi.core.utilities.impl.future.NumericJDBCDataSource;
import com.mapr.drill.dsi.exceptions.IncorrectTypeException;
import com.mapr.drill.support.IWarningListener;
import com.mapr.drill.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.sql.SQLException;

public abstract class SignedIntJDBCDataSource
extends NumericJDBCDataSource {
    public SignedIntJDBCDataSource(IWarningListener iWarningListener) {
        super(iWarningListener);
    }

    protected final void handleConversionResult(int n, String string) {
        switch (this.getListener().getStatus()) {
            case SUCCESS: {
                break;
            }
            case FRACTIONAL_TRUNCATION: {
                throw new RuntimeException("Unexpected fractional truncation!");
            }
            case OVERFLOW: {
                this.onOverflow(n, string);
            }
        }
    }

    @Override
    public Integer get() throws ErrorException {
        try {
            int n = this.getInt();
            if (n == 0 && this.wasNull()) {
                return null;
            }
            return n;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public String getString() throws ErrorException, IncorrectTypeException, SQLException {
        int n = this.getInt();
        if (n == 0 && this.wasNull()) {
            return null;
        }
        return Integer.toString(n);
    }

    @Override
    public boolean getBoolean() throws ErrorException, IncorrectTypeException, SQLException {
        return this.getInt() != 0;
    }

    @Override
    public byte getByte() throws ErrorException, IncorrectTypeException, SQLException {
        int n = this.getInt();
        byte by = NonTrivialJDBCConversions.LongConverter.toByte(n, this.getAndClearListener());
        this.handleConversionResult(n, "getByte");
        return by;
    }

    @Override
    public short getShort() throws ErrorException, IncorrectTypeException, SQLException {
        int n = this.getInt();
        short s = NonTrivialJDBCConversions.LongConverter.toShort(n, this.getAndClearListener());
        this.handleConversionResult(n, "getShort");
        return s;
    }

    @Override
    public abstract int getInt() throws ErrorException, SQLException;

    @Override
    public long getLong() throws ErrorException, IncorrectTypeException, SQLException {
        return this.getInt();
    }

    @Override
    public float getFloat() throws ErrorException, IncorrectTypeException, SQLException {
        return this.getInt();
    }

    @Override
    public double getDouble() throws ErrorException, IncorrectTypeException, SQLException {
        return this.getInt();
    }

    @Override
    public BigDecimal getBigDecimal() throws ErrorException, IncorrectTypeException, SQLException {
        int n = this.getInt();
        if (n == 0 && this.wasNull()) {
            return null;
        }
        return new BigDecimal(n);
    }
}

