/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.drill.dataengine.dynamicschema.converters;

import com.mapr.drill.drill.core.DRJDBCDriver;
import com.mapr.drill.drill.dataengine.dynamicschema.converters.DRJDBCNumberConverter;
import com.mapr.drill.drill.exceptions.DRJDBCMessageKey;
import com.mapr.drill.support.exceptions.ErrorException;
import java.math.BigDecimal;
import org.apache.drill.exec.vector.accessor.SqlAccessor;

public class DRJDBCBigIntConverter
extends DRJDBCNumberConverter {
    private static final String TYPE_NAME = "BigInt";

    public static DRJDBCBigIntConverter getInstance() {
        return DRJDBCConverterHelper.INSTANCE;
    }

    @Override
    public BigDecimal getAsBigDecimal(SqlAccessor sqlAccessor, int n) throws ErrorException {
        return new BigDecimal(DRJDBCBigIntConverter.getData(sqlAccessor, n));
    }

    @Override
    public byte getAsByte(SqlAccessor sqlAccessor, int n) throws ErrorException {
        long l = DRJDBCBigIntConverter.getData(sqlAccessor, n);
        DRJDBCBigIntConverter.verifyByteRange(l, TYPE_NAME);
        return (byte)l;
    }

    @Override
    public double getAsDouble(SqlAccessor sqlAccessor, int n) throws ErrorException {
        return DRJDBCBigIntConverter.getData(sqlAccessor, n);
    }

    @Override
    public float getAsFloat(SqlAccessor sqlAccessor, int n) throws ErrorException {
        return DRJDBCBigIntConverter.getData(sqlAccessor, n);
    }

    @Override
    public int getAsInt(SqlAccessor sqlAccessor, int n) throws ErrorException {
        long l = DRJDBCBigIntConverter.getData(sqlAccessor, n);
        DRJDBCBigIntConverter.verifyIntRange(l, TYPE_NAME);
        return (int)l;
    }

    @Override
    public long getAsLong(SqlAccessor sqlAccessor, int n) throws ErrorException {
        return DRJDBCBigIntConverter.getData(sqlAccessor, n);
    }

    @Override
    public short getAsShort(SqlAccessor sqlAccessor, int n) throws ErrorException {
        long l = DRJDBCBigIntConverter.getData(sqlAccessor, n);
        DRJDBCBigIntConverter.verifyShortRange(l, TYPE_NAME);
        return (short)l;
    }

    private DRJDBCBigIntConverter() {
    }

    private static long getData(SqlAccessor sqlAccessor, int n) throws ErrorException {
        try {
            return sqlAccessor.getLong(n);
        }
        catch (Exception exception) {
            ErrorException errorException = DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.DATA_CONVERT_ERR.name(), exception.getMessage());
            errorException.initCause(exception);
            throw errorException;
        }
    }

    private static class DRJDBCConverterHelper {
        private static final DRJDBCBigIntConverter INSTANCE = new DRJDBCBigIntConverter();

        private DRJDBCConverterHelper() {
        }
    }
}

