/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.drill.dataengine;

public class DRJDBCQueryParser {
    public static final String SELECT_KEYWORD = "SELECT";
    public static final String WITH_KEYWORD = "WITH";
    public static final String VALUES_KEYWORD = "VALUES";
    public static final String SHOW_KEYWORD = "SHOW";
    public static final String DESCRIBE_KEYWORD = "DESCRIBE";
    public static final String CREATE_KEYWORD = "CREATE";
    public static final String DROP_KEYWORD = "DROP";
    public static final String USE_KEYWORD = "USE";
    public static final String SET_KEYWORD = "SET";
    public static final String REFRESH_KEYWORD = "REFRESH";
    public static final String INSERT_KEYWORD = "INSERT";
    public static final String DELETE_KEYWORD = "DELETE";
    public static final String UPDATE_KEYWORD = "UPDATE";

    public static StatementType getQueryType(String string) {
        String string2;
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (i + 1 < string.length() && '-' == string.charAt(i) && '-' == string.charAt(i + 1) || '/' == string.charAt(i) && '*' == string.charAt(i + 1)) {
                int n2 = DRJDBCQueryParser.findEndOfComments(string, i);
                if (n2 != -1) {
                    i = n2;
                    continue;
                }
                return StatementType.OTHER_STATEMENT;
            }
            if (Character.isWhitespace(string.charAt(i))) continue;
            n = i;
            break;
        }
        StatementType statementType = (string2 = string.substring(n).trim().toUpperCase()).startsWith(SELECT_KEYWORD) || string2.startsWith(VALUES_KEYWORD) ? StatementType.SELECT_OR_VALUES_STATEMENT : (string2.startsWith(SHOW_KEYWORD) || string2.startsWith(DESCRIBE_KEYWORD) ? StatementType.SHOW_OR_DESCRIBE_STATEMENT : (string2.startsWith(CREATE_KEYWORD) || string2.startsWith(DROP_KEYWORD) || string2.startsWith(USE_KEYWORD) || string2.startsWith(SET_KEYWORD) || string2.startsWith(REFRESH_KEYWORD) || string2.startsWith(INSERT_KEYWORD) || string2.startsWith(DELETE_KEYWORD) || string2.startsWith(UPDATE_KEYWORD) ? StatementType.ROW_COUNT_STATEMENT : StatementType.OTHER_STATEMENT));
        return statementType;
    }

    private static int findEndOfComments(String string, int n) {
        boolean bl;
        String string2 = string.substring(n, n + 2);
        if (string2.equals("--")) {
            bl = true;
        } else if (string2.equals("/*")) {
            bl = false;
        } else {
            return -1;
        }
        for (int i = n + 2; i < string.length(); ++i) {
            if (bl && '\n' == string.charAt(i)) {
                return i;
            }
            if (bl || '*' != string.charAt(i) || i + 1 >= string.length() || '/' != string.charAt(i + 1)) continue;
            return i + 1;
        }
        if (bl) {
            return string.length() - 1;
        }
        return -1;
    }

    public static enum StatementType {
        SELECT_OR_VALUES_STATEMENT,
        ROW_COUNT_STATEMENT,
        SHOW_OR_DESCRIBE_STATEMENT,
        OTHER_STATEMENT;

    }
}

