/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.drill.core;

import com.mapr.drill.drill.core.DRJDBCEnvironment;
import com.mapr.drill.drill.exceptions.DRJDBCMessageKey;
import com.mapr.drill.dsi.core.impl.DSIDriver;
import com.mapr.drill.dsi.core.impl.DSILogger;
import com.mapr.drill.dsi.core.interfaces.IEnvironment;
import com.mapr.drill.dsi.core.utilities.Variant;
import com.mapr.drill.support.exceptions.ErrorException;
import com.mapr.drill.support.exceptions.ExceptionBuilder;
import com.mapr.drill.support.exceptions.ExceptionUtilities;
import java.text.MessageFormat;

public class DRJDBCDriver
extends DSIDriver {
    public static final String DRIVER_NAME = "DrillJDBC";
    public static final int DRIVER_MAJOR_VERSION = 1;
    public static final int DRIVER_MINOR_VERSION = 6;
    public static final int DRIVER_HOT_FIX_VERSION = 8;
    public static final int DRIVER_BUILD_NUMBER = 1011;
    public static final String VENDOR_NAME = "MapR";
    public static final String DRIVER_LICENSE_FILE_NAME = "MapRDrillJDBCDriver.lic";
    public static final String DRIVER_LICENSE_PRODUCT_NAME = "MapR Drill JDBC Driver";
    public static final String DRIVER_VERSION = "1.6.8.1011";
    private static final String LOG_NAME = "DrillJDBC_driver";
    public static final String RESOURCE_NAME = "messages";
    public static ExceptionBuilder s_DriverMessages = new ExceptionBuilder(101);
    private DSILogger m_log;

    public DRJDBCDriver() throws ErrorException {
        this.setDefaultProperties();
        StringBuilder stringBuilder = new StringBuilder(ExceptionUtilities.getPackageName(this.getClass()));
        stringBuilder.append(".");
        stringBuilder.append(RESOURCE_NAME);
        this.m_msgSrc.registerMessages(stringBuilder.toString(), 101, "DrillJDBCDriver");
        this.m_msgSrc.setVendorName(VENDOR_NAME);
    }

    @Override
    public IEnvironment createEnvironment() throws ErrorException {
        return new DRJDBCEnvironment(this);
    }

    @Override
    public DSILogger getDriverLog() {
        if (null == this.m_log) {
            this.m_log = new DSILogger(LOG_NAME);
        }
        return this.m_log;
    }

    private void setDefaultProperties() throws ErrorException {
        try {
            this.setProperty(3, new Variant(0, DRIVER_NAME));
            String string = MessageFormat.format("{0,number,00}.{1,number,00}.{2,number,00}.{3,number,0000}", 1, 6, 8, 1011);
            this.setProperty(5, new Variant(0, string));
            this.setProperty(1000, new Variant(5, (short)1));
            this.setProperty(10, new Variant(6, 1));
        }
        catch (Throwable throwable) {
            ErrorException errorException = s_DriverMessages.createGeneralException(DRJDBCMessageKey.DRIVER_DEFAULT_PROP_ERR.name(), "Driver property set error.");
            errorException.initCause(throwable);
            throw errorException;
        }
    }
}

