/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.drill.api;

import com.mapr.drill.drill.core.DRJDBCConnectionSettings;
import com.mapr.drill.drill.core.DRJDBCDriver;
import com.mapr.drill.drill.dataengine.dynamicschema.DRJDBCColumnMetadata;
import com.mapr.drill.drill.exceptions.DRJDBCMessageKey;
import com.mapr.drill.dsi.dataengine.utilities.Nullable;
import com.mapr.drill.dsi.dataengine.utilities.Searchable;
import com.mapr.drill.dsi.dataengine.utilities.TypeMetadata;
import com.mapr.drill.dsi.dataengine.utilities.TypeUtilities;
import com.mapr.drill.dsi.dataengine.utilities.Updatable;
import com.mapr.drill.dsi.exceptions.NumericOverflowException;
import com.mapr.drill.support.exceptions.ErrorException;
import java.util.HashMap;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.UserProtos;
import org.apache.drill.exec.record.MaterializedField;

public class DRJDBCDataTypeUtils {
    private static HashMap<String, Short> s_drillTypeToSQLType;
    private static HashMap<String, String> s_drillTypeToDriverType;
    public static final Short TIME_PRECISION;
    public static final Short TIME_TYPE_SCALE;
    public static final Short TIMESTAMP_PRECISION;
    private static final String ARRAY_TYPE = "ARRAY";

    public static DRJDBCColumnMetadata createColumn(String string, String string2, String string3, UserBitShared.SerializedField serializedField, MaterializedField materializedField, DRJDBCConnectionSettings dRJDBCConnectionSettings) throws Exception {
        String string4 = serializedField.getMajorType().getMinorType().name();
        String string5 = serializedField.getNamePart().getName();
        int n = serializedField.getBufferLength();
        int n2 = dRJDBCConnectionSettings.getStringColumnLength();
        Short s = s_drillTypeToSQLType.get(string4);
        if (TypeProtos.DataMode.REPEATED == serializedField.getMajorType().getMode()) {
            n2 = dRJDBCConnectionSettings.getRepeatModeColumnSize();
        }
        if (TypeUtilities.isCharacterOrBinaryType(s.shortValue())) {
            n = n2;
        }
        DRJDBCColumnMetadata dRJDBCColumnMetadata = DRJDBCDataTypeUtils.setDefaultColumnMetadata(string, string2, string3, string4, string5, n);
        if (null != materializedField) {
            if (serializedField.getMajorType() != materializedField.getType()) {
                throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.INTIALIZE_METADATA_ERR.name(), new String[]{"Major Type mismatch between Serialized and Materialized fields."});
            }
            if (serializedField.getMajorType().getMinorType() != materializedField.getType().getMinorType()) {
                throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.INTIALIZE_METADATA_ERR.name(), new String[]{"Minor Type mismatch between Serialized and Materialized fields."});
            }
            if (!serializedField.getNamePart().getName().equalsIgnoreCase(materializedField.getName())) {
                throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.INTIALIZE_METADATA_ERR.name(), new String[]{"Column name mismatch between Serialized and Materialized fields"});
            }
            dRJDBCColumnMetadata.setNullable(materializedField.isNullable() ? Nullable.NULLABLE : Nullable.NO_NULLS);
            DRJDBCDataTypeUtils.setColumnPrecisionAndScale(dRJDBCColumnMetadata, materializedField.getPrecision(), materializedField.getScale(), n);
        }
        return dRJDBCColumnMetadata;
    }

    public static DRJDBCColumnMetadata createColumn(UserProtos.ResultColumnMetadata resultColumnMetadata, DRJDBCConnectionSettings dRJDBCConnectionSettings) throws Exception {
        DRJDBCColumnMetadata dRJDBCColumnMetadata = DRJDBCDataTypeUtils.setDefaultColumnMetadata(resultColumnMetadata.getCatalogName(), resultColumnMetadata.getSchemaName(), resultColumnMetadata.getTableName(), resultColumnMetadata.getDataType(), resultColumnMetadata.getColumnName(), resultColumnMetadata.getPrecision());
        dRJDBCColumnMetadata.setNullable(resultColumnMetadata.getIsNullable() ? Nullable.NULLABLE : Nullable.NO_NULLS);
        dRJDBCColumnMetadata.setLabel(resultColumnMetadata.getLabel());
        switch (resultColumnMetadata.getSearchability().getNumber()) {
            case 2: {
                dRJDBCColumnMetadata.setSearchable(Searchable.PREDICATE_CHAR);
                break;
            }
            case 4: {
                dRJDBCColumnMetadata.setSearchable(Searchable.SEARCHABLE);
                break;
            }
            default: {
                dRJDBCColumnMetadata.setSearchable(Searchable.PREDICATE_NONE);
            }
        }
        switch (resultColumnMetadata.getUpdatability().getNumber()) {
            case 1: {
                dRJDBCColumnMetadata.setUpdatable(Updatable.READ_ONLY);
                break;
            }
            case 2: {
                dRJDBCColumnMetadata.setUpdatable(Updatable.WRITE);
                break;
            }
            default: {
                dRJDBCColumnMetadata.setUpdatable(Updatable.UNKNOWN);
            }
        }
        dRJDBCColumnMetadata.setCaseSensitive(resultColumnMetadata.getCaseSensitivity());
        int n = dRJDBCConnectionSettings.getStringColumnLength();
        if (dRJDBCColumnMetadata.getTypeMetadata().getTypeName().equals(ARRAY_TYPE)) {
            n = dRJDBCConnectionSettings.getRepeatModeColumnSize();
        }
        DRJDBCDataTypeUtils.setColumnPrecisionAndScale(dRJDBCColumnMetadata, resultColumnMetadata.hasPrecision() ? resultColumnMetadata.getPrecision() : 0, resultColumnMetadata.hasScale() ? resultColumnMetadata.getScale() : 0, n);
        return dRJDBCColumnMetadata;
    }

    public static String mapDrillTypeToDriverTypeName(String string) {
        String string2 = string.trim().toUpperCase();
        if (s_drillTypeToDriverType.containsKey(string2)) {
            return s_drillTypeToDriverType.get(string2);
        }
        return string2;
    }

    public static short mapDrillTypeNameToSqltype(String string) throws ErrorException {
        Short s = s_drillTypeToSQLType.get(string.trim());
        if (null != s) {
            return s;
        }
        throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.DATA_FETCH_ERR.name(), new String[]{string.trim() + " Data type is not supported."});
    }

    private static void initializeDrillTypeToDriverType() {
        s_drillTypeToDriverType = new HashMap();
        s_drillTypeToDriverType.put("CHARACTER", "CHAR");
        s_drillTypeToDriverType.put("FIXEDCHAR", "CHAR");
        s_drillTypeToDriverType.put("FIXED16CHAR", "CHAR");
        s_drillTypeToDriverType.put("FLOAT4", "REAL");
        s_drillTypeToDriverType.put("INT", "INTEGER");
        s_drillTypeToDriverType.put("FLOAT8", "DOUBLE");
        s_drillTypeToDriverType.put("TIME WITH TIME ZONE", "TIMETZ");
        s_drillTypeToDriverType.put("TIMESTAMP WITH TIME ZONE", "TIMESTAMPTZ");
        s_drillTypeToDriverType.put("INTERVAL DAY TO SECOND", "INTERVALDAY");
        s_drillTypeToDriverType.put("INTERVAL YEAR TO MONTH", "INTERVALYEAR");
        s_drillTypeToDriverType.put("DECIMAL9", "DECIMAL");
        s_drillTypeToDriverType.put("DECIMAL18", "DECIMAL");
        s_drillTypeToDriverType.put("DECIMAL28DENSE", "DECIMAL");
        s_drillTypeToDriverType.put("DECIMAL38DENSE", "DECIMAL");
        s_drillTypeToDriverType.put("DECIMAL28SPARSE", "DECIMAL");
        s_drillTypeToDriverType.put("DECIMAL38SPARSE", "DECIMAL");
        s_drillTypeToDriverType.put("VARDECIMAL", "DECIMAL");
        s_drillTypeToDriverType.put("FIXEDBINARY", "BINARY");
        s_drillTypeToDriverType.put("UINT1", "TINYINT");
        s_drillTypeToDriverType.put("UINT2", "SMALLINT");
        s_drillTypeToDriverType.put("UINT4", "INTEGER");
        s_drillTypeToDriverType.put("UINT8", "BIGINT");
        s_drillTypeToDriverType.put("VAR16CHAR", "VARCHAR");
        s_drillTypeToDriverType.put("LIST", "VARCHAR");
        s_drillTypeToDriverType.put("LATE", "VARCHAR");
        s_drillTypeToDriverType.put("MONEY", "DOUBLE");
    }

    private static void initializeDrillTypeToSQLTypeMap() {
        s_drillTypeToSQLType = new HashMap();
        s_drillTypeToSQLType.put("CHAR", (short)1);
        s_drillTypeToSQLType.put("CHARACTER", (short)1);
        s_drillTypeToSQLType.put("FIXEDCHAR", (short)1);
        s_drillTypeToSQLType.put("FIXED16CHAR", (short)1);
        s_drillTypeToSQLType.put("ANY", (short)12);
        s_drillTypeToSQLType.put(ARRAY_TYPE, (short)12);
        s_drillTypeToSQLType.put("CHARACTER VARYING", (short)12);
        s_drillTypeToSQLType.put("INTERVAL DAY TO SECOND", (short)12);
        s_drillTypeToSQLType.put("INTERVAL YEAR TO MONTH", (short)12);
        s_drillTypeToSQLType.put("INTERVAL", (short)12);
        s_drillTypeToSQLType.put("INTERVALDAY", (short)12);
        s_drillTypeToSQLType.put("INTERVALYEAR", (short)12);
        s_drillTypeToSQLType.put("LATE", (short)12);
        s_drillTypeToSQLType.put("LIST", (short)12);
        s_drillTypeToSQLType.put("MAP", (short)12);
        s_drillTypeToSQLType.put("NULL", (short)12);
        s_drillTypeToSQLType.put("UNION", (short)12);
        s_drillTypeToSQLType.put("VAR16CHAR", (short)12);
        s_drillTypeToSQLType.put("VARCHAR", (short)12);
        s_drillTypeToSQLType.put("DECIMAL", (short)3);
        s_drillTypeToSQLType.put("DECIMAL9", (short)3);
        s_drillTypeToSQLType.put("DECIMAL18", (short)3);
        s_drillTypeToSQLType.put("DECIMAL28DENSE", (short)3);
        s_drillTypeToSQLType.put("DECIMAL38DENSE", (short)3);
        s_drillTypeToSQLType.put("DECIMAL28SPARSE", (short)3);
        s_drillTypeToSQLType.put("DECIMAL38SPARSE", (short)3);
        s_drillTypeToSQLType.put("VARDECIMAL", (short)3);
        s_drillTypeToSQLType.put("BIT", (short)-7);
        s_drillTypeToSQLType.put("BOOLEAN", (short)16);
        s_drillTypeToSQLType.put("TINYINT", (short)-6);
        s_drillTypeToSQLType.put("UINT1", (short)-6);
        s_drillTypeToSQLType.put("SMALLINT", (short)5);
        s_drillTypeToSQLType.put("UINT2", (short)5);
        s_drillTypeToSQLType.put("INT", (short)4);
        s_drillTypeToSQLType.put("INTEGER", (short)4);
        s_drillTypeToSQLType.put("UINT4", (short)4);
        s_drillTypeToSQLType.put("BIGINT", (short)-5);
        s_drillTypeToSQLType.put("UINT8", (short)-5);
        s_drillTypeToSQLType.put("FLOAT4", (short)7);
        s_drillTypeToSQLType.put("REAL", (short)7);
        s_drillTypeToSQLType.put("FLOAT", (short)6);
        s_drillTypeToSQLType.put("FLOAT8", (short)8);
        s_drillTypeToSQLType.put("DOUBLE", (short)8);
        s_drillTypeToSQLType.put("MONEY", (short)8);
        s_drillTypeToSQLType.put("BINARY", (short)-2);
        s_drillTypeToSQLType.put("FIXEDBINARY", (short)-2);
        s_drillTypeToSQLType.put("BINARY VARYING", (short)-3);
        s_drillTypeToSQLType.put("VARBINARY", (short)-3);
        s_drillTypeToSQLType.put("DATE", (short)91);
        s_drillTypeToSQLType.put("TIME", (short)92);
        s_drillTypeToSQLType.put("TIMETZ", (short)92);
        s_drillTypeToSQLType.put("TIME WITH TIME ZONE", (short)92);
        s_drillTypeToSQLType.put("TIMESTAMP", (short)93);
        s_drillTypeToSQLType.put("TIMESTAMPTZ", (short)93);
        s_drillTypeToSQLType.put("TIMESTAMP WITH TIME ZONE", (short)93);
    }

    private static DRJDBCColumnMetadata setDefaultColumnMetadata(String string, String string2, String string3, String string4, String string5, int n) throws ErrorException, NumericOverflowException {
        Short s = s_drillTypeToSQLType.get(string4);
        if (null == s) {
            string4 = "VARCHAR";
            s = 12;
        }
        TypeMetadata typeMetadata = TypeMetadata.createTypeMetadata(s.shortValue());
        DRJDBCColumnMetadata dRJDBCColumnMetadata = new DRJDBCColumnMetadata(typeMetadata);
        typeMetadata.setTypeName(DRJDBCDataTypeUtils.mapDrillTypeToDriverTypeName(string4));
        dRJDBCColumnMetadata.setCatalogName(string);
        dRJDBCColumnMetadata.setColumnLength(n);
        dRJDBCColumnMetadata.setLabel(string5);
        dRJDBCColumnMetadata.setName(string5);
        dRJDBCColumnMetadata.setNullable(Nullable.NULLABLE);
        dRJDBCColumnMetadata.setSchemaName(string2);
        dRJDBCColumnMetadata.setTableName(string3);
        return dRJDBCColumnMetadata;
    }

    private static void setColumnPrecisionAndScale(DRJDBCColumnMetadata dRJDBCColumnMetadata, int n, int n2, int n3) throws NumericOverflowException {
        TypeMetadata typeMetadata = dRJDBCColumnMetadata.getTypeMetadata();
        if (typeMetadata.isCharacterOrBinaryType() || typeMetadata.isIntervalType()) {
            if (typeMetadata.isCharacterType()) {
                dRJDBCColumnMetadata.setColumnLength(0 < n ? n : n3);
            } else if (typeMetadata.isBinaryType()) {
                dRJDBCColumnMetadata.setColumnLength(0 < n ? (long)n : (long)(n3 * 2));
            }
        } else if (typeMetadata.isExactNumericType() || typeMetadata.isApproximateNumericType()) {
            typeMetadata.setScale((short)n2);
            if (n > 0) {
                typeMetadata.setPrecision((short)n);
            }
        } else if (TypeUtilities.isTimeType(typeMetadata.getType())) {
            switch (typeMetadata.getType()) {
                case 92: {
                    typeMetadata.setPrecision(TIME_TYPE_SCALE);
                    break;
                }
                case 93: {
                    typeMetadata.setPrecision(TIME_TYPE_SCALE);
                    break;
                }
            }
            typeMetadata.setScale(TIME_TYPE_SCALE);
        }
        dRJDBCColumnMetadata.setTypeMetadata(typeMetadata);
    }

    static {
        TIME_PRECISION = 12;
        TIME_TYPE_SCALE = 3;
        TIMESTAMP_PRECISION = 23;
        DRJDBCDataTypeUtils.initializeDrillTypeToSQLTypeMap();
        DRJDBCDataTypeUtils.initializeDrillTypeToDriverType();
    }
}

