/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.jdbc.utils;

import com.mapr.drill.support.exceptions.ErrorException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;

public class DataTypeUtilities {
    private static final int NUMBER_OF_POWERS_OF_10 = 18;
    private static final long[] POWERS_OF_10 = new long[19];
    private static final CalculateMantissa[] MANTISSA_CALCULATORS = new CalculateMantissa[19];

    public static byte[] toHexString(byte[] byArray) {
        byte[] byArray2 = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
        byte[] byArray3 = new byte[byArray.length * 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            byArray3[i * 2] = byArray2[n >>> 4];
            byArray3[i * 2 + 1] = byArray2[n & 0xF];
        }
        return byArray3;
    }

    public static final String toUTF8String(byte[] byArray) {
        String string = null;
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = new String(byArray);
        }
        return string;
    }

    public static final String toUTF8String(byte[] byArray, int n, int n2) {
        String string = null;
        try {
            string = new String(byArray, n, n2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = new String(byArray, n, n2);
        }
        return string;
    }

    public static final byte[] toUTF8ByteArray(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        return byArray;
    }

    public static int toInt(byte[] byArray) {
        switch (byArray.length) {
            case 4: {
                return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
            }
            case 3: {
                return (byArray[0] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[2] & 0xFF;
            }
            case 2: {
                return (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
            }
        }
        return byArray[0] & 0xFF;
    }

    public static long toLong(byte[] byArray, int n, int n2) throws ErrorException {
        boolean bl;
        if (18 < n2) {
            String string = DataTypeUtilities.toUTF8String(byArray, n, n2);
            BigDecimal bigDecimal = new BigDecimal(string);
            return bigDecimal.longValue();
        }
        int n3 = n;
        char c = (char)byArray[n3];
        boolean bl2 = bl = '-' == c;
        if (bl) {
            c = (char)byArray[++n3];
            --n2;
        }
        long l = DataTypeUtilities.toMantissa(byArray, n3, n2);
        return bl ? -l : l;
    }

    public static short toShort(byte[] byArray, int n, int n2) throws ErrorException {
        return (short)DataTypeUtilities.toLong(byArray, n, n2);
    }

    public static int toInteger(byte[] byArray, int n, int n2) throws ErrorException {
        return (int)DataTypeUtilities.toLong(byArray, n, n2);
    }

    public static float toFloat(byte[] byArray, int n, int n2) throws ErrorException {
        return (float)DataTypeUtilities.toDouble(byArray, n, n2);
    }

    public static double toDouble(byte[] byArray, int n, int n2) throws ErrorException {
        NumericRepresentation numericRepresentation = null;
        try {
            numericRepresentation = DataTypeUtilities.buildTotalMantissa(byArray, n, n2);
            if (numericRepresentation.isSmallValue()) {
                if (numericRepresentation.isInfinity) {
                    if (numericRepresentation.isValueNegative) {
                        return Double.NEGATIVE_INFINITY;
                    }
                    return Double.POSITIVE_INFINITY;
                }
                if (numericRepresentation.isNan) {
                    return Double.NaN;
                }
                if (0 != numericRepresentation.totalExponent) {
                    if (numericRepresentation.totalExponent >= 18 || -numericRepresentation.totalExponent >= 18) {
                        return BigDecimal.valueOf(numericRepresentation.totalMantissaValue).scaleByPowerOfTen(numericRepresentation.totalExponent).doubleValue();
                    }
                    if (0 < numericRepresentation.totalExponent) {
                        return (double)numericRepresentation.totalMantissaValue * (double)POWERS_OF_10[numericRepresentation.totalExponent];
                    }
                    return (double)numericRepresentation.totalMantissaValue / (double)POWERS_OF_10[-numericRepresentation.totalExponent];
                }
                return numericRepresentation.totalMantissaValue;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return DataTypeUtilities.getBigDecimal(numericRepresentation).doubleValue();
    }

    public static BigDecimal toBigDecimal(byte[] byArray, int n, int n2) throws ErrorException {
        NumericRepresentation numericRepresentation = null;
        try {
            numericRepresentation = DataTypeUtilities.buildTotalMantissa(byArray, n, n2);
            BigDecimal bigDecimal = null;
            if (numericRepresentation.isSmallValue()) {
                bigDecimal = new BigDecimal(numericRepresentation.totalMantissaValue);
                if (0 != numericRepresentation.totalExponent) {
                    return bigDecimal.scaleByPowerOfTen(numericRepresentation.totalExponent);
                }
                return bigDecimal;
            }
            return DataTypeUtilities.getBigDecimal(numericRepresentation);
        }
        catch (Exception exception) {
            return DataTypeUtilities.getBigDecimal(numericRepresentation);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static NumericRepresentation parseNumericRepresentation(byte[] byArray, int n, int n2) {
        NumericRepresentation numericRepresentation = new NumericRepresentation();
        numericRepresentation.mantissaValueLength = n2--;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = 0;
        try {
            int n7;
            switch (byArray[n]) {
                case 45: {
                    numericRepresentation.isValueNegative = true;
                    --numericRepresentation.mantissaValueLength;
                    if (73 != byArray[++n]) break;
                    numericRepresentation.isInfinity = true;
                    return numericRepresentation;
                }
                case 73: {
                    numericRepresentation.isInfinity = true;
                    return numericRepresentation;
                }
                case 78: {
                    numericRepresentation.isNan = true;
                    return numericRepresentation;
                }
            }
            block15: for (n7 = n; n7 < n + n2; ++n7) {
                switch (byArray[n7]) {
                    case 46: {
                        numericRepresentation.hasFractionalValue = true;
                        n5 = n7 + 1;
                        n4 = n + n2 - n5;
                        numericRepresentation.mantissaValueLength = n7 - n;
                        break;
                    }
                    case 69: 
                    case 101: {
                        numericRepresentation.hasExponentValue = true;
                        n3 = n7 + 1;
                        n6 = n + n2 - n3;
                        if (!numericRepresentation.hasFractionalValue) {
                            numericRepresentation.mantissaValueLength = n7 - n;
                            break block15;
                        }
                        n4 = n7 - n5;
                        break block15;
                    }
                }
            }
            if (numericRepresentation.hasExponentValue) {
                switch (byArray[n3]) {
                    case 45: {
                        numericRepresentation.isExponentNegative = true;
                    }
                    case 43: {
                        ++n3;
                        --n6;
                        break;
                    }
                }
                numericRepresentation.exponentValue = (short)DataTypeUtilities.toMantissa(byArray, n3, n6);
            }
            if (numericRepresentation.hasFractionalValue) {
                numericRepresentation.fractionalSignificantDigits = (short)n4;
                n7 = n4 - 1 + n5;
                while (n5 <= n7 && 48 == byArray[n5]) {
                    numericRepresentation.fractionalLeadingZeros = (short)(numericRepresentation.fractionalLeadingZeros + 1);
                    --n4;
                    ++n5;
                }
            }
            if (numericRepresentation.hasExponentValue) {
                numericRepresentation.totalExponent = (short)((numericRepresentation.isExponentNegative ? -numericRepresentation.exponentValue : numericRepresentation.exponentValue) - numericRepresentation.fractionalSignificantDigits);
            } else if (numericRepresentation.hasFractionalValue) {
                numericRepresentation.totalExponent = -numericRepresentation.fractionalSignificantDigits;
            }
            if (numericRepresentation.fractionalSignificantDigits > 0 && numericRepresentation.fractionalLeadingZeros != numericRepresentation.fractionalSignificantDigits) {
                if (18 >= numericRepresentation.fractionalSignificantDigits) {
                    numericRepresentation.fractionalValue = DataTypeUtilities.toMantissa(byArray, n5, n4);
                } else {
                    numericRepresentation.fractionalElements = DataTypeUtilities.toMantissaElements(byArray, n5, n4);
                }
            }
            if (18 >= numericRepresentation.mantissaValueLength) {
                numericRepresentation.mantissaValue = DataTypeUtilities.toMantissa(byArray, n, numericRepresentation.mantissaValueLength);
                return numericRepresentation;
            }
            numericRepresentation.mantissaElements = DataTypeUtilities.toMantissaElements(byArray, n, numericRepresentation.mantissaValueLength);
            return numericRepresentation;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return numericRepresentation;
    }

    private static long[] toMantissaElements(byte[] byArray, int n, int n2) {
        int n3 = n2 / 18;
        if (n2 % 18 != 0) {
            ++n3;
        }
        long[] lArray = new long[n3];
        for (int i = 0; i < n3; ++i) {
            int n4 = 18 > n2 ? n2 : 18;
            lArray[i] = DataTypeUtilities.toMantissa(byArray, n, n4);
            n += 18;
            n2 -= 18;
        }
        return lArray;
    }

    private static BigDecimal getBigDecimal(NumericRepresentation numericRepresentation) {
        BigDecimal bigDecimal = null;
        BigDecimal bigDecimal2 = null;
        if (null != numericRepresentation && null != numericRepresentation.mantissaElements) {
            bigDecimal = DataTypeUtilities.toBigDecimalMantissaValue(numericRepresentation.mantissaElements, numericRepresentation.mantissaValueLength);
        } else if (null != numericRepresentation) {
            bigDecimal = new BigDecimal(numericRepresentation.mantissaValue);
        }
        if (null != numericRepresentation && numericRepresentation.hasFractionalValue) {
            bigDecimal2 = null != numericRepresentation && null != numericRepresentation.fractionalElements ? DataTypeUtilities.toBigDecimalMantissaValue(numericRepresentation.fractionalElements, numericRepresentation.fractionalSignificantDigits - numericRepresentation.fractionalLeadingZeros) : new BigDecimal(numericRepresentation.fractionalValue);
            bigDecimal = bigDecimal2.scaleByPowerOfTen(-numericRepresentation.fractionalSignificantDigits).add(bigDecimal);
        }
        if (null != numericRepresentation && numericRepresentation.hasExponentValue) {
            bigDecimal = bigDecimal.scaleByPowerOfTen(numericRepresentation.exponentValue);
        }
        if (null != numericRepresentation && numericRepresentation.isValueNegative) {
            bigDecimal = bigDecimal.negate();
        }
        return bigDecimal;
    }

    private static BigDecimal toBigDecimalMantissaValue(long[] lArray, int n) {
        BigDecimal bigDecimal = new BigDecimal(lArray[0]);
        for (int i = 1; i < lArray.length; ++i) {
            int n2 = 18 > (n -= 18) ? n : 18;
            bigDecimal = bigDecimal.scaleByPowerOfTen(n2).add(new BigDecimal(lArray[i]));
        }
        return bigDecimal;
    }

    private static NumericRepresentation buildTotalMantissa(byte[] byArray, int n, int n2) {
        NumericRepresentation numericRepresentation = DataTypeUtilities.parseNumericRepresentation(byArray, n, n2);
        if (numericRepresentation.isSmallValue()) {
            numericRepresentation.totalMantissaValue = numericRepresentation.hasFractionalValue ? numericRepresentation.mantissaValue * POWERS_OF_10[numericRepresentation.fractionalSignificantDigits] + numericRepresentation.fractionalValue : numericRepresentation.mantissaValue;
            if (numericRepresentation.isValueNegative) {
                numericRepresentation.totalMantissaValue = -numericRepresentation.totalMantissaValue;
            }
        }
        return numericRepresentation;
    }

    private static long toMantissa(byte[] byArray, int n, int n2) {
        return MANTISSA_CALCULATORS[n2].calculate(byArray, n, n2);
    }

    static {
        for (int i = 18; i > 0; --i) {
            DataTypeUtilities.POWERS_OF_10[i] = (long)Math.pow(10.0, i);
        }
        DataTypeUtilities.MANTISSA_CALCULATORS[1] = new CalculateMantissa_Length_1();
        DataTypeUtilities.MANTISSA_CALCULATORS[2] = new CalculateMantissa_Length_2();
        DataTypeUtilities.MANTISSA_CALCULATORS[3] = new CalculateMantissa_Length_3();
        DataTypeUtilities.MANTISSA_CALCULATORS[4] = new CalculateMantissa_Length_4();
        DataTypeUtilities.MANTISSA_CALCULATORS[5] = new CalculateMantissa_Length_5();
        DataTypeUtilities.MANTISSA_CALCULATORS[6] = new CalculateMantissa_Length_6();
        DataTypeUtilities.MANTISSA_CALCULATORS[7] = new CalculateMantissa_Length_7();
        DataTypeUtilities.MANTISSA_CALCULATORS[8] = new CalculateMantissa_Length_8();
        DataTypeUtilities.MANTISSA_CALCULATORS[9] = new CalculateMantissa_Length_9();
        DataTypeUtilities.MANTISSA_CALCULATORS[10] = new CalculateMantissa_Length_10();
        DataTypeUtilities.MANTISSA_CALCULATORS[11] = new CalculateMantissa_Length_11();
        DataTypeUtilities.MANTISSA_CALCULATORS[12] = new CalculateMantissa_Length_12();
        DataTypeUtilities.MANTISSA_CALCULATORS[13] = new CalculateMantissa_Length_13();
        DataTypeUtilities.MANTISSA_CALCULATORS[14] = new CalculateMantissa_Length_14();
        DataTypeUtilities.MANTISSA_CALCULATORS[15] = new CalculateMantissa_Length_15();
        DataTypeUtilities.MANTISSA_CALCULATORS[16] = new CalculateMantissa_Length_16();
        DataTypeUtilities.MANTISSA_CALCULATORS[17] = new CalculateMantissa_Length_17();
        DataTypeUtilities.MANTISSA_CALCULATORS[18] = new CalculateMantissa_Length_18();
    }

    private static class CalculateMantissa_Length_1
    extends CalculateMantissa {
        private CalculateMantissa_Length_1() {
        }

        @Override
        public long calculate(byte[] byArray, int n, int n2) {
            return byArray[n] - 48;
        }
    }

    private static class CalculateMantissa_Length_2
    extends CalculateMantissa {
        private CalculateMantissa_Length_2() {
        }

        @Override
        public long calculate(byte[] byArray, int n, int n2) {
            if (0 == n) {
                return (long)(byArray[0] - 48) * POWERS_OF_10[1] + (long)(byArray[1] - 48);
            }
            return (long)(byArray[n] - 48) * POWERS_OF_10[1] + (long)(byArray[n + 1] - 48);
        }
    }

    private static class CalculateMantissa_Length_3
    extends CalculateMantissa {
        private CalculateMantissa_Length_3() {
        }

        @Override
        public long calculate(byte[] byArray, int n, int n2) {
            if (0 == n) {
                return (long)(byArray[0] - 48) * POWERS_OF_10[2] + (long)(byArray[1] - 48) * POWERS_OF_10[1] + (long)(byArray[2] - 48);
            }
            return (long)(byArray[n] - 48) * POWERS_OF_10[2] + (long)(byArray[n + 1] - 48) * POWERS_OF_10[1] + (long)(byArray[n + 2] - 48);
        }
    }

    private static class CalculateMantissa_Length_4
    extends CalculateMantissa {
        private CalculateMantissa_Length_4() {
        }

        @Override
        public long calculate(byte[] byArray, int n, int n2) {
            if (0 == n) {
                return (long)(byArray[0] - 48) * POWERS_OF_10[3] + (long)(byArray[1] - 48) * POWERS_OF_10[2] + (long)(byArray[2] - 48) * POWERS_OF_10[1] + (long)(byArray[3] - 48);
            }
            return (long)(byArray[n] - 48) * POWERS_OF_10[3] + (long)(byArray[n + 1] - 48) * POWERS_OF_10[2] + (long)(byArray[n + 2] - 48) * POWERS_OF_10[1] + (long)(byArray[n + 3] - 48);
        }
    }

    private static class CalculateMantissa_Length_5
    extends CalculateMantissa {
        private CalculateMantissa_Length_5() {
        }

        @Override
        public long calculate(byte[] byArray, int n, int n2) {
            if (0 == n) {
                return (long)(byArray[0] - 48) * POWERS_OF_10[4] + (long)(byArray[1] - 48) * POWERS_OF_10[3] + (long)(byArray[2] - 48) * POWERS_OF_10[2] + (long)(byArray[3] - 48) * POWERS_OF_10[1] + (long)(byArray[4] - 48);
            }
            return (long)(byArray[n] - 48) * POWERS_OF_10[4] + (long)(byArray[n + 1] - 48) * POWERS_OF_10[3] + (long)(byArray[n + 2] - 48) * POWERS_OF_10[2] + (long)(byArray[n + 3] - 48) * POWERS_OF_10[1] + (long)(byArray[n + 4] - 48);
        }
    }

    private static class CalculateMantissa_Length_6
    extends CalculateMantissa {
        private CalculateMantissa_Length_6() {
        }

        @Override
        public long calculate(byte[] byArray, int n, int n2) {
            if (0 == n) {
                return (long)(byArray[0] - 48) * POWERS_OF_10[5] + (long)(byArray[1] - 48) * POWERS_OF_10[4] + (long)(byArray[2] - 48) * POWERS_OF_10[3] + (long)(byArray[3] - 48) * POWERS_OF_10[2] + (long)(byArray[4] - 48) * POWERS_OF_10[1] + (long)(byArray[5] - 48);
            }
            return (long)(byArray[n] - 48) * POWERS_OF_10[5] + (long)(byArray[n + 1] - 48) * POWERS_OF_10[4] + (long)(byArray[n + 2] - 48) * POWERS_OF_10[3] + (long)(byArray[n + 3] - 48) * POWERS_OF_10[2] + (long)(byArray[n + 4] - 48) * POWERS_OF_10[1] + (long)(byArray[n + 5] - 48);
        }
    }

    private static class CalculateMantissa_Length_7
    extends CalculateMantissa {
        private CalculateMantissa_Length_7() {
        }

        @Override
        public long calculate(byte[] byArray, int n, int n2) {
            if (0 == n) {
                return (long)(byArray[0] - 48) * POWERS_OF_10[6] + (long)(byArray[1] - 48) * POWERS_OF_10[5] + (long)(byArray[2] - 48) * POWERS_OF_10[4] + (long)(byArray[3] - 48) * POWERS_OF_10[3] + (long)(byArray[4] - 48) * POWERS_OF_10[2] + (long)(byArray[5] - 48) * POWERS_OF_10[1] + (long)(byArray[6] - 48);
            }
            return (long)(byArray[n] - 48) * POWERS_OF_10[6] + (long)(byArray[n + 1] - 48) * POWERS_OF_10[5] + (long)(byArray[n + 2] - 48) * POWERS_OF_10[4] + (long)(byArray[n + 3] - 48) * POWERS_OF_10[3] + (long)(byArray[n + 4] - 48) * POWERS_OF_10[2] + (long)(byArray[n + 5] - 48) * POWERS_OF_10[1] + (long)(byArray[n + 6] - 48);
        }
    }

    private static class CalculateMantissa_Length_8
    extends CalculateMantissa {
        private CalculateMantissa_Length_8() {
        }

        @Override
        public long calculate(byte[] byArray, int n, int n2) {
            if (0 == n) {
                return (long)(byArray[0] - 48) * POWERS_OF_10[7] + (long)(byArray[1] - 48) * POWERS_OF_10[6] + (long)(byArray[2] - 48) * POWERS_OF_10[5] + (long)(byArray[3] - 48) * POWERS_OF_10[4] + (long)(byArray[4] - 48) * POWERS_OF_10[3] + (long)(byArray[5] - 48) * POWERS_OF_10[2] + (long)(byArray[6] - 48) * POWERS_OF_10[1] + (long)(byArray[7] - 48);
            }
            return (long)(byArray[n] - 48) * POWERS_OF_10[7] + (long)(byArray[n + 1] - 48) * POWERS_OF_10[6] + (long)(byArray[n + 2] - 48) * POWERS_OF_10[5] + (long)(byArray[n + 3] - 48) * POWERS_OF_10[4] + (long)(byArray[n + 4] - 48) * POWERS_OF_10[3] + (long)(byArray[n + 5] - 48) * POWERS_OF_10[2] + (long)(byArray[n + 6] - 48) * POWERS_OF_10[1] + (long)(byArray[n + 7] - 48);
        }
    }

    private static class CalculateMantissa_Length_9
    extends CalculateMantissa {
        private CalculateMantissa_Length_9() {
        }

        @Override
        public long calculate(byte[] byArray, int n, int n2) {
            if (0 == n) {
                return (long)(byArray[0] - 48) * POWERS_OF_10[8] + (long)(byArray[1] - 48) * POWERS_OF_10[7] + (long)(byArray[2] - 48) * POWERS_OF_10[6] + (long)(byArray[3] - 48) * POWERS_OF_10[5] + (long)(byArray[4] - 48) * POWERS_OF_10[4] + (long)(byArray[5] - 48) * POWERS_OF_10[3] + (long)(byArray[6] - 48) * POWERS_OF_10[2] + (long)(byArray[7] - 48) * POWERS_OF_10[1] + (long)(byArray[8] - 48);
            }
            return (long)(byArray[n] - 48) * POWERS_OF_10[8] + (long)(byArray[n + 1] - 48) * POWERS_OF_10[7] + (long)(byArray[n + 2] - 48) * POWERS_OF_10[6] + (long)(byArray[n + 3] - 48) * POWERS_OF_10[5] + (long)(byArray[n + 4] - 48) * POWERS_OF_10[4] + (long)(byArray[n + 5] - 48) * POWERS_OF_10[3] + (long)(byArray[n + 6] - 48) * POWERS_OF_10[2] + (long)(byArray[n + 7] - 48) * POWERS_OF_10[1] + (long)(byArray[n + 8] - 48);
        }
    }

    private static class CalculateMantissa_Length_10
    extends CalculateMantissa {
        private CalculateMantissa_Length_10() {
        }

        @Override
        public long calculate(byte[] byArray, int n, int n2) {
            if (0 == n) {
                return (long)(byArray[0] - 48) * POWERS_OF_10[9] + (long)(byArray[1] - 48) * POWERS_OF_10[8] + (long)(byArray[2] - 48) * POWERS_OF_10[7] + (long)(byArray[3] - 48) * POWERS_OF_10[6] + (long)(byArray[4] - 48) * POWERS_OF_10[5] + (long)(byArray[5] - 48) * POWERS_OF_10[4] + (long)(byArray[6] - 48) * POWERS_OF_10[3] + (long)(byArray[7] - 48) * POWERS_OF_10[2] + (long)(byArray[8] - 48) * POWERS_OF_10[1] + (long)(byArray[9] - 48);
            }
            return (long)(byArray[n] - 48) * POWERS_OF_10[9] + (long)(byArray[n + 1] - 48) * POWERS_OF_10[8] + (long)(byArray[n + 2] - 48) * POWERS_OF_10[7] + (long)(byArray[n + 3] - 48) * POWERS_OF_10[6] + (long)(byArray[n + 4] - 48) * POWERS_OF_10[5] + (long)(byArray[n + 5] - 48) * POWERS_OF_10[4] + (long)(byArray[n + 6] - 48) * POWERS_OF_10[3] + (long)(byArray[n + 7] - 48) * POWERS_OF_10[2] + (long)(byArray[n + 8] - 48) * POWERS_OF_10[1] + (long)(byArray[n + 9] - 48);
        }
    }

    private static class CalculateMantissa_Length_11
    extends CalculateMantissa {
        private CalculateMantissa_Length_11() {
        }

        @Override
        public long calculate(byte[] byArray, int n, int n2) {
            if (0 == n) {
                return (long)(byArray[0] - 48) * POWERS_OF_10[10] + (long)(byArray[1] - 48) * POWERS_OF_10[9] + (long)(byArray[2] - 48) * POWERS_OF_10[8] + (long)(byArray[3] - 48) * POWERS_OF_10[7] + (long)(byArray[4] - 48) * POWERS_OF_10[6] + (long)(byArray[5] - 48) * POWERS_OF_10[5] + (long)(byArray[6] - 48) * POWERS_OF_10[4] + (long)(byArray[7] - 48) * POWERS_OF_10[3] + (long)(byArray[8] - 48) * POWERS_OF_10[2] + (long)(byArray[9] - 48) * POWERS_OF_10[1] + (long)(byArray[10] - 48);
            }
            return (long)(byArray[n] - 48) * POWERS_OF_10[10] + (long)(byArray[n + 1] - 48) * POWERS_OF_10[9] + (long)(byArray[n + 2] - 48) * POWERS_OF_10[8] + (long)(byArray[n + 3] - 48) * POWERS_OF_10[7] + (long)(byArray[n + 4] - 48) * POWERS_OF_10[6] + (long)(byArray[n + 5] - 48) * POWERS_OF_10[5] + (long)(byArray[n + 6] - 48) * POWERS_OF_10[4] + (long)(byArray[n + 7] - 48) * POWERS_OF_10[3] + (long)(byArray[n + 8] - 48) * POWERS_OF_10[2] + (long)(byArray[n + 9] - 48) * POWERS_OF_10[1] + (long)(byArray[n + 10] - 48);
        }
    }

    private static class CalculateMantissa_Length_12
    extends CalculateMantissa {
        private CalculateMantissa_Length_12() {
        }

        @Override
        public long calculate(byte[] byArray, int n, int n2) {
            if (0 == n) {
                return (long)(byArray[0] - 48) * POWERS_OF_10[11] + (long)(byArray[1] - 48) * POWERS_OF_10[10] + (long)(byArray[2] - 48) * POWERS_OF_10[9] + (long)(byArray[3] - 48) * POWERS_OF_10[8] + (long)(byArray[4] - 48) * POWERS_OF_10[7] + (long)(byArray[5] - 48) * POWERS_OF_10[6] + (long)(byArray[6] - 48) * POWERS_OF_10[5] + (long)(byArray[7] - 48) * POWERS_OF_10[4] + (long)(byArray[8] - 48) * POWERS_OF_10[3] + (long)(byArray[9] - 48) * POWERS_OF_10[2] + (long)(byArray[10] - 48) * POWERS_OF_10[1] + (long)(byArray[11] - 48);
            }
            return (long)(byArray[n] - 48) * POWERS_OF_10[11] + (long)(byArray[n + 1] - 48) * POWERS_OF_10[10] + (long)(byArray[n + 2] - 48) * POWERS_OF_10[9] + (long)(byArray[n + 3] - 48) * POWERS_OF_10[8] + (long)(byArray[n + 4] - 48) * POWERS_OF_10[7] + (long)(byArray[n + 5] - 48) * POWERS_OF_10[6] + (long)(byArray[n + 6] - 48) * POWERS_OF_10[5] + (long)(byArray[n + 7] - 48) * POWERS_OF_10[4] + (long)(byArray[n + 8] - 48) * POWERS_OF_10[3] + (long)(byArray[n + 9] - 48) * POWERS_OF_10[2] + (long)(byArray[n + 10] - 48) * POWERS_OF_10[1] + (long)(byArray[n + 11] - 48);
        }
    }

    private static class CalculateMantissa_Length_13
    extends CalculateMantissa {
        private CalculateMantissa_Length_13() {
        }

        @Override
        public long calculate(byte[] byArray, int n, int n2) {
            if (0 == n) {
                return (long)(byArray[0] - 48) * POWERS_OF_10[12] + (long)(byArray[1] - 48) * POWERS_OF_10[11] + (long)(byArray[2] - 48) * POWERS_OF_10[10] + (long)(byArray[3] - 48) * POWERS_OF_10[9] + (long)(byArray[4] - 48) * POWERS_OF_10[8] + (long)(byArray[5] - 48) * POWERS_OF_10[7] + (long)(byArray[6] - 48) * POWERS_OF_10[6] + (long)(byArray[7] - 48) * POWERS_OF_10[5] + (long)(byArray[8] - 48) * POWERS_OF_10[4] + (long)(byArray[9] - 48) * POWERS_OF_10[3] + (long)(byArray[10] - 48) * POWERS_OF_10[2] + (long)(byArray[11] - 48) * POWERS_OF_10[1] + (long)(byArray[12] - 48);
            }
            return (long)(byArray[n] - 48) * POWERS_OF_10[12] + (long)(byArray[n + 1] - 48) * POWERS_OF_10[11] + (long)(byArray[n + 2] - 48) * POWERS_OF_10[10] + (long)(byArray[n + 3] - 48) * POWERS_OF_10[9] + (long)(byArray[n + 4] - 48) * POWERS_OF_10[8] + (long)(byArray[n + 5] - 48) * POWERS_OF_10[7] + (long)(byArray[n + 6] - 48) * POWERS_OF_10[6] + (long)(byArray[n + 7] - 48) * POWERS_OF_10[5] + (long)(byArray[n + 8] - 48) * POWERS_OF_10[4] + (long)(byArray[n + 9] - 48) * POWERS_OF_10[3] + (long)(byArray[n + 10] - 48) * POWERS_OF_10[2] + (long)(byArray[n + 11] - 48) * POWERS_OF_10[1] + (long)(byArray[n + 12] - 48);
        }
    }

    private static class CalculateMantissa_Length_14
    extends CalculateMantissa {
        private CalculateMantissa_Length_14() {
        }

        @Override
        public long calculate(byte[] byArray, int n, int n2) {
            if (0 == n) {
                return (long)(byArray[0] - 48) * POWERS_OF_10[13] + (long)(byArray[1] - 48) * POWERS_OF_10[12] + (long)(byArray[2] - 48) * POWERS_OF_10[11] + (long)(byArray[3] - 48) * POWERS_OF_10[10] + (long)(byArray[4] - 48) * POWERS_OF_10[9] + (long)(byArray[5] - 48) * POWERS_OF_10[8] + (long)(byArray[6] - 48) * POWERS_OF_10[7] + (long)(byArray[7] - 48) * POWERS_OF_10[6] + (long)(byArray[8] - 48) * POWERS_OF_10[5] + (long)(byArray[9] - 48) * POWERS_OF_10[4] + (long)(byArray[10] - 48) * POWERS_OF_10[3] + (long)(byArray[11] - 48) * POWERS_OF_10[2] + (long)(byArray[12] - 48) * POWERS_OF_10[1] + (long)(byArray[13] - 48);
            }
            return (long)(byArray[n] - 48) * POWERS_OF_10[13] + (long)(byArray[n + 1] - 48) * POWERS_OF_10[12] + (long)(byArray[n + 2] - 48) * POWERS_OF_10[11] + (long)(byArray[n + 3] - 48) * POWERS_OF_10[10] + (long)(byArray[n + 4] - 48) * POWERS_OF_10[9] + (long)(byArray[n + 5] - 48) * POWERS_OF_10[8] + (long)(byArray[n + 6] - 48) * POWERS_OF_10[7] + (long)(byArray[n + 7] - 48) * POWERS_OF_10[6] + (long)(byArray[n + 8] - 48) * POWERS_OF_10[5] + (long)(byArray[n + 9] - 48) * POWERS_OF_10[4] + (long)(byArray[n + 10] - 48) * POWERS_OF_10[3] + (long)(byArray[n + 11] - 48) * POWERS_OF_10[2] + (long)(byArray[n + 12] - 48) * POWERS_OF_10[1] + (long)(byArray[n + 13] - 48);
        }
    }

    private static class CalculateMantissa_Length_15
    extends CalculateMantissa {
        private CalculateMantissa_Length_15() {
        }

        @Override
        public long calculate(byte[] byArray, int n, int n2) {
            if (0 == n) {
                return (long)(byArray[0] - 48) * POWERS_OF_10[14] + (long)(byArray[1] - 48) * POWERS_OF_10[13] + (long)(byArray[2] - 48) * POWERS_OF_10[12] + (long)(byArray[3] - 48) * POWERS_OF_10[11] + (long)(byArray[4] - 48) * POWERS_OF_10[10] + (long)(byArray[5] - 48) * POWERS_OF_10[9] + (long)(byArray[6] - 48) * POWERS_OF_10[8] + (long)(byArray[7] - 48) * POWERS_OF_10[7] + (long)(byArray[8] - 48) * POWERS_OF_10[6] + (long)(byArray[9] - 48) * POWERS_OF_10[5] + (long)(byArray[10] - 48) * POWERS_OF_10[4] + (long)(byArray[11] - 48) * POWERS_OF_10[3] + (long)(byArray[12] - 48) * POWERS_OF_10[2] + (long)(byArray[13] - 48) * POWERS_OF_10[1] + (long)(byArray[14] - 48);
            }
            return (long)(byArray[n] - 48) * POWERS_OF_10[14] + (long)(byArray[n + 1] - 48) * POWERS_OF_10[13] + (long)(byArray[n + 2] - 48) * POWERS_OF_10[12] + (long)(byArray[n + 3] - 48) * POWERS_OF_10[11] + (long)(byArray[n + 4] - 48) * POWERS_OF_10[10] + (long)(byArray[n + 5] - 48) * POWERS_OF_10[9] + (long)(byArray[n + 6] - 48) * POWERS_OF_10[8] + (long)(byArray[n + 7] - 48) * POWERS_OF_10[7] + (long)(byArray[n + 8] - 48) * POWERS_OF_10[6] + (long)(byArray[n + 9] - 48) * POWERS_OF_10[5] + (long)(byArray[n + 10] - 48) * POWERS_OF_10[4] + (long)(byArray[n + 11] - 48) * POWERS_OF_10[3] + (long)(byArray[n + 12] - 48) * POWERS_OF_10[2] + (long)(byArray[n + 13] - 48) * POWERS_OF_10[1] + (long)(byArray[n + 14] - 48);
        }
    }

    private static class CalculateMantissa_Length_16
    extends CalculateMantissa {
        private CalculateMantissa_Length_16() {
        }

        @Override
        public long calculate(byte[] byArray, int n, int n2) {
            if (0 == n) {
                return (long)(byArray[0] - 48) * POWERS_OF_10[15] + (long)(byArray[1] - 48) * POWERS_OF_10[14] + (long)(byArray[2] - 48) * POWERS_OF_10[13] + (long)(byArray[3] - 48) * POWERS_OF_10[12] + (long)(byArray[4] - 48) * POWERS_OF_10[11] + (long)(byArray[5] - 48) * POWERS_OF_10[10] + (long)(byArray[6] - 48) * POWERS_OF_10[9] + (long)(byArray[7] - 48) * POWERS_OF_10[8] + (long)(byArray[8] - 48) * POWERS_OF_10[7] + (long)(byArray[9] - 48) * POWERS_OF_10[6] + (long)(byArray[10] - 48) * POWERS_OF_10[5] + (long)(byArray[11] - 48) * POWERS_OF_10[4] + (long)(byArray[12] - 48) * POWERS_OF_10[3] + (long)(byArray[13] - 48) * POWERS_OF_10[2] + (long)(byArray[14] - 48) * POWERS_OF_10[1] + (long)(byArray[15] - 48);
            }
            return (long)(byArray[n] - 48) * POWERS_OF_10[15] + (long)(byArray[n + 1] - 48) * POWERS_OF_10[14] + (long)(byArray[n + 2] - 48) * POWERS_OF_10[13] + (long)(byArray[n + 3] - 48) * POWERS_OF_10[12] + (long)(byArray[n + 4] - 48) * POWERS_OF_10[11] + (long)(byArray[n + 5] - 48) * POWERS_OF_10[10] + (long)(byArray[n + 6] - 48) * POWERS_OF_10[9] + (long)(byArray[n + 7] - 48) * POWERS_OF_10[8] + (long)(byArray[n + 8] - 48) * POWERS_OF_10[7] + (long)(byArray[n + 9] - 48) * POWERS_OF_10[6] + (long)(byArray[n + 10] - 48) * POWERS_OF_10[5] + (long)(byArray[n + 11] - 48) * POWERS_OF_10[4] + (long)(byArray[n + 12] - 48) * POWERS_OF_10[3] + (long)(byArray[n + 13] - 48) * POWERS_OF_10[2] + (long)(byArray[n + 14] - 48) * POWERS_OF_10[1] + (long)(byArray[n + 15] - 48);
        }
    }

    private static class CalculateMantissa_Length_17
    extends CalculateMantissa {
        private CalculateMantissa_Length_17() {
        }

        @Override
        public long calculate(byte[] byArray, int n, int n2) {
            if (0 == n) {
                return (long)(byArray[0] - 48) * POWERS_OF_10[16] + (long)(byArray[1] - 48) * POWERS_OF_10[15] + (long)(byArray[2] - 48) * POWERS_OF_10[14] + (long)(byArray[3] - 48) * POWERS_OF_10[13] + (long)(byArray[4] - 48) * POWERS_OF_10[12] + (long)(byArray[5] - 48) * POWERS_OF_10[11] + (long)(byArray[6] - 48) * POWERS_OF_10[10] + (long)(byArray[7] - 48) * POWERS_OF_10[9] + (long)(byArray[8] - 48) * POWERS_OF_10[8] + (long)(byArray[9] - 48) * POWERS_OF_10[7] + (long)(byArray[10] - 48) * POWERS_OF_10[6] + (long)(byArray[11] - 48) * POWERS_OF_10[5] + (long)(byArray[12] - 48) * POWERS_OF_10[4] + (long)(byArray[13] - 48) * POWERS_OF_10[3] + (long)(byArray[14] - 48) * POWERS_OF_10[2] + (long)(byArray[15] - 48) * POWERS_OF_10[1] + (long)(byArray[16] - 48);
            }
            return (long)(byArray[n] - 48) * POWERS_OF_10[16] + (long)(byArray[n + 1] - 48) * POWERS_OF_10[15] + (long)(byArray[n + 2] - 48) * POWERS_OF_10[14] + (long)(byArray[n + 3] - 48) * POWERS_OF_10[13] + (long)(byArray[n + 4] - 48) * POWERS_OF_10[12] + (long)(byArray[n + 5] - 48) * POWERS_OF_10[11] + (long)(byArray[n + 6] - 48) * POWERS_OF_10[10] + (long)(byArray[n + 7] - 48) * POWERS_OF_10[9] + (long)(byArray[n + 8] - 48) * POWERS_OF_10[8] + (long)(byArray[n + 9] - 48) * POWERS_OF_10[7] + (long)(byArray[n + 10] - 48) * POWERS_OF_10[6] + (long)(byArray[n + 11] - 48) * POWERS_OF_10[5] + (long)(byArray[n + 12] - 48) * POWERS_OF_10[4] + (long)(byArray[n + 13] - 48) * POWERS_OF_10[3] + (long)(byArray[n + 14] - 48) * POWERS_OF_10[2] + (long)(byArray[n + 15] - 48) * POWERS_OF_10[1] + (long)(byArray[n + 16] - 48);
        }
    }

    private static class CalculateMantissa_Length_18
    extends CalculateMantissa {
        private CalculateMantissa_Length_18() {
        }

        @Override
        public long calculate(byte[] byArray, int n, int n2) {
            if (0 == n) {
                return (long)(byArray[0] - 48) * POWERS_OF_10[17] + (long)(byArray[1] - 48) * POWERS_OF_10[16] + (long)(byArray[2] - 48) * POWERS_OF_10[15] + (long)(byArray[3] - 48) * POWERS_OF_10[14] + (long)(byArray[4] - 48) * POWERS_OF_10[13] + (long)(byArray[5] - 48) * POWERS_OF_10[12] + (long)(byArray[6] - 48) * POWERS_OF_10[11] + (long)(byArray[7] - 48) * POWERS_OF_10[10] + (long)(byArray[8] - 48) * POWERS_OF_10[9] + (long)(byArray[9] - 48) * POWERS_OF_10[8] + (long)(byArray[10] - 48) * POWERS_OF_10[7] + (long)(byArray[11] - 48) * POWERS_OF_10[6] + (long)(byArray[12] - 48) * POWERS_OF_10[5] + (long)(byArray[13] - 48) * POWERS_OF_10[4] + (long)(byArray[14] - 48) * POWERS_OF_10[3] + (long)(byArray[15] - 48) * POWERS_OF_10[2] + (long)(byArray[16] - 48) * POWERS_OF_10[1] + (long)(byArray[17] - 48);
            }
            return (long)(byArray[n] - 48) * POWERS_OF_10[17] + (long)(byArray[n + 1] - 48) * POWERS_OF_10[16] + (long)(byArray[n + 2] - 48) * POWERS_OF_10[15] + (long)(byArray[n + 3] - 48) * POWERS_OF_10[14] + (long)(byArray[n + 4] - 48) * POWERS_OF_10[13] + (long)(byArray[n + 5] - 48) * POWERS_OF_10[12] + (long)(byArray[n + 6] - 48) * POWERS_OF_10[11] + (long)(byArray[n + 7] - 48) * POWERS_OF_10[10] + (long)(byArray[n + 8] - 48) * POWERS_OF_10[9] + (long)(byArray[n + 9] - 48) * POWERS_OF_10[8] + (long)(byArray[n + 10] - 48) * POWERS_OF_10[7] + (long)(byArray[n + 11] - 48) * POWERS_OF_10[6] + (long)(byArray[n + 12] - 48) * POWERS_OF_10[5] + (long)(byArray[n + 13] - 48) * POWERS_OF_10[4] + (long)(byArray[n + 14] - 48) * POWERS_OF_10[3] + (long)(byArray[n + 15] - 48) * POWERS_OF_10[2] + (long)(byArray[n + 16] - 48) * POWERS_OF_10[1] + (long)(byArray[n + 17] - 48);
        }
    }

    private static class NumericRepresentation {
        boolean isValueNegative;
        long mantissaValue;
        long[] mantissaElements;
        int mantissaValueLength;
        boolean hasFractionalValue = false;
        short fractionalSignificantDigits = 0;
        short fractionalLeadingZeros = 0;
        long fractionalValue;
        long[] fractionalElements;
        boolean hasExponentValue = false;
        boolean isExponentNegative = false;
        short exponentValue = 0;
        boolean isInfinity = false;
        boolean isNan = false;
        long totalMantissaValue;
        short totalExponent = 0;

        private NumericRepresentation() {
        }

        public boolean isSmallValue() {
            return 18 > this.mantissaValueLength + (this.fractionalSignificantDigits != -1 ? this.fractionalSignificantDigits : (short)0);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (null != this.mantissaElements) {
                stringBuilder.append("{");
                for (Object object : (StringBuilder)this.mantissaElements) {
                    stringBuilder.append((long)object);
                    stringBuilder.append(",");
                }
                stringBuilder.append("}");
            }
            StringBuilder stringBuilder2 = new StringBuilder();
            if (null != this.fractionalElements) {
                stringBuilder2.append("{");
                for (long l : this.fractionalElements) {
                    stringBuilder2.append(l);
                    stringBuilder2.append(",");
                }
                stringBuilder2.append("}");
            }
            return "isValueNegative: " + this.isValueNegative + "\nmantissaValue: " + this.mantissaValue + "\nmantissaElements :" + stringBuilder + "\nhasFractionalValue: " + this.hasFractionalValue + "\nfractionalSignificantDigits: " + this.fractionalSignificantDigits + "\nfractionalLeadingZeros: " + this.fractionalLeadingZeros + "\nfractionalValue: " + this.fractionalValue + "\nfractionalElements: " + stringBuilder2 + "\nhasExponentValue: " + this.hasExponentValue + "\nisExponentNegative: " + this.isExponentNegative + "\nexponentValue: " + this.exponentValue + "\ntotalMantissaValue: " + this.totalMantissaValue + "\ntotalMantissaValue: " + this.totalExponent;
        }
    }

    static abstract class CalculateMantissa {
        CalculateMantissa() {
        }

        public abstract long calculate(byte[] var1, int var2, int var3);
    }
}

