/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.jdbc.utils;

import com.mapr.drill.jdbc.utils.DSEncryptionProperties;
import com.mapr.drill.jdbc.utils.DSEncryptionUtils;
import com.mapr.drill.jdbc.utils.DSStringCache;
import com.mapr.drill.support.ILogger;
import com.mapr.drill.support.LogUtilities;
import com.mapr.drill.support.exceptions.ErrorException;

public class DSStringEncryptedCache
extends DSStringCache {
    private DSStringCache m_cache;
    private DSEncryptionProperties m_encryptProp;

    public DSStringEncryptedCache(ILogger iLogger, DSStringCache dSStringCache, boolean bl, boolean bl2, DSEncryptionProperties dSEncryptionProperties) {
        super(iLogger, bl, bl2);
        this.m_cache = dSStringCache;
        this.m_encryptProp = dSEncryptionProperties;
    }

    @Override
    public String getValue(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (string == null) {
            return null;
        }
        String string2 = this.m_cache.getValue(string);
        if (string2 == null) {
            return null;
        }
        String string3 = DSEncryptionUtils.DecryptFromHex(string2, this.m_encryptProp, this.m_logger);
        return string3;
    }

    @Override
    public long getExpiry(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_cache.getExpiry(string);
    }

    @Override
    public boolean setValue(String string, String string2, long l) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        String string3 = DSEncryptionUtils.EncryptFromHex(string2, this.m_encryptProp, this.m_logger);
        return this.m_cache.setValue(string, string3, l);
    }
}

