/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.jdbc.utils;

import com.mapr.drill.jdbc.core.DSDriver;
import com.mapr.drill.jdbc.exceptions.CommonJDBCMessageKey;
import com.mapr.drill.support.ILogger;
import com.mapr.drill.support.LogUtilities;
import com.mapr.drill.support.exceptions.ErrorException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class DSEncryptionProperties {
    private static final String CIPHER_TRANSFORMATION = "AES/GCM/NoPadding";
    private static final String SECRET_KEY_ALGORITHM = "AES";
    private static final int GCM_TLEN_SIZE = 128;
    private static final int EXPECTED_KEY_LENGTH = 16;
    private static final String CHAR_TO_APPEND_KEY = "*";
    public String m_key;
    public String m_iv;
    public Cipher m_aesCipher_encrypt;
    public Cipher m_aesCipher_decrypt;
    public Boolean m_useDefaultIV;

    public DSEncryptionProperties(String string, String string2, ILogger iLogger, Boolean bl) throws ErrorException {
        this.m_key = string;
        this.m_iv = string2;
        this.m_useDefaultIV = bl;
        this.m_aesCipher_encrypt = this.initCipher(1, iLogger);
        this.m_aesCipher_decrypt = this.initCipher(2, iLogger);
    }

    private Cipher initCipher(int n, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(Base64.getEncoder().encode(this.trimEncryptionKey(this.m_key).getBytes()), SECRET_KEY_ALGORITHM);
            Cipher cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
            if (this.m_useDefaultIV.booleanValue()) {
                cipher.init(n, (Key)secretKeySpec, new GCMParameterSpec(128, new byte[cipher.getBlockSize()]));
            } else {
                cipher.init(n, (Key)secretKeySpec, new GCMParameterSpec(128, Base64.getDecoder().decode(this.m_iv)));
            }
            return cipher;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILED_ENCRYPTION_INITIALIZATION.name(), generalSecurityException.getMessage(), generalSecurityException.getCause());
            throw errorException;
        }
    }

    private String trimEncryptionKey(String string) {
        if (null == string) {
            string = "";
        }
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(string);
        if (16 > n) {
            for (int i = n; i < 16; ++i) {
                stringBuilder.append(CHAR_TO_APPEND_KEY);
            }
            return stringBuilder.toString();
        }
        if (16 < n) {
            return stringBuilder.substring(0, 16);
        }
        return string;
    }
}

