/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.jdbc.jdbc42;

import com.mapr.drill.dsi.dataengine.interfaces.IColumn;
import com.mapr.drill.dsi.dataengine.interfaces.IResultSet;
import com.mapr.drill.dsi.dataengine.utilities.DataWrapper;
import com.mapr.drill.dsi.dataengine.utilities.TypeMetadata;
import com.mapr.drill.dsi.exceptions.IncorrectTypeException;
import com.mapr.drill.exceptions.ExceptionConverter;
import com.mapr.drill.exceptions.JDBCMessageKey;
import com.mapr.drill.jdbc.common.SStatement;
import com.mapr.drill.jdbc.jdbc41.S41UpdatableForwardResultSet;
import com.mapr.drill.jdbc.jdbc42.S42ResultSetMetaData;
import com.mapr.drill.support.ILogger;
import com.mapr.drill.support.IWarningListener;
import com.mapr.drill.support.LogUtilities;
import com.mapr.drill.support.exceptions.ExceptionType;
import com.mapr.drill.utilities.JDBCVersion;
import com.mapr.drill.utilities.conversion.TypeConverter;
import java.math.BigDecimal;
import java.sql.JDBCType;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.ArrayList;

public class S42UpdatableForwardResultSet
extends S41UpdatableForwardResultSet {
    public S42UpdatableForwardResultSet(SStatement sStatement, IResultSet iResultSet, ILogger iLogger) throws SQLException {
        super(sStatement, iResultSet, iLogger);
        this.m_jdbcVersion = JDBCVersion.JDBC42;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            this.initializeColumnsIfNeeded();
            if (null == this.getResultSetMetaData()) {
                this.initializeResultSetColumns();
                this.setResultSetMetadata(new S42ResultSetMetaData(this.getResultSetColumns(), this.getLogger(), this.getWarningListener()));
            }
            return this.getResultSetMetaData();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public void updateObject(int n, Object object, SQLType sQLType) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, object, sQLType);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(n);
            this.clearStream(n);
            TypeMetadata typeMetadata = ((IColumn)((ArrayList)((IResultSet)this.m_resultSet).getSelectColumns()).get(n - 1)).getTypeMetadata();
            int n2 = sQLType.getVendorTypeNumber();
            DataWrapper dataWrapper = new DataWrapper();
            if (null == object) {
                dataWrapper.setNull(typeMetadata.getType());
            } else {
                try {
                    DataWrapper dataWrapper2 = new DataWrapper();
                    dataWrapper2.setData(TypeConverter.getSqlType(object), object);
                    dataWrapper = TypeConverter.toType(dataWrapper2, object, n2, this.m_warningListener, this.getParentConnection());
                    dataWrapper = TypeConverter.toType(dataWrapper, typeMetadata, this.m_warningListener, this.getParentConnection());
                }
                catch (IncorrectTypeException incorrectTypeException) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.PARAM_OBJECT_MISMATCH, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(object));
                }
            }
            this.m_updateValues.set(n - 1, dataWrapper);
            this.m_hasUpdateValues = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateObject(int n, Object object, SQLType sQLType, int n2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, object, sQLType, n2);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(n);
            this.clearStream(n);
            TypeMetadata typeMetadata = ((IColumn)((ArrayList)((IResultSet)this.m_resultSet).getSelectColumns()).get(n - 1)).getTypeMetadata();
            int n3 = sQLType.getVendorTypeNumber();
            DataWrapper dataWrapper = new DataWrapper();
            if (null == object) {
                dataWrapper.setNull(typeMetadata.getType());
            } else {
                Object object2;
                try {
                    object2 = new DataWrapper();
                    ((DataWrapper)object2).setData(TypeConverter.getSqlType(object), object);
                    dataWrapper = TypeConverter.toType((DataWrapper)object2, object, n3, this.m_warningListener, this.getParentConnection());
                    dataWrapper = TypeConverter.toType(dataWrapper, typeMetadata, this.m_warningListener, this.getParentConnection());
                }
                catch (IncorrectTypeException incorrectTypeException) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.PARAM_OBJECT_MISMATCH, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(object));
                }
                if (JDBCType.NUMERIC.getVendorTypeNumber().intValue() == dataWrapper.getType() || JDBCType.DECIMAL.getVendorTypeNumber().intValue() == dataWrapper.getType()) {
                    object2 = (BigDecimal)dataWrapper.getObject();
                    dataWrapper.setData(dataWrapper.getType(), ((BigDecimal)object2).setScale(n2, 4));
                }
            }
            this.m_updateValues.set(n - 1, dataWrapper);
            this.m_hasUpdateValues = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateObject(String string, Object object, SQLType sQLType) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, object, sQLType);
        this.updateObject(this.findColumn(string), object, sQLType);
    }

    @Override
    public void updateObject(String string, Object object, SQLType sQLType, int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, object, sQLType, n);
        this.updateObject(this.findColumn(string), object, sQLType, n);
    }
}

