/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.jdbc.common.future;

import com.mapr.drill.dsi.core.interfaces.IStatement;
import com.mapr.drill.dsi.dataengine.interfaces.future.IDataEngine;
import com.mapr.drill.dsi.dataengine.interfaces.future.IResultSet;
import com.mapr.drill.dsi.dataengine.utilities.MetadataSourceID;
import com.mapr.drill.dsi.dataengine.utilities.OrderType;
import com.mapr.drill.exceptions.ExceptionConverter;
import com.mapr.drill.jdbc.common.BaseDatabaseMetaData;
import com.mapr.drill.jdbc.common.SConnection;
import com.mapr.drill.jdbc.common.utilities.future.ClientInfoPropertiesMetadataSource;
import com.mapr.drill.support.ILogger;
import com.mapr.drill.support.exceptions.ErrorException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public abstract class SDatabaseMetaData
extends BaseDatabaseMetaData<IDataEngine> {
    protected SDatabaseMetaData(SConnection sConnection, ILogger iLogger) throws SQLException {
        super(sConnection, iLogger);
    }

    @Override
    protected IDataEngine createDataEngine(IStatement iStatement) throws ErrorException {
        return (IDataEngine)((Object)this.m_parentStatement.createDataEngine());
    }

    @Override
    protected void closeDataEngine(IDataEngine iDataEngine) {
        iDataEngine.close();
    }

    protected IResultSet createDSIMetadataResult(MetadataSourceID metadataSourceID, List<String> list, OrderType orderType) throws ErrorException, SQLException {
        return ((IDataEngine)this.m_dataEngine).makeNewMetadataResult(new IDataEngine.MetadataParameters(metadataSourceID, list, this.getSearchStringEscape(), this.getIdentifierQuoteString(), false, orderType));
    }

    protected abstract ResultSet wrapDSIMetadataResultSet(IResultSet var1, MetadataSourceID var2) throws SQLException;

    protected abstract ResultSet wrapDSIResultSet(IResultSet var1) throws SQLException;

    protected abstract OrderType getJDBCOrderType();

    protected ResultSet doCreateMetadataResult(MetadataSourceID metadataSourceID, List<String> list, OrderType orderType) throws SQLException {
        try {
            return this.wrapDSIMetadataResultSet(this.createDSIMetadataResult(metadataSourceID, list, orderType), metadataSourceID);
        }
        catch (ErrorException errorException) {
            throw ExceptionConverter.getInstance().toSQLException(errorException, this.m_parentStatement.getWarningListener());
        }
    }

    @Override
    protected ResultSet createMetaDataResult(MetadataSourceID metadataSourceID, List<String> list) throws SQLException {
        return this.doCreateMetadataResult(metadataSourceID, list, this.getJDBCOrderType());
    }

    @Override
    protected ResultSet createUnorderedMetaDataResult(MetadataSourceID metadataSourceID, List<String> list) throws SQLException {
        return this.doCreateMetadataResult(metadataSourceID, list, OrderType.NONE);
    }

    @Override
    protected ResultSet createNullMetaDataResult(MetadataSourceID metadataSourceID) throws SQLException {
        return this.wrapDSIMetadataResultSet(null, metadataSourceID);
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return this.wrapDSIResultSet(new ClientInfoPropertiesMetadataSource(this.m_parentConnection.getConnection().getClientInfoProperties(), this.m_parentConnection.getWarningListener()));
    }
}

