/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.dsi.core.impl;

import com.mapr.drill.dsi.core.impl.DSIDriver;
import com.mapr.drill.dsi.core.interfaces.ILogHandler;
import com.mapr.drill.dsi.utilities.DSIMessageKey;
import com.mapr.drill.support.SettingReader;
import com.mapr.drill.support.exceptions.ErrorException;
import com.mapr.drill.support.exceptions.ExceptionType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileHandler
implements ILogHandler {
    private static final int DEFAULT_FILE_SIZE = 0x1400000;
    private static final int DEFAULT_FILE_COUNT = 50;
    public static final String LOG_PRINT_WRITER_KEY = "LogPrintWriter";
    private static final String LOG_FILE_EXTENSION = ".log";
    private static final String EXTENSION_SEPERATOR = ".";
    private static final Pattern FILE_SIZE_PATTERN = Pattern.compile("\\s*(\\d+)\\s*(k|g|m|)b?\\s*", 2);
    private File m_currentLogFile;
    private String m_fileName;
    private boolean isRotationOn = false;
    private String m_logDirectory;
    private PrintWriter m_logWriter = null;
    private int m_maxFileSize;
    private int m_maxFileCount;
    private ArrayList<String> m_rotationFileNames;

    public FileHandler(String string) throws Exception {
        int n = string.lastIndexOf(File.separator);
        if (-1 != n) {
            this.m_logDirectory = string.substring(0, n);
            this.m_fileName = string.substring(n + 1);
            this.createDirectory();
        } else {
            this.m_fileName = string;
        }
        this.prepareLogWriter();
    }

    @Override
    public void writeLog(String string) throws Exception {
        this.m_logWriter.println(string);
        this.m_logWriter.flush();
        if (this.isRotationOn && 0 != this.m_maxFileSize && this.m_currentLogFile.length() >= (long)this.m_maxFileSize) {
            this.closeFile();
            this.rotateLogFiles();
            this.openFile();
        }
    }

    private void createDirectory() throws ErrorException {
        File file = new File(this.m_logDirectory);
        if (!file.exists() && !file.mkdir()) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.CANNOT_CREATE_LOGGING_PATH.name(), this.m_logDirectory, ExceptionType.DEFAULT);
        }
    }

    private int convertStringToMaxFileSize(String string) {
        int n = 0x1400000;
        if (null == string || string.isEmpty()) {
            return n;
        }
        Matcher matcher = FILE_SIZE_PATTERN.matcher(string);
        if (matcher.find()) {
            try {
                n = Integer.valueOf(matcher.group(1)) * this.suffixToMultiplier(matcher.group(2).toLowerCase());
            }
            catch (NumberFormatException numberFormatException) {
                this.m_logWriter.println(numberFormatException.getMessage());
                this.m_logWriter.flush();
            }
        }
        return n;
    }

    private int convertStringToMaxFileCount(String string) {
        if (null != string && !string.isEmpty()) {
            int n = Integer.valueOf(string);
            if (n < 0) {
                return 50;
            }
            return n;
        }
        return 50;
    }

    private void closeFile() {
        if (this.isOpen()) {
            this.m_currentLogFile = null;
            if (null != this.m_logWriter) {
                this.m_logWriter.close();
            }
        }
    }

    private void deleteOldestFile() throws IOException {
        String string = this.m_rotationFileNames.get(this.m_rotationFileNames.size() - 1);
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        for (int i = this.m_rotationFileNames.size() - 2; i >= 0; --i) {
            File file2;
            File file3 = new File(this.m_rotationFileNames.get(i));
            if (file3.exists() && !file3.renameTo(file2 = new File(string))) {
                throw new IOException("cannot rename file: " + file3.getName() + " to: " + string);
            }
            string = this.m_rotationFileNames.get(i);
        }
    }

    private ArrayList<String> initializeFileNamesForLogRotation(String string, String string2, int n) {
        this.m_rotationFileNames = new ArrayList();
        if (this.m_fileName.contains(EXTENSION_SEPERATOR)) {
            string2 = this.m_fileName.substring(this.m_fileName.lastIndexOf(EXTENSION_SEPERATOR), this.m_fileName.length());
            this.m_fileName = this.m_fileName.substring(0, this.m_fileName.lastIndexOf(EXTENSION_SEPERATOR));
        }
        String string3 = string == null ? "" : string + File.separator;
        this.m_rotationFileNames.add(string3 + this.m_fileName + string2);
        for (int i = 1; i < n; ++i) {
            this.m_rotationFileNames.add(string3 + this.m_fileName + EXTENSION_SEPERATOR + i + string2);
        }
        return this.m_rotationFileNames;
    }

    private boolean isOpen() {
        return null != this.m_logWriter;
    }

    private void openFile() throws FileNotFoundException {
        this.m_currentLogFile = new File(this.m_rotationFileNames.get(0));
        FileOutputStream fileOutputStream = new FileOutputStream(this.m_rotationFileNames.get(0), true);
        this.m_logWriter = new PrintWriter(fileOutputStream);
    }

    private void rotateLogFiles() throws Exception {
        assert (!this.m_rotationFileNames.isEmpty());
        this.deleteOldestFile();
    }

    private void prepareLogWriter() throws Exception {
        this.m_logWriter = (PrintWriter)SettingReader.readAdditionalSetting(LOG_PRINT_WRITER_KEY);
        if (null == this.m_logWriter) {
            String string;
            String string2 = string = this.m_logDirectory != null ? this.m_logDirectory + File.separator + this.m_fileName : this.m_fileName;
            if (null != string && 0 != string.length()) {
                FileOutputStream fileOutputStream = new FileOutputStream(string, true);
                this.m_logWriter = new PrintWriter(fileOutputStream);
                this.updateLoggingFileSettings();
                return;
            }
            throw new Exception("Failed to create log writer");
        }
    }

    private Integer suffixToMultiplier(String string) {
        if (string.equals("g")) {
            return 0x40000000;
        }
        if (string.equals("m")) {
            return 0x100000;
        }
        if (string.equals("k")) {
            return 1024;
        }
        throw new NumberFormatException("Invalid file size unit.");
    }

    private void updateLoggingFileSettings() {
        String string = this.m_logDirectory != null ? this.m_logDirectory + File.separator + this.m_fileName : this.m_fileName;
        this.m_currentLogFile = new File(string);
        this.m_maxFileCount = this.convertStringToMaxFileCount(SettingReader.readSetting("maxFileCount"));
        this.m_maxFileSize = this.convertStringToMaxFileSize(SettingReader.readSetting("maxFileSize"));
        if (1 < this.m_maxFileCount) {
            this.isRotationOn = true;
            this.m_rotationFileNames = this.initializeFileNamesForLogRotation(this.m_logDirectory, LOG_FILE_EXTENSION, this.m_maxFileCount);
        }
    }
}

