/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.drill.dataengine.metadata;

import com.mapr.drill.drill.client.DRJDBCClient;
import com.mapr.drill.drill.commons.SettingsKeys;
import com.mapr.drill.drill.dataengine.metadata.DRJDBCMetadataSourceClientAPI;
import com.mapr.drill.dsi.dataengine.utilities.DSITypeUtilities;
import com.mapr.drill.dsi.dataengine.utilities.DataWrapper;
import com.mapr.drill.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.mapr.drill.support.ILogger;
import com.mapr.drill.support.LogUtilities;
import com.mapr.drill.support.exceptions.ErrorException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.drill.exec.proto.UserProtos;

public class DRJDBCTablesMetadataSourceClientAPI
extends DRJDBCMetadataSourceClientAPI<UserProtos.TableMetadata> {
    public DRJDBCTablesMetadataSourceClientAPI(ILogger iLogger, DRJDBCClient dRJDBCClient, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, dRJDBCClient, map);
        this.m_logger = iLogger;
        this.m_client = dRJDBCClient;
        this.m_currIdx = -1;
        this.m_numData = 0;
        this.m_data = null;
        this.m_settings = this.m_client.getSettings();
        this.getData(map.get((Object)MetadataSourceColumnTag.CATALOG_NAME), map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME), map.get((Object)MetadataSourceColumnTag.TABLE_NAME), map.get((Object)MetadataSourceColumnTag.TABLE_TYPE));
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                if (SettingsKeys.CATALOG_SUPPORT_ENUM.NOT_SUPPORTED == this.m_settings.getCatalogSupport()) {
                    dataWrapper.setNull(12);
                    return false;
                }
                if (((UserProtos.TableMetadata)this.m_data.get(this.m_currIdx)).hasCatalogName()) {
                    return DSITypeUtilities.outputVarCharStringData(((UserProtos.TableMetadata)this.m_data.get(this.m_currIdx)).getCatalogName(), dataWrapper, l, l2);
                }
                this.throwFailedMetadataColumnError("Failed to find catalog name.");
            }
            case SCHEMA_NAME: {
                if (((UserProtos.TableMetadata)this.m_data.get(this.m_currIdx)).hasSchemaName()) {
                    return DSITypeUtilities.outputVarCharStringData(((UserProtos.TableMetadata)this.m_data.get(this.m_currIdx)).getSchemaName(), dataWrapper, l, l2);
                }
                this.throwFailedMetadataColumnError("Failed to find schema name.");
            }
            case TABLE_NAME: {
                if (((UserProtos.TableMetadata)this.m_data.get(this.m_currIdx)).hasTableName()) {
                    return DSITypeUtilities.outputVarCharStringData(((UserProtos.TableMetadata)this.m_data.get(this.m_currIdx)).getTableName(), dataWrapper, l, l2);
                }
                this.throwFailedMetadataColumnError("Failed to find table name.");
            }
            case TABLE_TYPE: {
                if (((UserProtos.TableMetadata)this.m_data.get(this.m_currIdx)).hasType()) {
                    return DSITypeUtilities.outputVarCharStringData(((UserProtos.TableMetadata)this.m_data.get(this.m_currIdx)).getType(), dataWrapper, l, l2);
                }
                this.throwFailedMetadataColumnError("Failed to find table type");
            }
            case REMARKS: {
                return DSITypeUtilities.outputVarCharStringData("", dataWrapper, l, l2);
            }
        }
        this.throwMetadataColumnNotFoundException(metadataSourceColumnTag);
        return false;
    }

    private void getData(String string, String string2, String string3, String string4) throws ErrorException {
        UserProtos.LikeFilter likeFilter = null;
        UserProtos.LikeFilter likeFilter2 = null;
        UserProtos.LikeFilter likeFilter3 = null;
        List<String> list = null;
        if (null != string && !string.isEmpty() && SettingsKeys.CATALOG_SUPPORT_ENUM.SUPPORTED == this.m_settings.getCatalogSupport()) {
            likeFilter = UserProtos.LikeFilter.newBuilder().setPattern(string).setEscape("\\").build();
        }
        if (null != string2 && !string2.isEmpty()) {
            likeFilter2 = UserProtos.LikeFilter.newBuilder().setPattern(string2).setEscape("\\").build();
        }
        if (null != string3 && !string3.isEmpty()) {
            likeFilter3 = UserProtos.LikeFilter.newBuilder().setPattern(string3).setEscape("\\").build();
        }
        if (null != string4 && !string4.isEmpty()) {
            list = Arrays.asList(string4.split(","));
        }
        UserProtos.GetTablesResp getTablesResp = this.m_client.getTables(likeFilter, likeFilter2, likeFilter3, list);
        this.m_data = getTablesResp.getTablesList();
        if (null == this.m_data) {
            this.throwNullDataResponseException(getTablesResp.getClass().getSimpleName());
        }
        this.m_numData = this.m_data.size();
    }
}

