/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.drill.dataengine.metadata;

import com.mapr.drill.drill.client.DRJDBCClient;
import com.mapr.drill.drill.core.DRJDBCConnectionSettings;
import com.mapr.drill.drill.core.DRJDBCDriver;
import com.mapr.drill.drill.dataengine.DRJDBCExecutionContext;
import com.mapr.drill.drill.dataengine.DRJDBCResultSet;
import com.mapr.drill.drill.dataengine.metadata.DRJDBCMetadataSourceHelper;
import com.mapr.drill.drill.exceptions.DRJDBCMessageKey;
import com.mapr.drill.dsi.dataengine.interfaces.IMetadataSource;
import com.mapr.drill.dsi.dataengine.utilities.DSITypeUtilities;
import com.mapr.drill.dsi.dataengine.utilities.DataWrapper;
import com.mapr.drill.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.mapr.drill.support.ILogger;
import com.mapr.drill.support.LogUtilities;
import com.mapr.drill.support.exceptions.ErrorException;
import java.util.Map;

public class DRJDBCTablesMetadataSource
implements IMetadataSource {
    static final String SCHEMA_NAME = "TABLE_SCHEMA";
    static final String SCHEMA_FILTER_PREFIX = " WHERE ";
    private DRJDBCClient m_client;
    private ILogger m_logger;
    private DRJDBCExecutionContext m_context;
    private DRJDBCResultSet m_results;
    private DRJDBCConnectionSettings m_settings;
    private boolean m_isFetching = false;

    public DRJDBCTablesMetadataSource(ILogger iLogger, DRJDBCClient dRJDBCClient, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        String string;
        LogUtilities.logFunctionEntrance(iLogger, dRJDBCClient, map);
        this.m_logger = iLogger;
        this.m_client = dRJDBCClient;
        this.m_settings = dRJDBCClient.getSettings();
        String string2 = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string3 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
        String string4 = map.get((Object)MetadataSourceColumnTag.TABLE_TYPE);
        String string5 = map.get((Object)MetadataSourceColumnTag.CATALOG_NAME);
        String string6 = "SELECT TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME, TABLE_TYPE FROM INFORMATION_SCHEMA.`TABLES`";
        boolean bl = false;
        if (null != string5 && !string5.equals("")) {
            if (bl) {
                string6 = string6 + " AND TABLE_CATALOG LIKE '" + string5 + "' ESCAPE '\\'";
            } else {
                string6 = string6 + " WHERE TABLE_CATALOG LIKE '" + string5 + "' ESCAPE '\\'";
                bl = true;
            }
        }
        if (null != string2 && !string2.equals("")) {
            if (bl) {
                string6 = string6 + " AND TABLE_SCHEMA LIKE '" + string2 + "' ESCAPE '\\'";
            } else {
                string6 = string6 + " WHERE TABLE_SCHEMA LIKE '" + string2 + "' ESCAPE '\\'";
                bl = true;
            }
        }
        if (null != string4 && !string4.equals("")) {
            if (bl) {
                string6 = string6 + " AND TABLE_TYPE LIKE '" + string4 + "' ESCAPE '\\'";
            } else {
                string6 = string6 + " WHERE TABLE_TYPE LIKE '" + string4 + "' ESCAPE '\\'";
                bl = true;
            }
        }
        if (null != string3 && !string3.equals("")) {
            if (bl) {
                string6 = string6 + " AND TABLE_NAME LIKE '" + string3 + "' ESCAPE '\\'";
            } else {
                string6 = string6 + " WHERE TABLE_NAME LIKE '" + string3 + "' ESCAPE '\\'";
                bl = true;
            }
        }
        if (!(string = DRJDBCMetadataSourceHelper.genSchemaFilterQuery(this.m_settings, SCHEMA_NAME)).isEmpty()) {
            string6 = string6 + SCHEMA_FILTER_PREFIX + string;
        }
        string6 = string6 + " ORDER BY TABLE_TYPE, TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME";
        this.m_context = this.m_client.executeStatementDirect(string6);
        this.m_results = new DRJDBCResultSet(this.m_client, this.m_context, this.m_logger);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_results.close();
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_results.closeCursor();
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                return this.m_results.getData(0, l, l2, dataWrapper);
            }
            case SCHEMA_NAME: {
                return this.m_results.getData(1, l, l2, dataWrapper);
            }
            case TABLE_NAME: {
                return this.m_results.getData(2, l, l2, dataWrapper);
            }
            case TABLE_TYPE: {
                return this.m_results.getData(3, l, l2, dataWrapper);
            }
            case REMARKS: {
                return DSITypeUtilities.outputVarCharStringData("", dataWrapper, l, l2);
            }
        }
        throw DRJDBCDriver.s_DriverMessages.createGeneralException(DRJDBCMessageKey.METADATA_COLUMN_NOT_FOUND.name(), new String[]{metadataSourceColumnTag.toString()});
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_results.hasMoreRows();
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_isFetching) {
            try {
                return this.hasMoreRows();
            }
            catch (ErrorException errorException) {
                return false;
            }
        }
        this.m_isFetching = true;
        try {
            this.m_results.moveToNextRow();
            return this.m_results.moveToNextRow();
        }
        catch (ErrorException errorException) {
            return false;
        }
    }
}

